/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;

public class ThreadLocalCryptoMap<TL extends ThreadLocalCrypto<?>> {
    private final ConcurrentMap<String, TL> FUNCTIONS = new ConcurrentHashMap<String, TL>();
    private final Factory<TL> factory;

    public ThreadLocalCryptoMap(Factory<TL> factory) {
        this.factory = factory;
    }

    public TL get(String algorithm) {
        ThreadLocalCrypto function;
        ThreadLocalCrypto threadLocalCryptFunction = (ThreadLocalCrypto)this.FUNCTIONS.get(algorithm);
        if (threadLocalCryptFunction == null && (threadLocalCryptFunction = this.FUNCTIONS.putIfAbsent(algorithm, function = (ThreadLocalCrypto)this.factory.getInstance(algorithm))) == null) {
            threadLocalCryptFunction = function;
        }
        return (TL)threadLocalCryptFunction;
    }

    public static interface Factory<T> {
        public T getInstance(String var1);
    }
}

