/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.OSGiRunnable;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class OSGiImpl<T>
implements OSGi<T> {
    OSGiRunnable<T> _operation;

    protected OSGiImpl(OSGiRunnable<T> operation) {
        this._operation = operation;
    }

    public static <T> OSGi<T> create(OSGiRunnable<T> runnable) {
        return new OSGiImpl((b, op) -> new OSGiResultImpl(runnable.run(b, op)));
    }

    @Override
    public OSGiResult run(BundleContext bundleContext) {
        return this.run(bundleContext, x -> NOOP);
    }

    @Override
    public OSGiResult run(BundleContext bundleContext, Publisher<? super T> op) {
        return this._operation.run(bundleContext, op);
    }

    static Filter buildFilter(BundleContext bundleContext, String filterString, Class<?> clazz) {
        Filter filter;
        String string = OSGiImpl.buildFilterString(filterString, clazz);
        try {
            filter = bundleContext.createFilter(string);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        return filter;
    }

    static String buildFilterString(String filterString, Class<?> clazz) {
        if (filterString == null && clazz == null) {
            throw new IllegalArgumentException("Both filterString and clazz can't be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (filterString != null) {
            stringBuilder.append(filterString);
        }
        if (clazz != null) {
            boolean extend;
            boolean bl = extend = stringBuilder.length() != 0;
            if (extend) {
                stringBuilder.insert(0, "(&");
            }
            stringBuilder.append("(objectClass=").append(clazz.getName()).append(")");
            if (extend) {
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }
}

