/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.exception.ModbusTransportException;

@NonNullByDefault
public abstract class ModbusSlaveErrorResponseException
extends ModbusTransportException {
    private static final Map<Integer, KnownExceptionCode> EXCEPTION_CODES_INDEX = new HashMap<Integer, KnownExceptionCode>(10);
    public static final int ILLEGAL_FUNCTION;
    public static final int ILLEGAL_DATA_ACCESS;
    public static final int ILLEGAL_DATA_VALUE;
    public static final int SLAVE_DEVICE_FAILURE;
    public static final int ACKNOWLEDGE;
    public static final int SLAVE_DEVICE_BUSY;
    public static final int NEGATIVE_ACKNOWLEDGE;
    public static final int MEMORY_PARITY_ERROR;
    public static final int GATEWAY_PATH_UNVAVAILABLE;
    public static final int GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND;
    private static final long serialVersionUID = -1435199498550990487L;

    static {
        KnownExceptionCode[] knownExceptionCodeArray = KnownExceptionCode.values();
        int n = knownExceptionCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnownExceptionCode code = knownExceptionCodeArray[n2];
            EXCEPTION_CODES_INDEX.put(code.exceptionCode, code);
            ++n2;
        }
        ILLEGAL_FUNCTION = KnownExceptionCode.ILLEGAL_FUNCTION.getExceptionCode();
        ILLEGAL_DATA_ACCESS = KnownExceptionCode.ILLEGAL_DATA_ACCESS.getExceptionCode();
        ILLEGAL_DATA_VALUE = KnownExceptionCode.ILLEGAL_DATA_VALUE.getExceptionCode();
        SLAVE_DEVICE_FAILURE = KnownExceptionCode.SLAVE_DEVICE_FAILURE.getExceptionCode();
        ACKNOWLEDGE = KnownExceptionCode.ACKNOWLEDGE.getExceptionCode();
        SLAVE_DEVICE_BUSY = KnownExceptionCode.SLAVE_DEVICE_BUSY.getExceptionCode();
        NEGATIVE_ACKNOWLEDGE = KnownExceptionCode.ACKNOWLEDGE.getExceptionCode();
        MEMORY_PARITY_ERROR = KnownExceptionCode.MEMORY_PARITY_ERROR.getExceptionCode();
        GATEWAY_PATH_UNVAVAILABLE = KnownExceptionCode.GATEWAY_PATH_UNVAVAILABLE.getExceptionCode();
        GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND = KnownExceptionCode.GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND.getExceptionCode();
    }

    public abstract int getExceptionCode();

    public static enum KnownExceptionCode {
        ILLEGAL_FUNCTION(1),
        ILLEGAL_DATA_ACCESS(2),
        ILLEGAL_DATA_VALUE(3),
        SLAVE_DEVICE_FAILURE(4),
        ACKNOWLEDGE(5),
        SLAVE_DEVICE_BUSY(6),
        NEGATIVE_ACKNOWLEDGE(7),
        MEMORY_PARITY_ERROR(8),
        GATEWAY_PATH_UNVAVAILABLE(10),
        GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND(11);

        private final int exceptionCode;

        private KnownExceptionCode(int exceptionCode) {
            this.exceptionCode = exceptionCode;
        }

        public int getExceptionCode() {
            return this.exceptionCode;
        }

        public static Optional<KnownExceptionCode> tryFromExceptionCode(int exceptionCode) {
            return Optional.ofNullable(EXCEPTION_CODES_INDEX.get(exceptionCode));
        }
    }
}

