/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemPredicates;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.semantics.Equipment;
import org.openhab.core.semantics.ItemSemanticsProblem;
import org.openhab.core.semantics.Location;
import org.openhab.core.semantics.Point;
import org.openhab.core.semantics.Property;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagRegistry;
import org.openhab.core.semantics.SemanticTags;
import org.openhab.core.semantics.SemanticsPredicates;
import org.openhab.core.semantics.SemanticsService;
import org.openhab.core.semantics.Tag;
import org.openhab.core.semantics.internal.SemanticTagRegistryImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class SemanticsServiceImpl
implements SemanticsService,
RegistryChangeListener<Item> {
    private static final String SYNONYMS_NAMESPACE = "synonyms";
    private final Logger logger = LoggerFactory.getLogger(SemanticsServiceImpl.class);
    private final ItemRegistry itemRegistry;
    private final MetadataRegistry metadataRegistry;
    private final SemanticTagRegistry semanticTagRegistry;

    @Activate
    public SemanticsServiceImpl(@Reference ItemRegistry itemRegistry, @Reference MetadataRegistry metadataRegistry, @Reference SemanticTagRegistry semanticTagRegistry) {
        this.itemRegistry = itemRegistry;
        this.metadataRegistry = metadataRegistry;
        this.semanticTagRegistry = semanticTagRegistry;
        this.itemRegistry.stream().forEach(this::checkSemantics);
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
    }

    @Override
    public Set<Item> getItemsInLocation(Class<? extends Location> locationType) {
        HashSet<Item> items = new HashSet<Item>();
        Set locationItems = this.itemRegistry.stream().filter(SemanticsPredicates.isA(locationType)).collect(Collectors.toSet());
        for (Item locationItem : locationItems) {
            if (!(locationItem instanceof GroupItem)) continue;
            GroupItem gItem = (GroupItem)locationItem;
            items.addAll(gItem.getMembers(SemanticsPredicates.isA(Point.class).or(SemanticsPredicates.isA(Equipment.class))));
        }
        return items;
    }

    @Override
    public Set<Item> getItemsInLocation(String labelOrSynonym, Locale locale) {
        HashSet<Item> items = new HashSet<Item>();
        List<Class<? extends Tag>> tagList = this.getByLabelOrSynonym(labelOrSynonym, locale);
        if (!tagList.isEmpty()) {
            for (Class<? extends Tag> tag : tagList) {
                if (!Location.class.isAssignableFrom(tag)) continue;
                items.addAll(this.getItemsInLocation(tag));
            }
        } else {
            Set locationItems = this.itemRegistry.stream().filter(ItemPredicates.hasLabel((String)labelOrSynonym).or(this.hasSynonym(labelOrSynonym)).and(SemanticsPredicates.isLocation())).collect(Collectors.toSet());
            for (Item locationItem : locationItems) {
                if (!(locationItem instanceof GroupItem)) continue;
                GroupItem gItem = (GroupItem)locationItem;
                items.addAll(gItem.getMembers(SemanticsPredicates.isA(Point.class).or(SemanticsPredicates.isA(Equipment.class))));
            }
        }
        return items;
    }

    private Predicate<? super Item> hasSynonym(String labelOrSynonym) {
        return item -> {
            MetadataKey key = new MetadataKey(SYNONYMS_NAMESPACE, item.getName());
            Metadata md = (Metadata)this.metadataRegistry.get((Object)key);
            if (md != null) {
                String[] synonyms;
                String[] stringArray = synonyms = md.getValue().split(",");
                int n = synonyms.length;
                int n2 = 0;
                while (n2 < n) {
                    String synonym = stringArray[n2];
                    if (synonym.equalsIgnoreCase(labelOrSynonym)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        };
    }

    @Override
    public @Nullable Class<? extends Tag> getByLabel(String tagLabel, Locale locale) {
        Optional<SemanticTag> tag = this.semanticTagRegistry.getAll().stream().filter(t -> t.localized(locale).getLabel().equalsIgnoreCase(tagLabel)).sorted(Comparator.comparing(Identifiable::getUID)).findFirst();
        return tag.isPresent() ? this.semanticTagRegistry.getTagClassById((String)tag.get().getUID()) : null;
    }

    @Override
    public List<Class<? extends Tag>> getByLabelOrSynonym(String tagLabelOrSynonym, Locale locale) {
        List<SemanticTag> tags = this.semanticTagRegistry.getAll().stream().filter(t -> this.getLabelAndSynonyms((SemanticTag)t, locale).contains(tagLabelOrSynonym.toLowerCase(locale))).sorted(Comparator.comparing(Identifiable::getUID)).toList();
        ArrayList<Class<? extends Tag>> tagList = new ArrayList<Class<? extends Tag>>();
        tags.forEach(t -> {
            Class<? extends Tag> tag = this.semanticTagRegistry.getTagClassById((String)t.getUID());
            if (tag != null) {
                tagList.add(tag);
            }
        });
        return tagList;
    }

    @Override
    public List<String> getLabelAndSynonyms(Class<? extends Tag> tagClass, Locale locale) {
        SemanticTag tag = (SemanticTag)this.semanticTagRegistry.get(SemanticTagRegistryImpl.buildId(tagClass));
        return tag == null ? List.of() : this.getLabelAndSynonyms(tag, locale);
    }

    private List<String> getLabelAndSynonyms(SemanticTag tag, Locale locale) {
        SemanticTag localizedTag = tag.localized(locale);
        Stream<String> label = Stream.of(localizedTag.getLabel());
        Stream synonyms = localizedTag.getSynonyms().stream();
        return Stream.concat(label, synonyms).map(s -> s.toLowerCase(locale)).distinct().toList();
    }

    boolean validateTags(Item item, @Nullable Class<? extends Tag> semanticTag) {
        return this.getItemTagProblems(item, semanticTag, true) == null;
    }

    @Nullable ItemSemanticsProblem getItemTagProblems(Item item, @Nullable Class<? extends Tag> semanticTag, boolean logWarnings) {
        if (semanticTag == null) {
            return null;
        }
        String semanticType = SemanticTags.getSemanticRootName(semanticTag);
        List tags = item.getTags().stream().map(SemanticTags::getById).filter(Objects::nonNull).collect(Collectors.toList());
        switch (tags.size()) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                String lastType;
                Class firstTag = (Class)tags.getFirst();
                Class lastTag = (Class)tags.getLast();
                if (Point.class.isAssignableFrom(firstTag) && Property.class.isAssignableFrom(lastTag) || Point.class.isAssignableFrom(lastTag) && Property.class.isAssignableFrom(firstTag)) {
                    return null;
                }
                String firstType = SemanticTags.getSemanticRootName(firstTag);
                if (firstType.equals(lastType = SemanticTags.getSemanticRootName(lastTag))) {
                    if (Point.class.isAssignableFrom(firstTag) || Property.class.isAssignableFrom(firstTag)) {
                        String reason = String.format("Invalid combination of semantic tags: %s (%s) and %s (%s).", firstTag.getSimpleName(), firstType, lastTag.getSimpleName(), lastType);
                        String explanation = "Only one Point and optionally one Property tag may be assigned.";
                        if (logWarnings) {
                            this.logger.warn("Item '{}' ({}): {} {}", new Object[]{item.getName(), semanticType, reason, explanation});
                        }
                        return new ItemSemanticsProblem(item.getName(), semanticType, reason, explanation, null);
                    }
                    String reason = String.format("Invalid combination of semantic tags: %s (%s) and %s (%s).", firstTag.getSimpleName(), firstType, lastTag.getSimpleName(), lastType);
                    String explanation = String.format("Only one %s tag may be assigned.", firstType);
                    if (logWarnings) {
                        this.logger.warn("Item '{}' ({}): {} {}", new Object[]{item.getName(), semanticType, reason, explanation});
                    }
                    return new ItemSemanticsProblem(item.getName(), semanticType, reason, explanation, null);
                }
                String reason = String.format("Invalid combination of semantic tags: %s (%s) and %s (%s).", firstTag.getSimpleName(), firstType, lastTag.getSimpleName(), lastType);
                String explanation = String.format("%s and %s tags cannot be assigned at the same time.", firstType, lastType);
                if (logWarnings) {
                    this.logger.warn("Item '{}' ({}): {} {}", new Object[]{item.getName(), semanticType, reason, explanation});
                }
                return new ItemSemanticsProblem(item.getName(), semanticType, reason, explanation, null);
            }
        }
        List<String> allTags = tags.stream().map(tag -> {
            String tagType = SemanticTags.getSemanticRootName(tag);
            return String.format("%s (%s)", tag.getSimpleName(), tagType);
        }).toList();
        String reason = String.format("Invalid combination of semantic tags: %s.", allTags);
        String explanation = "An Item may only have one tag of Location, Equipment, or Point type. A Property tag may be assigned in conjunction with a Point tag.";
        if (logWarnings) {
            this.logger.warn("Item '{}' ({}): {} {}", new Object[]{item.getName(), semanticType, reason, explanation});
        }
        return new ItemSemanticsProblem(item.getName(), semanticType, reason, explanation, null);
    }

    boolean checkSemantics(Item item) {
        return this.getItemSemanticsProblems(item, true).size() == 0;
    }

    @Override
    public List<ItemSemanticsProblem> getItemSemanticsProblems(Item item) {
        return this.getItemSemanticsProblems(item, false);
    }

    List<ItemSemanticsProblem> getItemSemanticsProblems(Item item, boolean logWarnings) {
        String itemName = item.getName();
        Class<? extends Tag> semanticTag = SemanticTags.getSemanticType(item);
        if (semanticTag == null) {
            return List.of();
        }
        ItemSemanticsProblem tagProblem = this.getItemTagProblems(item, semanticTag, logWarnings);
        if (tagProblem != null) {
            return List.of(tagProblem);
        }
        ArrayList<String[]> warnings = new ArrayList<String[]>();
        ArrayList<String> parentLocations = new ArrayList<String>();
        ArrayList<String> parentEquipments = new ArrayList<String>();
        for (String groupName : item.getGroupNames()) {
            try {
                GroupItem groupItem;
                Class<? extends Tag> groupSemanticType;
                Item item2 = this.itemRegistry.getItem(groupName);
                if (!(item2 instanceof GroupItem) || (groupSemanticType = SemanticTags.getSemanticType((Item)(groupItem = (GroupItem)item2))) == null) continue;
                if (Equipment.class.isAssignableFrom(groupSemanticType)) {
                    parentEquipments.add(groupName);
                    continue;
                }
                if (!Location.class.isAssignableFrom(groupSemanticType)) continue;
                parentLocations.add(groupName);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        String semanticType = SemanticTags.getSemanticRootName(semanticTag);
        if (Point.class.isAssignableFrom(semanticTag)) {
            if (parentLocations.size() == 1 && parentEquipments.size() == 1) {
                if (logWarnings) {
                    this.logger.info("Item '{}' ({}): Belongs to Location {} and Equipment {}.", new Object[]{itemName, semanticType, parentLocations, parentEquipments});
                }
            } else {
                if (parentLocations.size() > 1) {
                    warning = new String[]{String.format("Belongs to multiple Locations %s.", ((Object)parentLocations).toString()), "It should only belong to one Equipment or one Location, preferably not both at the same time."};
                    warnings.add(warning);
                }
                if (parentEquipments.size() > 1) {
                    warning = new String[]{String.format("Belongs to multiple Equipment %s.", ((Object)parentEquipments).toString()), "A Point can only belong to at most one Equipment."};
                    warnings.add(warning);
                }
            }
        } else if (Equipment.class.isAssignableFrom(semanticTag)) {
            if (!parentLocations.isEmpty() && !parentEquipments.isEmpty()) {
                warning = new String[]{String.format("Belongs to Location(s) %s and Equipment %s.", ((Object)parentLocations).toString(), ((Object)parentEquipments).toString()), "An Equipment can only belong to one Location or another Equipment, but not both."};
                warnings.add(warning);
            }
            if (parentLocations.size() > 1) {
                warning = new String[]{String.format("Belongs to multiple Locations %s.", ((Object)parentLocations).toString()), "An Equipment can only belong to one Location or another Equipment."};
                warnings.add(warning);
            }
            if (parentEquipments.size() > 1) {
                warning = new String[]{String.format("Belongs to multiple Equipment %s.", ((Object)parentEquipments).toString()), "An Equipment can only belong to at most one Equipment."};
                warnings.add(warning);
            }
        } else if (Location.class.isAssignableFrom(semanticTag)) {
            if (!(item instanceof GroupItem)) {
                warning = new String[]{String.format("Is a %s Item, not a Group Item.", item.getType()), "A Location should be a Group Item."};
                warnings.add(warning);
            }
            if (!parentEquipments.isEmpty()) {
                warning = new String[]{String.format("Belongs to Equipment %s.", ((Object)parentEquipments).toString()), "A Location can only belong to another Location, not Equipment."};
                warnings.add(warning);
            }
            if (parentLocations.size() > 1) {
                warning = new String[]{String.format("Belongs to multiple Locations %s.", ((Object)parentLocations).toString()), "It should only belong to one Location."};
                warnings.add(warning);
            }
        }
        if (!warnings.isEmpty()) {
            if (logWarnings) {
                this.logger.warn("Item '{}' ({}): Invalid semantic structure:{}", new Object[]{itemName, semanticType, warnings.stream().map(w -> w[0] + " " + w[1]).reduce("", (result, w) -> result + "\n        " + w)});
            }
            return warnings.stream().map(w -> new ItemSemanticsProblem(itemName, semanticType, w[0], w[1], false)).toList();
        }
        return List.of();
    }

    public void added(Item item) {
        this.checkSemantics(item);
    }

    public void removed(Item item) {
    }

    public void updated(Item oldElement, Item element) {
        this.checkSemantics(element);
    }
}

