/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.ModificationFilter;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.XMLPrettyPrinter;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class WorkflowTraceSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static JAXBContext context;

    private static synchronized JAXBContext getJAXBContext() throws JAXBException, IOException {
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{ExtensionMessage.class, WorkflowTrace.class, ProtocolMessage.class, ModificationFilter.class, VariableModification.class, ModifiableVariable.class, TlsAction.class, SendAction.class, ReceiveAction.class});
        }
        return context;
    }

    public static void write(File file, WorkflowTrace trace) throws FileNotFoundException, JAXBException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        WorkflowTraceSerializer.write(fos, trace);
    }

    public static String write(WorkflowTrace trace) throws JAXBException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WorkflowTraceSerializer.write(bos, trace);
        return new String(bos.toByteArray(), "UTF-8");
    }

    public static void write(OutputStream outputStream, WorkflowTrace workflowTrace) throws JAXBException, IOException {
        context = WorkflowTraceSerializer.getJAXBContext();
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        try (ByteArrayOutputStream tempStream = new ByteArrayOutputStream();){
            m.marshal((Object)workflowTrace, (OutputStream)tempStream);
            try {
                outputStream.write(XMLPrettyPrinter.prettyPrintXML((String)new String(tempStream.toByteArray())).getBytes());
            }
            catch (ParserConfigurationException | TransformerException | XPathExpressionException | XPathFactoryConfigurationException | SAXException ex) {
                throw new RuntimeException("Could not format XML");
            }
        }
        outputStream.close();
    }

    public static WorkflowTrace read(InputStream inputStream) throws JAXBException, IOException, XMLStreamException {
        context = WorkflowTraceSerializer.getJAXBContext();
        Unmarshaller m = context.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        WorkflowTrace wt = (WorkflowTrace)m.unmarshal(xsr);
        inputStream.close();
        return wt;
    }

    public static List<WorkflowTrace> readFolder(File f) {
        if (f.isDirectory()) {
            ArrayList<WorkflowTrace> list = new ArrayList<WorkflowTrace>();
            for (File file : f.listFiles()) {
                if (file.getName().startsWith(".")) continue;
                try {
                    WorkflowTrace trace = WorkflowTraceSerializer.read(new FileInputStream(file));
                    trace.setName(file.getAbsolutePath());
                    list.add(trace);
                }
                catch (IOException | JAXBException | XMLStreamException ex) {
                    LOGGER.warn("Could not read " + file.getAbsolutePath() + " from Folder.");
                    LOGGER.debug(ex.getLocalizedMessage(), ex);
                }
            }
            return list;
        }
        throw new IllegalArgumentException("Cannot read Folder, because its not a Folder");
    }

    private WorkflowTraceSerializer() {
    }
}

