/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryMeta {
    private String name;
    private String description;
    private DatabaseMeta databaseMeta;
    private boolean lock;

    public RepositoryMeta(String name, String description, DatabaseMeta connection) {
        this.name = name;
        this.description = description;
        this.databaseMeta = connection;
        this.lock = false;
    }

    public RepositoryMeta() {
        this.name = "";
        this.description = "";
        this.databaseMeta = null;
    }

    public boolean loadXML(Node repnode, List<DatabaseMeta> databases) {
        try {
            this.name = XMLHandler.getTagValue((Node)repnode, (String)"name");
            this.description = XMLHandler.getTagValue((Node)repnode, (String)"description");
            String conn = XMLHandler.getTagValue((Node)repnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)conn);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setConnection(DatabaseMeta connection) {
        this.databaseMeta = connection;
    }

    public DatabaseMeta getConnection() {
        return this.databaseMeta;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("  <repository>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", this.databaseMeta != null ? this.databaseMeta.getName() : null));
        retval.append("  </repository>").append(Const.CR);
        return retval.toString();
    }
}

