/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.URLUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class IPv6Address
extends Host {
    private static final long serialVersionUID = 1L;
    private final short[] pieces;

    IPv6Address(short[] pieces) {
        this.pieces = Arrays.copyOf(pieces, pieces.length);
    }

    public static IPv6Address parseIPv6Address(String ipString) throws GalimatiasParseException {
        char c;
        if (ipString == null) {
            throw new NullPointerException("Argument is null");
        }
        if (ipString.isEmpty()) {
            throw new GalimatiasParseException("empty string");
        }
        short[] address = new short[8];
        int piecePointer = 0;
        Integer compressPointer = null;
        int idx = 0;
        char[] input = ipString.toCharArray();
        boolean isEOF = idx >= input.length;
        char c2 = c = isEOF ? (char)'\u0000' : input[idx];
        if (c == ':') {
            if (idx + 1 >= input.length || input[idx + 1] != ':') {
                throw new GalimatiasParseException("IPv6 address starting with ':' is not followed by a second ':'.");
            }
            idx += 2;
            piecePointer = 1;
            compressPointer = piecePointer;
        }
        boolean jumpToIpV4 = false;
        while (!isEOF) {
            int length;
            isEOF = idx >= input.length;
            char c3 = c = isEOF ? (char)'\u0000' : input[idx];
            if (piecePointer == 8) {
                throw new GalimatiasParseException("Address too long");
            }
            if (c == ':') {
                if (compressPointer != null) {
                    throw new GalimatiasParseException("Zero-compression can be used only once.");
                }
                isEOF = ++idx >= input.length;
                c = isEOF ? (char)'\u0000' : input[idx];
                compressPointer = ++piecePointer;
                continue;
            }
            int value = 0;
            for (length = 0; length < 4 && URLUtils.isASCIIHexDigit(c); ++length) {
                value = value * 16 + Integer.parseInt("" + c, 16);
                isEOF = ++idx >= input.length;
                c = isEOF ? (char)'\u0000' : input[idx];
            }
            if (c == '.') {
                if (length == 0) {
                    throw new GalimatiasParseException("':' cannot be followed by '.'");
                }
                isEOF = (idx -= length) >= input.length;
                c = isEOF ? (char)'\u0000' : input[idx];
                jumpToIpV4 = true;
                break;
            }
            if (c == ':') {
                boolean bl = isEOF = ++idx >= input.length;
                if (isEOF) {
                    throw new GalimatiasParseException("Cannot end with ':'");
                }
            } else if (!isEOF) {
                throw new GalimatiasParseException("Illegal character");
            }
            address[piecePointer] = (short)value;
            ++piecePointer;
        }
        boolean jumpToFinale = false;
        if (!jumpToIpV4 && isEOF) {
            jumpToFinale = true;
        }
        if (!jumpToFinale && piecePointer > 6) {
            throw new GalimatiasParseException("Not enough room for a IPv4-mapped address");
        }
        int dotsSeen = 0;
        if (!jumpToFinale) {
            while (!isEOF) {
                int value = 0;
                if (!URLUtils.isASCIIDigit(c)) {
                    throw new GalimatiasParseException("Non-digit character in IPv4-mapped address");
                }
                while (URLUtils.isASCIIDigit(c)) {
                    value = value * 10 + (c - 48);
                    isEOF = ++idx >= input.length;
                    c = isEOF ? (char)'\u0000' : input[idx];
                }
                if (value > 255) {
                    throw new GalimatiasParseException("Invalid value for IPv4-mapped address");
                }
                if (dotsSeen < 3 && c != '.') {
                    throw new GalimatiasParseException("Illegal character in IPv4-mapped address");
                }
                address[piecePointer] = (short)((address[piecePointer] << 8) + value);
                if (dotsSeen == 1 || dotsSeen == 3) {
                    ++piecePointer;
                }
                isEOF = ++idx >= input.length;
                char c4 = c = isEOF ? (char)'\u0000' : input[idx];
                if (dotsSeen == 3 && !isEOF) {
                    throw new GalimatiasParseException("Too long IPv4-mapped address");
                }
                ++dotsSeen;
            }
        }
        if (compressPointer != null) {
            int swaps = piecePointer - compressPointer;
            piecePointer = 7;
            while (swaps != 0) {
                short swappedPiece = address[piecePointer];
                address[piecePointer] = address[compressPointer + swaps - 1];
                address[compressPointer.intValue() + swaps - 1] = swappedPiece;
                --piecePointer;
                --swaps;
            }
        } else if (piecePointer != 8) {
            throw new GalimatiasParseException("Address too short");
        }
        return new IPv6Address(address);
    }

    public InetAddress toInetAddress() {
        byte[] bytes = new byte[16];
        for (int i = 0; i < this.pieces.length; ++i) {
            bytes[i * 2] = (byte)(this.pieces[i] >> 8 & 0xFF);
            bytes[i * 2 + 1] = (byte)(this.pieces[i] & 0xFF);
        }
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("BUG", e);
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder output = new StringBuilder(40);
        int compressPointer = -1;
        int maxConsecutiveZeroes = 0;
        for (i = 0; i < this.pieces.length; ++i) {
            if (this.pieces[i] != 0) continue;
            int consecutiveZeroes = 0;
            for (int j = i; j < this.pieces.length && this.pieces[j] == 0; ++j) {
                ++consecutiveZeroes;
            }
            if (consecutiveZeroes <= maxConsecutiveZeroes) continue;
            compressPointer = i;
            maxConsecutiveZeroes = consecutiveZeroes;
        }
        for (i = 0; i < this.pieces.length; ++i) {
            if (compressPointer == i) {
                if (i == 0) {
                    output.append("::");
                } else {
                    output.append(':');
                }
                while (i < this.pieces.length && this.pieces[i] == 0) {
                    ++i;
                }
            }
            if (i >= this.pieces.length) break;
            output.append(Integer.toHexString(this.pieces[i] & 0xFFFF));
            if (i >= this.pieces.length - 1) continue;
            output.append(':');
        }
        return output.toString();
    }

    @Override
    public String toHumanString() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPv6Address that = (IPv6Address)o;
        return Arrays.equals(this.pieces, that.pieces);
    }

    public int hashCode() {
        return Arrays.hashCode(this.pieces);
    }
}

