/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.impl;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonFeaturePackDescription;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FeaturePackLightXmlParser {
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY = "dependency";
    private static final String TRANSITIVE = "transitive";

    FeaturePackLightXmlParser() {
    }

    public static GalleonFeaturePackDescription parseDescription(Path featurePack) throws ProvisioningException {
        GalleonFeaturePackDescription galleonFeaturePackDescription;
        FileInputStream fileInputStream = new FileInputStream(featurePack.toFile());
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            Element root = document.getDocumentElement();
            String producer = root.getAttribute("location");
            String version = root.getAttribute("galleon-min-version");
            ArrayList<FeaturePackLocation.FPID> dependencies = new ArrayList<FeaturePackLocation.FPID>();
            ArrayList<FeaturePackLocation.FPID> transitives = new ArrayList<FeaturePackLocation.FPID>();
            NodeList lst = root.getChildNodes();
            for (int i = 0; i < lst.getLength(); ++i) {
                String location;
                Element depElement;
                Node dep;
                int j;
                NodeList deps;
                Element e;
                Node n = lst.item(i);
                if (!(n instanceof Element)) continue;
                if (DEPENDENCIES.equals(n.getNodeName())) {
                    e = (Element)n;
                    deps = e.getChildNodes();
                    for (j = 0; j < deps.getLength(); ++j) {
                        dep = deps.item(j);
                        if (!(dep instanceof Element) || !DEPENDENCY.equals(dep.getNodeName())) continue;
                        depElement = (Element)dep;
                        location = depElement.getAttribute("location");
                        dependencies.add(FeaturePackLocation.fromString(location).getFPID());
                    }
                    continue;
                }
                if (!TRANSITIVE.equals(n.getNodeName())) continue;
                e = (Element)n;
                deps = e.getChildNodes();
                for (j = 0; j < deps.getLength(); ++j) {
                    dep = deps.item(j);
                    if (!(dep instanceof Element) || !DEPENDENCY.equals(dep.getNodeName())) continue;
                    depElement = (Element)dep;
                    location = depElement.getAttribute("location");
                    dependencies.add(FeaturePackLocation.fromString(location).getFPID());
                }
            }
            galleonFeaturePackDescription = new GalleonFeaturePackDescription(FeaturePackLocation.fromString(producer).getFPID(), dependencies, transitives, version);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ProvisioningException(ex);
            }
        }
        fileInputStream.close();
        return galleonFeaturePackDescription;
    }

    public static String parseVersion(Path featurePack) throws ProvisioningException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(featurePack.toFile());
        try {
            String version;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            Element root = document.getDocumentElement();
            string = version = root.getAttribute("galleon-min-version");
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ProvisioningException(ex);
            }
        }
        fileInputStream.close();
        return string;
    }
}

