/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.DirectBufferWrapper;

@ApiStatus.Internal
final class PagedFileStorageCache {
    private volatile CachedBuffer myLastBuffer;
    private volatile CachedBuffer myLastBuffer2;
    private volatile CachedBuffer myLastBuffer3;

    PagedFileStorageCache() {
    }

    void clear() {
        this.myLastBuffer = null;
        this.myLastBuffer2 = null;
        this.myLastBuffer3 = null;
    }

    @Nullable
    DirectBufferWrapper getPageFromCache(long page) {
        DirectBufferWrapper buffer = PagedFileStorageCache.fromCache(this.myLastBuffer, page);
        if (buffer != null) {
            return buffer;
        }
        buffer = PagedFileStorageCache.fromCache(this.myLastBuffer2, page);
        if (buffer != null) {
            return buffer;
        }
        buffer = PagedFileStorageCache.fromCache(this.myLastBuffer3, page);
        return buffer;
    }

    @Nullable
    private static DirectBufferWrapper fromCache(CachedBuffer lastBuffer, long page) {
        if (lastBuffer != null && !lastBuffer.myWrapper.isReleased() && lastBuffer.myLastPage == page) {
            return lastBuffer.myWrapper;
        }
        return null;
    }

    void updateCache(long page, DirectBufferWrapper byteBufferWrapper) {
        if (this.myLastBuffer != null && this.myLastBuffer.myLastPage != page) {
            this.myLastBuffer3 = this.myLastBuffer2;
            this.myLastBuffer2 = this.myLastBuffer;
        }
        this.myLastBuffer = new CachedBuffer(byteBufferWrapper, page);
    }

    private static final class CachedBuffer {
        private final DirectBufferWrapper myWrapper;
        private final long myLastPage;

        private CachedBuffer(DirectBufferWrapper wrapper, long page) {
            this.myWrapper = wrapper;
            this.myLastPage = page;
        }
    }
}

