/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u00020\u000e*\u00020\u000fJ*\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirArrayOfNothingQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isArrayOfNothing", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkTypeAndTypeArguments", "type", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
public final class FirArrayOfNothingQualifierChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirArrayOfNothingQualifierChecker INSTANCE = new FirArrayOfNothingQualifierChecker();

    private FirArrayOfNothingQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeKotlinType resolvedType = FirTypeUtilsKt.getResolvedType(expression2);
        this.checkTypeAndTypeArguments(resolvedType, expression2.getCalleeReference().getSource(), context, reporter);
    }

    public final boolean isArrayOfNothing(@NotNull ConeKotlinType $this$isArrayOfNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isArrayOfNothing, (String)"<this>");
        if (!ConeBuiltinTypeUtilsKt.isArrayTypeOrNullableArrayType($this$isArrayOfNothing)) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])$this$isArrayOfNothing.getType().getTypeArguments());
        if (coneTypeProjection == null || (coneTypeProjection = ConeTypeProjectionKt.getType(coneTypeProjection)) == null) {
            return false;
        }
        ConeTypeProjection typeParameterType = coneTypeProjection;
        return ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing((ConeKotlinType)typeParameterType);
    }

    private final void checkTypeAndTypeArguments(ConeKotlinType type2, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(type2, context.getSession(), null, 2, null);
        if (this.isArrayOfNothing(fullyExpandedType2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Array<Nothing> is illegal", (DiagnosticContext)context, null, 16, null);
        } else {
            for (ConeTypeProjection typeArg : fullyExpandedType2.getTypeArguments()) {
                ConeKotlinType typeArgType;
                if (ConeTypeProjectionKt.getType(typeArg) == null) continue;
                this.checkTypeAndTypeArguments(typeArgType, source, context, reporter);
            }
        }
    }
}

