/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.BuildException;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.resteasy.reactive.common.deployment.JsonDefaultProducersHandler;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.scanning.ScannedSerializer;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.spi.EndpointInvokerFactory;

public class QuarkusServerEndpointIndexer
extends ServerEndpointIndexer {
    private static final Logger LOGGER = Logger.getLogger(QuarkusServerEndpointIndexer.class);
    private static final String REST_CLIENT_NOT_BODY_ANNOTATION = "io.quarkus.rest.client.reactive.NotBody";
    private final Capabilities capabilities;
    private final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    private final DefaultProducesHandler defaultProducesHandler;
    private final JsonDefaultProducersHandler jsonDefaultProducersHandler;
    private final ResteasyReactiveRecorder resteasyReactiveRecorder;
    private DefaultProducesHandler.Context currentDefaultProducesContext;

    QuarkusServerEndpointIndexer(Builder builder) {
        super((ServerEndpointIndexer.AbstractBuilder)builder);
        this.capabilities = builder.capabilities;
        this.generatedClassBuildItemBuildProducer = builder.generatedClassBuildItemBuildProducer;
        this.defaultProducesHandler = builder.defaultProducesHandler;
        this.resteasyReactiveRecorder = builder.resteasyReactiveRecorder;
        this.jsonDefaultProducersHandler = new JsonDefaultProducersHandler();
    }

    protected void setupApplyDefaults(final Type nonAsyncReturnType, final DotName httpMethod) {
        this.currentDefaultProducesContext = new DefaultProducesHandler.Context(){

            public Type nonAsyncReturnType() {
                return nonAsyncReturnType;
            }

            public DotName httpMethod() {
                return httpMethod;
            }

            public IndexView index() {
                return QuarkusServerEndpointIndexer.this.applicationIndex;
            }

            public ResteasyReactiveConfig config() {
                return QuarkusServerEndpointIndexer.this.config;
            }
        };
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        List defaultMediaTypes = this.defaultProducesHandler.handle(this.currentDefaultProducesContext);
        if (defaultMediaTypes != null && !defaultMediaTypes.isEmpty()) {
            String[] result = new String[defaultMediaTypes.size()];
            for (int i = 0; i < defaultMediaTypes.size(); ++i) {
                result[i] = ((MediaType)defaultMediaTypes.get(i)).toString();
            }
            return result;
        }
        return super.applyAdditionalDefaults(nonAsyncReturnType);
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ServerIndexedParameter builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        methodContext.put(GeneratedClassBuildItem.class.getName(), this.generatedClassBuildItemBuildProducer);
        methodContext.put(EndpointInvokerFactory.class.getName(), this.resteasyReactiveRecorder);
        return super.handleCustomParameter(anns, builder, paramType, field, methodContext);
    }

    protected void handleAdditionalMethodProcessing(ServerResourceMethod method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
        super.handleAdditionalMethodProcessing(method, currentClassInfo, info, annotationStore);
        if (!this.capabilities.isCapabilityWithPrefixMissing("io.quarkus.resteasy.reactive.json")) {
            return;
        }
        this.warnAboutMissingJsonProviderIfNeeded((ResourceMethod)method, info, (DefaultProducesHandler)this.jsonDefaultProducersHandler, this.currentDefaultProducesContext);
    }

    public boolean additionalRegisterClassForReflectionCheck(EndpointIndexer.ResourceMethodCallbackEntry entry) {
        return this.checkBodyParameterMessageBodyReader(entry) || this.checkReturnTypeMessageBodyWriter(entry);
    }

    private boolean checkBodyParameterMessageBodyReader(EndpointIndexer.ResourceMethodCallbackEntry entry) {
        MethodParameter[] parameters = entry.getResourceMethod().getParameters();
        if (parameters.length == 0) {
            return false;
        }
        MethodParameter bodyParameter = null;
        for (MethodParameter parameter : parameters) {
            if (parameter.parameterType != ParameterType.BODY) continue;
            bodyParameter = parameter;
            break;
        }
        if (bodyParameter == null) {
            return false;
        }
        String parameterClassName = bodyParameter.getDeclaredType();
        List readers = this.getSerializerScanningResult().getReaders();
        for (ScannedSerializer reader : readers) {
            if (!this.isSubclassOf(parameterClassName, reader.getHandledClassName()) || this.isServerMessageBodyReader(reader.getClassInfo())) continue;
            return true;
        }
        return false;
    }

    private boolean checkReturnTypeMessageBodyWriter(EndpointIndexer.ResourceMethodCallbackEntry entry) {
        Type returnType = entry.getMethodInfo().returnType();
        String returnTypeName = switch (returnType.kind()) {
            case Type.Kind.CLASS -> returnType.asClassType().name().toString();
            case Type.Kind.PARAMETERIZED_TYPE -> returnType.asParameterizedType().name().toString();
            default -> null;
        };
        if (returnTypeName == null) {
            return false;
        }
        List writers = this.getSerializerScanningResult().getWriters();
        for (ScannedSerializer writer : writers) {
            if (!this.isSubclassOf(returnTypeName, writer.getHandledClassName()) || this.isServerMessageBodyWriter(writer.getClassInfo())) continue;
            return true;
        }
        return false;
    }

    private boolean isSubclassOf(String className, String parentName) {
        if (className.equals(parentName)) {
            return true;
        }
        ClassInfo classByName = this.index.getClassByName(className);
        if (classByName == null || classByName.superName() == null) {
            return false;
        }
        try {
            return JandexUtil.isSubclassOf((IndexView)this.index, (ClassInfo)classByName, (DotName)DotName.createSimple((String)parentName));
        }
        catch (BuildException e) {
            return false;
        }
    }

    private boolean isServerMessageBodyReader(ClassInfo classInfo) {
        return this.index.getAllKnownImplementors(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_READER).contains(classInfo);
    }

    private boolean isServerMessageBodyWriter(ClassInfo classInfo) {
        return this.index.getAllKnownImplementors(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_WRITER).contains(classInfo);
    }

    protected void logMissingJsonWarning(MethodInfo info) {
        LOGGER.warnf("Quarkus detected the use of JSON in JAX-RS method '" + String.valueOf(info.declaringClass().name()) + "#" + info.name() + "' but no JSON extension has been added. Consider adding 'quarkus-rest-jackson' (recommended) or 'quarkus-rest-jsonb'.", new Object[0]);
    }

    protected void warnAboutMissUsedBodyParameter(DotName httpMethod, MethodInfo methodInfo) {
        if (methodInfo.hasAnnotation(REST_CLIENT_NOT_BODY_ANNOTATION)) {
            return;
        }
        super.warnAboutMissUsedBodyParameter(httpMethod, methodInfo);
    }

    protected void verifyClassThatRequiresFieldInjection(ClassInfo classInfo) {
        BuiltinScope scope;
        if (!this.alreadyHandledRequestScopedResources.contains(classInfo.name()) && BuiltinScope.REQUEST != (scope = BuiltinScope.from((ClassInfo)classInfo))) {
            throw new DeploymentException("Resource classes that use field injection for REST parameters can only be @RequestScoped. Offending class is " + String.valueOf(classInfo.name()));
        }
    }

    public static final class Builder
    extends ServerEndpointIndexer.AbstractBuilder<Builder> {
        private final Capabilities capabilities;
        private BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
        private ResteasyReactiveRecorder resteasyReactiveRecorder;
        private DefaultProducesHandler defaultProducesHandler = DefaultProducesHandler.Noop.INSTANCE;
        public Predicate<String> applicationClassPredicate;

        public Builder(Capabilities capabilities) {
            this.capabilities = capabilities;
        }

        public QuarkusServerEndpointIndexer build() {
            return new QuarkusServerEndpointIndexer(this);
        }

        public Builder setGeneratedClassBuildItemBuildProducer(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
            this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
            return this;
        }

        public Builder setApplicationClassPredicate(Predicate<String> applicationClassPredicate) {
            this.applicationClassPredicate = applicationClassPredicate;
            return this;
        }

        public Builder setResteasyReactiveRecorder(ResteasyReactiveRecorder resteasyReactiveRecorder) {
            this.resteasyReactiveRecorder = resteasyReactiveRecorder;
            return this;
        }

        public Builder setDefaultProducesHandler(DefaultProducesHandler defaultProducesHandler) {
            this.defaultProducesHandler = defaultProducesHandler;
            return this;
        }
    }
}

