/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;
import org.openhab.core.automation.internal.commands.Utils;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.Template;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.FilterCriteria;
import org.openhab.core.config.core.ParameterOption;

public class Printer {
    private static final int TABLE_WIDTH = 100;
    private static final int COLUMN_ID = 7;
    private static final int COLUMN_UID = 93;
    private static final int COLUMN_RULE_UID = 36;
    private static final int COLUMN_RULE_NAME = 36;
    private static final int COLUMN_RULE_STATUS = 15;
    private static final int COLUMN_PROPERTY = 28;
    private static final int COLUMN_PROPERTY_VALUE = 72;
    private static final int COLUMN_CONFIG_PARAMETER = 20;
    private static final int COLUMN_CONFIG_PARAMETER_VALUE = 52;
    private static final int COLUMN_CONFIG_PARAMETER_PROP = 16;
    private static final int COLUMN_CONFIG_PARAMETER_PROP_VALUE = 36;
    private static final String ID = "ID";
    private static final String UID = "UID";
    private static final String NAME = "NAME";
    private static final String STATUS = "STATUS";
    private static final String TAGS = "TAGS";
    private static final String LABEL = "LABEL";
    private static final String VISIBILITY = "VISIBILITY";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CONFIGURATION_DESCRIPTIONS = "CONFIGURATION DESCRIPTIONS ";
    private static final String ACTIONS = "ACTIONS";
    private static final String TRIGGERS = "TRIGGERS";
    private static final String CONDITIONS = "CONDITIONS";
    private static final String INPUTS = "INPUTS";
    private static final String OUTPUTS = "OUTPUTS";
    private static final String CHILDREN = "CHILDREN";
    private static final String TYPE = "TYPE";
    private static final String CONFIGURATION = "CONFIGURATION";
    private static final String MIN = "MIN";
    private static final String MAX = "MAX";
    private static final String DEFAULT = "DEFAULT";
    private static final String CONTEXT = "CONTEXT";
    private static final String PATTERN = "PATTERN";
    private static final String OPTIONS = "OPTIONS";
    private static final String STEP_SIZE = "STEP_SIZE";
    private static final String FILTER_CRITERIA = "FILTER CRITERIA ";
    private static final String REQUIRED = "REQUIRED";
    private static final String NOT_REQUIRED = "NOT REQUIRED";

    static String printRules(AutomationCommandsPluggable autoCommands, Map<String, String> ruleUIDs) {
        int[] columnWidths = new int[]{7, 36, 36, 15};
        ArrayList<String> columnValues = new ArrayList<String>();
        columnValues.add(ID);
        columnValues.add(UID);
        columnValues.add(NAME);
        columnValues.add(STATUS);
        String titleRow = Utils.getRow(columnWidths, columnValues);
        ArrayList<String> rulesRows = new ArrayList<String>();
        int i = 1;
        while (i <= ruleUIDs.size()) {
            String id = String.valueOf(i);
            String uid = ruleUIDs.get(id);
            if (uid != null) {
                columnValues.set(0, id);
                columnValues.set(1, uid);
                Rule rule = autoCommands.getRule(uid);
                columnValues.set(2, rule.getName());
                columnValues.set(3, autoCommands.getRuleStatus(uid).toString());
                rulesRows.add(Utils.getRow(columnWidths, columnValues));
            }
            ++i;
        }
        return Utils.getTableContent(100, columnWidths, rulesRows, titleRow);
    }

    static String printTemplates(Map<String, String> templateUIDs) {
        int[] columnWidths = new int[]{7, 93};
        ArrayList<String> columnTitles = new ArrayList<String>();
        columnTitles.add(ID);
        columnTitles.add(UID);
        String titleRow = Utils.getRow(columnWidths, columnTitles);
        ArrayList<String> templates = new ArrayList<String>();
        Printer.collectListRecords(templateUIDs, templates, columnWidths);
        return Utils.getTableContent(100, columnWidths, templates, titleRow);
    }

    static String printModuleTypes(Map<String, String> moduleTypeUIDs) {
        int[] columnWidths = new int[]{7, 93};
        ArrayList<String> columnTitles = new ArrayList<String>();
        columnTitles.add(ID);
        columnTitles.add(UID);
        String titleRow = Utils.getRow(columnWidths, columnTitles);
        ArrayList<String> moduleTypes = new ArrayList<String>();
        Printer.collectListRecords(moduleTypeUIDs, moduleTypes, columnWidths);
        return Utils.getTableContent(100, columnWidths, moduleTypes, titleRow);
    }

    static String printRule(Rule rule, RuleStatus status) {
        int[] columnWidths = new int[]{100};
        ArrayList<String> ruleProperty = new ArrayList<String>();
        ruleProperty.add(rule.getUID() + " [ " + String.valueOf((Object)status) + " ]");
        String titleRow = Utils.getRow(columnWidths, ruleProperty);
        ArrayList<String> ruleContent = new ArrayList<String>();
        columnWidths = new int[]{28, 72};
        ruleProperty.set(0, UID);
        ruleProperty.add(rule.getUID());
        ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        if (rule.getName() != null) {
            ruleProperty.set(0, NAME);
            ruleProperty.set(1, rule.getName());
            ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        }
        if (rule.getDescription() != null) {
            ruleProperty.set(0, DESCRIPTION);
            ruleProperty.set(1, rule.getDescription());
            ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        }
        ruleProperty.set(0, TAGS);
        ruleProperty.set(1, Printer.getTagsRecord(rule.getTags()));
        ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        ruleContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION, rule.getConfiguration().getProperties().entrySet()));
        ruleContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION_DESCRIPTIONS, Printer.getConfigurationDescriptionRecords(rule.getConfigurationDescriptions())));
        ruleContent.addAll(Printer.collectRecords(columnWidths, TRIGGERS, rule.getTriggers()));
        ruleContent.addAll(Printer.collectRecords(columnWidths, CONDITIONS, rule.getConditions()));
        ruleContent.addAll(Printer.collectRecords(columnWidths, ACTIONS, rule.getActions()));
        return Utils.getTableContent(100, columnWidths, ruleContent, titleRow);
    }

    /*
     * WARNING - void declaration
     */
    static String printTemplate(Template template) {
        int[] columnWidths = new int[]{100};
        ArrayList<String> templateProperty = new ArrayList<String>();
        templateProperty.add(template.getUID());
        String titleRow = Utils.getRow(columnWidths, templateProperty);
        ArrayList<String> templateContent = new ArrayList<String>();
        columnWidths = new int[]{28, 72};
        templateProperty.set(0, UID);
        templateProperty.add(template.getUID());
        templateContent.add(Utils.getRow(columnWidths, templateProperty));
        if (template.getLabel() != null) {
            templateProperty.set(0, LABEL);
            templateProperty.set(1, template.getLabel());
            templateContent.add(Utils.getRow(columnWidths, templateProperty));
        }
        if (template.getDescription() != null) {
            templateProperty.set(0, DESCRIPTION);
            templateProperty.set(1, template.getDescription());
            templateContent.add(Utils.getRow(columnWidths, templateProperty));
        }
        templateProperty.set(0, VISIBILITY);
        templateProperty.set(1, template.getVisibility().toString());
        templateContent.add(Utils.getRow(columnWidths, templateProperty));
        templateProperty.set(0, TAGS);
        templateProperty.set(1, Printer.getTagsRecord(template.getTags()));
        templateContent.add(Utils.getRow(columnWidths, templateProperty));
        Template template2 = template;
        if (template2 instanceof RuleTemplate) {
            void ruleTemplate;
            RuleTemplate ruleTemplate2 = (RuleTemplate)template2;
            RuleTemplate cfr_ignored_0 = (RuleTemplate)template2;
            templateContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION_DESCRIPTIONS, Printer.getConfigurationDescriptionRecords(ruleTemplate.getConfigurationDescriptions())));
            templateContent.addAll(Printer.collectRecords(columnWidths, TRIGGERS, ruleTemplate.getTriggers()));
            templateContent.addAll(Printer.collectRecords(columnWidths, CONDITIONS, ruleTemplate.getConditions()));
            templateContent.addAll(Printer.collectRecords(columnWidths, ACTIONS, ruleTemplate.getActions()));
        }
        return Utils.getTableContent(100, columnWidths, templateContent, titleRow);
    }

    /*
     * WARNING - void declaration
     */
    static String printModuleType(ModuleType moduleType) {
        ModuleType moduleType2;
        ModuleType moduleType3;
        ModuleType moduleType4;
        ModuleType moduleType5;
        ModuleType moduleType6;
        int[] columnWidths = new int[]{100};
        ArrayList<String> moduleTypeProperty = new ArrayList<String>();
        moduleTypeProperty.add(moduleType.getUID());
        String titleRow = Utils.getRow(columnWidths, moduleTypeProperty);
        ArrayList<String> moduleTypeContent = new ArrayList<String>();
        columnWidths = new int[]{28, 72};
        moduleTypeProperty.set(0, UID);
        moduleTypeProperty.add(moduleType.getUID());
        moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        if (moduleType.getLabel() != null) {
            moduleTypeProperty.set(0, LABEL);
            moduleTypeProperty.set(1, moduleType.getLabel());
            moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        }
        if (moduleType.getDescription() != null) {
            moduleTypeProperty.set(0, DESCRIPTION);
            moduleTypeProperty.set(1, moduleType.getDescription());
            moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        }
        moduleTypeProperty.set(0, VISIBILITY);
        moduleTypeProperty.set(1, moduleType.getVisibility().toString());
        moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        moduleTypeProperty.set(0, TAGS);
        moduleTypeProperty.set(1, Printer.getTagsRecord(moduleType.getTags()));
        moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION_DESCRIPTIONS, Printer.getConfigurationDescriptionRecords(moduleType.getConfigurationDescriptions())));
        ModuleType moduleType7 = moduleType;
        if (moduleType7 instanceof TriggerType) {
            void type;
            TriggerType triggerType = (TriggerType)moduleType7;
            TriggerType cfr_ignored_0 = (TriggerType)moduleType7;
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, OUTPUTS, type.getOutputs()));
        }
        if ((moduleType6 = moduleType) instanceof ConditionType) {
            void type;
            ConditionType conditionType = (ConditionType)moduleType6;
            ConditionType cfr_ignored_1 = (ConditionType)moduleType6;
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, INPUTS, type.getInputs()));
        }
        if ((moduleType5 = moduleType) instanceof ActionType) {
            void type;
            ActionType actionType = (ActionType)moduleType5;
            ActionType cfr_ignored_2 = (ActionType)moduleType5;
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, INPUTS, type.getInputs()));
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, OUTPUTS, type.getOutputs()));
        }
        if ((moduleType4 = moduleType) instanceof CompositeTriggerType) {
            void type;
            CompositeTriggerType compositeTriggerType = (CompositeTriggerType)moduleType4;
            CompositeTriggerType cfr_ignored_3 = (CompositeTriggerType)moduleType4;
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CHILDREN, type.getChildren()));
        }
        if ((moduleType3 = moduleType) instanceof CompositeConditionType) {
            void type;
            CompositeConditionType compositeConditionType = (CompositeConditionType)moduleType3;
            CompositeConditionType cfr_ignored_4 = (CompositeConditionType)moduleType3;
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CHILDREN, type.getChildren()));
        }
        if ((moduleType2 = moduleType) instanceof CompositeActionType) {
            void type;
            CompositeActionType compositeActionType = (CompositeActionType)moduleType2;
            CompositeActionType cfr_ignored_5 = (CompositeActionType)moduleType2;
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CHILDREN, type.getChildren()));
        }
        return Utils.getTableContent(100, columnWidths, moduleTypeContent, titleRow);
    }

    static String printRuleStatus(String ruleUID, RuleStatus status) {
        ArrayList<String> title = new ArrayList<String>();
        title.add(ruleUID + " [ " + String.valueOf((Object)status) + " ]");
        String titleRow = Utils.getRow(new int[]{100}, title);
        List<String> res = Utils.getTableTitle(titleRow, 100);
        StringBuilder sb = new StringBuilder();
        for (String line : res) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> collectRecords(int[] columnWidths, String prop, Collection<?> list) {
        ArrayList<String> res = new ArrayList<String>();
        boolean isFirst = true;
        boolean isList = false;
        ArrayList<String> values = new ArrayList<String>();
        values.add(prop);
        values.add("");
        if (list != null && !list.isEmpty()) {
            for (Object element : list) {
                Object obj = element;
                if (obj instanceof String) {
                    void string;
                    String cfr_ignored_0 = (String)obj;
                    String cfr_ignored_1 = (String)obj;
                    res.add(Utils.getColumn(columnWidths[0], (String)values.get(0)) + (String)string);
                    if (!isFirst) continue;
                    isFirst = false;
                    values.set(0, "");
                    continue;
                }
                Object obj2 = element;
                if (obj2 instanceof Module) {
                    void module;
                    Module cfr_ignored_2 = (Module)obj2;
                    Module cfr_ignored_3 = (Module)obj2;
                    FilterCriteria moduleRecords = Printer.getModuleRecords((Module)module);
                    for (String elementRecord : moduleRecords) {
                        res.add(Utils.getColumn(columnWidths[0], (String)values.get(0)) + elementRecord);
                        if (!isFirst) continue;
                        isFirst = false;
                        values.set(0, "");
                    }
                    continue;
                }
                isList = true;
                if (isFirst) {
                    values.set(1, "[");
                    res.add(Utils.getRow(columnWidths, values));
                    isFirst = false;
                }
                values.set(0, "");
                Object obj3 = element;
                if (obj3 instanceof FilterCriteria) {
                    void criteria;
                    FilterCriteria cfr_ignored_4 = (FilterCriteria)obj3;
                    FilterCriteria cfr_ignored_5 = (FilterCriteria)obj3;
                    values.set(1, Printer.getFilterCriteriaRecord((FilterCriteria)criteria));
                } else {
                    Object obj4 = element;
                    if (obj4 instanceof ParameterOption) {
                        void option;
                        ParameterOption cfr_ignored_6 = (ParameterOption)obj4;
                        ParameterOption cfr_ignored_7 = (ParameterOption)obj4;
                        values.set(1, Printer.getParameterOptionRecord((ParameterOption)option));
                    } else {
                        Object obj5 = element;
                        if (obj5 instanceof Input) {
                            void input;
                            Input cfr_ignored_8 = (Input)obj5;
                            Input cfr_ignored_9 = (Input)obj5;
                            values.set(1, Printer.getInputRecord((Input)input));
                        } else {
                            Object obj6 = element;
                            if (obj6 instanceof Output) {
                                void output;
                                Output cfr_ignored_10 = (Output)obj6;
                                Output cfr_ignored_11 = (Output)obj6;
                                values.set(1, Printer.getOutputRecord((Output)output));
                            } else if (element instanceof Map.Entry) {
                                values.set(1, "  " + (String)((Map.Entry)element).getKey() + " = \"" + ((Map.Entry)element).getValue().toString() + "\"");
                            }
                        }
                    }
                }
                res.add(Utils.getRow(columnWidths, values));
            }
            if (isList) {
                values.set(0, "");
                values.set(1, "]");
                res.add(Utils.getRow(columnWidths, values));
            }
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getModuleRecords(Module module) {
        Module module2;
        int[] columnWidths = new int[]{72};
        ArrayList<String> columnValues = new ArrayList<String>();
        columnValues.add(module.getId());
        ArrayList<String> moduleContent = new ArrayList<String>(Utils.getTableTitle(Utils.getRow(columnWidths, columnValues), 72));
        columnWidths = new int[]{20, 52};
        columnValues.set(0, ID);
        columnValues.add(module.getId());
        moduleContent.add(Utils.getRow(columnWidths, columnValues));
        if (module.getLabel() != null) {
            columnValues.set(0, LABEL);
            columnValues.set(1, module.getLabel());
            moduleContent.add(Utils.getRow(columnWidths, columnValues));
        }
        if (module.getDescription() != null) {
            columnValues.set(0, DESCRIPTION);
            columnValues.set(1, module.getDescription());
            moduleContent.add(Utils.getRow(columnWidths, columnValues));
        }
        columnValues.set(0, TYPE);
        columnValues.set(1, module.getTypeUID());
        moduleContent.add(Utils.getRow(columnWidths, columnValues));
        moduleContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION, module.getConfiguration().getProperties().entrySet()));
        Map<String, String> inputs = null;
        Module module3 = module;
        if (module3 instanceof Condition) {
            void condition;
            Condition condition2 = (Condition)module3;
            Condition cfr_ignored_0 = (Condition)module3;
            inputs = condition.getInputs();
        }
        if ((module2 = module) instanceof Action) {
            void action;
            Action action2 = (Action)module2;
            Action cfr_ignored_1 = (Action)module2;
            inputs = action.getInputs();
        }
        if (inputs != null && !inputs.isEmpty()) {
            moduleContent.addAll(Printer.collectRecords(columnWidths, INPUTS, new ArrayList<Map.Entry<String, String>>(inputs.entrySet())));
        }
        return moduleContent;
    }

    private static String getParameterOptionRecord(ParameterOption option) {
        return "  value=\"" + option.getValue() + "\", label=\"" + option.getLabel() + "\"";
    }

    private static String getFilterCriteriaRecord(FilterCriteria criteria) {
        return "  name=\"" + criteria.getName() + "\", value=\"" + criteria.getValue() + "\"";
    }

    private static String getInputRecord(Input input) {
        return "  name=\"" + input.getName() + "\", label=\"" + input.getLabel() + "\", decription=\"" + input.getDescription() + "\", type=\"" + input.getType() + "\", " + (input.isRequired() ? REQUIRED : NOT_REQUIRED) + (String)(input.getDefaultValue() != null ? "\", default=\"" + input.getDefaultValue() : "");
    }

    private static String getOutputRecord(Output output) {
        return "  name=\"" + output.getName() + "\", label=\"" + output.getLabel() + "\", decription=\"" + output.getDescription() + "\", type=\"" + output.getType() + "\"";
    }

    private static List<String> getConfigurationDescriptionRecords(List<ConfigDescriptionParameter> configDescriptions) {
        ArrayList<String> configParamContent = new ArrayList<String>();
        if (configDescriptions != null && !configDescriptions.isEmpty()) {
            for (ConfigDescriptionParameter parameter : configDescriptions) {
                int[] columnWidths = new int[]{20, 16, 36};
                configParamContent.add(Utils.getColumn(72, parameter.getName() + " : "));
                ArrayList<String> configParamProperty = new ArrayList<String>();
                configParamProperty.add("");
                configParamProperty.add(TYPE);
                configParamProperty.add(parameter.getType().toString());
                configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                if (parameter.getLabel() != null) {
                    configParamProperty.set(1, LABEL);
                    configParamProperty.set(2, parameter.getLabel());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getDescription() != null) {
                    configParamProperty.set(1, DESCRIPTION);
                    configParamProperty.set(2, parameter.getDescription());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getDefault() != null) {
                    configParamProperty.set(1, DEFAULT);
                    configParamProperty.set(2, parameter.getDefault());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getContext() != null) {
                    configParamProperty.set(1, CONTEXT);
                    configParamProperty.set(2, parameter.getContext());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getPattern() != null) {
                    configParamProperty.set(1, PATTERN);
                    configParamProperty.set(2, parameter.getPattern());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getStepSize() != null) {
                    configParamProperty.set(1, STEP_SIZE);
                    configParamProperty.set(2, parameter.getStepSize().toString());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getMinimum() != null) {
                    configParamProperty.set(1, MIN);
                    configParamProperty.set(2, parameter.getMinimum().toString());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getMaximum() != null) {
                    configParamProperty.set(1, MAX);
                    configParamProperty.set(2, parameter.getMaximum().toString());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                columnWidths = new int[]{16, 36};
                List<String> options = Printer.collectRecords(columnWidths, OPTIONS, parameter.getOptions());
                for (String option : options) {
                    configParamContent.add(Utils.getColumn(20, "") + option);
                }
                List<String> filters = Printer.collectRecords(columnWidths, FILTER_CRITERIA, parameter.getFilterCriteria());
                for (String filter : filters) {
                    configParamContent.add(Utils.getColumn(20, "") + filter);
                }
                configParamContent.add(Utils.getColumn(72, Utils.printChars('-', 72)));
            }
        }
        return configParamContent;
    }

    private static String getTagsRecord(Set<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return "[ ]";
        }
        StringBuilder res = new StringBuilder().append("[ ");
        int i = 1;
        for (String tag : tags) {
            if (i < tags.size()) {
                res.append(tag + ", ");
            } else {
                res.append(tag);
            }
            ++i;
        }
        return res.append(" ]").toString();
    }

    private static void collectListRecords(Map<String, String> list, List<String> rows, int[] columnWidths) {
        int i = 1;
        while (i <= list.size()) {
            String id = String.valueOf(i);
            String uid = list.get(id);
            ArrayList<String> columnValues = new ArrayList<String>();
            columnValues.add(id);
            columnValues.add(uid);
            rows.add(Utils.getRow(columnWidths, columnValues));
            ++i;
        }
    }
}

