/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioHTTPServer;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.ByteArrayAudioStream;
import org.openhab.core.audio.ClonableAudioStream;
import org.openhab.core.audio.FileAudioStream;
import org.openhab.core.audio.FixedLengthAudioStream;
import org.openhab.core.audio.SizeableAudioStream;
import org.openhab.core.audio.StreamServed;
import org.openhab.core.audio.utils.AudioSinkUtils;
import org.openhab.core.common.ThreadPoolManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AudioHTTPServer.class, Servlet.class})
@HttpWhiteboardServletName(value="/audio")
@HttpWhiteboardServletPattern(value={"/audio/*"})
@NonNullByDefault
public class AudioServlet
extends HttpServlet
implements AudioHTTPServer {
    private static final long serialVersionUID = -3364664035854567854L;
    private static final List<String> WAV_MIME_TYPES = List.of("audio/wav", "audio/x-wav", "audio/vnd.wave");
    private static final int ONETIME_STREAM_BUFFER_MAX_SIZE = 0x100000;
    private static final int ONETIME_STREAM_FILE_MAX_SIZE = 0x500000;
    static final String SERVLET_PATH = "/audio";
    private final Logger logger = LoggerFactory.getLogger(AudioServlet.class);
    private final Map<String, StreamServed> servedStreams = new ConcurrentHashMap<String, StreamServed>();
    private final ScheduledExecutorService threadPool = ThreadPoolManager.getScheduledPool((String)"common");
    @Nullable ScheduledFuture<?> periodicCleaner;
    private AudioSinkUtils audioSinkUtils;

    @Activate
    public AudioServlet(@Reference AudioSinkUtils audioSinkUtils) {
        this.audioSinkUtils = audioSinkUtils;
    }

    @Deactivate
    protected synchronized void deactivate() {
        this.servedStreams.values().stream().map(StreamServed::audioStream).forEach(this::tryClose);
        this.servedStreams.clear();
    }

    private void tryClose(@Nullable AudioStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private InputStream prepareInputStream(StreamServed streamServed, HttpServletResponse resp, List<String> acceptedMimeTypes) throws AudioException {
        AudioStream audioStream;
        AudioStream audioStream2;
        this.logger.debug("Stream to serve is {}", (Object)streamServed.url());
        String mimeType = "MP3".equals(streamServed.audioStream().getFormat().getCodec()) ? "audio/mpeg" : ("WAVE".equals(streamServed.audioStream().getFormat().getContainer()) ? WAV_MIME_TYPES.stream().filter(acceptedMimeTypes::contains).findFirst().orElse("audio/wav") : ("OGG".equals(streamServed.audioStream().getFormat().getContainer()) ? "audio/ogg" : null));
        if (mimeType != null) {
            resp.setContentType(mimeType);
        }
        if ((audioStream2 = streamServed.audioStream()) instanceof SizeableAudioStream) {
            SizeableAudioStream sizeableServedStream = (SizeableAudioStream)((Object)audioStream2);
            long size = sizeableServedStream.length();
            resp.setContentLength((int)size);
        }
        if (streamServed.multiTimeStream() && (audioStream = streamServed.audioStream()) instanceof ClonableAudioStream) {
            ClonableAudioStream clonableAudioStream = (ClonableAudioStream)((Object)audioStream);
            return clonableAudioStream.getClonedStream();
        }
        return streamServed.audioStream();
    }

    private String substringAfterLast(String str, String separator) {
        int index = str.lastIndexOf(separator);
        return index == -1 || index == str.length() - separator.length() ? "" : str.substring(index + separator.length());
    }

    private String substringBefore(String str, String separator) {
        int index = str.indexOf(separator);
        return index == -1 ? str : str.substring(0, index);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StreamServed servedStream;
        String streamId;
        block20: {
            String requestURI = req.getRequestURI();
            if (requestURI == null) {
                resp.sendError(500, "requestURI is null");
                return;
            }
            streamId = this.substringBefore(this.substringAfterLast(requestURI, "/"), ".");
            List<String> acceptedMimeTypes = Stream.of(Objects.requireNonNullElse(req.getHeader("Accept"), "").split(",")).map(String::trim).toList();
            servedStream = this.servedStreams.get(streamId);
            if (servedStream == null) {
                this.logger.debug("Received request for invalid stream id at {}", (Object)requestURI);
                resp.sendError(404);
                return;
            }
            AtomicInteger currentlyServedStream = servedStream.currentlyServedStream();
            if (currentlyServedStream.incrementAndGet() == 1 || servedStream.multiTimeStream()) {
                try {
                    try {
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (InputStream stream = this.prepareInputStream(servedStream, resp, acceptedMimeTypes);){
                            Long endOfPlayTimestamp = this.audioSinkUtils.transferAndAnalyzeLength(stream, (OutputStream)resp.getOutputStream(), servedStream.audioStream().getFormat());
                            if (endOfPlayTimestamp != null) {
                                servedStream.timeout().set(Math.max(servedStream.timeout().get(), endOfPlayTimestamp));
                                this.logger.debug("doGet endOfPlayTimestamp {} (delay from now {} nanoseconds) => new timeout timestamp {} nanoseconds", new Object[]{endOfPlayTimestamp, endOfPlayTimestamp - System.nanoTime(), servedStream.timeout().get()});
                            }
                            resp.flushBuffer();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (AudioException ex) {
                        resp.sendError(500, ex.getMessage());
                        currentlyServedStream.decrementAndGet();
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    currentlyServedStream.decrementAndGet();
                    throw throwable;
                }
                currentlyServedStream.decrementAndGet();
            } else {
                this.logger.debug("Received request for already consumed stream id at {}", (Object)requestURI);
                resp.sendError(404);
                return;
            }
        }
        if (!servedStream.multiTimeStream()) {
            this.servedStreams.remove(streamId);
            servedStream.playEnd().complete(null);
            this.logger.debug("Removed timed out stream {}", (Object)streamId);
        }
    }

    private synchronized void removeTimedOutStreams() {
        long now = System.nanoTime();
        List<String> toRemove = this.servedStreams.entrySet().stream().filter(e -> ((StreamServed)e.getValue()).timeout().get() < now && ((StreamServed)e.getValue()).currentlyServedStream().get() <= 0).map(Map.Entry::getKey).toList();
        toRemove.forEach(streamId -> {
            StreamServed streamServed = this.servedStreams.remove(streamId);
            if (streamServed != null) {
                this.tryClose(streamServed.audioStream());
                streamServed.playEnd().complete(null);
                this.logger.debug("Removed timed out stream {}", streamId);
            }
        });
        ScheduledFuture<?> periodicCleanerLocal = this.periodicCleaner;
        if (!this.servedStreams.isEmpty()) {
            if (periodicCleanerLocal == null || periodicCleanerLocal.isDone()) {
                this.periodicCleaner = this.threadPool.scheduleWithFixedDelay(this::removeTimedOutStreams, 2L, 2L, TimeUnit.SECONDS);
            }
        } else if (periodicCleanerLocal != null) {
            periodicCleanerLocal.cancel(true);
            this.periodicCleaner = null;
        }
    }

    @Override
    public String serve(AudioStream stream) {
        try {
            return this.serve(stream, 10, false).url();
        }
        catch (IOException e) {
            this.logger.warn("Cannot precache the audio stream to serve it", (Throwable)e);
            return this.getRelativeURL("error");
        }
    }

    @Override
    public String serve(AudioStream stream, int seconds) {
        try {
            return this.serve(stream, seconds, true).url();
        }
        catch (IOException e) {
            this.logger.warn("Cannot precache the audio stream to serve it", (Throwable)e);
            return this.getRelativeURL("error");
        }
    }

    @Override
    public StreamServed serve(AudioStream originalStream, int seconds, boolean multiTimeStream) throws IOException {
        String streamId = UUID.randomUUID().toString();
        AudioStream audioStream = originalStream;
        if (!(originalStream instanceof ClonableAudioStream) && multiTimeStream) {
            audioStream = this.createClonableInputStream(originalStream, streamId);
        }
        long timeOut = System.nanoTime() + TimeUnit.SECONDS.toNanos(seconds);
        this.logger.debug("timeout {} seconds => timestamp {} nanoseconds", (Object)seconds, (Object)timeOut);
        CompletableFuture<@Nullable Void> playEnd = new CompletableFuture<Void>();
        StreamServed streamToServe = new StreamServed(this.getRelativeURL(streamId), audioStream, new AtomicInteger(), new AtomicLong(timeOut), multiTimeStream, playEnd);
        this.servedStreams.put(streamId, streamToServe);
        this.removeTimedOutStreams();
        return streamToServe;
    }

    private AudioStream createClonableInputStream(AudioStream stream, String streamId) throws IOException {
        FixedLengthAudioStream clonableAudioStreamResult;
        byte[] dataBytes = stream.readNBytes(0x100001);
        if (dataBytes.length <= 0x100000) {
            clonableAudioStreamResult = new ByteArrayAudioStream(dataBytes, stream.getFormat());
        } else {
            File tempFile = Files.createTempFile(streamId, ".snd", new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                int length;
                ((OutputStream)outputStream).write(dataBytes);
                byte[] buf = new byte[8192];
                int fileSize = 0x100001;
                while ((length = stream.read(buf)) != -1 && fileSize < 0x500000) {
                    int lengthToWrite = Math.min(length, 0x500000 - fileSize);
                    ((OutputStream)outputStream).write(buf, 0, lengthToWrite);
                    fileSize += lengthToWrite;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                clonableAudioStreamResult = new FileAudioStream(tempFile, stream.getFormat(), true);
            }
            catch (AudioException e) {
                throw new IOException("Cannot find the cache file we just created.", e);
            }
        }
        this.tryClose(stream);
        return clonableAudioStreamResult;
    }

    Map<String, StreamServed> getServedStreams() {
        return Collections.unmodifiableMap(this.servedStreams);
    }

    private String getRelativeURL(String streamId) {
        return "/audio/" + streamId;
    }
}

