/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * require_extensions: GL_AMD_shader_trinary_minmax
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min3(-5, -5, -5) => -5
 * min3(-5, -5, -2) => -5
 * min3(-5, -5, -1) => -5
 * min3(-5, -5, 0) => -5
 * min3(-5, -5, 1) => -5
 * min3(-5, -5, 2) => -5
 * min3(-5, -5, 5) => -5
 * min3(-5, -2, -5) => -5
 * min3(-5, -2, -2) => -5
 * min3(-5, -2, -1) => -5
 * min3(-5, -2, 0) => -5
 * min3(-5, -2, 1) => -5
 * min3(-5, -2, 2) => -5
 * min3(-5, -2, 5) => -5
 * min3(-5, -1, -5) => -5
 * min3(-5, -1, -2) => -5
 * min3(-5, -1, -1) => -5
 * min3(-5, -1, 0) => -5
 * min3(-5, -1, 1) => -5
 * min3(-5, -1, 2) => -5
 * min3(-5, -1, 5) => -5
 * min3(-5, 0, -5) => -5
 * min3(-5, 0, -2) => -5
 * min3(-5, 0, -1) => -5
 * min3(-5, 0, 0) => -5
 * min3(-5, 0, 1) => -5
 * min3(-5, 0, 2) => -5
 * min3(-5, 0, 5) => -5
 * min3(-5, 1, -5) => -5
 * min3(-5, 1, -2) => -5
 * min3(-5, 1, -1) => -5
 * min3(-5, 1, 0) => -5
 * min3(-5, 1, 1) => -5
 * min3(-5, 1, 2) => -5
 * min3(-5, 1, 5) => -5
 * min3(-5, 2, -5) => -5
 * min3(-5, 2, -2) => -5
 * min3(-5, 2, -1) => -5
 * min3(-5, 2, 0) => -5
 * min3(-5, 2, 1) => -5
 * min3(-5, 2, 2) => -5
 * min3(-5, 2, 5) => -5
 * min3(-5, 5, -5) => -5
 * min3(-5, 5, -2) => -5
 * min3(-5, 5, -1) => -5
 * min3(-5, 5, 0) => -5
 * min3(-5, 5, 1) => -5
 * min3(-5, 5, 2) => -5
 * min3(-5, 5, 5) => -5
 * min3(-2, -5, -5) => -5
 * min3(-2, -5, -2) => -5
 * min3(-2, -5, -1) => -5
 * min3(-2, -5, 0) => -5
 * min3(-2, -5, 1) => -5
 * min3(-2, -5, 2) => -5
 * min3(-2, -5, 5) => -5
 * min3(-2, -2, -5) => -5
 * min3(-2, -2, -2) => -2
 * min3(-2, -2, -1) => -2
 * min3(-2, -2, 0) => -2
 * min3(-2, -2, 1) => -2
 * min3(-2, -2, 2) => -2
 * min3(-2, -2, 5) => -2
 * min3(-2, -1, -5) => -5
 * min3(-2, -1, -2) => -2
 * min3(-2, -1, -1) => -2
 * min3(-2, -1, 0) => -2
 * min3(-2, -1, 1) => -2
 * min3(-2, -1, 2) => -2
 * min3(-2, -1, 5) => -2
 * min3(-2, 0, -5) => -5
 * min3(-2, 0, -2) => -2
 * min3(-2, 0, -1) => -2
 * min3(-2, 0, 0) => -2
 * min3(-2, 0, 1) => -2
 * min3(-2, 0, 2) => -2
 * min3(-2, 0, 5) => -2
 * min3(-2, 1, -5) => -5
 * min3(-2, 1, -2) => -2
 * min3(-2, 1, -1) => -2
 * min3(-2, 1, 0) => -2
 * min3(-2, 1, 1) => -2
 * min3(-2, 1, 2) => -2
 * min3(-2, 1, 5) => -2
 * min3(-2, 2, -5) => -5
 * min3(-2, 2, -2) => -2
 * min3(-2, 2, -1) => -2
 * min3(-2, 2, 0) => -2
 * min3(-2, 2, 1) => -2
 * min3(-2, 2, 2) => -2
 * min3(-2, 2, 5) => -2
 * min3(-2, 5, -5) => -5
 * min3(-2, 5, -2) => -2
 * min3(-2, 5, -1) => -2
 * min3(-2, 5, 0) => -2
 * min3(-2, 5, 1) => -2
 * min3(-2, 5, 2) => -2
 * min3(-2, 5, 5) => -2
 * min3(-1, -5, -5) => -5
 * min3(-1, -5, -2) => -5
 * min3(-1, -5, -1) => -5
 * min3(-1, -5, 0) => -5
 * min3(-1, -5, 1) => -5
 * min3(-1, -5, 2) => -5
 * min3(-1, -5, 5) => -5
 * min3(-1, -2, -5) => -5
 * min3(-1, -2, -2) => -2
 * min3(-1, -2, -1) => -2
 * min3(-1, -2, 0) => -2
 * min3(-1, -2, 1) => -2
 * min3(-1, -2, 2) => -2
 * min3(-1, -2, 5) => -2
 * min3(-1, -1, -5) => -5
 * min3(-1, -1, -2) => -2
 * min3(-1, -1, -1) => -1
 * min3(-1, -1, 0) => -1
 * min3(-1, -1, 1) => -1
 * min3(-1, -1, 2) => -1
 * min3(-1, -1, 5) => -1
 * min3(-1, 0, -5) => -5
 * min3(-1, 0, -2) => -2
 * min3(-1, 0, -1) => -1
 * min3(-1, 0, 0) => -1
 * min3(-1, 0, 1) => -1
 * min3(-1, 0, 2) => -1
 * min3(-1, 0, 5) => -1
 * min3(-1, 1, -5) => -5
 * min3(-1, 1, -2) => -2
 * min3(-1, 1, -1) => -1
 * min3(-1, 1, 0) => -1
 * min3(-1, 1, 1) => -1
 * min3(-1, 1, 2) => -1
 * min3(-1, 1, 5) => -1
 * min3(-1, 2, -5) => -5
 * min3(-1, 2, -2) => -2
 * min3(-1, 2, -1) => -1
 * min3(-1, 2, 0) => -1
 * min3(-1, 2, 1) => -1
 * min3(-1, 2, 2) => -1
 * min3(-1, 2, 5) => -1
 * min3(-1, 5, -5) => -5
 * min3(-1, 5, -2) => -2
 * min3(-1, 5, -1) => -1
 * min3(-1, 5, 0) => -1
 * min3(-1, 5, 1) => -1
 * min3(-1, 5, 2) => -1
 * min3(-1, 5, 5) => -1
 * min3(0, -5, -5) => -5
 * min3(0, -5, -2) => -5
 * min3(0, -5, -1) => -5
 * min3(0, -5, 0) => -5
 * min3(0, -5, 1) => -5
 * min3(0, -5, 2) => -5
 * min3(0, -5, 5) => -5
 * min3(0, -2, -5) => -5
 * min3(0, -2, -2) => -2
 * min3(0, -2, -1) => -2
 * min3(0, -2, 0) => -2
 * min3(0, -2, 1) => -2
 * min3(0, -2, 2) => -2
 * min3(0, -2, 5) => -2
 * min3(0, -1, -5) => -5
 * min3(0, -1, -2) => -2
 * min3(0, -1, -1) => -1
 * min3(0, -1, 0) => -1
 * min3(0, -1, 1) => -1
 * min3(0, -1, 2) => -1
 * min3(0, -1, 5) => -1
 * min3(0, 0, -5) => -5
 * min3(0, 0, -2) => -2
 * min3(0, 0, -1) => -1
 * min3(0, 0, 0) => 0
 * min3(0, 0, 1) => 0
 * min3(0, 0, 2) => 0
 * min3(0, 0, 5) => 0
 * min3(0, 1, -5) => -5
 * min3(0, 1, -2) => -2
 * min3(0, 1, -1) => -1
 * min3(0, 1, 0) => 0
 * min3(0, 1, 1) => 0
 * min3(0, 1, 2) => 0
 * min3(0, 1, 5) => 0
 * min3(0, 2, -5) => -5
 * min3(0, 2, -2) => -2
 * min3(0, 2, -1) => -1
 * min3(0, 2, 0) => 0
 * min3(0, 2, 1) => 0
 * min3(0, 2, 2) => 0
 * min3(0, 2, 5) => 0
 * min3(0, 5, -5) => -5
 * min3(0, 5, -2) => -2
 * min3(0, 5, -1) => -1
 * min3(0, 5, 0) => 0
 * min3(0, 5, 1) => 0
 * min3(0, 5, 2) => 0
 * min3(0, 5, 5) => 0
 * min3(1, -5, -5) => -5
 * min3(1, -5, -2) => -5
 * min3(1, -5, -1) => -5
 * min3(1, -5, 0) => -5
 * min3(1, -5, 1) => -5
 * min3(1, -5, 2) => -5
 * min3(1, -5, 5) => -5
 * min3(1, -2, -5) => -5
 * min3(1, -2, -2) => -2
 * min3(1, -2, -1) => -2
 * min3(1, -2, 0) => -2
 * min3(1, -2, 1) => -2
 * min3(1, -2, 2) => -2
 * min3(1, -2, 5) => -2
 * min3(1, -1, -5) => -5
 * min3(1, -1, -2) => -2
 * min3(1, -1, -1) => -1
 * min3(1, -1, 0) => -1
 * min3(1, -1, 1) => -1
 * min3(1, -1, 2) => -1
 * min3(1, -1, 5) => -1
 * min3(1, 0, -5) => -5
 * min3(1, 0, -2) => -2
 * min3(1, 0, -1) => -1
 * min3(1, 0, 0) => 0
 * min3(1, 0, 1) => 0
 * min3(1, 0, 2) => 0
 * min3(1, 0, 5) => 0
 * min3(1, 1, -5) => -5
 * min3(1, 1, -2) => -2
 * min3(1, 1, -1) => -1
 * min3(1, 1, 0) => 0
 * min3(1, 1, 1) => 1
 * min3(1, 1, 2) => 1
 * min3(1, 1, 5) => 1
 * min3(1, 2, -5) => -5
 * min3(1, 2, -2) => -2
 * min3(1, 2, -1) => -1
 * min3(1, 2, 0) => 0
 * min3(1, 2, 1) => 1
 * min3(1, 2, 2) => 1
 * min3(1, 2, 5) => 1
 * min3(1, 5, -5) => -5
 * min3(1, 5, -2) => -2
 * min3(1, 5, -1) => -1
 * min3(1, 5, 0) => 0
 * min3(1, 5, 1) => 1
 * min3(1, 5, 2) => 1
 * min3(1, 5, 5) => 1
 * min3(2, -5, -5) => -5
 * min3(2, -5, -2) => -5
 * min3(2, -5, -1) => -5
 * min3(2, -5, 0) => -5
 * min3(2, -5, 1) => -5
 * min3(2, -5, 2) => -5
 * min3(2, -5, 5) => -5
 * min3(2, -2, -5) => -5
 * min3(2, -2, -2) => -2
 * min3(2, -2, -1) => -2
 * min3(2, -2, 0) => -2
 * min3(2, -2, 1) => -2
 * min3(2, -2, 2) => -2
 * min3(2, -2, 5) => -2
 * min3(2, -1, -5) => -5
 * min3(2, -1, -2) => -2
 * min3(2, -1, -1) => -1
 * min3(2, -1, 0) => -1
 * min3(2, -1, 1) => -1
 * min3(2, -1, 2) => -1
 * min3(2, -1, 5) => -1
 * min3(2, 0, -5) => -5
 * min3(2, 0, -2) => -2
 * min3(2, 0, -1) => -1
 * min3(2, 0, 0) => 0
 * min3(2, 0, 1) => 0
 * min3(2, 0, 2) => 0
 * min3(2, 0, 5) => 0
 * min3(2, 1, -5) => -5
 * min3(2, 1, -2) => -2
 * min3(2, 1, -1) => -1
 * min3(2, 1, 0) => 0
 * min3(2, 1, 1) => 1
 * min3(2, 1, 2) => 1
 * min3(2, 1, 5) => 1
 * min3(2, 2, -5) => -5
 * min3(2, 2, -2) => -2
 * min3(2, 2, -1) => -1
 * min3(2, 2, 0) => 0
 * min3(2, 2, 1) => 1
 * min3(2, 2, 2) => 2
 * min3(2, 2, 5) => 2
 * min3(2, 5, -5) => -5
 * min3(2, 5, -2) => -2
 * min3(2, 5, -1) => -1
 * min3(2, 5, 0) => 0
 * min3(2, 5, 1) => 1
 * min3(2, 5, 2) => 2
 * min3(2, 5, 5) => 2
 * min3(5, -5, -5) => -5
 * min3(5, -5, -2) => -5
 * min3(5, -5, -1) => -5
 * min3(5, -5, 0) => -5
 * min3(5, -5, 1) => -5
 * min3(5, -5, 2) => -5
 * min3(5, -5, 5) => -5
 * min3(5, -2, -5) => -5
 * min3(5, -2, -2) => -2
 * min3(5, -2, -1) => -2
 * min3(5, -2, 0) => -2
 * min3(5, -2, 1) => -2
 * min3(5, -2, 2) => -2
 * min3(5, -2, 5) => -2
 * min3(5, -1, -5) => -5
 * min3(5, -1, -2) => -2
 * min3(5, -1, -1) => -1
 * min3(5, -1, 0) => -1
 * min3(5, -1, 1) => -1
 * min3(5, -1, 2) => -1
 * min3(5, -1, 5) => -1
 * min3(5, 0, -5) => -5
 * min3(5, 0, -2) => -2
 * min3(5, 0, -1) => -1
 * min3(5, 0, 0) => 0
 * min3(5, 0, 1) => 0
 * min3(5, 0, 2) => 0
 * min3(5, 0, 5) => 0
 * min3(5, 1, -5) => -5
 * min3(5, 1, -2) => -2
 * min3(5, 1, -1) => -1
 * min3(5, 1, 0) => 0
 * min3(5, 1, 1) => 1
 * min3(5, 1, 2) => 1
 * min3(5, 1, 5) => 1
 * min3(5, 2, -5) => -5
 * min3(5, 2, -2) => -2
 * min3(5, 2, -1) => -1
 * min3(5, 2, 0) => 0
 * min3(5, 2, 1) => 1
 * min3(5, 2, 2) => 2
 * min3(5, 2, 5) => 2
 * min3(5, 5, -5) => -5
 * min3(5, 5, -2) => -2
 * min3(5, 5, -1) => -1
 * min3(5, 5, 0) => 0
 * min3(5, 5, 1) => 1
 * min3(5, 5, 2) => 2
 * min3(5, 5, 5) => 5
 */
#version 130
#extension GL_AMD_shader_trinary_minmax : require

void main()
{
  float[min3(-5, -5, -5) == -5 ? 1 : -1] array0;
  float[min3(-5, -5, -2) == -5 ? 1 : -1] array1;
  float[min3(-5, -5, -1) == -5 ? 1 : -1] array2;
  float[min3(-5, -5, 0) == -5 ? 1 : -1] array3;
  float[min3(-5, -5, 1) == -5 ? 1 : -1] array4;
  float[min3(-5, -5, 2) == -5 ? 1 : -1] array5;
  float[min3(-5, -5, 5) == -5 ? 1 : -1] array6;
  float[min3(-5, -2, -5) == -5 ? 1 : -1] array7;
  float[min3(-5, -2, -2) == -5 ? 1 : -1] array8;
  float[min3(-5, -2, -1) == -5 ? 1 : -1] array9;
  float[min3(-5, -2, 0) == -5 ? 1 : -1] array10;
  float[min3(-5, -2, 1) == -5 ? 1 : -1] array11;
  float[min3(-5, -2, 2) == -5 ? 1 : -1] array12;
  float[min3(-5, -2, 5) == -5 ? 1 : -1] array13;
  float[min3(-5, -1, -5) == -5 ? 1 : -1] array14;
  float[min3(-5, -1, -2) == -5 ? 1 : -1] array15;
  float[min3(-5, -1, -1) == -5 ? 1 : -1] array16;
  float[min3(-5, -1, 0) == -5 ? 1 : -1] array17;
  float[min3(-5, -1, 1) == -5 ? 1 : -1] array18;
  float[min3(-5, -1, 2) == -5 ? 1 : -1] array19;
  float[min3(-5, -1, 5) == -5 ? 1 : -1] array20;
  float[min3(-5, 0, -5) == -5 ? 1 : -1] array21;
  float[min3(-5, 0, -2) == -5 ? 1 : -1] array22;
  float[min3(-5, 0, -1) == -5 ? 1 : -1] array23;
  float[min3(-5, 0, 0) == -5 ? 1 : -1] array24;
  float[min3(-5, 0, 1) == -5 ? 1 : -1] array25;
  float[min3(-5, 0, 2) == -5 ? 1 : -1] array26;
  float[min3(-5, 0, 5) == -5 ? 1 : -1] array27;
  float[min3(-5, 1, -5) == -5 ? 1 : -1] array28;
  float[min3(-5, 1, -2) == -5 ? 1 : -1] array29;
  float[min3(-5, 1, -1) == -5 ? 1 : -1] array30;
  float[min3(-5, 1, 0) == -5 ? 1 : -1] array31;
  float[min3(-5, 1, 1) == -5 ? 1 : -1] array32;
  float[min3(-5, 1, 2) == -5 ? 1 : -1] array33;
  float[min3(-5, 1, 5) == -5 ? 1 : -1] array34;
  float[min3(-5, 2, -5) == -5 ? 1 : -1] array35;
  float[min3(-5, 2, -2) == -5 ? 1 : -1] array36;
  float[min3(-5, 2, -1) == -5 ? 1 : -1] array37;
  float[min3(-5, 2, 0) == -5 ? 1 : -1] array38;
  float[min3(-5, 2, 1) == -5 ? 1 : -1] array39;
  float[min3(-5, 2, 2) == -5 ? 1 : -1] array40;
  float[min3(-5, 2, 5) == -5 ? 1 : -1] array41;
  float[min3(-5, 5, -5) == -5 ? 1 : -1] array42;
  float[min3(-5, 5, -2) == -5 ? 1 : -1] array43;
  float[min3(-5, 5, -1) == -5 ? 1 : -1] array44;
  float[min3(-5, 5, 0) == -5 ? 1 : -1] array45;
  float[min3(-5, 5, 1) == -5 ? 1 : -1] array46;
  float[min3(-5, 5, 2) == -5 ? 1 : -1] array47;
  float[min3(-5, 5, 5) == -5 ? 1 : -1] array48;
  float[min3(-2, -5, -5) == -5 ? 1 : -1] array49;
  float[min3(-2, -5, -2) == -5 ? 1 : -1] array50;
  float[min3(-2, -5, -1) == -5 ? 1 : -1] array51;
  float[min3(-2, -5, 0) == -5 ? 1 : -1] array52;
  float[min3(-2, -5, 1) == -5 ? 1 : -1] array53;
  float[min3(-2, -5, 2) == -5 ? 1 : -1] array54;
  float[min3(-2, -5, 5) == -5 ? 1 : -1] array55;
  float[min3(-2, -2, -5) == -5 ? 1 : -1] array56;
  float[min3(-2, -2, -2) == -2 ? 1 : -1] array57;
  float[min3(-2, -2, -1) == -2 ? 1 : -1] array58;
  float[min3(-2, -2, 0) == -2 ? 1 : -1] array59;
  float[min3(-2, -2, 1) == -2 ? 1 : -1] array60;
  float[min3(-2, -2, 2) == -2 ? 1 : -1] array61;
  float[min3(-2, -2, 5) == -2 ? 1 : -1] array62;
  float[min3(-2, -1, -5) == -5 ? 1 : -1] array63;
  float[min3(-2, -1, -2) == -2 ? 1 : -1] array64;
  float[min3(-2, -1, -1) == -2 ? 1 : -1] array65;
  float[min3(-2, -1, 0) == -2 ? 1 : -1] array66;
  float[min3(-2, -1, 1) == -2 ? 1 : -1] array67;
  float[min3(-2, -1, 2) == -2 ? 1 : -1] array68;
  float[min3(-2, -1, 5) == -2 ? 1 : -1] array69;
  float[min3(-2, 0, -5) == -5 ? 1 : -1] array70;
  float[min3(-2, 0, -2) == -2 ? 1 : -1] array71;
  float[min3(-2, 0, -1) == -2 ? 1 : -1] array72;
  float[min3(-2, 0, 0) == -2 ? 1 : -1] array73;
  float[min3(-2, 0, 1) == -2 ? 1 : -1] array74;
  float[min3(-2, 0, 2) == -2 ? 1 : -1] array75;
  float[min3(-2, 0, 5) == -2 ? 1 : -1] array76;
  float[min3(-2, 1, -5) == -5 ? 1 : -1] array77;
  float[min3(-2, 1, -2) == -2 ? 1 : -1] array78;
  float[min3(-2, 1, -1) == -2 ? 1 : -1] array79;
  float[min3(-2, 1, 0) == -2 ? 1 : -1] array80;
  float[min3(-2, 1, 1) == -2 ? 1 : -1] array81;
  float[min3(-2, 1, 2) == -2 ? 1 : -1] array82;
  float[min3(-2, 1, 5) == -2 ? 1 : -1] array83;
  float[min3(-2, 2, -5) == -5 ? 1 : -1] array84;
  float[min3(-2, 2, -2) == -2 ? 1 : -1] array85;
  float[min3(-2, 2, -1) == -2 ? 1 : -1] array86;
  float[min3(-2, 2, 0) == -2 ? 1 : -1] array87;
  float[min3(-2, 2, 1) == -2 ? 1 : -1] array88;
  float[min3(-2, 2, 2) == -2 ? 1 : -1] array89;
  float[min3(-2, 2, 5) == -2 ? 1 : -1] array90;
  float[min3(-2, 5, -5) == -5 ? 1 : -1] array91;
  float[min3(-2, 5, -2) == -2 ? 1 : -1] array92;
  float[min3(-2, 5, -1) == -2 ? 1 : -1] array93;
  float[min3(-2, 5, 0) == -2 ? 1 : -1] array94;
  float[min3(-2, 5, 1) == -2 ? 1 : -1] array95;
  float[min3(-2, 5, 2) == -2 ? 1 : -1] array96;
  float[min3(-2, 5, 5) == -2 ? 1 : -1] array97;
  float[min3(-1, -5, -5) == -5 ? 1 : -1] array98;
  float[min3(-1, -5, -2) == -5 ? 1 : -1] array99;
  float[min3(-1, -5, -1) == -5 ? 1 : -1] array100;
  float[min3(-1, -5, 0) == -5 ? 1 : -1] array101;
  float[min3(-1, -5, 1) == -5 ? 1 : -1] array102;
  float[min3(-1, -5, 2) == -5 ? 1 : -1] array103;
  float[min3(-1, -5, 5) == -5 ? 1 : -1] array104;
  float[min3(-1, -2, -5) == -5 ? 1 : -1] array105;
  float[min3(-1, -2, -2) == -2 ? 1 : -1] array106;
  float[min3(-1, -2, -1) == -2 ? 1 : -1] array107;
  float[min3(-1, -2, 0) == -2 ? 1 : -1] array108;
  float[min3(-1, -2, 1) == -2 ? 1 : -1] array109;
  float[min3(-1, -2, 2) == -2 ? 1 : -1] array110;
  float[min3(-1, -2, 5) == -2 ? 1 : -1] array111;
  float[min3(-1, -1, -5) == -5 ? 1 : -1] array112;
  float[min3(-1, -1, -2) == -2 ? 1 : -1] array113;
  float[min3(-1, -1, -1) == -1 ? 1 : -1] array114;
  float[min3(-1, -1, 0) == -1 ? 1 : -1] array115;
  float[min3(-1, -1, 1) == -1 ? 1 : -1] array116;
  float[min3(-1, -1, 2) == -1 ? 1 : -1] array117;
  float[min3(-1, -1, 5) == -1 ? 1 : -1] array118;
  float[min3(-1, 0, -5) == -5 ? 1 : -1] array119;
  float[min3(-1, 0, -2) == -2 ? 1 : -1] array120;
  float[min3(-1, 0, -1) == -1 ? 1 : -1] array121;
  float[min3(-1, 0, 0) == -1 ? 1 : -1] array122;
  float[min3(-1, 0, 1) == -1 ? 1 : -1] array123;
  float[min3(-1, 0, 2) == -1 ? 1 : -1] array124;
  float[min3(-1, 0, 5) == -1 ? 1 : -1] array125;
  float[min3(-1, 1, -5) == -5 ? 1 : -1] array126;
  float[min3(-1, 1, -2) == -2 ? 1 : -1] array127;
  float[min3(-1, 1, -1) == -1 ? 1 : -1] array128;
  float[min3(-1, 1, 0) == -1 ? 1 : -1] array129;
  float[min3(-1, 1, 1) == -1 ? 1 : -1] array130;
  float[min3(-1, 1, 2) == -1 ? 1 : -1] array131;
  float[min3(-1, 1, 5) == -1 ? 1 : -1] array132;
  float[min3(-1, 2, -5) == -5 ? 1 : -1] array133;
  float[min3(-1, 2, -2) == -2 ? 1 : -1] array134;
  float[min3(-1, 2, -1) == -1 ? 1 : -1] array135;
  float[min3(-1, 2, 0) == -1 ? 1 : -1] array136;
  float[min3(-1, 2, 1) == -1 ? 1 : -1] array137;
  float[min3(-1, 2, 2) == -1 ? 1 : -1] array138;
  float[min3(-1, 2, 5) == -1 ? 1 : -1] array139;
  float[min3(-1, 5, -5) == -5 ? 1 : -1] array140;
  float[min3(-1, 5, -2) == -2 ? 1 : -1] array141;
  float[min3(-1, 5, -1) == -1 ? 1 : -1] array142;
  float[min3(-1, 5, 0) == -1 ? 1 : -1] array143;
  float[min3(-1, 5, 1) == -1 ? 1 : -1] array144;
  float[min3(-1, 5, 2) == -1 ? 1 : -1] array145;
  float[min3(-1, 5, 5) == -1 ? 1 : -1] array146;
  float[min3(0, -5, -5) == -5 ? 1 : -1] array147;
  float[min3(0, -5, -2) == -5 ? 1 : -1] array148;
  float[min3(0, -5, -1) == -5 ? 1 : -1] array149;
  float[min3(0, -5, 0) == -5 ? 1 : -1] array150;
  float[min3(0, -5, 1) == -5 ? 1 : -1] array151;
  float[min3(0, -5, 2) == -5 ? 1 : -1] array152;
  float[min3(0, -5, 5) == -5 ? 1 : -1] array153;
  float[min3(0, -2, -5) == -5 ? 1 : -1] array154;
  float[min3(0, -2, -2) == -2 ? 1 : -1] array155;
  float[min3(0, -2, -1) == -2 ? 1 : -1] array156;
  float[min3(0, -2, 0) == -2 ? 1 : -1] array157;
  float[min3(0, -2, 1) == -2 ? 1 : -1] array158;
  float[min3(0, -2, 2) == -2 ? 1 : -1] array159;
  float[min3(0, -2, 5) == -2 ? 1 : -1] array160;
  float[min3(0, -1, -5) == -5 ? 1 : -1] array161;
  float[min3(0, -1, -2) == -2 ? 1 : -1] array162;
  float[min3(0, -1, -1) == -1 ? 1 : -1] array163;
  float[min3(0, -1, 0) == -1 ? 1 : -1] array164;
  float[min3(0, -1, 1) == -1 ? 1 : -1] array165;
  float[min3(0, -1, 2) == -1 ? 1 : -1] array166;
  float[min3(0, -1, 5) == -1 ? 1 : -1] array167;
  float[min3(0, 0, -5) == -5 ? 1 : -1] array168;
  float[min3(0, 0, -2) == -2 ? 1 : -1] array169;
  float[min3(0, 0, -1) == -1 ? 1 : -1] array170;
  float[min3(0, 0, 0) == 0 ? 1 : -1] array171;
  float[min3(0, 0, 1) == 0 ? 1 : -1] array172;
  float[min3(0, 0, 2) == 0 ? 1 : -1] array173;
  float[min3(0, 0, 5) == 0 ? 1 : -1] array174;
  float[min3(0, 1, -5) == -5 ? 1 : -1] array175;
  float[min3(0, 1, -2) == -2 ? 1 : -1] array176;
  float[min3(0, 1, -1) == -1 ? 1 : -1] array177;
  float[min3(0, 1, 0) == 0 ? 1 : -1] array178;
  float[min3(0, 1, 1) == 0 ? 1 : -1] array179;
  float[min3(0, 1, 2) == 0 ? 1 : -1] array180;
  float[min3(0, 1, 5) == 0 ? 1 : -1] array181;
  float[min3(0, 2, -5) == -5 ? 1 : -1] array182;
  float[min3(0, 2, -2) == -2 ? 1 : -1] array183;
  float[min3(0, 2, -1) == -1 ? 1 : -1] array184;
  float[min3(0, 2, 0) == 0 ? 1 : -1] array185;
  float[min3(0, 2, 1) == 0 ? 1 : -1] array186;
  float[min3(0, 2, 2) == 0 ? 1 : -1] array187;
  float[min3(0, 2, 5) == 0 ? 1 : -1] array188;
  float[min3(0, 5, -5) == -5 ? 1 : -1] array189;
  float[min3(0, 5, -2) == -2 ? 1 : -1] array190;
  float[min3(0, 5, -1) == -1 ? 1 : -1] array191;
  float[min3(0, 5, 0) == 0 ? 1 : -1] array192;
  float[min3(0, 5, 1) == 0 ? 1 : -1] array193;
  float[min3(0, 5, 2) == 0 ? 1 : -1] array194;
  float[min3(0, 5, 5) == 0 ? 1 : -1] array195;
  float[min3(1, -5, -5) == -5 ? 1 : -1] array196;
  float[min3(1, -5, -2) == -5 ? 1 : -1] array197;
  float[min3(1, -5, -1) == -5 ? 1 : -1] array198;
  float[min3(1, -5, 0) == -5 ? 1 : -1] array199;
  float[min3(1, -5, 1) == -5 ? 1 : -1] array200;
  float[min3(1, -5, 2) == -5 ? 1 : -1] array201;
  float[min3(1, -5, 5) == -5 ? 1 : -1] array202;
  float[min3(1, -2, -5) == -5 ? 1 : -1] array203;
  float[min3(1, -2, -2) == -2 ? 1 : -1] array204;
  float[min3(1, -2, -1) == -2 ? 1 : -1] array205;
  float[min3(1, -2, 0) == -2 ? 1 : -1] array206;
  float[min3(1, -2, 1) == -2 ? 1 : -1] array207;
  float[min3(1, -2, 2) == -2 ? 1 : -1] array208;
  float[min3(1, -2, 5) == -2 ? 1 : -1] array209;
  float[min3(1, -1, -5) == -5 ? 1 : -1] array210;
  float[min3(1, -1, -2) == -2 ? 1 : -1] array211;
  float[min3(1, -1, -1) == -1 ? 1 : -1] array212;
  float[min3(1, -1, 0) == -1 ? 1 : -1] array213;
  float[min3(1, -1, 1) == -1 ? 1 : -1] array214;
  float[min3(1, -1, 2) == -1 ? 1 : -1] array215;
  float[min3(1, -1, 5) == -1 ? 1 : -1] array216;
  float[min3(1, 0, -5) == -5 ? 1 : -1] array217;
  float[min3(1, 0, -2) == -2 ? 1 : -1] array218;
  float[min3(1, 0, -1) == -1 ? 1 : -1] array219;
  float[min3(1, 0, 0) == 0 ? 1 : -1] array220;
  float[min3(1, 0, 1) == 0 ? 1 : -1] array221;
  float[min3(1, 0, 2) == 0 ? 1 : -1] array222;
  float[min3(1, 0, 5) == 0 ? 1 : -1] array223;
  float[min3(1, 1, -5) == -5 ? 1 : -1] array224;
  float[min3(1, 1, -2) == -2 ? 1 : -1] array225;
  float[min3(1, 1, -1) == -1 ? 1 : -1] array226;
  float[min3(1, 1, 0) == 0 ? 1 : -1] array227;
  float[min3(1, 1, 1) == 1 ? 1 : -1] array228;
  float[min3(1, 1, 2) == 1 ? 1 : -1] array229;
  float[min3(1, 1, 5) == 1 ? 1 : -1] array230;
  float[min3(1, 2, -5) == -5 ? 1 : -1] array231;
  float[min3(1, 2, -2) == -2 ? 1 : -1] array232;
  float[min3(1, 2, -1) == -1 ? 1 : -1] array233;
  float[min3(1, 2, 0) == 0 ? 1 : -1] array234;
  float[min3(1, 2, 1) == 1 ? 1 : -1] array235;
  float[min3(1, 2, 2) == 1 ? 1 : -1] array236;
  float[min3(1, 2, 5) == 1 ? 1 : -1] array237;
  float[min3(1, 5, -5) == -5 ? 1 : -1] array238;
  float[min3(1, 5, -2) == -2 ? 1 : -1] array239;
  float[min3(1, 5, -1) == -1 ? 1 : -1] array240;
  float[min3(1, 5, 0) == 0 ? 1 : -1] array241;
  float[min3(1, 5, 1) == 1 ? 1 : -1] array242;
  float[min3(1, 5, 2) == 1 ? 1 : -1] array243;
  float[min3(1, 5, 5) == 1 ? 1 : -1] array244;
  float[min3(2, -5, -5) == -5 ? 1 : -1] array245;
  float[min3(2, -5, -2) == -5 ? 1 : -1] array246;
  float[min3(2, -5, -1) == -5 ? 1 : -1] array247;
  float[min3(2, -5, 0) == -5 ? 1 : -1] array248;
  float[min3(2, -5, 1) == -5 ? 1 : -1] array249;
  float[min3(2, -5, 2) == -5 ? 1 : -1] array250;
  float[min3(2, -5, 5) == -5 ? 1 : -1] array251;
  float[min3(2, -2, -5) == -5 ? 1 : -1] array252;
  float[min3(2, -2, -2) == -2 ? 1 : -1] array253;
  float[min3(2, -2, -1) == -2 ? 1 : -1] array254;
  float[min3(2, -2, 0) == -2 ? 1 : -1] array255;
  float[min3(2, -2, 1) == -2 ? 1 : -1] array256;
  float[min3(2, -2, 2) == -2 ? 1 : -1] array257;
  float[min3(2, -2, 5) == -2 ? 1 : -1] array258;
  float[min3(2, -1, -5) == -5 ? 1 : -1] array259;
  float[min3(2, -1, -2) == -2 ? 1 : -1] array260;
  float[min3(2, -1, -1) == -1 ? 1 : -1] array261;
  float[min3(2, -1, 0) == -1 ? 1 : -1] array262;
  float[min3(2, -1, 1) == -1 ? 1 : -1] array263;
  float[min3(2, -1, 2) == -1 ? 1 : -1] array264;
  float[min3(2, -1, 5) == -1 ? 1 : -1] array265;
  float[min3(2, 0, -5) == -5 ? 1 : -1] array266;
  float[min3(2, 0, -2) == -2 ? 1 : -1] array267;
  float[min3(2, 0, -1) == -1 ? 1 : -1] array268;
  float[min3(2, 0, 0) == 0 ? 1 : -1] array269;
  float[min3(2, 0, 1) == 0 ? 1 : -1] array270;
  float[min3(2, 0, 2) == 0 ? 1 : -1] array271;
  float[min3(2, 0, 5) == 0 ? 1 : -1] array272;
  float[min3(2, 1, -5) == -5 ? 1 : -1] array273;
  float[min3(2, 1, -2) == -2 ? 1 : -1] array274;
  float[min3(2, 1, -1) == -1 ? 1 : -1] array275;
  float[min3(2, 1, 0) == 0 ? 1 : -1] array276;
  float[min3(2, 1, 1) == 1 ? 1 : -1] array277;
  float[min3(2, 1, 2) == 1 ? 1 : -1] array278;
  float[min3(2, 1, 5) == 1 ? 1 : -1] array279;
  float[min3(2, 2, -5) == -5 ? 1 : -1] array280;
  float[min3(2, 2, -2) == -2 ? 1 : -1] array281;
  float[min3(2, 2, -1) == -1 ? 1 : -1] array282;
  float[min3(2, 2, 0) == 0 ? 1 : -1] array283;
  float[min3(2, 2, 1) == 1 ? 1 : -1] array284;
  float[min3(2, 2, 2) == 2 ? 1 : -1] array285;
  float[min3(2, 2, 5) == 2 ? 1 : -1] array286;
  float[min3(2, 5, -5) == -5 ? 1 : -1] array287;
  float[min3(2, 5, -2) == -2 ? 1 : -1] array288;
  float[min3(2, 5, -1) == -1 ? 1 : -1] array289;
  float[min3(2, 5, 0) == 0 ? 1 : -1] array290;
  float[min3(2, 5, 1) == 1 ? 1 : -1] array291;
  float[min3(2, 5, 2) == 2 ? 1 : -1] array292;
  float[min3(2, 5, 5) == 2 ? 1 : -1] array293;
  float[min3(5, -5, -5) == -5 ? 1 : -1] array294;
  float[min3(5, -5, -2) == -5 ? 1 : -1] array295;
  float[min3(5, -5, -1) == -5 ? 1 : -1] array296;
  float[min3(5, -5, 0) == -5 ? 1 : -1] array297;
  float[min3(5, -5, 1) == -5 ? 1 : -1] array298;
  float[min3(5, -5, 2) == -5 ? 1 : -1] array299;
  float[min3(5, -5, 5) == -5 ? 1 : -1] array300;
  float[min3(5, -2, -5) == -5 ? 1 : -1] array301;
  float[min3(5, -2, -2) == -2 ? 1 : -1] array302;
  float[min3(5, -2, -1) == -2 ? 1 : -1] array303;
  float[min3(5, -2, 0) == -2 ? 1 : -1] array304;
  float[min3(5, -2, 1) == -2 ? 1 : -1] array305;
  float[min3(5, -2, 2) == -2 ? 1 : -1] array306;
  float[min3(5, -2, 5) == -2 ? 1 : -1] array307;
  float[min3(5, -1, -5) == -5 ? 1 : -1] array308;
  float[min3(5, -1, -2) == -2 ? 1 : -1] array309;
  float[min3(5, -1, -1) == -1 ? 1 : -1] array310;
  float[min3(5, -1, 0) == -1 ? 1 : -1] array311;
  float[min3(5, -1, 1) == -1 ? 1 : -1] array312;
  float[min3(5, -1, 2) == -1 ? 1 : -1] array313;
  float[min3(5, -1, 5) == -1 ? 1 : -1] array314;
  float[min3(5, 0, -5) == -5 ? 1 : -1] array315;
  float[min3(5, 0, -2) == -2 ? 1 : -1] array316;
  float[min3(5, 0, -1) == -1 ? 1 : -1] array317;
  float[min3(5, 0, 0) == 0 ? 1 : -1] array318;
  float[min3(5, 0, 1) == 0 ? 1 : -1] array319;
  float[min3(5, 0, 2) == 0 ? 1 : -1] array320;
  float[min3(5, 0, 5) == 0 ? 1 : -1] array321;
  float[min3(5, 1, -5) == -5 ? 1 : -1] array322;
  float[min3(5, 1, -2) == -2 ? 1 : -1] array323;
  float[min3(5, 1, -1) == -1 ? 1 : -1] array324;
  float[min3(5, 1, 0) == 0 ? 1 : -1] array325;
  float[min3(5, 1, 1) == 1 ? 1 : -1] array326;
  float[min3(5, 1, 2) == 1 ? 1 : -1] array327;
  float[min3(5, 1, 5) == 1 ? 1 : -1] array328;
  float[min3(5, 2, -5) == -5 ? 1 : -1] array329;
  float[min3(5, 2, -2) == -2 ? 1 : -1] array330;
  float[min3(5, 2, -1) == -1 ? 1 : -1] array331;
  float[min3(5, 2, 0) == 0 ? 1 : -1] array332;
  float[min3(5, 2, 1) == 1 ? 1 : -1] array333;
  float[min3(5, 2, 2) == 2 ? 1 : -1] array334;
  float[min3(5, 2, 5) == 2 ? 1 : -1] array335;
  float[min3(5, 5, -5) == -5 ? 1 : -1] array336;
  float[min3(5, 5, -2) == -2 ? 1 : -1] array337;
  float[min3(5, 5, -1) == -1 ? 1 : -1] array338;
  float[min3(5, 5, 0) == 0 ? 1 : -1] array339;
  float[min3(5, 5, 1) == 1 ? 1 : -1] array340;
  float[min3(5, 5, 2) == 2 ? 1 : -1] array341;
  float[min3(5, 5, 5) == 5 ? 1 : -1] array342;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length() + array60.length() + array61.length() + array62.length() + array63.length() + array64.length() + array65.length() + array66.length() + array67.length() + array68.length() + array69.length() + array70.length() + array71.length() + array72.length() + array73.length() + array74.length() + array75.length() + array76.length() + array77.length() + array78.length() + array79.length() + array80.length() + array81.length() + array82.length() + array83.length() + array84.length() + array85.length() + array86.length() + array87.length() + array88.length() + array89.length() + array90.length() + array91.length() + array92.length() + array93.length() + array94.length() + array95.length() + array96.length() + array97.length() + array98.length() + array99.length() + array100.length() + array101.length() + array102.length() + array103.length() + array104.length() + array105.length() + array106.length() + array107.length() + array108.length() + array109.length() + array110.length() + array111.length() + array112.length() + array113.length() + array114.length() + array115.length() + array116.length() + array117.length() + array118.length() + array119.length() + array120.length() + array121.length() + array122.length() + array123.length() + array124.length() + array125.length() + array126.length() + array127.length() + array128.length() + array129.length() + array130.length() + array131.length() + array132.length() + array133.length() + array134.length() + array135.length() + array136.length() + array137.length() + array138.length() + array139.length() + array140.length() + array141.length() + array142.length() + array143.length() + array144.length() + array145.length() + array146.length() + array147.length() + array148.length() + array149.length() + array150.length() + array151.length() + array152.length() + array153.length() + array154.length() + array155.length() + array156.length() + array157.length() + array158.length() + array159.length() + array160.length() + array161.length() + array162.length() + array163.length() + array164.length() + array165.length() + array166.length() + array167.length() + array168.length() + array169.length() + array170.length() + array171.length() + array172.length() + array173.length() + array174.length() + array175.length() + array176.length() + array177.length() + array178.length() + array179.length() + array180.length() + array181.length() + array182.length() + array183.length() + array184.length() + array185.length() + array186.length() + array187.length() + array188.length() + array189.length() + array190.length() + array191.length() + array192.length() + array193.length() + array194.length() + array195.length() + array196.length() + array197.length() + array198.length() + array199.length() + array200.length() + array201.length() + array202.length() + array203.length() + array204.length() + array205.length() + array206.length() + array207.length() + array208.length() + array209.length() + array210.length() + array211.length() + array212.length() + array213.length() + array214.length() + array215.length() + array216.length() + array217.length() + array218.length() + array219.length() + array220.length() + array221.length() + array222.length() + array223.length() + array224.length() + array225.length() + array226.length() + array227.length() + array228.length() + array229.length() + array230.length() + array231.length() + array232.length() + array233.length() + array234.length() + array235.length() + array236.length() + array237.length() + array238.length() + array239.length() + array240.length() + array241.length() + array242.length() + array243.length() + array244.length() + array245.length() + array246.length() + array247.length() + array248.length() + array249.length() + array250.length() + array251.length() + array252.length() + array253.length() + array254.length() + array255.length() + array256.length() + array257.length() + array258.length() + array259.length() + array260.length() + array261.length() + array262.length() + array263.length() + array264.length() + array265.length() + array266.length() + array267.length() + array268.length() + array269.length() + array270.length() + array271.length() + array272.length() + array273.length() + array274.length() + array275.length() + array276.length() + array277.length() + array278.length() + array279.length() + array280.length() + array281.length() + array282.length() + array283.length() + array284.length() + array285.length() + array286.length() + array287.length() + array288.length() + array289.length() + array290.length() + array291.length() + array292.length() + array293.length() + array294.length() + array295.length() + array296.length() + array297.length() + array298.length() + array299.length() + array300.length() + array301.length() + array302.length() + array303.length() + array304.length() + array305.length() + array306.length() + array307.length() + array308.length() + array309.length() + array310.length() + array311.length() + array312.length() + array313.length() + array314.length() + array315.length() + array316.length() + array317.length() + array318.length() + array319.length() + array320.length() + array321.length() + array322.length() + array323.length() + array324.length() + array325.length() + array326.length() + array327.length() + array328.length() + array329.length() + array330.length() + array331.length() + array332.length() + array333.length() + array334.length() + array335.length() + array336.length() + array337.length() + array338.length() + array339.length() + array340.length() + array341.length() + array342.length());
}
