/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet.selection;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.configuration.NamedItem;
import com.projectlibre1.dialog.RenameDialog;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projectlibre1.strings.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.BevelBorder;

public class SpreadSheetColumnsPopupMenu
extends JPopupMenu {
    protected final CommonSpreadSheet spreadSheet;
    private String type;

    private void setContents() {
        Object[] objectArray = Dictionary.getAll(this.type);
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl = this.spreadSheet.getFieldArray() == objectArray[i];
            this.add(new MenuAction(objectArray[i].toString(), this.spreadSheet, (ArrayList)objectArray[i], bl));
        }
    }

    public SpreadSheetColumnsPopupMenu(CommonSpreadSheet commonSpreadSheet, String string) {
        this.spreadSheet = commonSpreadSheet;
        this.type = string;
        this.setBorder(new BevelBorder(0));
        this.setContents();
    }

    private class MenuAction
    extends JRadioButtonMenuItem
    implements ActionListener {
        CommonSpreadSheet spreadSheet;
        ArrayList fields;
        private boolean current;

        MenuAction(String string, CommonSpreadSheet commonSpreadSheet, ArrayList arrayList, boolean bl) {
            super(string);
            this.current = false;
            if (bl) {
                this.setText("<html><span color=\"blue\"><u><b>" + string + " " + Messages.getString("Text.clickToRename") + "</b></u></span></html>");
            }
            this.fields = arrayList;
            this.spreadSheet = commonSpreadSheet;
            this.current = bl;
            this.setSelected(bl);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.spreadSheet.finishCurrentOperations();
            if (this.current) {
                RenameDialog.doRename(this.spreadSheet, (NamedItem)((Object)this.fields));
            } else {
                this.spreadSheet.setFieldArray(this.fields);
            }
        }
    }
}

