/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.EnumSet;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandFlagsRegistry;
import redis.clients.jedis.StaticCommandFlagsRegistryInitializer;
import redis.clients.jedis.annots.Internal;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.JedisByteMap;
import redis.clients.jedis.util.SafeEncoder;

@Internal
public class StaticCommandFlagsRegistry
implements CommandFlagsRegistry {
    public static final EnumSet<CommandFlagsRegistry.CommandFlag> EMPTY_FLAGS = EnumSet.noneOf(CommandFlagsRegistry.CommandFlag.class);
    private static final StaticCommandFlagsRegistry REGISTRY = StaticCommandFlagsRegistry.createRegistry();
    private final Commands commands;

    private StaticCommandFlagsRegistry(Commands commands) {
        this.commands = commands;
    }

    public static StaticCommandFlagsRegistry registry() {
        return REGISTRY;
    }

    private static StaticCommandFlagsRegistry createRegistry() {
        Builder builder = new Builder();
        StaticCommandFlagsRegistryInitializer.initialize(builder);
        return builder.build();
    }

    @Override
    public EnumSet<CommandFlagsRegistry.CommandFlag> getFlags(CommandArguments commandArguments) {
        ProtocolCommand cmd = commandArguments.getCommand();
        byte[] raw = cmd.getRaw();
        byte[] uppercaseBytes = SafeEncoder.toUpperCase(raw);
        CommandMeta commandMeta = this.commands.getCommand(uppercaseBytes);
        if (commandMeta == null) {
            return EMPTY_FLAGS;
        }
        if (!commandMeta.hasSubcommands()) {
            return commandMeta.getFlags();
        }
        byte[] subCommand = this.getSubCommand(commandArguments);
        if (subCommand != null) {
            CommandMeta subCommandMeta = commandMeta.getSubcommand(subCommand);
            if (subCommandMeta != null) {
                return subCommandMeta.getFlags();
            }
            return commandMeta.getFlags();
        }
        return commandMeta.getFlags();
    }

    private byte[] getSubCommand(CommandArguments commandArguments) {
        if (commandArguments.size() > 1) {
            Rawable secondArg = commandArguments.get(1);
            byte[] subRaw = secondArg.getRaw();
            return SafeEncoder.toUpperCase(subRaw);
        }
        return null;
    }

    public static class Builder {
        private final Commands commands = new Commands();

        public Builder register(String name, EnumSet<CommandFlagsRegistry.CommandFlag> flags) {
            this.commands.register(SafeEncoder.encode(name), new CommandMeta(flags));
            return this;
        }

        public Builder register(String name, String subcommand, EnumSet<CommandFlagsRegistry.CommandFlag> flags) {
            byte[] cmdName = SafeEncoder.encode(name);
            if (!this.commands.containsKey(cmdName)) {
                this.commands.register(SafeEncoder.encode(name), new CommandMeta(EMPTY_FLAGS));
            }
            byte[] subCmdName = SafeEncoder.encode(subcommand);
            this.commands.getCommand(cmdName).putSubCommand(subCmdName, new CommandMeta(flags));
            return this;
        }

        public StaticCommandFlagsRegistry build() {
            return new StaticCommandFlagsRegistry(this.commands);
        }
    }

    static class CommandMeta {
        final EnumSet<CommandFlagsRegistry.CommandFlag> flags;
        final Commands subcommands = new Commands();

        CommandMeta(EnumSet<CommandFlagsRegistry.CommandFlag> flags) {
            this.flags = flags;
        }

        void putSubCommand(byte[] subCommand, CommandMeta subCommandMeta) {
            this.subcommands.register(subCommand, subCommandMeta);
        }

        boolean hasSubcommands() {
            return !this.subcommands.isEmpty();
        }

        EnumSet<CommandFlagsRegistry.CommandFlag> getFlags() {
            if (this.flags == null) {
                return EMPTY_FLAGS;
            }
            return this.flags;
        }

        CommandMeta getSubcommand(byte[] subcommand) {
            return this.subcommands.getCommand(subcommand);
        }
    }

    static class Commands {
        final JedisByteMap<CommandMeta> commands = new JedisByteMap();

        Commands() {
        }

        boolean isEmpty() {
            return this.commands.isEmpty();
        }

        public Commands register(byte[] cmd, CommandMeta command) {
            this.commands.put(cmd, command);
            return this;
        }

        public boolean containsKey(byte[] command) {
            return this.commands.containsKey(command);
        }

        public CommandMeta getCommand(byte[] command) {
            return this.commands.get(command);
        }

        public Map<byte[], CommandMeta> getCommands() {
            return this.commands;
        }
    }
}

