/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RoboTrackProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_ID = 0;
    public static final int MSG_ACK = 128;
    public static final int MSG_GPS = 3;
    public static final int MSG_GSM = 4;
    public static final int MSG_IMAGE_START = 6;
    public static final int MSG_IMAGE_DATA = 7;
    public static final int MSG_IMAGE_END = 8;

    public RoboTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short type = buf.readUnsignedByte();
        if (type == 0) {
            buf.skipBytes(16);
            String imei = buf.readSlice(15).toString(StandardCharsets.US_ASCII);
            if (this.getDeviceSession(channel, remoteAddress, imei) != null && channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeByte(128);
                response.writeByte(1);
                response.writeByte(102);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        } else if (type == 3 || type == 4) {
            int i;
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setDeviceTime(new Date(buf.readUnsignedIntLE() * 1000L));
            if (type == 3) {
                position.setValid(true);
                position.setFixTime(position.getDeviceTime());
                position.setLatitude((double)buf.readIntLE() * 1.0E-6);
                position.setLongitude((double)buf.readIntLE() * 1.0E-6);
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readByte()));
            } else {
                this.getLastLocation(position, position.getDeviceTime());
                position.setNetwork(new Network(CellTower.from(buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), buf.readUnsignedShortLE())));
                buf.readUnsignedByte();
            }
            short value = buf.readUnsignedByte();
            position.set("sat", BitUtil.to(value, 4));
            position.set("rssi", BitUtil.between(value, 4, 7));
            position.set("motion", BitUtil.check(value, 7));
            value = buf.readUnsignedByte();
            position.set("charge", BitUtil.check(value, 0));
            for (i = 1; i <= 4; ++i) {
                position.set("in" + i, BitUtil.check(value, i));
            }
            position.set("batteryLevel", BitUtil.from(value, 5) * 100 / 7);
            position.set("deviceTemp", buf.readByte());
            for (i = 1; i <= 3; ++i) {
                position.set("adc" + i, buf.readUnsignedShortLE());
            }
            return position;
        }
        return null;
    }
}

