/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.SnapshotsSupport;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.HTMLTextAreaSearchUtils;
import org.graalvm.visualvm.threaddump.ThreadDump;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class OverviewViewSupport {
    OverviewViewSupport() {
    }

    static class SystemPropertiesViewSupport
    extends JPanel {
        SystemPropertiesViewSupport(Properties properties) {
            this.initComponents(properties);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_System_properties"), null, 20, (JComponent)this, null);
        }

        private void initComponents(Properties properties) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.formatSystemProperties(properties) + "</nobr>");
            area.setCaretPosition(0);
            area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)new ScrollableContainer((JComponent)area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)area), "South");
        }

        private String formatSystemProperties(Properties properties) {
            if (properties == null || properties.isEmpty()) {
                return NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Unknown");
            }
            StringBuilder text = new StringBuilder(200);
            ArrayList<Object> keys = new ArrayList<Object>();
            Enumeration<?> en = properties.propertyNames();
            while (en.hasMoreElements()) {
                keys.add(en.nextElement());
            }
            keys.sort(null);
            for (String string : keys) {
                String val = properties.getProperty(string);
                if ("line.separator".equals(string) && val != null) {
                    val = val.replace("\n", "\\n");
                    val = val.replace("\r", "\\r");
                }
                text.append("<b>");
                text.append(string);
                text.append("</b>=");
                text.append(val);
                text.append("<br>");
            }
            return text.toString();
        }
    }

    static class JVMArgumentsViewSupport
    extends JPanel {
        JVMArgumentsViewSupport(String jvmargs) {
            this.initComponents(jvmargs);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_arguments"), null, 10, (JComponent)this, null);
        }

        private void initComponents(String jvmargs) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.formatJVMArgs(jvmargs) + "</nobr>");
            area.setCaretPosition(0);
            area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)new ScrollableContainer((JComponent)area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)area), "South");
        }

        private String formatJVMArgs(String jvmargs) {
            if (jvmargs == null || jvmargs.isEmpty()) {
                return NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_none");
            }
            String mangledString = " ".concat(jvmargs).replace(" -", "\n");
            StringTokenizer tok = new StringTokenizer(mangledString, "\n");
            StringBuilder text = new StringBuilder(100);
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken().replace(" ", "&nbsp;");
                int equalsSign = arg.indexOf(61);
                text.append("<b>");
                text.append("-");
                if (equalsSign != -1) {
                    text.append(arg.substring(0, equalsSign));
                    text.append("</b>");
                    text.append(arg.substring(equalsSign));
                } else {
                    text.append(arg);
                    text.append("</b>");
                }
                text.append("<br>");
            }
            return text.toString();
        }
    }

    static class SnapshotsViewSupport
    extends JPanel
    implements JFREventVisitor {
        private static final Logger LOGGER = Logger.getLogger(SnapshotsViewSupport.class.getName());
        private static final String LINK_TOGGLE_CATEGORY = "file:/toggle_category/";
        private static final String LINK_OPEN_SNAPSHOT = "file:/open_snapshot/";
        private static final String CATEGORY_THREAD_DUMPS = "thread_dumps";
        private final JFRSnapshot snapshot;
        private final Map<String, Boolean> expansionMap = new HashMap<String, Boolean>();
        private List<Long> tdumpsTimestamps;
        private HTMLTextArea area;

        SnapshotsViewSupport(JFRSnapshot snapshot) {
            this.snapshot = snapshot;
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Saved_data"), null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.tdumpsTimestamps = new ArrayList<Long>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.ThreadDump".equals(typeName)) {
                try {
                    this.tdumpsTimestamps.add(ValuesConverter.instantToNanos(event.getInstant("eventTime")));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.tdumpsTimestamps);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    area.setText(this.getSavedData());
                }
            });
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea(this.getSavedData()){

                protected void showURL(URL url) {
                    String link = url.toString();
                    if (link.startsWith(SnapshotsViewSupport.LINK_TOGGLE_CATEGORY)) {
                        link = link.substring(SnapshotsViewSupport.LINK_TOGGLE_CATEGORY.length());
                        this.toggleExpanded(link);
                        this.setText(this.getSavedData());
                    } else if (link.startsWith(SnapshotsViewSupport.LINK_OPEN_SNAPSHOT)) {
                        link = link.substring(SnapshotsViewSupport.LINK_OPEN_SNAPSHOT.length());
                        this.openThreadDump(Long.parseLong(link));
                    }
                }
            };
            this.area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
        }

        private String getSavedData() {
            int tdumpsCount;
            StringBuilder data = new StringBuilder();
            int n = tdumpsCount = this.tdumpsTimestamps == null ? -1 : this.tdumpsTimestamps.size();
            if (tdumpsCount < 0) {
                data.append("<b>Progress:</b> reading data...");
            } else {
                data.append("<b>Thread Dumps:</b> ");
                if (tdumpsCount == 0) {
                    data.append(tdumpsCount);
                } else {
                    data.append("<a href='file:/toggle_category/thread_dumps'>" + tdumpsCount + "</a><br>");
                    if (this.isExpanded(CATEGORY_THREAD_DUMPS)) {
                        for (long timestamp : this.tdumpsTimestamps) {
                            data.append("&nbsp;&nbsp;&nbsp;<a href='file:/open_snapshot/" + timestamp + "'>[threaddump] " + SnapshotsSupport.getInstance().getTimeStamp(ValuesConverter.nanosToMillis(timestamp)) + "</a><br>");
                        }
                        data.append("<br>");
                    }
                }
            }
            return "<nobr>" + data.toString() + "</nobr>";
        }

        private boolean isExpanded(String categoryName) {
            Boolean expanded = this.expansionMap.get(categoryName);
            return expanded == null ? false : expanded;
        }

        private void toggleExpanded(String categoryName) {
            this.expansionMap.put(categoryName, !this.isExpanded(categoryName));
        }

        private void openThreadDump(final long timestamp) {
            final String name = "threaddump-" + Long.toString(ValuesConverter.nanosToMillis(timestamp));
            DataSource.EVENT_QUEUE.post(new Runnable(){

                @Override
                public void run() {
                    for (ThreadDump tdump : snapshot.getRepository().getDataSources(ThreadDump.class)) {
                        File tdumpF = tdump.getFile();
                        if (tdumpF == null || !tdumpF.getName().startsWith(name)) continue;
                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)tdump, true);
                        return;
                    }
                    this.openThreadDumpImpl(timestamp);
                }
            });
        }

        private void openThreadDumpImpl(final long timestamp) {
            new RequestProcessor("JFR Thread Dump Loader").post(new Runnable(){

                @Override
                public void run() {
                    JFRModelFactory.getJFRModelFor((DataSource)snapshot).visitEvents(new JFREventVisitor(){

                        @Override
                        public boolean visit(String typeName, JFREvent event) {
                            try {
                                if ("jdk.ThreadDump".equals(typeName) && ValuesConverter.instantToNanos(event.getInstant("eventTime")) == timestamp) {
                                    ThreadDump tdump = this.createThreadDump(ValuesConverter.nanosToMillis(timestamp), event.getString("result"));
                                    if (tdump != null) {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)tdump, true);
                                    }
                                    return true;
                                }
                            }
                            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                                // empty catch block
                            }
                            return false;
                        }
                    });
                }
            });
        }

        private ThreadDump createThreadDump(long timestamp, String result) {
            if (result == null) {
                return null;
            }
            String name = "threaddump-" + timestamp + ".tdump";
            File file = new File(this.snapshot.getStorage().getDirectory(), name);
            try (PrintWriter out = new PrintWriter(file);){
                out.println(result);
                file.deleteOnExit();
            }
            catch (FileNotFoundException ex) {
                LOGGER.log(Level.SEVERE, "Error saving thread dump", ex);
            }
            ThreadDump tdump = new ThreadDump(file, (DataSource)this.snapshot){
                {
                    super(x0, x1);
                    this.getStorage().setCustomProperty("prop_view_closable", Boolean.TRUE.toString());
                }
            };
            this.snapshot.getRepository().addDataSource((DataSource)tdump);
            return tdump;
        }
    }
}

