/*-------------------------------------------------------------------------
 *
 * unicode_norm_hashfunc.h
 *	  Perfect hash functions used for Unicode normalization
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_norm_hashfunc.h
 *
 *-------------------------------------------------------------------------
 */

/*
 * File auto-generated by src/common/unicode/generate-unicode_norm_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_NORM_HASHFUNC_H
 * here.
 */

#include "common/unicode_norm_table.h"

/* Typedef for perfect hash functions */
typedef int (*cp_hash_func) (const void *key);

/* Information for lookups with perfect hash functions */
typedef struct
{
	const pg_unicode_decomposition *decomps;
	cp_hash_func	hash;
	int		num_decomps;
} pg_unicode_decompinfo;

typedef struct
{
	const uint16	*inverse_lookup;
	cp_hash_func	hash;
	int		num_recomps;
} pg_unicode_recompinfo;

/* Perfect hash function for decomposition */
static int
Decomp_hash_func(const void *key)
{
	static const int16 h[13551] = {
		6102,  6103,  6104,  6105,  6106,  11163, 11164, 9247,
		3108,  32767, 32767, 5839,  5840,  11166, 3130,  3130,
		3130,  3130,  -1926, -1926, 9274,  9275,  9276,  9277,
		9278,  473,   473,   6107,  0,     6110,  6111,  -1569,
		9287,  9288,  9289,  9290,  9291,  9292,  9293,  9294,
		9295,  11077, 11078, 11079, 11080, 9300,  9301,  9302,
		9303,  9304,  9305,  9306,  9307,  9308,  9309,  9310,
		9311,  9312,  9313,  9314,  9315,  9316,  9317,  9318,
		9319,  9320,  4265,  4266,  -1834, 4268,  4269,  4270,
		4271,  4272,  9329,  9330,  7413,  1274,  1274,  1274,
		5264,  1274,  9337,  1301,  1301,  1301,  1301,  8982,
		-3754, 11381, 11382, 11383, 11384, 10049, 11386, 5605,
		5606,  5607,  5608,  5609,  5610,  5611,  5612,  465,
		465,   5617,  5618,  5619,  5620,  5621,  5622,  5623,
		465,   465,   465,   465,   465,   465,   465,   465,
		465,   465,   465,   465,   465,   465,   465,   465,
		465,   465,   465,   465,   465,   465,   465,   465,
		465,   465,   465,   465,   465,   465,   5256,  5256,
		-10103,5256,  465,   465,   5256,  5256,  465,   5939,
		465,   465,   465,   465,   465,   0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -71,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     -884,  -884,  -884,  -884,  -884,  -884,
		0,     -885,  -885,  -885,  -885,  -885,  -885,  0,
		0,     -886,  -886,  -886,  -886,  -886,  -4378, 0,
		-888,  -888,  422,   -888,  -888,  -888,  0,     -7896,
		-7896, -7896, 0,     0,     0,     0,     0,     1463,
		1463,  1463,  1463,  2951,  1464,  1464,  -18469,1464,
		1464,  1464,  1464,  1464,  1464,  1464,  1464,  1464,
		1215,  1216,  1464,  1464,  1464,  1464,  1464,  1464,
		1464,  1464,  0,     1465,  1465,  1465,  80,    1464,
		1464,  1464,  7565,  1464,  1464,  1464,  1464,  1464,
		88,    89,    90,    91,    92,    93,    94,    95,
		96,    97,    98,    99,    100,   101,   102,   32767,
		32767, 103,   104,   105,   106,   107,   108,   109,
		110,   111,   32767, 112,   113,   114,   115,   116,
		117,   32767, 118,   119,   120,   121,   122,   123,
		124,   0,     0,     0,     126,   0,     0,     0,
		0,     0,     0,     0,     4145,  4146,  4147,  4148,
		4149,  4150,  4151,  4152,  4153,  4154,  0,     0,
		0,     0,     0,     0,     4155,  4156,  4157,  4158,
		4159,  4160,  4161,  4162,  4163,  4164,  4165,  4166,
		4167,  4168,  4169,  4170,  4171,  4172,  4173,  4174,
		4175,  4176,  4177,  4178,  4179,  4180,  4181,  4182,
		4183,  4184,  4185,  4186,  4187,  4188,  4189,  179,
		180,   32767, 32767, 4192,  4193,  4194,  4195,  4196,
		4197,  4198,  4199,  4200,  4201,  4202,  4203,  32767,
		4204,  4205,  4206,  4207,  4208,  4209,  4210,  4211,
		4212,  4213,  4214,  4215,  4216,  4217,  4218,  4219,
		4220,  4221,  4222,  32767, 4223,  4224,  4225,  4226,
		32767, 32767, 32767, 32767, 4227,  4228,  4229,  32767,
		-4545, -5662, -5662, -5662, -5662, -5662, -5662, -5662,
		-5662, 4238,  4239,  -5664, -5664, -5664, -5664, -5664,
		-5664, -5664, -5664, 4248,  4249,  4250,  4251,  4252,
		4253,  -6935, -1879, -1879, 4222,  -1879, -1879, -1879,
		-1879, -1879, -6935, -6935, 4265,  4266,  4267,  4268,
		4269,  -4536, -4536, 1098,  1099,  1100,  1101,  -6579,
		4277,  4278,  4279,  4280,  4281,  4282,  4283,  4284,
		4285,  6067,  6068,  6069,  6070,  4290,  4291,  4292,
		4293,  4294,  4295,  4296,  4297,  4298,  4299,  4300,
		4301,  4302,  4303,  4304,  4305,  4306,  4307,  4308,
		4309,  4310,  -745,  -744,  -6844, -742,  -741,  -740,
		-739,  -738,  4319,  4320,  2403,  -3736, -3736, -3736,
		254,   -3736, 4327,  -3709, -3709, 4330,  0,     0,
		0,     0,     0,     0,     0,     -2997, -2997, 2705,
		2705,  2705,  2705,  2705,  2705,  2705,  2705,  2705,
		0,     0,     0,     0,     0,     0,     -4452, 0,
		0,     0,     0,     0,     2716,  0,     0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 1841,
		32767, 32767, 4710,  32767, 0,     32767, 32767, 0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 1845,  32767, 32767, 32767, 32767, 32767, 0,
		0,     32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1850,  32767, 32767, 0,
		32767, 32767, 0,     32767, 1853,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     284,   285,   286,   287,   288,   289,
		290,   291,   292,   0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     32767, 32767, 0,
		0,     32767, 32767, 0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 567,   567,   567,   567,   -1649, -4447,
		32767, 32767, 566,   566,   -1644, 566,   566,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     -1144, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     0,     304,   305,   306,   -2209, -2208,
		309,   2223,  311,   312,   313,   314,   315,   316,
		317,   318,   319,   320,   321,   322,   323,   324,
		325,   326,   -550,  328,   329,   330,   331,   332,
		333,   334,   335,   0,     0,     0,     0,     340,
		341,   342,   343,   -534,  345,   0,     0,     0,
		0,     -6511, 351,   352,   353,   354,   355,   356,
		357,   358,   359,   360,   361,   362,   363,   364,
		365,   366,   367,   368,   369,   370,   371,   372,
		373,   374,   375,   376,   377,   378,   379,   380,
		381,   382,   32767, 383,   384,   385,   386,   387,
		388,   389,   390,   391,   392,   393,   394,   395,
		396,   397,   398,   399,   400,   401,   402,   403,
		404,   405,   406,   407,   408,   4654,  410,   4655,
		412,   413,   414,   32767, 32767, 32767, 32767, 415,
		32767, 32767, 32767, 32767, 32767, 416,   32767, 32767,
		32767, -464,  32767, 32767, 32767, 32767, 32767, 418,
		419,   420,   421,   422,   423,   424,   32767, 425,
		32767, 426,   427,   428,   32767, 32767, 32767, 32767,
		4656,  4657,  4658,  32767, 32767, 32767, 32767, 4659,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 429,   430,   431,
		432,   433,   434,   435,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -2290, -2290, -2290,
		-2290, -2290, 32767, -2291, -2291, -2291, -2291, -2291,
		-2291, 2502,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 733,   733,   733,   32767, 732,
		732,   32767, 32767, 32767, 729,   32767, 0,     0,
		32767, 32767, 32767, 32767, -241,  -241,  32767, -242,
		32767, 32767, 32767, -4550, 32767, 32767, 32767, 32767,
		-249,  -1737, -1737, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -1747, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -291,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4660,  4661,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		3982,  3982,  3982,  32767, -1149, -1148, 32767, -1147,
		32767, 32767, 32767, -1146, 32767, 32767, 32767, 32767,
		-1145, -1144, -1143, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -4642, -1836, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -1839,
		-4651, -1838, -1838, 476,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 4708,  4709,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, -4703, -1851, 32767,
		32767, 32767, 32767, 32767, 4710,  4711,  4712,  32767,
		32767, 32767, 32767, 32767, -1857, -4716, -1856, -4716,
		32767, 32767, -4718, -1855, 32767, 32767, -4720, -905,
		-4720, -4720, -4720, -4720, 32767, 32767, -894,  -893,
		4714,  4715,  4716,  1689,  8219,  4719,  -4724, -1850,
		-1850, 3912,  4721,  4722,  4723,  4724,  -4724, -4724,
		-4724, -4724, 32767, 32767, -4726, -4726, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-1149, -1396, -1395, -1394, -1393, -1392, -1391, -1390,
		-1389, 76,    -1388, -1387, -1386, 0,     -1383, -1382,
		32767, 32767, -1381, -1380, -1379, -1378, -1377, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     32767, 0,     0,     0,     0,     0,     0,
		32767, 0,     0,     0,     0,     0,     0,     0,
		125,   32767, 32767, 0,     127,   128,   129,   130,
		131,   132,   32767, 32767, -4013, -4013, -4013, -4013,
		-4013, -4013, 32767, 32767, -4015, 140,   141,   142,
		143,   144,   145,   -4009, -4009, -4009, -4009, -4009,
		-4009, -4009, -4009, -4009, -4009, -4009, 32767, 32767,
		-4011, -4011, -4011, -4011, -4011, -4011, -4011, -4011,
		-4011, -4011, -4011, -4011, -4011, -4011, -4011, -4011,
		-4011, -4011, -4011, -4011, -4011, -4011, 0,     0,
		-2541, 32767, 32767, 32767, 32767, 32767, 512,   513,
		514,   515,   516,   517,   -441,  -441,  520,   521,
		522,   523,   524,   525,   526,   527,   528,   529,
		530,   531,   532,   533,   534,   535,   536,   537,
		-4040, -4040, 540,   541,   542,   543,   544,   545,
		546,   547,   548,   549,   550,   551,   552,   4728,
		5846,  555,   556,   32767, 557,   32767, 558,   559,
		32767, 560,   561,   32767, 562,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, -4065, -4065, -4065, -4065,
		7124,  2069,  2070,  -4030, 2072,  2073,  2074,  2075,
		2076,  7133,  7134,  -4065, -4065, -4065, -4065, -4065,
		4741,  4742,  -891,  -891,  -891,  32767, 6789,  -4066,
		-4066, -4066, -4066, -4066, 32767, 32767, -4068, -4068,
		-5849, -5849, -5849, -5849, -4068, -4068, -4068, -4068,
		-4068, -4068, -4068, -4068, -4068, -4068, 5832,  5833,
		-4070, -4070, -4070, -4070, -4070, -4070, -4070, -4070,
		5842,  5843,  5844,  5845,  5846,  5847,  -5341, -285,
		-285,  5816,  -285,  -285,  -285,  -285,  -285,  -5341,
		-5341, 5859,  5860,  5861,  5862,  5863,  -2942, -2942,
		2692,  2693,  2694,  2695,  -4985, 5871,  5872,  5873,
		5874,  5875,  5876,  5877,  5878,  5879,  7661,  7662,
		7663,  7664,  5884,  5885,  5886,  5887,  5888,  5889,
		5890,  5891,  5892,  5893,  5894,  5895,  5896,  5897,
		5898,  5899,  5900,  5901,  5902,  5903,  5904,  849,
		850,   -5250, 852,   853,   854,   855,   856,   5913,
		5914,  3997,  -2142, -2142, 590,   591,   592,   5918,
		-2118, -2118, -2118, -2118, 5563,  -7173, 7962,  7963,
		7964,  7965,  6630,  7967,  2186,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4034,  32767,
		32767, 32767, 5815,  5816,  5817,  5818,  5819,  5820,
		5821,  32767, 5822,  5823,  5824,  5825,  5826,  5827,
		5828,  5829,  -272,  -272,  -272,  -272,  -272,  -5328,
		-5328, -3410, 2730,  2731,  0,     0,     0,     -5325,
		2712,  2713,  2714,  2715,  -4965, 7772,  -3427, 32767,
		-3428, -3428, -3428, 5378,  5379,  32767, 32767, 32767,
		32767, 32767, -3434, -3434, -3434, -3434, -3434, -3434,
		-3434, -3434, -3434, -5215, -5215, -5215, -5215, -3434,
		-3434, -3434, -3434, -3434, -3434, -3434, -3434, -3434,
		-3434, -3434, -3434, -3434, -3434, -3434, -3434, -3434,
		-3434, -3434, -3434, -3434, 1622,  1622,  7723,  1622,
		1622,  1622,  1622,  1622,  -3434, -3434, -1516, 4624,
		4625,  4626,  637,   4628,  -3434, 4603,  4604,  4605,
		4606,  -3074, 9663,  -5471, -5471, -5471, -5471, -4135,
		618,   -4134, -4134, 32767, 32767, 621,   622,   32767,
		623,   624,   625,   626,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4039,  32767,
		4040,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 5450,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, -4019, 32767, 32767, 4042,  -3994, -3994, -3994,
		-3994, 3687,  -9049, 32767, 32767, 6086,  6087,  4752,
		0,     4753,  4754,  32767, 32767, 0,     0,     32767,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 6862,
		6863,  6864,  6865,  1810,  1811,  -4289, 1813,  1814,
		1815,  1816,  1817,  6874,  6875,  4958,  -1181, -1181,
		-1181, 2809,  -1181, 6882,  -1154, -1154, -1154, -1154,
		6527,  -6209, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		82,    32767, 32767, 11618, 11619, 11620, 5919,  5920,
		5921,  5922,  32767, 32767, 786,   32767, 32767, 787,
		788,   789,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		790,   791,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -1151, -1151, -1151, -1151, -1151, -1151,
		-1151, -1400, -1399, 32767, 32767, 32767, 32767, 32767,
		792,   32767, 32767, 32767, -1159, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4666,
		4667,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 665,   666,
		667,   668,   32767, 669,   670,   671,   672,   673,
		674,   675,   676,   677,   32767, 678,   679,   680,
		32767, 681,   682,   683,   684,   685,   -1578, -5751,
		-5751, -5751, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-1193, 32767, 32767, 32767, 32767, -5986, -5986, -5986,
		-5986, -5986, -5986, -5986, -5986, -5986, -5986, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 686,   687,   688,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -174,  1314,  -173,
		-173,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		689,   690,   691,   692,   693,   694,   695,   696,
		32767, 32767, 32767, 4671,  4672,  4673,  4674,  4675,
		4676,  4677,  4678,  4679,  4680,  4681,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -1552, -1552, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     697,   533,   533,   700,   701,   702,
		703,   704,   705,   706,   707,   708,   709,   710,
		711,   712,   713,   714,   715,   716,   717,   4682,
		6946,  2158,  4685,  721,   722,   723,   724,   725,
		726,   727,   728,   729,   730,   731,   732,   733,
		734,   735,   736,   737,   738,   739,   740,   741,
		742,   743,   744,   745,   746,   747,   748,   749,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 5923,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4215,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4181,  32767, 32767, -1922, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4218,  32767, 32767,
		32767, 32767, 2986,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4219,  32767,
		32767, 32767, 6001,  4221,  4222,  4223,  32767, 32767,
		32767, 4224,  4225,  4226,  4227,  4228,  4229,  4230,
		4231,  5925,  5926,  5927,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1170,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -901,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 767,   32767, 32767,
		32767, 32767, 32767, 32767, -5005, -4757, -4757, 32767,
		32767, 32767, -4760, -4760, 68,    68,    68,    32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 287,   32767, 32767, 32767, 58,    58,    32767,
		57,    32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		4689,  32767, 4690,  32767, 32767, 32767, 32767, -1717,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4691,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 6903,
		4693,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 775,   32767, 32767,
		776,   32767, 32767, 32767, 32767, 32767, 777,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 778,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 779,   780,   781,   32767, 4694,
		4695,  4696,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4697,  4698,  32767,
		32767, 32767, 4699,  4700,  32767, 32767, 32767, 2428,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 2995,  2996,  2997,  2998,  2999,
		2696,  2696,  2696,  5212,  5212,  2696,  783,   2696,
		2696,  2696,  2696,  2696,  2696,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 784,
		32767, 32767, 4701,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3013,
		3014,  3015,  32767, 32767, 32767, 0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 2139,  2140,  -808,
		681,   682,   683,   684,   32767, 32767, 32767, 2633,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3016,
		685,   686,   936,   936,   689,   32767, 32767, 32767,
		32767, 32767, 690,   691,   692,   693,   694,   695,
		696,   697,   698,   699,   -5401, 701,   702,   703,
		704,   705,   706,   707,   -779,  709,   80,    -7189,
		-7189, -7189, 0,     0,     32767, 0,     0,     0,
		0,     0,     32767, 0,     32767, 0,     0,     32767,
		0,     0,     32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     1310,  0,
		0,     0,     0,     -7007, -7007, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     6538,
		6539,  6540,  6541,  6542,  6543,  2371,  6545,  6546,
		6547,  6548,  6549,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     1693,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-6893, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -6902, 0,     0,     0,
		0,     -2600, 0,     1974,  1974,  0,     0,     0,
		0,     -6912, -5556, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     3019,  0,     3020,
		3021,  3022,  0,     0,     3023,  3024,  0,     0,
		0,     0,     0,     2206,  3026,  0,     3027,  0,
		0,     0,     32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-3504, 0,     0,     0,     -6893, 0,     0,     5606,
		0,     0,     0,     3028,  -3501, 0,     -3500, -3499,
		0,     808,   0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     32767, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		32767, 32767, 0,     0,     0,     0,     0,     0,
		32767, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     1619,  1620,  32767, 32767, 1621,  1622,
		1623,  32767, 1624,  1625,  1626,  1627,  1628,  1629,
		0,     0,     1632,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3029,  3030,  3031,  3032,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3033,
		-1994, 810,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 811,
		1188,  -1999, 814,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2778,  32767, 32767, 32767,
		2775,  32767, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -2863, -2863, -2863, -2863,
		-2863, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     986,   0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     815,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     817,   818,   819,   0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -2752, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     4452,  0,
		4451,  0,     0,     0,     4448,  4732,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     2022,  0,     32767, 32767, 32767,
		32767, -7994, 32767, 32767, 32767, 32767, -4824, -4824,
		2857,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -8011, -8011,
		-8011, -8011, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -251,  -251,  -251,  -251,  -251,  -251,  4127,
		3239,  3239,  4549,  4549,  32767, 32767, 32767, 32767,
		32767, -3773, 4123,  4123,  4123,  4123,  4123,  5586,
		5586,  5586,  5586,  7074,  5587,  5587,  -14346,5587,
		5587,  5587,  5587,  5587,  5587,  5587,  5587,  5587,
		5338,  0,     0,     0,     0,     0,     0,     0,
		32767, 0,     4131,  0,     0,     0,     0,     0,
		0,     828,   0,     0,     0,     0,     829,   830,
		-3958, 0,     0,     8614,  4312,  0,     0,     0,
		0,     0,     4619,  0,     0,     0,     832,   833,
		834,   835,   32767, 32767, 32767, 32767, -215,  -215,
		4094,  4630,  -213,  -213,  -213,  32767, 32767, 32767,
		32767, 32767, -3542, -2653, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -21505,-1572, -1572, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -977,  32767, -2211, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4386,  4386,  -2210,
		-2209, 32767, 4735,  4736,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -5881, 32767, 4018,  32767,
		-5885, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4020,  1382,  1382,  1382,  1382,  1382,
		5938,  32767, 32767, 32767, -2118, 32767, 32767, 32767,
		32767, 4022,  32767, 32767, 32767, 32767, -4783, 32767,
		32767, 32767, 32767, 850,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		5806,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		4026,  4027,  4028,  4029,  4030,  4031,  4032,  4033,
		4034,  4035,  4036,  4037,  4038,  32767, 32767, -1017,
		-1016, -7116, -1014, -1013, 32767, -1012, -1011, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -3993, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4737,  302,   32767, 32767, 32767,
		32767, 303,   32767, 32767, 32767, 32767, 306,   32767,
		32767, 32767, 32767, 307,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 5939,
		-4862, 5941,  -388,  -388,  -388,  -388,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, -4874, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     2516,  2516,  0,     -1913, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     877,   0,
		0,     0,     0,     0,     0,     0,     0,     336,
		337,   338,   339,   0,     0,     0,     0,     878,
		0,     346,   347,   348,   349,   6861,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -4245, 0,     -4244, 0,     0,     0,     32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		3833,  0,     32767, 32767, 32767, 881,   32767, 32767,
		32767, 0,     32767, 0,     0,     0,     0,     0,
		0,     0,     32767, 0,     32767, 0,     0,     0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     0,     0,     0,     0,     0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2713,  -2075, -2074, -2073,
		-2072, -2071, -2070, 2720,  -2068, -2067, -2066, 2724,
		2725,  2726,  2727,  2728,  2729,  2730,  2731,  2732,
		2733,  2734,  2735,  2736,  2737,  -2055, -2054, 2740,
		-2052, 2742,  2743,  2744,  2745,  2746,  2747,  -1630,
		-741,  -740,  -2049, -2048, -738,  -737,  -1624, 6273,
		6274,  -291,  -290,  -289,  -288,  -287,  -286,  -285,
		-284,  -283,  -282,  -281,  -280,  -279,  -278,  -277,
		-276,  2772,  0,     0,     0,     0,     2779,  -5015,
		-269,  -268,  0,     0,     -2210, 0,     0,     -262,
		-261,  -260,  -259,  -258,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     2040,  2040,
		2040,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		165,   166,   0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -3964, -6227, -1438, 32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2824,  2825,  5791,  3454,
		3455,  3456,  32767, 10734, -115,  3459,  1375,  32767,
		32767, 3461,  10743, 5953,  3464,  3465,  3466,  3467,
		10751, 32767, 10753, 3470,  3471,  3472,  3473,  3474,
		3475,  32767, 3476,  5980,  10770, 5982,  7789,  7790,
		3482,  0,     2797,  0,     2798,  0,     2799,  0,
		2800,  0,     2801,  0,     2802,  0,     2803,  0,
		2804,  0,     0,     2806,  0,     2807,  32767, 2807,
		0,     0,     0,     32767, 0,     0,     -376,  2812,
		0,     32767, 2812,  32767, 32767, 32767, 0,     2811,
		2811,  0,     2812,  2812,  0,     32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     2833,  0,     0,     0,     0,     3781,
		2837,  3782,  2837,  0,     3784,  3785,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     2850,  0,     2851,  0,     2852,  0,
		2853,  0,     2854,  0,     2855,  0,     2856,  0,
		2857,  0,     2858,  0,     2859,  0,     2860,  0,
		2861,  0,     0,     2863,  0,     2864,  0,     3815,
		0,     0,     0,     0,     0,     0,     3828,  3829,
		9436,  9437,  9438,  6411,  2873,  2873,  0,     2874,
		2874,  8636,  9445,  9446,  9447,  9448,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     2897,  0,     0,     660,   7421,  7236,
		2899,  0,     0,     0,     2902,  816,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2013,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 5486,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4750,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1009,  -417,  -417,  -417,  32767, 3553,  -9183, 5952,
		5953,  5954,  5955,  4620,  5957,  176,   177,   178,
		179,   180,   181,   182,   183,   -4964, -4964, 188,
		189,   190,   191,   192,   193,   194,   -4964, -4964,
		32767, -4965, -4965, 32767, -4966, 32767, 32767, -4968,
		32767, -4969, -4969, -4969, -4969, -4969, -4969, -4969,
		-4969, -4969, -4969, 32767, -4970, -4970, -4970, -4970,
		32767, -4971, 32767, -4972, 32767, 32767, 32767, 32767,
		32767, 32767, -187,  32767, 32767, 32767, 32767, -4980,
		32767, -4981, 32767, -4982, 32767, -194,  -194,  -194,
		32767, -195,  -195,  32767, -196,  32767, 32767, -4987,
		32767, -4988, 32767, -4989, 32767, -4990, 32767, -4991,
		32767, -4992, -4992, 0,     -4993, 32767, 32767, -4995,
		-202,  -4995, -4995, 32767, -4996, -4996, -4996, -618,
		-1506, -1506, -196,  32767, -1506, -1506, -618,  -8514,
		32767, -8515, -619,  -619,  -619,  32767, 6034,  32767,
		-455,  -455,  -455,  -455,  -455,  -455,  -455,  -455,
		-455,  -455,  32767, -456,  -456,  -456,  -456,  -456,
		-456,  -456,  -456,  -456,  -456,  -456,  -456,  -456,
		-456,  -456,  -456,  -456,  32767, 32767, 32767, 32767,
		32767, -461,  -461,  -461,  32767, -7469, -462,  -462,
		-462,  -462,  32767, -463,  -463,  -463,  -463,  -463,
		6075,  6076,  6077,  6078,  6079,  6080,  1908,  6082,
		6083,  6084,  6085,  6086,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -9650, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4751,  32767, 32767, -6842, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		3990,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     2002,  2002,  2002,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     4118,  0,
		0,     0,     0,     0,     0,     0,     4126,  0,
		0,     2728,  0,     0,     32767, 32767, 32767, 32767,
		32767, 0,     5928,  5929,  5930,  5931,  0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4755,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 4132,  4133,  4134,  4135,
		4136,  4137,  4138,  4139,  4140,  4141,  4142,  4143,
		4144,  32767, 32767, 886,   5880,  32767, 32767, 32767,
		32767, 32767, 32767, 1132,  1132,  1132,  1132,  32767,
		6280,  1129,  1129,  32767, 1128,  1128,  1128,  1128,
		6287,  6288,  6289,  6290,  6291,  6292,  6293,  32767,
		6294,  6295,  32767, 1343,  6296,  6297,  6298,  6299,
		6300,  32767, 32767, 6301,  6302,  6303,  32767, 6304,
		32767, 6305,  32767, 6306,  32767, 6307,  1517,  1518,
		16878, 32767, 6311,  6312,  1522,  32767, 6314,  1524,
		1525,  6315,  6316,  6317,  6318,  32767, 6319,  1531,
		1532,  1533,  1534,  1535,  32767, 32767, 32767, 32767,
		1536,  6326,  6327,  6328,  6329,  32767, 0,     32767,
		0,     10802, 0,     6330,  6331,  6332,  6333,  1541,
		1542,  6336,  1544,  6338,  6339,  6340,  6341,  6342,
		6343,  1966,  2855,  2856,  1547,  1548,  2858,  2859,
		1972,  9869,  9870,  9871,  1976,  1977,  1978,  1979,
		1980,  518,   519,   520,   521,   -966,  522,   523,
		20457, 525,   526,   527,   528,   529,   530,   531,
		532,   533,   783,   6122,  6123,  6124,  6125,  6126,
		6127,  6128,  32767, 6129,  1999,  6131,  6132,  6133,
		6134,  6135,  6136,  5309,  6138,  6139,  6140,  6141,
		5313,  5313,  10102, 6145,  6146,  -2467, 1836,  6149,
		6150,  6151,  6152,  6153,  1535,  6155,  6156,  6157,
		5326,  5326,  5326,  32767, 32767, 32767, 32767, 32767,
		32767, 1837,  32767, 1741,  32767, 32767, 32767, 32767,
		10538, 10539, 9184,  9185,  6237,  7726,  7727,  7728,
		7729,  7730,  6243,  7731,  7732,  27666, 7734,  7735,
		7736,  7737,  7738,  7739,  7740,  7741,  7742,  7992,
		7992,  7745,  7746,  7747,  7748,  7749,  7750,  7751,
		7752,  7753,  7754,  7755,  7756,  7757,  7758,  7759,
		7760,  1660,  7762,  7763,  7764,  7765,  7766,  7767,
		7768,  6282,  7770,  7141,  -128,  -128,  -128,  7768,
		7768,  7768,  4803,  7141,  7141,  7141,  5529,  -136,
		10714, 7141,  9226,  -10707,4652,  7141,  -140,  4651,
		7141,  7141,  7141,  7141,  -142,  5529,  -143,  7141,
		7141,  7141,  6315,  7140,  7140,  6318,  6319,  4635,
		6321,  6322,  6323,  6324,  6325,  6326,  6327,  6328,
		6329,  6330,  9168,  9169,  9170,  15325, 15078, 15079,
		9174,  9175,  9176,  6539,  9178,  9179,  9180,  6344,
		6345,  6346,  6347,  8761,  6349,  6350,  6351,  9193,
		9194,  9195,  4634,  4634,  9196,  9197,  9198,  -1165,
		-1165, -1165, 4937,  6364,  6365,  6366,  10077, 2397,
		15134, 0,     0,     0,     0,     1336,  0,     5782,
		5782,  5782,  5782,  5782,  5782,  5782,  5782,  10930,
		10931, 5780,  5780,  5780,  5780,  5780,  5780,  5780,
		10939, 10940, 10941, 10942, 10943, 10944, 10945, 10946,
		10947, 10948, 10949, 10950, 10951, 10952, 10953, 10954,
		10955, 10956, 10957, 10958, 10959, 10960, 10961, 10962,
		10963, 10964, 10965, 10966, 10967, 10968, 6178,  6179,
		21539, 6181,  10973, 10974, 6184,  6185,  10977, 6187,
		6188,  10978, 10979, 10980, 10981, 10982, 10983, 6195,
		6196,  6197,  6198,  6199,  6200,  10990, 6202,  6203,
		6204,  10994, 10995, 10996, 10997, 10998, 10999, 11000,
		11001, 11002, 11003, 11004, 11005, 11006, 11007, 6215,
		6216,  11010, 6218,  11012, 11013, 11014, 11015, 11016,
		11017, 6640,  7529,  7530,  6221,  6222,  7532,  7533,
		6646,  14543, 14544, 14545, 6650,  6651,  6652,  6653,
		0,     6489,  6490,  6491,  6492,  6493,  6494,  6495,
		6496,  6497,  6498,  6499,  6500,  6501,  6502,  6503,
		6504,  6505,  6506,  6507,  6508,  6509,  6510,  6511,
		6512,  6513,  6514,  6515,  6516,  6517,  6518,  6519,
		6520,  5211,  6522,  6523,  6524,  6525,  13533, 13534,
		6528,  6529,  6530,  6531,  6532,  6533,  6534,  6535,
		6536,  6537,  0,     0,     0,     0,     0,     0,
		4173,  0,     0,     0,     0,     0,     6550,  6551,
		6552,  6553,  6554,  6555,  6556,  6557,  6558,  6559,
		6560,  6561,  6562,  6563,  6564,  6565,  4873,  6567,
		6568,  6569,  6570,  6571,  6572,  6573,  6574,  6575,
		6576,  6577,  6578,  6579,  6580,  6581,  6582,  6583,
		6584,  6585,  6586,  6587,  6588,  6589,  6590,  6591,
		6592,  6593,  6594,  6595,  6596,  6597,  6598,  6599,
		6600,  6601,  6602,  6603,  6604,  6605,  6606,  6607,
		6608,  6609,  6610,  6611,  6612,  6613,  6614,  6615,
		6616,  6617,  6618,  6619,  6620,  6621,  6622,  6623,
		6624,  6625,  6626,  6627,  6628,  6629,  6630,  6631,
		6632,  6633,  6634,  6635,  6636,  6637,  6638,  6639,
		6640,  6641,  6642,  6643,  6644,  6645,  6646,  6647,
		6648,  6649,  6650,  6651,  6652,  6653,  6654,  6655,
		6656,  6657,  6658,  13552, 6660,  6661,  6662,  6663,
		6664,  6665,  6666,  6667,  6668,  6669,  6670,  13573,
		6672,  6673,  6674,  6675,  9276,  6677,  4704,  4705,
		6680,  6681,  6682,  6683,  13596, 12241, 6686,  6687,
		6688,  6689,  6690,  6691,  6692,  6693,  6694,  6695,
		6696,  6697,  6698,  6699,  6700,  6701,  6702,  6703,
		6704,  6705,  6706,  6707,  6708,  6709,  6710,  6711,
		6712,  6713,  6714,  6715,  6716,  6717,  6718,  6719,
		6720,  6721,  6722,  6723,  6724,  6725,  6726,  6727,
		3709,  6729,  3710,  3710,  3710,  6733,  6734,  3712,
		3712,  6737,  6738,  6739,  6740,  6741,  4536,  3717,
		6744,  32767, 6745,  6746,  6747,  6748,  6749,  6750,
		6751,  6752,  6753,  6754,  6755,  6756,  6757,  6758,
		6759,  6760,  6761,  6762,  6763,  6764,  6765,  6766,
		6767,  6768,  6769,  -2005, 6771,  -3121, -3121, -3121,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 895,   896,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4706,  4707,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 897,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 898,
		899,   900,   901,   902,   903,   904,   905,   32767,
		32767, 906,   32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1,     32767, 2,     32767, 32767, 32767, 32767, 3,
		32767, 32767, 4,     5,     6,     7,     32767, 32767,
		8,     9,     10,    32767, 11,    83,    13,    32767,
		14,    15,    16,    17,    18,    19,    32767, 20,
		21,    22,    907,   908,   909,   910,   911,   912,
		913,   914,   915,   916,   917,   918,   919,   920,
		32767, 921,   922,   923,   924,   925,   926,   927,
		928,   929,   -380,  931,   932,   933,   934,   7942,
		7943,  7944,  49,    50,    51,    52,    53,    -1409,
		32767, -1408, -1407, -2894, -1406, -1405, 18529, 3171,
		32767, -1403, -1402, -1401, -1400, -1399, 32767, -1398,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 683,   32767, 7976,  32767, 4994,  32767, 686,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 937,   0,     -3182, 0,     -3183, 0,     -3184,
		32767, 941,   32767, 32767, 32767, -3188, 0,     32767,
		0,     0,     32767, 0,     0,     32767, 0,     0,
		32767, 0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 943,
		32767, 0,     32767, 32767, 32767, 32767, 944,   0,
		945,   0,     32767, 946,   947,   32767, 948,   949,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 32767, 0,     32767, 0,     32767, 950,   951,
		952,   953,   954,   955,   956,   957,   958,   32767,
		6565,  6566,  32767, 0,     0,     32767, 0,     0,
		32767, 6570,  6571,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, -2239, 4522,  4337,  0,
		32767, 32767, 32767, 0,     -2086, 32767, 32767, 0,
		0,     0,     0,     0,     0,     959,   960,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     4578,  4579,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-4175, -5292, 0,     0,     32767, 0,     32767, 0,
		0,     32767, 0,     0,     32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 961,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     962,   963,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 964,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		32767, 32767, -3913, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 965,   966,   967,   32767,
		968,   969,   970,   971,   972,   973,   974,   975,
		976,   977,   978,   979,   980,   32767, 981,   982,
		983,   984,   985,   986,   987,   32767, 32767, 32767,
		32767, 988,   32767, 32767, 32767, 32767, 32767, 32767,
		989,   32767, 32767, 32767, -4941, 991,   32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 992,   993,   994,   32767, 995,   996,   997,
		998,   999,   1000,  1001,  -3143, -3143, -3143, -3143,
		32767, -3144, -3144, -3144, -3144, -3144, 1011,  1012,
		1013,  1014,  1015,  1016,  -3138, -3138, -3138, -3138,
		-3138, -3138, -3138, 32767, -3139, -3139, -3139, -3139,
		-3139, -3139, -3139, -3139, -3139, -3139, -3139, -3139,
		-3139, -3139, -3139, -3139, -3139, -3139, -3139, -3139,
		-3139, -3139, -3139, -3139, -3139, -3139, -3139, 872,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 3049,  3049,  -3150, 3049,  3049,
		3049,  3049,  3049,  3049,  3049,  3049,  3049,  3049,
		3049,  3049,  3049,  3049,  3049,  3049,  3049,  3049,
		3049,  3049,  3049,  3049,  3049,  0,     0,     0,
		0,     0,     0,     0,     0,     3057,  5596,  5597,
		5598,  6716,  6717,  6718,  6719,  6720,  6721,  6722,
		6723,  -3176, -3176, 6728,  6729,  6730,  6731,  6732,
		6733,  6734,  6735,  -3176, -3176, -3176, -3176, -3176,
		-3176, 8013,  2958,  2959,  -3141, 2961,  2962,  2963,
		2964,  2965,  8022,  8023,  -3176, -3176, -3176, -3176,
		-3176, 5630,  5631,  -2,    -2,    -2,    -2,    7679,
		-3176, -3176, -3176, -3176, -3176, -3176, -3176, -3176,
		-3176, -4957, -4957, -4957, -4957, -3176, -3176, -3176,
		-3176, -3176, -3176, -3176, -3176, -3176, -3176, -3176,
		-3176, -3176, -3176, -3176, -3176, -3176, -3176, -3176,
		-3176, -3176, 1880,  1880,  7981,  1880,  1880,  1880,
		1880,  1880,  -3176, -3176, -1258, 4882,  4883,  4884,
		895,   4886,  -3176, 4861,  4862,  4863,  4864,  -2816,
		9921,  -5213, -5213, -5213, -5213, -3877, -5213, 569,
		569,   569,   569,   569,   569,   569,   569,   5717,
		5718,  567,   567,   567,   567,   567,   567,   567,
		5726,  5727,  5728,  5729,  5730,  5731,  5732,  5733,
		5734,  5735,  5736,  5737,  5738,  5739,  5740,  5741,
		5742,  5743,  5744,  5745,  5746,  5747,  5748,  5749,
		5750,  5751,  5752,  5753,  5754,  5755,  965,   966,
		16326, 968,   5760,  5761,  971,   972,   5764,  974,
		975,   5765,  5766,  5767,  5768,  5769,  5770,  982,
		983,   984,   985,   986,   987,   5777,  989,   990,
		991,   5781,  5782,  5783,  5784,  5785,  5786,  5787,
		5788,  5789,  5790,  5791,  5792,  5793,  5794,  1002,
		1003,  5797,  1005,  5799,  5800,  5801,  5802,  5803,
		5804,  1427,  2316,  2317,  1008,  1009,  2319,  2320,
		1433,  9330,  9331,  9332,  1437,  1438,  1439,  1440,
		1441,  -21,   -20,   -19,   -18,   -1505, -17,   -16,
		19918, -14,   -13,   -12,   -11,   -10,   -9,    -8,
		-7,    -6,    244,   244,   -3,    -2,    -1,    0,
		1,     2,     3,     4,     1469,  5,     6,     7,
		8,     9,     32767, 32767, 32767, 32767, 10,    11,
		12,    13,    5070,  5071,  3154,  -2985, 1318,  1319,
		1320,  -2988, 5075,  -2961, -2961, -2961, -2961, 1327,
		1328,  1329,  1330,  1331,  1332,  1333,  1334,  1335,
		1336,  1337,  1338,  1339,  1340,  1341,  1342,  1343,
		1344,  1345,  1346,  1347,  1348,  1349,  1350,  1351,
		1352,  1353,  1354,  1355,  1356,  1357,  1358,  1359,
		1360,  1361,  1362,  1363,  1364,  1365,  1366,  1367,
		7522,  7275,  7276,  1371,  1372,  1373,  -1264, 1375,
		1376,  1377,  1378,  1379,  1380,  1381,  1382,  957,
		-14402,957,   1386,  1387,  1388,  1389,  1390,  1391,
		1392,  1393,  -8970, -8970, -8970, 1397,  1398,  948,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 1400,
		1401,  1402,  1403,  1404,  1405,  1406,  1407,  1408,
		1409,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
		1417,  1418,  1419,  1420,  1421,  32767, 32767, 1422,
		1423,  1424,  1425,  1426,  1427,  32767, 32767, 1428,
		1429,  1430,  1431,  8325,  1433,  1434,  1435,  1436,
		1437,  1438,  1439,  1440,  1441,  1442,  1443,  8346,
		1445,  1446,  1447,  1448,  4049,  1450,  -523,  -522,
		1453,  1454,  1455,  1456,  8369,  7014,  1459,  1460,
		1461,  1462,  1463,  1464,  1465,  32767, 32767, 1466,
		1467,  1468,  1469,  1470,  1471,  32767, 32767, 1472,
		1473,  1474,  1475,  1476,  1477,  1478,  1479,  32767,
		1480,  32767, 1481,  32767, 1482,  32767, 1483,  1484,
		1485,  1486,  1487,  1488,  1489,  1490,  1491,  1492,
		-1526, 1494,  -1525, -1525, -1525, 1498,  1499,  -1523,
		-1523, 1502,  1503,  1504,  1505,  1506,  -699,  -1518,
		1509,  -1517, 1511,  1512,  1513,  32767, 32767, 1514,
		1515,  1516,  1517,  1518,  1519,  1520,  1521,  1522,
		1523,  1524,  1525,  1526,  1527,  1528,  1529,  1530,
		1531,  1532,  1533,  1534,  1535,  1536,  1537,  1538,
		1539,  1540,  1541,  1542,  1543,  1544,  1545,  1546,
		1547,  1548,  1549,  5054,  1551,  1552,  1553,  8447,
		1555,  1556,  -4049, 1558,  1559,  1560,  -1467, 5063,
		1563,  5064,  5064,  1566,  32767, 1567,  1568,  1569,
		1570,  1571,  1572,  1573,  1574,  1575,  1576,  1577,
		1578,  1579,  1580,  1581,  32767, 1582,  1583,  1584,
		1585,  1586,  1587,  1588,  1589,  1590,  1591,  1592,
		1593,  1594,  1595,  32767, 32767, 1596,  1597,  1598,
		1599,  1600,  1601,  32767, 1602,  1603,  1604,  1605,
		1606,  1607,  1608,  1609,  1610,  1611,  1612,  1613,
		1614,  1615,  1616,  1617,  1618,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     1630,  1631,  0,     32767, -5702,
		-5702, -5702, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 0,     32767, 0,
		32767, -7163, 0,     0,     32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -7269, -7269, -7269, 627,
		627,   627,   -2338, 0,     0,     0,     -1612, -7277,
		3573,  0,     2085,  -17848,-2489, 0,     -7281, -2490,
		0,     0,     0,     0,     -7283, -1612, -7284, 0,
		0,     0,     0,     0,     0,     0,     0,     -2503,
		-7292, -2503, -4309, -4309, 0,     536,   -4307, -4307,
		-4307, -4307, 677,   -4306, -4306, -4306, -4306, -7305,
		0,     -4306, -4306, 32767, 32767, -4308, -4308, -7312,
		-4307, 690,   -4306, -6530, 0,     -4306, 0,     0,
		-4306, 0,     -4305, -4305, -4305, -4305, -4305, -4305,
		-2949, -2949, 0,     -1488, -1488, -1488, -1488, -1488,
		0,     -1487, -1487, -21420,-1487, -1487, -1487, -1487,
		-1487, -1487, -1487, -1487, -1487, -1736, -1735, -1487,
		-1487, -1487, -1487, -1487, -1487, -1487, -1487, -1487,
		-1487, -1487, -1487, -1487, -1487, -1487, -1487, 4614,
		-1487, -1487, -1487, -1487, -1487, -1487, -1487, 0,
		-1487, -857,  6413,  6414,  6415,  -1480, -1479, -1478,
		1488,  -849,  -848,  -847,  766,   6432,  -4417, -843,
		-2927, 17007, 1649,  -839,  6443,  1653,  -836,  -835,
		-834,  -833,  6451,  781,   6454,  -829,  -828,  -827,
		0,     -824,  -823,  0,     0,     1685,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-2837, -2837, -2837, -8991, -8743, -8743, -2837, -2837,
		-2837, -199,  -2837, -2837, -2837, 0,     0,     0,
		0,     -2413, 0,     0,     0,     -2841, -2841, -2841,
		1721,  1722,  -2839, -2839, -2839, 7525,  7526,  7527,
		1426,  0,     0,     0,     -3710, 3971,  -8765, 6370,
		6371,  6372,  6373,  5038,  6375,  594,   595,   596,
		597,   598,   599,   600,   601,   -4546, -4546, 606,
		607,   608,   609,   610,   611,   612,   -4546, -4546,
		-4546, -4546, -4546, -4546, -4546, -4546, -4546, -4546,
		-4546, -4546, -4546, -4546, -4546, -4546, -4546, -4546,
		-4546, -4546, -4546, -4546, -4546, -4546, -4546, -4546,
		-4546, -4546, -4546, -4546, 245,   245,   -15114,245,
		-4546, -4546, 245,   245,   -4546, 245,   245,   -4544,
		-4544, -4544, -4544, -4544, -4544, 245,   245,   245,
		245,   245,   245,   -4544, 245,   245,   245,   -4544,
		-4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
		-4544, -4544, -4544, -4544, -4544, 249,   249,   -4544,
		249,   -4544, -4544, -4544, -4544, -4544, -4544, -166,
		-1054, -1054, 256,   256,   -1053, -1053, -165,  -8061,
		-8061, -8061, -165,  -165,  -165,  -165,  -165,  1298,
		1298,  1298,  1298,  2786,  1299,  1299,  -18634,1299,
		1299,  1299,  1299,  1299,  1299,  1299,  1299,  1299,
		1050,  1051,  1299,  1299,  1299,  1299,  1299,  1299,
		1299,  1299,  -165,  1300,  1300,  1300,  1300,  1300,
		1300,  1300,  7401,  1300,  1300,  1300,  1300,  1300,
		-3756, -3756, -1838, 4302,  0,     0,     0,     4309,
		-3753, 4284,  4285,  4286,  4287,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -6154, -5906,
		-5906, 0,     0,     0,     2638,  0,     0,     0,
		0,     0,     0,     0,     0,     426,   15786, 428,
		0,     0,     0,     0,     0,     0,     0,     0,
		10364, 10365, 10366, 0,     0,     451,   452,   453,
		454,   455,   456,   32767, 32767, 0,     0,     0,
		32767, 32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     32767, 0,     0,     0,     0,     0,
		0,     0,     32767, 1842,  32767, 32767, 1843,  32767,
		32767, 0,     32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1844,  32767,
		0,     0,     0,     32767, 32767, 32767, 1846,  1847,
		32767, 1848,  1849,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     32767,
		32767, 32767, 32767, 0,     32767, 32767, 1851,  32767,
		32767, 1852,  32767, 0,     0,     32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 1854,  32767, 1855,  6223,  6224,  6225,
		6226,  6227,  6228,  6229,  6230,  6231,  6232,  1856,
		1857,  1574,  1574,  1574,  32767, 32767, 1572,  1572,
		32767, 32767, 1863,  1864,  32767, 32767, 32767, 32767,
		32767, 32767, 1865,  1866,  32767, 32767, 1867,  1868,
		32767, 32767, 1869,  1870,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1871,  1872,
		3017,  1874,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 3018,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 1875,  1876,  1877,  1878,  32767, 32767,
		32767, 0,     0,     32767, 1879,  1880,  1881,  1882,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1883,  1884,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     -2263, 2526,  0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1885,  1886,  1887,  1888,
		1889,  1890,  1891,  1892,  1893,  1894,  4758,  4759,
		4760,  4761,  4762,  1900,  1901,  1902,  1903,  1904,
		1905,  1906,  1907,  1908,  1909,  924,   1911,  1912,
		1913,  1914,  1915,  1916,  1917,  1918,  1919,  1920,
		1921,  1107,  1923,  1924,  1925,  1926,  1927,  1928,
		1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,
		1937,  1938,  1939,  1123,  1123,  1123,  1943,  1944,
		1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,
		1953,  1954,  1955,  1956,  1957,  1958,  1959,  1960,
		1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,
		1969,  1970,  1971,  1972,  1973,  1974,  4727,  1976,
		1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,
		1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,
		1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,
		-2451, 2002,  -2448, 2004,  2005,  2006,  -2441, -2724,
		2009,  2010,  2011,  2012,  2013,  2014,  2015,  2016,
		2017,  2018,  2019,  2020,  2021,  0,     2023,  985,
		985,   7086,  985,   985,   985,   985,   985,   -4071,
		-4071, -2153, 3987,  3988,  3989,  0,     3991,  -4071,
		3966,  3967,  -4071, 260,   261,   262,   263,   264,
		265,   266,   3264,  32767, 32767, -2437, -2436, 32767,
		32767, 32767, 32767, 32767, 32767, 270,   271,   272,
		273,   274,   275,   4728,  277,   278,   279,   280,
		281,   -2434, 283,   0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		32767, 32767, 32767, 32767, 1329,  441,   441,   1751,
		1751,  442,   442,   1330,  -6566, -6566, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -3047, -274,
		-273,  -272,  -271,  1946,  4745,  0,     0,     -267,
		-266,  1945,  -264,  -263,  0,     0,     0,     0,
		0,     0,     0,     0,     -6199, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     2539,  2540,  2541,
		3659,  3660,  3661,  3662,  3663,  3664,  3665,  3666,
		-6233, -6233, 3671,  3672,  3673,  3674,  3675,  3676,
		3677,  3678,  -6233, -6233, -6233, -6233, -6233, -6233,
		4956,  -99,   -98,   -6198, -96,   -95,   -94,   -93,
		-92,   4965,  4966,  -6233, -6233, -6233, -6233, -6233,
		2573,  2574,  -3059, 3049,  -3060, -3060, 4621,  -6234,
		-6234, -6234, -6234, -6234, -6234, -6234, -6234, -6234,
		-8015, -8015, -8015, -8015, -6234, -6234, -6234, -6234,
		-6234, -6234, -6234, -6234, -6234, -6234, -6234, -6234,
		-6234, -6234, -6234, -6234, -6234, -6234, -6234, -6234,
		-6234, -1178, -1178, 4923,  -1178, -1178, -1178, -1178,
		-1178, -6234, -6234, -4316, 1824,  1825,  1826,  -2163,
		1828,  -6234, 1803,  1804,  1805,  1806,  -5874, 6863,
		-8271, -8271, -8271, -8271, -6935, -8271, -2489, -2489,
		-2489, -2489, -2489, -2489, -2489, -2489, 2659,  2660,
		-2491, -2491, -2491, -2491, -2491, -2491, -2491, 2668,
		2669,  2670,  2671,  2672,  2673,  2674,  2675,  2676,
		2677,  2678,  2679,  2680,  2681,  2682,  2683,  2684,
		2685,  2686,  2687,  2688,  2689,  2690,  2691,  2692,
		2693,  2694,  2695,  2696,  2697,  -2093, -2092, 13268,
		-2090, 2702,  2703,  -2087, -2086, 2706,  -2767, 2708,
		2709,  2710,  2711,  2712,  3178,  3179,  3180,  3181,
		3182,  3183,  3184,  3185,  3186,  3187,  3188,  3189,
		3190,  3191,  3192,  3193,  3194,  3195,  3196,  3197,
		3198,  3199,  3200,  3201,  3202,  3203,  3204,  3205,
		3206,  3207,  3208,  3209,  3281,  3211,  3212,  3213,
		3214,  3215,  3216,  3217,  3218,  3219,  3220,  3221,
		3222,  4107,  4108,  4109,  4110,  4111,  4112,  3229,
		4115,  4116,  4117,  4118,  4119,  4120,  3236,  3237,
		4124,  4125,  4126,  4127,  4128,  7621,  3244,  4133,
		4134,  2825,  4136,  4137,  4138,  3251,  11148, 11149,
		11150, 3255,  3256,  3257,  3258,  3259,  1797,  1798,
		1799,  1800,  313,   1801,  1802,  21736, 1804,  1805,
		1806,  1807,  1808,  1809,  1810,  1811,  1812,  2062,
		2062,  1815,  1816,  1817,  1818,  1819,  1820,  1821,
		1822,  3287,  1823,  1824,  1825,  32767, 3291,  3292,
		3293,  3294,  3295,  3296,  3297,  3298,  3299,  3300,
		3301,  3302,  3303,  3304,  32767, 32767, 3305,  32767,
		9008,  32767, 32767, 3307,  3308,  3309,  3310,  3311,
		3312,  3313,  3314,  3315,  3316,  32767, 3317,  32767,
		3318,  32767, 32767, 3319,  3320,  32767, 32767, 32767,
		3321,  3322,  3323,  3324,  3325,  3326,  3327,  3328,
		3329,  3330,  3331,  3332,  3333,  10603, 10604, 10605,
		2710,  2711,  2712,  5678,  3341,  3342,  3343,  4956,
		10622, -227,  3347,  1263,  21197, 5839,  3351,  10633,
		5843,  3354,  3355,  3356,  3357,  10641, 4971,  10644,
		3361,  3362,  3363,  3364,  3365,  3366,  3367,  3368,
		5872,  10662, 5874,  7681,  7682,  3374,  2839,  7683,
		7684,  7685,  7686,  2703,  7687,  7688,  7689,  7690,
		10690, 3386,  7693,  7694,  7695,  0,     7697,  7698,
		10703, 7699,  2703,  7700,  9925,  3396,  7703,  3398,
		3399,  7706,  3401,  7707,  7708,  7709,  7710,  7711,
		7712,  6357,  6358,  3410,  4899,  4900,  4901,  4902,
		4903,  3416,  4904,  4905,  24839, 4907,  4908,  4909,
		4910,  4911,  4912,  4913,  4914,  4915,  5165,  5165,
		4918,  4919,  4920,  4921,  4922,  4923,  4924,  4925,
		4926,  4927,  4928,  4929,  4930,  4931,  4932,  4933,
		-1167, 4935,  4936,  4937,  4938,  4939,  4940,  4941,
		3455,  4943,  4314,  -2955, -2955, -2955, 4941,  4941,
		4941,  1976,  4314,  4314,  4314,  2702,  -2963, 7887,
		4314,  6399,  -13534,1825,  4314,  -2967, 1824,  4314,
		4314,  4314,  4314,  -2969, 2702,  -2970, 4314,  4314,
		4314,  3488,  4313,  4313,  3491,  3492,  1808,  3494,
		32767, 0,     0,     32767, 32767, 0,     0,     0,
		0,     32767, 0,     0,     0,     0,     -2999, 4306,
		0,     0,     0,     7696,  0,     0,     32767, 0,
		32767, 0,     -2224, 4306,  0,     4306,  4306,  0,
		0,     0,     0,     0,     0,     0,     0,     1356,
		1356,  4305,  2817,  2817,  2817,  2817,  2817,  2817,
		2817,  2817,  -17116,2817,  2817,  2817,  2817,  2817,
		2817,  2817,  2817,  2817,  2568,  2569,  2817,  2817,
		2817,  2817,  2817,  2817,  2817,  2817,  2817,  2817,
		2817,  2817,  2817,  2817,  2817,  2817,  8918,  2817,
		2817,  2817,  2817,  2817,  2817,  2817,  4304,  2817,
		3447,  10717, 10718, 10719, 3531,  3532,  32767, 3533,
		3534,  3535,  3536,  3537,  32767, 3538,  32767, 3539,
		3540,  32767, 3541,  3542,  32767, 3543,  3544,  3545,
		3546,  3547,  3548,  3549,  3550,  3551,  3552,  3553,
		3554,  3555,  3556,  3557,  3558,  3559,  3560,  3561,
		3562,  3563,  3564,  3565,  3566,  3567,  3568,  3569,
		3570,  3571,  3572,  3573,  3574,  3575,  3576,  3577,
		3578,  3579,  3580,  3581,  3582,  3583,  3584,  3585,
		3586,  3587,  3588,  3589,  3590,  3591,  3592,  3593,
		3594,  3595,  3596,  3597,  3598,  3599,  3600,  3601,
		3602,  3603,  3604,  3605,  3606,  3607,  3608,  3609,
		3610,  3611,  3612,  3613,  3614,  3615,  3616,  3617,
		3618,  3619,  3620,  3621,  3622,  3623,  3624,  3625,
		3626,  3627,  3628,  3629,  3630,  3631,  3632,  3633,
		2324,  3635,  3636,  3637,  3638,  10646, 10647, 3641,
		3642,  3643,  3644,  3645,  3646,  3647,  3648,  3649,
		3650,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3651,  3652,  3653,  3654,  3655,  3656,
		3657,  3658,  3659,  3660,  3661,  3662,  3663,  3664,
		3665,  3666,  3667,  3668,  3669,  3670,  3671,  3672,
		3673,  3674,  3675,  3676,  3677,  3678,  3679,  3680,
		3681,  3682,  3683,  3684,  3685,  3686,  3687,  3688,
		3689,  3690,  3691,  3692,  3693,  3694,  3695,  32767,
		3696,  3697,  3698,  3699,  3700,  3701,  3702,  3703,
		3704,  3705,  3706,  3707,  3708,  3709,  3710,  3711,
		3712,  3713,  3714,  3715,  3716,  3717,  3718,  3719,
		3720,  3721,  3722,  3723,  3724,  3725,  3726,  3727,
		3728,  3729,  3730,  3731,  3732,  3733,  3734,  3735,
		3736,  3737,  3738,  3739,  3740,  3741,  3742,  3743,
		3744,  3745,  3746,  3747,  3748,  3749,  3750,  3751,
		3752,  3753,  3754,  3755,  3756,  3757,  3758,  3759,
		3760,  3761,  3762,  3763,  3764,  3765,  3766,  3767,
		3768,  3769,  3770,  3771,  3772,  3773,  3774,  3775,
		3776,  3777,  3778,  3779,  3780,  3781,  3782,  3783,
		3784,  3785,  3786,  3787,  3788,  3789,  3790,  3791,
		3792,  3793,  3794,  3795,  3796,  3797,  3798,  3799,
		3800,  -210,  -209,  3803,  3804,  3805,  3806,  3807,
		3808,  3809,  3810,  3811,  3812,  3813,  3814,  3815,
		3816,  3817,  3818,  3819,  3820,  3821,  3822,  3823,
		3824,  3825,  3826,  3827,  3828,  3829,  3830,  3831,
		3832,  3833,  3834,  3835,  3836,  3837,  3838,  3839,
		3840,  3841,  3842,  3843,  3844,  3845,  3846,  3847,
		3848,  3849,  -4925, 3851,  -6041, -6041, -6041, -6041,
		-6041, -6041, -6041, 3859,  3860,  -6043, -6043, -6043,
		-6043, -6043, -6043, -6043, -6043, 3869,  3870,  3871,
		3872,  3873,  3874,  -7314, -2258, -2258, 3843,  -2258,
		-2258, -2258, -2258, -2258, -7314, -7314, 3886,  3887,
		3888,  3889,  3890,  -4915, -4915, 719,   720,   721,
		722,   -6958, 3898,  3899,  3900,  3901,  3902,  3903,
		3904,  3905,  3906,  5688,  5689,  5690,  5691,  3911,
		3912,  3913,  3914,  3915,  3916,  3917,  3918,  3919,
		3920,  3921,  3922,  3923,  3924,  3925,  3926,  3927,
		3928,  3929,  3930,  3931,  -1124, -1123, -7223, -1121,
		-1120, -1119, -1118, -1117, 3940,  3941,  2024,  -4115,
		-4115, -4115, -125,  -4115, 3948,  -4088, -4088, 3951,
		32767, 3952,  3953,  3954,  3955,  3956,  3957,  3958,
		3959,  3960,  3961,  3962,  3963,  3964,  3965,  3966,
		3967,  3968,  3969,  3970,  3971,  3972,  3973,  3974,
		3975,  3976,  3977,  3978,  3979,  3980,  3981,  3982,
		3983,  3984,  3985,  3986,  3987,  3988,  3989,  3990,
		3991,  3992,  3993,  3994,  3995,  3996,  3997,  3998,
		3999,  4000,  4001,  4002,  4003,  14,    4005,  4006,
		4007,  4008,  4009,  4010,  4011,  4012,  4013,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4014,  4015,  4016,  4017,  4018,  4019,  4020,
		4021,  4022,  4023,  4024,  4025,  4026,  2025,  2026,
		2027,  4030,  4031,  4032,  4033,  4034,  4035,  4036,
		4037,  4038,  4039,  4040,  4041,  4042,  4043,  4044,
		4045,  4046,  4047,  4048,  4049,  4050,  4051,  4052,
		4053,  4054,  4055,  4056,  4057,  4058,  4059,  4060,
		4061,  4062,  4063,  4064,  4065,  4066,  4067,  4068,
		4069,  4070,  4071,  4072,  4073,  4074,  4075,  4076,
		4077,  32767, 32767, 4078,  4079,  4080,  4081,  4082,
		4083,  4084,  4085,  4086,  4087,  4088,  4089,  4090,
		4091,  4092,  4093,  4094,  4095,  4096,  4097,  4098,
		4099,  4100,  4101,  4102,  4103,  4104,  4105,  4106,
		4107,  4108,  4109,  4110,  4111,  4112,  4113,  4114,
		4115,  4116,  4117,  0,     4119,  4120,  4121,  4122,
		4123,  4124,  4125,  0,     4127,  4128,  1401,  4130,
		4131,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     4011,  4011,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     8775,  0,
		9893,  9894,  9895,  9896,  9897,  9898,  9899,  0,
		0,     9904,  9905,  9906,  9907,  9908,  9909,  9910,
		9911,  0,     0,     0,     0,     0,     0,     11189,
		6134,  6135,  35,    6137,  6138,  6139,  6140,  6141,
		11198, 11199, 0,     0,     0,     0,     0,     8806,
		8807,  3174,  3174,  3174,  3174,  10855, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     -1781,
		-1781, -1781, -1781, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		5056,  5056,  11157, 5056,  5056,  5056,  5056,  5056,
		0,     0,     1918,  8058,  8059,  8060,  4071,  8062,
		0,     8037,  8038,  0,     4331,  4332,  4333,  4334,
		4335,  4336,  4337,  7335,  7336,  1635,  1636,  1637,
		1638,  1639,  1640,  1641,  1642,  1643,  4349,  4350,
		4351,  4352,  4353,  4354,  8807,  4356,  4357,  4358,
		4359,  4360,  1645,  4362,  4363,  4364,  4365,  32767,
		32767, 32767, 32767, 32767, 8912,  8913,  8914,  8915,
		8916,  8917,  8918,  8919,  8920,  8921,  8922,  8923,
		8924,  8925,  8926,  8927,  4137,  4138,  19498, 4140,
		8932,  8933,  4143,  4144,  8936,  4146,  4147,  8937,
		8938,  8939,  8940,  8941,  8942,  4154,  4155,  4156,
		4157,  4158,  4159,  8949,  4161,  4162,  4163,  8953,
		8954,  8955,  8956,  8957,  8958,  8959,  8960,  8961,
		8962,  8963,  8964,  8965,  8966,  4174,  4175,  8969,
		4177,  8971,  8972,  8973,  8974,  8975,  8976,  4599,
		5488,  5489,  4180,  4181,  5491,  5492,  4605,  12502,
		12503, 12504, 4609,  4610,  4611,  4612,  4613,  3151,
		3152,  3153,  3154,  1667,  3155,  3156,  23090, 3158,
		3159,  3160,  3161,  3162,  3163,  3164,  3165,  3166,
		3416,  3416,  3169,  3170,  3171,  3172,  3173,  3174,
		3175,  3176,  4641,  3177,  3178,  3179,  3180,  3181,
		3182,  3183,  -2917, 3185,  3186,  3187,  3188,  3189,
		8246,  8247,  6330,  191,   4494,  4495,  4496,  188,
		8251,  215,   215,   215,   215,   4503,  4504,  4505,
		4506,  4507,  4508,  4509,  4510,  4511,  4512,  4513,
		4514,  4515,  4516,  4517,  4518,  4519,  4520,  4521,
		4522,  4523,  4524,  4525,  4526,  4527,  4528,  4529,
		4530,  4531,  4532,  4533,  4534,  4535,  4536,  4537,
		4538,  4539,  4540,  4541,  4542,  4543,  10698, 10451,
		10452, 4547,  4548,  4549,  1912,  4551,  4552,  4553,
		4554,  4555,  0,     32767, 4130,  4130,  -11229,4130,
		4559,  4560,  4561,  0,     0,     4562,  4563,  4564,
		-5799, -5799, -5799, 303,   32767, 4117,  4117,  4117,
		4117,  4117,  4117,  2031,  2032,  4574,  4575,  4576,
		32767, 32767, 32767, 4577,  4578,  4579,  4580,  4581,
		4582,  4583,  32767, 4584,  4585,  4586,  4587,  4588,
		4589,  4590,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 2034,  4816,  4817,  4818,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2035,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 2036,  2037,  2038,
		2039,  2040,  2041,  2042,  2043,  2044,  2045,  2046,
		2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
		2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,
		2063,  2064,  2065,  2066,  2067,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-4778, -4778, -4778, 0,     32767, 32767, 32767, 0,
		0,     32767, 32767, 32767, 0,     0,     32767, 32767,
		-4791, -4791, -4791, -4791, -4791, -4791, -4791, -4791,
		-4791, -4791, 0,     0,     -15359,0,     -4791, -4791,
		0,     0,     -4791, 0,     0,     -4789, -4789, -4789,
		-4789, -4789, -4789, 0,     0,     0,     0,     0,
		0,     -4789, 0,     0,     0,     -4789, -4789, -4789,
		-4789, -4789, -4789, -4789, 32767, 32767, 32767, 32767,
		-4793, -4793, -4793, 0,     0,     -4793, 0,     -4793,
		-4793, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 2069,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4017,  32767, 32767, 32767, 2070,
		2071,  2072,  2073,  2074,  2075,  2076,  2077,  22011,
		2079,  2080,  2081,  2082,  2083,  2084,  2085,  2086,
		2087,  2337,  2337,  2090,  2091,  2092,  2093,  2094,
		2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,
		2103,  2104,  2105,  -3995, 2107,  2108,  2109,  2110,
		2111,  2112,  2113,  627,   2115,  1486,  -5783, -5783,
		-5783, 2113,  2113,  2113,  -852,  1486,  1486,  1486,
		-126,  -5791, 5059,  1486,  3571,  -16362,-1003, 1486,
		-5795, -1004, 1486,  1486,  1486,  1486,  -5797, -126,
		-5798, 1486,  1486,  1486,  1486,  1486,  1486,  1486,
		1486,  -1017, -5806, -1017, -2823, -2823, 1486,  2022,
		-2821, -2821, -2821, -2821, 2163,  -2820, -2820, -2820,
		-2820, -5819, 1486,  -2820, -2820, -2820, 4876,  -2820,
		-2820, -5824, -2819, 2178,  -2818, -5042, 1488,  -2818,
		1488,  1488,  -2818, 1488,  -2817, -2817, -2817, -2817,
		-2817, -2817, -1461, -1461, 1488,  0,     0,     0,
		0,     0,     0,     0,     0,     -19933,0,     0,
		0,     0,     0,     0,     0,     0,     0,     -249,
		-248,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     6101,  0,     0,     0,     0,     0,     0,
		0,     1487,  0,     630,   7900,  7901,  7902,  7,
		8,     9,     2975,  638,   639,   640,   2253,  7919,
		-2930, 644,   -1440, 18494, 3136,  648,   7930,  3140,
		651,   652,   653,   654,   7938,  2268,  7941,  658,
		659,   660,   661,   662,   663,   664,   665,   3169,
		7959,  3171,  4978,  4979,  671,   136,   4980,  4981,
		4982,  4983,  0,     4984,  4985,  4986,  4987,  7987,
		683,   4990,  4991,  4992,  -2703, 4994,  4995,  8000,
		4996,  0,     4997,  7222,  693,   5000,  695,   696,
		5003,  698,   5004,  5005,  5006,  5007,  5008,  5009,
		3654,  3655,  707,   2196,  2197,  2198,  2199,  2200,
		2201,  2202,  2203,  22137, 2205,  2206,  2207,  2208,
		2209,  2210,  2211,  2212,  2213,  2463,  2463,  2216,
		2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,
		2225,  2226,  2227,  2228,  2229,  2230,  2231,  -3869,
		2233,  2234,  2235,  2236,  2237,  2238,  2239,  753,
		2241,  1612,  -5657, -5657, -5657, 2239,  2239,  2239,
		-726,  1612,  1612,  1612,  0,     -5665, 5185,  1612,
		3697,  -16236,-877,  1612,  -5669, -878,  1612,  1612,
		1612,  1612,  -5671, 0,     -5672, 1612,  1612,  1612,
		1612,  1612,  1612,  1612,  1612,  -891,  -5680, -891,
		-2697, -2697, 1612,  5095,  2299,  5097,  2300,  5099,
		2301,  5101,  2302,  5103,  2303,  5105,  2304,  5107,
		2305,  5109,  2306,  5111,  5112,  2307,  5114,  2308,
		32767, 2309,  5117,  5118,  5119,  32767, 5120,  5121,
		5498,  2311,  5124,  2312,  2313,  0,     2314,  2315,
		5126,  2316,  2317,  5129,  2318,  2319,  5132,  32767,
		5133,  5134,  5135,  5136,  5137,  5138,  5139,  5140,
		5141,  5142,  5143,  5144,  5145,  5146,  5147,  5148,
		5149,  5150,  5151,  5152,  2320,  5154,  5155,  5156,
		5157,  1377,  2322,  1378,  2324,  5162,  1379,  1379,
		5165,  5166,  5167,  5168,  5169,  5170,  5171,  5172,
		5173,  5174,  5175,  5176,  2327,  5178,  2328,  5180,
		2329,  5182,  2330,  5184,  2331,  5186,  2332,  5188,
		2333,  5190,  2334,  5192,  2335,  5194,  2336,  5196,
		2337,  5198,  2338,  5200,  5201,  2339,  5203,  2340,
		5205,  1391,  5207,  5208,  5209,  5210,  5211,  5212,
		1385,  1385,  -4221, -4221, -4221, -1193, 2346,  2347,
		5221,  2348,  2349,  -3412, -4220, -4220, -4220, -4220,
		5229,  5230,  5231,  5232,  5233,  5234,  5235,  5236,
		5237,  5238,  5239,  5240,  5241,  5242,  5243,  5244,
		5245,  5246,  5247,  5248,  2352,  5250,  5251,  4592,
		-2168, -1982, 2356,  5256,  5257,  5258,  2357,  4444,
		5261,  5262,  5263,  5264,  5265,  5266,  5267,  5268,
		5269,  5270,  5271,  5272,  5273,  5274,  5275,  5276,
		5277,  5278,  5279,  5280,  5281,  5282,  5283,  5284,
		5285,  5286,  5287,  5288,  5289,  5290,  5291,  5292,
		5293,  5294,  5295,  5296,  5297,  5298,  5299,  5300,
		5301,  5302,  5303,  5304,  5305,  5306,  32767, 5307,
		5308,  5309,  6427,  6428,  6429,  6430,  6431,  6432,
		6433,  6434,  -3465, -3465, 6439,  6440,  6441,  6442,
		6443,  6444,  6445,  6446,  -3465, -3465, -3465, -3465,
		-3465, -3465, 7724,  2669,  2670,  -3430, 2672,  2673,
		2674,  2675,  2676,  7733,  7734,  -3465, -3465, -3465,
		-3465, -3465, 5341,  5342,  -291,  -291,  -291,  -291,
		7390,  -3465, -3465, -3465, -3465, -3465, -3465, -3465,
		-3465, -3465, -5246, -5246, -5246, -5246, -3465, -3465,
		-3465, -3465, -3465, -3465, -3465, -3465, -3465, -3465,
		-3465, -3465, -3465, -3465, -3465, -3465, -3465, -3465,
		-3465, -3465, -3465, 1591,  1591,  7692,  1591,  1591,
		1591,  1591,  1591,  -3465, -3465, -1547, 4593,  4594,
		4595,  606,   4597,  -3465, 4572,  4573,  4574,  4575,
		-3105, 9632,  -5502, -5502, -5502, -5502, -4166, -5502,
		280,   280,   280,   280,   280,   280,   280,   280,
		5428,  5429,  278,   278,   278,   278,   278,   278,
		278,   5437,  5438,  5439,  5440,  5441,  5442,  5443,
		5444,  5445,  5446,  5447,  5448,  5449,  5450,  5451,
		5452,  5453,  5454,  5455,  5456,  5457,  5458,  5459,
		5460,  5461,  5462,  5463,  5464,  5465,  5466,  676,
		677,   16037, 679,   5471,  5472,  32767, 32767, 5473,
		0,     5475,  5476,  5477,  5478,  5479,  5480,  5481,
		693,   694,   695,   696,   697,   698,   5488,  700,
		701,   702,   5492,  5493,  5494,  5495,  5496,  5497,
		5498,  5499,  5500,  5501,  5502,  5503,  5504,  5505,
		713,   714,   5508,  716,   5510,  5511,  5512,  5513,
		5514,  5515,  1138,  2027,  2028,  719,   720,   2030,
		2031,  1144,  9041,  9042,  2477,  2478,  2479,  2480,
		2481,  2482,  2483,  2484,  2485,  2486,  2487,  2488,
		2489,  2490,  2491,  2492,  5540,  2768,  2768,  2768,
		2768,  5547,  -2247, 2499,  2500,  2768,  2768,  558,
		2768,  2768,  2506,  2507,  2508,  2509,  2510,  2511,
		2512,  2513,  8713,  2515,  2516,  2517,  2518,  2519,
		2520,  2521,  2522,  2523,  2524,  2525,  2526,  2527,
		2528,  2529,  2530,  2531,  2532,  2533,  2534,  2535,
		2536,  2537,  5587,  5588,  5589,  5590,  5591,  5592,
		5593,  5594,  2538,  0,     0,     0,     -1117, -1117,
		-1117, -1117, -1117, -1117, -1117, -1117, 8783,  8784,
		-1119, -1119, -1119, -1119, -1119, -1119, -1119, -1119,
		8793,  8794,  8795,  8796,  8797,  8798,  -2390, 2666,
		2666,  8767,  2666,  2666,  2666,  2666,  2666,  -2390,
		-2390, 8810,  8811,  8812,  8813,  8814,  9,     9,
		5643,  5644,  5645,  5646,  -2034, 8822,  8823,  8824,
		8825,  8826,  8827,  8828,  8829,  8830,  10612, 10613,
		10614, 10615, 8835,  8836,  8837,  8838,  8839,  8840,
		8841,  8842,  8843,  8844,  8845,  8846,  8847,  8848,
		8849,  8850,  8851,  8852,  8853,  8854,  8855,  3800,
		3801,  -2299, 3803,  3804,  3805,  3806,  3807,  8864,
		8865,  6948,  809,   809,   809,   4799,  809,   8872,
		836,   836,   836,   836,   8517,  -4219, 10916, 10917,
		10918, 10919, 9584,  10921, 5140,  5141,  5142,  5143,
		5144,  5145,  5146,  5147,  0,     0,     5152,  5153,
		5154,  5155,  5156,  5157,  5158,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     4791,  4791,  -10568,4791,  0,
		0,     4791,  4791,  0,     5474,  0,     0,     0,
		0,     0,     0,     0,     4789,  4789,  4789,  4789,
		4789,  4789,  0,     4789,  4789,  4789,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     4793,  4793,  0,     4793,
		0,     0,     0,     0,     0,     0,     4378,  3490,
		3490,  4800,  4800,  3491,  3491,  4379,  -3517, -3517,
		3049,  3049,  3049,  3049,  3049,  3049,  3049,  3049,
		3049,  3049,  3049,  3049,  3049,  3049,  3049,  3049,
		2,     2775,  2776,  2777,  2778,  0,     7795,  3050,
		3050,  2783,  2784,  4995,  2786,  2787,  3050,  3050,
		3050,  3050,  3050,  2793,  2794,  2795,  2796,  2797,
		2798,  2799,  2800,  2801,  2802,  2803,  2804,  2805,
		2806,  2807,  2808,  2809,  2810,  2811,  2812,  2813,
		2814,  2815,  2816,  2817,  2818,  2819,  2820,  2821,
		2822,  2823,  2824,  2825,  2826,  2827,  2828,  2829,
		2830,  2831,  2832,  2833,  2834,  2835,  2836,  2837,
		2838,  2839,  2840,  2841,  2842,  2843,  2844,  2845,
		2846,  2847,  2848,  2849,  2850,  2851,  2852,  2853,
		2854,  2855,  2856,  2857,  2858,  2859,  2860,  2861,
		2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,
		2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,
		2878,  2879,  2880,  2881,  2882,  2883,  2884,  2885,
		2886,  2887,  2888,  2889,  2890,  2891,  2892,  2893,
		2894,  2895,  2896,  2897,  2898,  2899,  2900,  2901,
		2902,  2903,  2904,  2905,  2906,  2907,  2908,  2909,
		2910,  2911,  2912,  2913,  2914,  2915,  2916,  2917,
		2918,  2919,  2920,  2921,  2922,  883,   884,   885,
		2926,  2927,  2928,  2929,  2930,  2931,  2932,  2933,
		2934,  2935,  2936,  2937,  2938,  2939,  2940,  2941,
		2942,  2943,  2944,  2945,  2946,  2947,  2948,  2949,
		2950,  2951,  2952,  2953,  2954,  2955,  2956,  2957,
		2958,  2959,  2960,  2961,  2962,  2963,  2964,  2965,
		2966,  2967,  2968,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4770,  4771,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     32767, 0,
		0,     0,     0,     0,     0,     0,     0
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 4;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 8191 + c;
	}
	return h[a % 13551] + h[b % 13551];
}

/* Hash lookup information for decomposition */
static const pg_unicode_decompinfo UnicodeDecompInfo =
{
	UnicodeDecompMain,
	Decomp_hash_func,
	6775
};

/* Inverse lookup array -- contains indexes into UnicodeDecompMain[] */
static const uint16 RecompInverseLookup[941] =
{
	/* U+003C+0338 -> U+226E */ 1857,
	/* U+003D+0338 -> U+2260 */ 1854,
	/* U+003E+0338 -> U+226F */ 1858,
	/* U+0041+0300 -> U+00C0 */ 14,
	/* U+0041+0301 -> U+00C1 */ 15,
	/* U+0041+0302 -> U+00C2 */ 16,
	/* U+0041+0303 -> U+00C3 */ 17,
	/* U+0041+0304 -> U+0100 */ 67,
	/* U+0041+0306 -> U+0102 */ 69,
	/* U+0041+0307 -> U+0226 */ 270,
	/* U+0041+0308 -> U+00C4 */ 18,
	/* U+0041+0309 -> U+1EA2 */ 1312,
	/* U+0041+030A -> U+00C5 */ 19,
	/* U+0041+030C -> U+01CD */ 194,
	/* U+0041+030F -> U+0200 */ 240,
	/* U+0041+0311 -> U+0202 */ 242,
	/* U+0041+0323 -> U+1EA0 */ 1310,
	/* U+0041+0325 -> U+1E00 */ 1154,
	/* U+0041+0328 -> U+0104 */ 71,
	/* U+0042+0307 -> U+1E02 */ 1156,
	/* U+0042+0323 -> U+1E04 */ 1158,
	/* U+0042+0331 -> U+1E06 */ 1160,
	/* U+0043+0301 -> U+0106 */ 73,
	/* U+0043+0302 -> U+0108 */ 75,
	/* U+0043+0307 -> U+010A */ 77,
	/* U+0043+030C -> U+010C */ 79,
	/* U+0043+0327 -> U+00C7 */ 20,
	/* U+0044+0307 -> U+1E0A */ 1164,
	/* U+0044+030C -> U+010E */ 81,
	/* U+0044+0323 -> U+1E0C */ 1166,
	/* U+0044+0327 -> U+1E10 */ 1170,
	/* U+0044+032D -> U+1E12 */ 1172,
	/* U+0044+0331 -> U+1E0E */ 1168,
	/* U+0045+0300 -> U+00C8 */ 21,
	/* U+0045+0301 -> U+00C9 */ 22,
	/* U+0045+0302 -> U+00CA */ 23,
	/* U+0045+0303 -> U+1EBC */ 1338,
	/* U+0045+0304 -> U+0112 */ 83,
	/* U+0045+0306 -> U+0114 */ 85,
	/* U+0045+0307 -> U+0116 */ 87,
	/* U+0045+0308 -> U+00CB */ 24,
	/* U+0045+0309 -> U+1EBA */ 1336,
	/* U+0045+030C -> U+011A */ 91,
	/* U+0045+030F -> U+0204 */ 244,
	/* U+0045+0311 -> U+0206 */ 246,
	/* U+0045+0323 -> U+1EB8 */ 1334,
	/* U+0045+0327 -> U+0228 */ 272,
	/* U+0045+0328 -> U+0118 */ 89,
	/* U+0045+032D -> U+1E18 */ 1178,
	/* U+0045+0330 -> U+1E1A */ 1180,
	/* U+0046+0307 -> U+1E1E */ 1184,
	/* U+0047+0301 -> U+01F4 */ 230,
	/* U+0047+0302 -> U+011C */ 93,
	/* U+0047+0304 -> U+1E20 */ 1186,
	/* U+0047+0306 -> U+011E */ 95,
	/* U+0047+0307 -> U+0120 */ 97,
	/* U+0047+030C -> U+01E6 */ 216,
	/* U+0047+0327 -> U+0122 */ 99,
	/* U+0048+0302 -> U+0124 */ 101,
	/* U+0048+0307 -> U+1E22 */ 1188,
	/* U+0048+0308 -> U+1E26 */ 1192,
	/* U+0048+030C -> U+021E */ 268,
	/* U+0048+0323 -> U+1E24 */ 1190,
	/* U+0048+0327 -> U+1E28 */ 1194,
	/* U+0048+032E -> U+1E2A */ 1196,
	/* U+0049+0300 -> U+00CC */ 25,
	/* U+0049+0301 -> U+00CD */ 26,
	/* U+0049+0302 -> U+00CE */ 27,
	/* U+0049+0303 -> U+0128 */ 103,
	/* U+0049+0304 -> U+012A */ 105,
	/* U+0049+0306 -> U+012C */ 107,
	/* U+0049+0307 -> U+0130 */ 111,
	/* U+0049+0308 -> U+00CF */ 28,
	/* U+0049+0309 -> U+1EC8 */ 1350,
	/* U+0049+030C -> U+01CF */ 196,
	/* U+0049+030F -> U+0208 */ 248,
	/* U+0049+0311 -> U+020A */ 250,
	/* U+0049+0323 -> U+1ECA */ 1352,
	/* U+0049+0328 -> U+012E */ 109,
	/* U+0049+0330 -> U+1E2C */ 1198,
	/* U+004A+0302 -> U+0134 */ 114,
	/* U+004B+0301 -> U+1E30 */ 1202,
	/* U+004B+030C -> U+01E8 */ 218,
	/* U+004B+0323 -> U+1E32 */ 1204,
	/* U+004B+0327 -> U+0136 */ 116,
	/* U+004B+0331 -> U+1E34 */ 1206,
	/* U+004C+0301 -> U+0139 */ 118,
	/* U+004C+030C -> U+013D */ 122,
	/* U+004C+0323 -> U+1E36 */ 1208,
	/* U+004C+0327 -> U+013B */ 120,
	/* U+004C+032D -> U+1E3C */ 1214,
	/* U+004C+0331 -> U+1E3A */ 1212,
	/* U+004D+0301 -> U+1E3E */ 1216,
	/* U+004D+0307 -> U+1E40 */ 1218,
	/* U+004D+0323 -> U+1E42 */ 1220,
	/* U+004E+0300 -> U+01F8 */ 232,
	/* U+004E+0301 -> U+0143 */ 126,
	/* U+004E+0303 -> U+00D1 */ 29,
	/* U+004E+0307 -> U+1E44 */ 1222,
	/* U+004E+030C -> U+0147 */ 130,
	/* U+004E+0323 -> U+1E46 */ 1224,
	/* U+004E+0327 -> U+0145 */ 128,
	/* U+004E+032D -> U+1E4A */ 1228,
	/* U+004E+0331 -> U+1E48 */ 1226,
	/* U+004F+0300 -> U+00D2 */ 30,
	/* U+004F+0301 -> U+00D3 */ 31,
	/* U+004F+0302 -> U+00D4 */ 32,
	/* U+004F+0303 -> U+00D5 */ 33,
	/* U+004F+0304 -> U+014C */ 133,
	/* U+004F+0306 -> U+014E */ 135,
	/* U+004F+0307 -> U+022E */ 278,
	/* U+004F+0308 -> U+00D6 */ 34,
	/* U+004F+0309 -> U+1ECE */ 1356,
	/* U+004F+030B -> U+0150 */ 137,
	/* U+004F+030C -> U+01D1 */ 198,
	/* U+004F+030F -> U+020C */ 252,
	/* U+004F+0311 -> U+020E */ 254,
	/* U+004F+031B -> U+01A0 */ 181,
	/* U+004F+0323 -> U+1ECC */ 1354,
	/* U+004F+0328 -> U+01EA */ 220,
	/* U+0050+0301 -> U+1E54 */ 1238,
	/* U+0050+0307 -> U+1E56 */ 1240,
	/* U+0052+0301 -> U+0154 */ 139,
	/* U+0052+0307 -> U+1E58 */ 1242,
	/* U+0052+030C -> U+0158 */ 143,
	/* U+0052+030F -> U+0210 */ 256,
	/* U+0052+0311 -> U+0212 */ 258,
	/* U+0052+0323 -> U+1E5A */ 1244,
	/* U+0052+0327 -> U+0156 */ 141,
	/* U+0052+0331 -> U+1E5E */ 1248,
	/* U+0053+0301 -> U+015A */ 145,
	/* U+0053+0302 -> U+015C */ 147,
	/* U+0053+0307 -> U+1E60 */ 1250,
	/* U+0053+030C -> U+0160 */ 151,
	/* U+0053+0323 -> U+1E62 */ 1252,
	/* U+0053+0326 -> U+0218 */ 264,
	/* U+0053+0327 -> U+015E */ 149,
	/* U+0054+0307 -> U+1E6A */ 1260,
	/* U+0054+030C -> U+0164 */ 155,
	/* U+0054+0323 -> U+1E6C */ 1262,
	/* U+0054+0326 -> U+021A */ 266,
	/* U+0054+0327 -> U+0162 */ 153,
	/* U+0054+032D -> U+1E70 */ 1266,
	/* U+0054+0331 -> U+1E6E */ 1264,
	/* U+0055+0300 -> U+00D9 */ 35,
	/* U+0055+0301 -> U+00DA */ 36,
	/* U+0055+0302 -> U+00DB */ 37,
	/* U+0055+0303 -> U+0168 */ 157,
	/* U+0055+0304 -> U+016A */ 159,
	/* U+0055+0306 -> U+016C */ 161,
	/* U+0055+0308 -> U+00DC */ 38,
	/* U+0055+0309 -> U+1EE6 */ 1380,
	/* U+0055+030A -> U+016E */ 163,
	/* U+0055+030B -> U+0170 */ 165,
	/* U+0055+030C -> U+01D3 */ 200,
	/* U+0055+030F -> U+0214 */ 260,
	/* U+0055+0311 -> U+0216 */ 262,
	/* U+0055+031B -> U+01AF */ 183,
	/* U+0055+0323 -> U+1EE4 */ 1378,
	/* U+0055+0324 -> U+1E72 */ 1268,
	/* U+0055+0328 -> U+0172 */ 167,
	/* U+0055+032D -> U+1E76 */ 1272,
	/* U+0055+0330 -> U+1E74 */ 1270,
	/* U+0056+0303 -> U+1E7C */ 1278,
	/* U+0056+0323 -> U+1E7E */ 1280,
	/* U+0057+0300 -> U+1E80 */ 1282,
	/* U+0057+0301 -> U+1E82 */ 1284,
	/* U+0057+0302 -> U+0174 */ 169,
	/* U+0057+0307 -> U+1E86 */ 1288,
	/* U+0057+0308 -> U+1E84 */ 1286,
	/* U+0057+0323 -> U+1E88 */ 1290,
	/* U+0058+0307 -> U+1E8A */ 1292,
	/* U+0058+0308 -> U+1E8C */ 1294,
	/* U+0059+0300 -> U+1EF2 */ 1392,
	/* U+0059+0301 -> U+00DD */ 39,
	/* U+0059+0302 -> U+0176 */ 171,
	/* U+0059+0303 -> U+1EF8 */ 1398,
	/* U+0059+0304 -> U+0232 */ 282,
	/* U+0059+0307 -> U+1E8E */ 1296,
	/* U+0059+0308 -> U+0178 */ 173,
	/* U+0059+0309 -> U+1EF6 */ 1396,
	/* U+0059+0323 -> U+1EF4 */ 1394,
	/* U+005A+0301 -> U+0179 */ 174,
	/* U+005A+0302 -> U+1E90 */ 1298,
	/* U+005A+0307 -> U+017B */ 176,
	/* U+005A+030C -> U+017D */ 178,
	/* U+005A+0323 -> U+1E92 */ 1300,
	/* U+005A+0331 -> U+1E94 */ 1302,
	/* U+0061+0300 -> U+00E0 */ 40,
	/* U+0061+0301 -> U+00E1 */ 41,
	/* U+0061+0302 -> U+00E2 */ 42,
	/* U+0061+0303 -> U+00E3 */ 43,
	/* U+0061+0304 -> U+0101 */ 68,
	/* U+0061+0306 -> U+0103 */ 70,
	/* U+0061+0307 -> U+0227 */ 271,
	/* U+0061+0308 -> U+00E4 */ 44,
	/* U+0061+0309 -> U+1EA3 */ 1313,
	/* U+0061+030A -> U+00E5 */ 45,
	/* U+0061+030C -> U+01CE */ 195,
	/* U+0061+030F -> U+0201 */ 241,
	/* U+0061+0311 -> U+0203 */ 243,
	/* U+0061+0323 -> U+1EA1 */ 1311,
	/* U+0061+0325 -> U+1E01 */ 1155,
	/* U+0061+0328 -> U+0105 */ 72,
	/* U+0062+0307 -> U+1E03 */ 1157,
	/* U+0062+0323 -> U+1E05 */ 1159,
	/* U+0062+0331 -> U+1E07 */ 1161,
	/* U+0063+0301 -> U+0107 */ 74,
	/* U+0063+0302 -> U+0109 */ 76,
	/* U+0063+0307 -> U+010B */ 78,
	/* U+0063+030C -> U+010D */ 80,
	/* U+0063+0327 -> U+00E7 */ 46,
	/* U+0064+0307 -> U+1E0B */ 1165,
	/* U+0064+030C -> U+010F */ 82,
	/* U+0064+0323 -> U+1E0D */ 1167,
	/* U+0064+0327 -> U+1E11 */ 1171,
	/* U+0064+032D -> U+1E13 */ 1173,
	/* U+0064+0331 -> U+1E0F */ 1169,
	/* U+0065+0300 -> U+00E8 */ 47,
	/* U+0065+0301 -> U+00E9 */ 48,
	/* U+0065+0302 -> U+00EA */ 49,
	/* U+0065+0303 -> U+1EBD */ 1339,
	/* U+0065+0304 -> U+0113 */ 84,
	/* U+0065+0306 -> U+0115 */ 86,
	/* U+0065+0307 -> U+0117 */ 88,
	/* U+0065+0308 -> U+00EB */ 50,
	/* U+0065+0309 -> U+1EBB */ 1337,
	/* U+0065+030C -> U+011B */ 92,
	/* U+0065+030F -> U+0205 */ 245,
	/* U+0065+0311 -> U+0207 */ 247,
	/* U+0065+0323 -> U+1EB9 */ 1335,
	/* U+0065+0327 -> U+0229 */ 273,
	/* U+0065+0328 -> U+0119 */ 90,
	/* U+0065+032D -> U+1E19 */ 1179,
	/* U+0065+0330 -> U+1E1B */ 1181,
	/* U+0066+0307 -> U+1E1F */ 1185,
	/* U+0067+0301 -> U+01F5 */ 231,
	/* U+0067+0302 -> U+011D */ 94,
	/* U+0067+0304 -> U+1E21 */ 1187,
	/* U+0067+0306 -> U+011F */ 96,
	/* U+0067+0307 -> U+0121 */ 98,
	/* U+0067+030C -> U+01E7 */ 217,
	/* U+0067+0327 -> U+0123 */ 100,
	/* U+0068+0302 -> U+0125 */ 102,
	/* U+0068+0307 -> U+1E23 */ 1189,
	/* U+0068+0308 -> U+1E27 */ 1193,
	/* U+0068+030C -> U+021F */ 269,
	/* U+0068+0323 -> U+1E25 */ 1191,
	/* U+0068+0327 -> U+1E29 */ 1195,
	/* U+0068+032E -> U+1E2B */ 1197,
	/* U+0068+0331 -> U+1E96 */ 1304,
	/* U+0069+0300 -> U+00EC */ 51,
	/* U+0069+0301 -> U+00ED */ 52,
	/* U+0069+0302 -> U+00EE */ 53,
	/* U+0069+0303 -> U+0129 */ 104,
	/* U+0069+0304 -> U+012B */ 106,
	/* U+0069+0306 -> U+012D */ 108,
	/* U+0069+0308 -> U+00EF */ 54,
	/* U+0069+0309 -> U+1EC9 */ 1351,
	/* U+0069+030C -> U+01D0 */ 197,
	/* U+0069+030F -> U+0209 */ 249,
	/* U+0069+0311 -> U+020B */ 251,
	/* U+0069+0323 -> U+1ECB */ 1353,
	/* U+0069+0328 -> U+012F */ 110,
	/* U+0069+0330 -> U+1E2D */ 1199,
	/* U+006A+0302 -> U+0135 */ 115,
	/* U+006A+030C -> U+01F0 */ 226,
	/* U+006B+0301 -> U+1E31 */ 1203,
	/* U+006B+030C -> U+01E9 */ 219,
	/* U+006B+0323 -> U+1E33 */ 1205,
	/* U+006B+0327 -> U+0137 */ 117,
	/* U+006B+0331 -> U+1E35 */ 1207,
	/* U+006C+0301 -> U+013A */ 119,
	/* U+006C+030C -> U+013E */ 123,
	/* U+006C+0323 -> U+1E37 */ 1209,
	/* U+006C+0327 -> U+013C */ 121,
	/* U+006C+032D -> U+1E3D */ 1215,
	/* U+006C+0331 -> U+1E3B */ 1213,
	/* U+006D+0301 -> U+1E3F */ 1217,
	/* U+006D+0307 -> U+1E41 */ 1219,
	/* U+006D+0323 -> U+1E43 */ 1221,
	/* U+006E+0300 -> U+01F9 */ 233,
	/* U+006E+0301 -> U+0144 */ 127,
	/* U+006E+0303 -> U+00F1 */ 55,
	/* U+006E+0307 -> U+1E45 */ 1223,
	/* U+006E+030C -> U+0148 */ 131,
	/* U+006E+0323 -> U+1E47 */ 1225,
	/* U+006E+0327 -> U+0146 */ 129,
	/* U+006E+032D -> U+1E4B */ 1229,
	/* U+006E+0331 -> U+1E49 */ 1227,
	/* U+006F+0300 -> U+00F2 */ 56,
	/* U+006F+0301 -> U+00F3 */ 57,
	/* U+006F+0302 -> U+00F4 */ 58,
	/* U+006F+0303 -> U+00F5 */ 59,
	/* U+006F+0304 -> U+014D */ 134,
	/* U+006F+0306 -> U+014F */ 136,
	/* U+006F+0307 -> U+022F */ 279,
	/* U+006F+0308 -> U+00F6 */ 60,
	/* U+006F+0309 -> U+1ECF */ 1357,
	/* U+006F+030B -> U+0151 */ 138,
	/* U+006F+030C -> U+01D2 */ 199,
	/* U+006F+030F -> U+020D */ 253,
	/* U+006F+0311 -> U+020F */ 255,
	/* U+006F+031B -> U+01A1 */ 182,
	/* U+006F+0323 -> U+1ECD */ 1355,
	/* U+006F+0328 -> U+01EB */ 221,
	/* U+0070+0301 -> U+1E55 */ 1239,
	/* U+0070+0307 -> U+1E57 */ 1241,
	/* U+0072+0301 -> U+0155 */ 140,
	/* U+0072+0307 -> U+1E59 */ 1243,
	/* U+0072+030C -> U+0159 */ 144,
	/* U+0072+030F -> U+0211 */ 257,
	/* U+0072+0311 -> U+0213 */ 259,
	/* U+0072+0323 -> U+1E5B */ 1245,
	/* U+0072+0327 -> U+0157 */ 142,
	/* U+0072+0331 -> U+1E5F */ 1249,
	/* U+0073+0301 -> U+015B */ 146,
	/* U+0073+0302 -> U+015D */ 148,
	/* U+0073+0307 -> U+1E61 */ 1251,
	/* U+0073+030C -> U+0161 */ 152,
	/* U+0073+0323 -> U+1E63 */ 1253,
	/* U+0073+0326 -> U+0219 */ 265,
	/* U+0073+0327 -> U+015F */ 150,
	/* U+0074+0307 -> U+1E6B */ 1261,
	/* U+0074+0308 -> U+1E97 */ 1305,
	/* U+0074+030C -> U+0165 */ 156,
	/* U+0074+0323 -> U+1E6D */ 1263,
	/* U+0074+0326 -> U+021B */ 267,
	/* U+0074+0327 -> U+0163 */ 154,
	/* U+0074+032D -> U+1E71 */ 1267,
	/* U+0074+0331 -> U+1E6F */ 1265,
	/* U+0075+0300 -> U+00F9 */ 61,
	/* U+0075+0301 -> U+00FA */ 62,
	/* U+0075+0302 -> U+00FB */ 63,
	/* U+0075+0303 -> U+0169 */ 158,
	/* U+0075+0304 -> U+016B */ 160,
	/* U+0075+0306 -> U+016D */ 162,
	/* U+0075+0308 -> U+00FC */ 64,
	/* U+0075+0309 -> U+1EE7 */ 1381,
	/* U+0075+030A -> U+016F */ 164,
	/* U+0075+030B -> U+0171 */ 166,
	/* U+0075+030C -> U+01D4 */ 201,
	/* U+0075+030F -> U+0215 */ 261,
	/* U+0075+0311 -> U+0217 */ 263,
	/* U+0075+031B -> U+01B0 */ 184,
	/* U+0075+0323 -> U+1EE5 */ 1379,
	/* U+0075+0324 -> U+1E73 */ 1269,
	/* U+0075+0328 -> U+0173 */ 168,
	/* U+0075+032D -> U+1E77 */ 1273,
	/* U+0075+0330 -> U+1E75 */ 1271,
	/* U+0076+0303 -> U+1E7D */ 1279,
	/* U+0076+0323 -> U+1E7F */ 1281,
	/* U+0077+0300 -> U+1E81 */ 1283,
	/* U+0077+0301 -> U+1E83 */ 1285,
	/* U+0077+0302 -> U+0175 */ 170,
	/* U+0077+0307 -> U+1E87 */ 1289,
	/* U+0077+0308 -> U+1E85 */ 1287,
	/* U+0077+030A -> U+1E98 */ 1306,
	/* U+0077+0323 -> U+1E89 */ 1291,
	/* U+0078+0307 -> U+1E8B */ 1293,
	/* U+0078+0308 -> U+1E8D */ 1295,
	/* U+0079+0300 -> U+1EF3 */ 1393,
	/* U+0079+0301 -> U+00FD */ 65,
	/* U+0079+0302 -> U+0177 */ 172,
	/* U+0079+0303 -> U+1EF9 */ 1399,
	/* U+0079+0304 -> U+0233 */ 283,
	/* U+0079+0307 -> U+1E8F */ 1297,
	/* U+0079+0308 -> U+00FF */ 66,
	/* U+0079+0309 -> U+1EF7 */ 1397,
	/* U+0079+030A -> U+1E99 */ 1307,
	/* U+0079+0323 -> U+1EF5 */ 1395,
	/* U+007A+0301 -> U+017A */ 175,
	/* U+007A+0302 -> U+1E91 */ 1299,
	/* U+007A+0307 -> U+017C */ 177,
	/* U+007A+030C -> U+017E */ 179,
	/* U+007A+0323 -> U+1E93 */ 1301,
	/* U+007A+0331 -> U+1E95 */ 1303,
	/* U+00A8+0300 -> U+1FED */ 1618,
	/* U+00A8+0301 -> U+0385 */ 419,
	/* U+00A8+0342 -> U+1FC1 */ 1578,
	/* U+00C2+0300 -> U+1EA6 */ 1316,
	/* U+00C2+0301 -> U+1EA4 */ 1314,
	/* U+00C2+0303 -> U+1EAA */ 1320,
	/* U+00C2+0309 -> U+1EA8 */ 1318,
	/* U+00C4+0304 -> U+01DE */ 210,
	/* U+00C5+0301 -> U+01FA */ 234,
	/* U+00C6+0301 -> U+01FC */ 236,
	/* U+00C6+0304 -> U+01E2 */ 214,
	/* U+00C7+0301 -> U+1E08 */ 1162,
	/* U+00CA+0300 -> U+1EC0 */ 1342,
	/* U+00CA+0301 -> U+1EBE */ 1340,
	/* U+00CA+0303 -> U+1EC4 */ 1346,
	/* U+00CA+0309 -> U+1EC2 */ 1344,
	/* U+00CF+0301 -> U+1E2E */ 1200,
	/* U+00D4+0300 -> U+1ED2 */ 1360,
	/* U+00D4+0301 -> U+1ED0 */ 1358,
	/* U+00D4+0303 -> U+1ED6 */ 1364,
	/* U+00D4+0309 -> U+1ED4 */ 1362,
	/* U+00D5+0301 -> U+1E4C */ 1230,
	/* U+00D5+0304 -> U+022C */ 276,
	/* U+00D5+0308 -> U+1E4E */ 1232,
	/* U+00D6+0304 -> U+022A */ 274,
	/* U+00D8+0301 -> U+01FE */ 238,
	/* U+00DC+0300 -> U+01DB */ 208,
	/* U+00DC+0301 -> U+01D7 */ 204,
	/* U+00DC+0304 -> U+01D5 */ 202,
	/* U+00DC+030C -> U+01D9 */ 206,
	/* U+00E2+0300 -> U+1EA7 */ 1317,
	/* U+00E2+0301 -> U+1EA5 */ 1315,
	/* U+00E2+0303 -> U+1EAB */ 1321,
	/* U+00E2+0309 -> U+1EA9 */ 1319,
	/* U+00E4+0304 -> U+01DF */ 211,
	/* U+00E5+0301 -> U+01FB */ 235,
	/* U+00E6+0301 -> U+01FD */ 237,
	/* U+00E6+0304 -> U+01E3 */ 215,
	/* U+00E7+0301 -> U+1E09 */ 1163,
	/* U+00EA+0300 -> U+1EC1 */ 1343,
	/* U+00EA+0301 -> U+1EBF */ 1341,
	/* U+00EA+0303 -> U+1EC5 */ 1347,
	/* U+00EA+0309 -> U+1EC3 */ 1345,
	/* U+00EF+0301 -> U+1E2F */ 1201,
	/* U+00F4+0300 -> U+1ED3 */ 1361,
	/* U+00F4+0301 -> U+1ED1 */ 1359,
	/* U+00F4+0303 -> U+1ED7 */ 1365,
	/* U+00F4+0309 -> U+1ED5 */ 1363,
	/* U+00F5+0301 -> U+1E4D */ 1231,
	/* U+00F5+0304 -> U+022D */ 277,
	/* U+00F5+0308 -> U+1E4F */ 1233,
	/* U+00F6+0304 -> U+022B */ 275,
	/* U+00F8+0301 -> U+01FF */ 239,
	/* U+00FC+0300 -> U+01DC */ 209,
	/* U+00FC+0301 -> U+01D8 */ 205,
	/* U+00FC+0304 -> U+01D6 */ 203,
	/* U+00FC+030C -> U+01DA */ 207,
	/* U+0102+0300 -> U+1EB0 */ 1326,
	/* U+0102+0301 -> U+1EAE */ 1324,
	/* U+0102+0303 -> U+1EB4 */ 1330,
	/* U+0102+0309 -> U+1EB2 */ 1328,
	/* U+0103+0300 -> U+1EB1 */ 1327,
	/* U+0103+0301 -> U+1EAF */ 1325,
	/* U+0103+0303 -> U+1EB5 */ 1331,
	/* U+0103+0309 -> U+1EB3 */ 1329,
	/* U+0112+0300 -> U+1E14 */ 1174,
	/* U+0112+0301 -> U+1E16 */ 1176,
	/* U+0113+0300 -> U+1E15 */ 1175,
	/* U+0113+0301 -> U+1E17 */ 1177,
	/* U+014C+0300 -> U+1E50 */ 1234,
	/* U+014C+0301 -> U+1E52 */ 1236,
	/* U+014D+0300 -> U+1E51 */ 1235,
	/* U+014D+0301 -> U+1E53 */ 1237,
	/* U+015A+0307 -> U+1E64 */ 1254,
	/* U+015B+0307 -> U+1E65 */ 1255,
	/* U+0160+0307 -> U+1E66 */ 1256,
	/* U+0161+0307 -> U+1E67 */ 1257,
	/* U+0168+0301 -> U+1E78 */ 1274,
	/* U+0169+0301 -> U+1E79 */ 1275,
	/* U+016A+0308 -> U+1E7A */ 1276,
	/* U+016B+0308 -> U+1E7B */ 1277,
	/* U+017F+0307 -> U+1E9B */ 1309,
	/* U+01A0+0300 -> U+1EDC */ 1370,
	/* U+01A0+0301 -> U+1EDA */ 1368,
	/* U+01A0+0303 -> U+1EE0 */ 1374,
	/* U+01A0+0309 -> U+1EDE */ 1372,
	/* U+01A0+0323 -> U+1EE2 */ 1376,
	/* U+01A1+0300 -> U+1EDD */ 1371,
	/* U+01A1+0301 -> U+1EDB */ 1369,
	/* U+01A1+0303 -> U+1EE1 */ 1375,
	/* U+01A1+0309 -> U+1EDF */ 1373,
	/* U+01A1+0323 -> U+1EE3 */ 1377,
	/* U+01AF+0300 -> U+1EEA */ 1384,
	/* U+01AF+0301 -> U+1EE8 */ 1382,
	/* U+01AF+0303 -> U+1EEE */ 1388,
	/* U+01AF+0309 -> U+1EEC */ 1386,
	/* U+01AF+0323 -> U+1EF0 */ 1390,
	/* U+01B0+0300 -> U+1EEB */ 1385,
	/* U+01B0+0301 -> U+1EE9 */ 1383,
	/* U+01B0+0303 -> U+1EEF */ 1389,
	/* U+01B0+0309 -> U+1EED */ 1387,
	/* U+01B0+0323 -> U+1EF1 */ 1391,
	/* U+01B7+030C -> U+01EE */ 224,
	/* U+01EA+0304 -> U+01EC */ 222,
	/* U+01EB+0304 -> U+01ED */ 223,
	/* U+0226+0304 -> U+01E0 */ 212,
	/* U+0227+0304 -> U+01E1 */ 213,
	/* U+0228+0306 -> U+1E1C */ 1182,
	/* U+0229+0306 -> U+1E1D */ 1183,
	/* U+022E+0304 -> U+0230 */ 280,
	/* U+022F+0304 -> U+0231 */ 281,
	/* U+0292+030C -> U+01EF */ 225,
	/* U+0391+0300 -> U+1FBA */ 1571,
	/* U+0391+0301 -> U+0386 */ 420,
	/* U+0391+0304 -> U+1FB9 */ 1570,
	/* U+0391+0306 -> U+1FB8 */ 1569,
	/* U+0391+0313 -> U+1F08 */ 1408,
	/* U+0391+0314 -> U+1F09 */ 1409,
	/* U+0391+0345 -> U+1FBC */ 1573,
	/* U+0395+0300 -> U+1FC8 */ 1584,
	/* U+0395+0301 -> U+0388 */ 422,
	/* U+0395+0313 -> U+1F18 */ 1422,
	/* U+0395+0314 -> U+1F19 */ 1423,
	/* U+0397+0300 -> U+1FCA */ 1586,
	/* U+0397+0301 -> U+0389 */ 423,
	/* U+0397+0313 -> U+1F28 */ 1436,
	/* U+0397+0314 -> U+1F29 */ 1437,
	/* U+0397+0345 -> U+1FCC */ 1588,
	/* U+0399+0300 -> U+1FDA */ 1600,
	/* U+0399+0301 -> U+038A */ 424,
	/* U+0399+0304 -> U+1FD9 */ 1599,
	/* U+0399+0306 -> U+1FD8 */ 1598,
	/* U+0399+0308 -> U+03AA */ 429,
	/* U+0399+0313 -> U+1F38 */ 1452,
	/* U+0399+0314 -> U+1F39 */ 1453,
	/* U+039F+0300 -> U+1FF8 */ 1626,
	/* U+039F+0301 -> U+038C */ 425,
	/* U+039F+0313 -> U+1F48 */ 1466,
	/* U+039F+0314 -> U+1F49 */ 1467,
	/* U+03A1+0314 -> U+1FEC */ 1617,
	/* U+03A5+0300 -> U+1FEA */ 1615,
	/* U+03A5+0301 -> U+038E */ 426,
	/* U+03A5+0304 -> U+1FE9 */ 1614,
	/* U+03A5+0306 -> U+1FE8 */ 1613,
	/* U+03A5+0308 -> U+03AB */ 430,
	/* U+03A5+0314 -> U+1F59 */ 1480,
	/* U+03A9+0300 -> U+1FFA */ 1628,
	/* U+03A9+0301 -> U+038F */ 427,
	/* U+03A9+0313 -> U+1F68 */ 1492,
	/* U+03A9+0314 -> U+1F69 */ 1493,
	/* U+03A9+0345 -> U+1FFC */ 1630,
	/* U+03AC+0345 -> U+1FB4 */ 1566,
	/* U+03AE+0345 -> U+1FC4 */ 1581,
	/* U+03B1+0300 -> U+1F70 */ 1500,
	/* U+03B1+0301 -> U+03AC */ 431,
	/* U+03B1+0304 -> U+1FB1 */ 1563,
	/* U+03B1+0306 -> U+1FB0 */ 1562,
	/* U+03B1+0313 -> U+1F00 */ 1400,
	/* U+03B1+0314 -> U+1F01 */ 1401,
	/* U+03B1+0342 -> U+1FB6 */ 1567,
	/* U+03B1+0345 -> U+1FB3 */ 1565,
	/* U+03B5+0300 -> U+1F72 */ 1502,
	/* U+03B5+0301 -> U+03AD */ 432,
	/* U+03B5+0313 -> U+1F10 */ 1416,
	/* U+03B5+0314 -> U+1F11 */ 1417,
	/* U+03B7+0300 -> U+1F74 */ 1504,
	/* U+03B7+0301 -> U+03AE */ 433,
	/* U+03B7+0313 -> U+1F20 */ 1428,
	/* U+03B7+0314 -> U+1F21 */ 1429,
	/* U+03B7+0342 -> U+1FC6 */ 1582,
	/* U+03B7+0345 -> U+1FC3 */ 1580,
	/* U+03B9+0300 -> U+1F76 */ 1506,
	/* U+03B9+0301 -> U+03AF */ 434,
	/* U+03B9+0304 -> U+1FD1 */ 1593,
	/* U+03B9+0306 -> U+1FD0 */ 1592,
	/* U+03B9+0308 -> U+03CA */ 436,
	/* U+03B9+0313 -> U+1F30 */ 1444,
	/* U+03B9+0314 -> U+1F31 */ 1445,
	/* U+03B9+0342 -> U+1FD6 */ 1596,
	/* U+03BF+0300 -> U+1F78 */ 1508,
	/* U+03BF+0301 -> U+03CC */ 438,
	/* U+03BF+0313 -> U+1F40 */ 1460,
	/* U+03BF+0314 -> U+1F41 */ 1461,
	/* U+03C1+0313 -> U+1FE4 */ 1609,
	/* U+03C1+0314 -> U+1FE5 */ 1610,
	/* U+03C5+0300 -> U+1F7A */ 1510,
	/* U+03C5+0301 -> U+03CD */ 439,
	/* U+03C5+0304 -> U+1FE1 */ 1606,
	/* U+03C5+0306 -> U+1FE0 */ 1605,
	/* U+03C5+0308 -> U+03CB */ 437,
	/* U+03C5+0313 -> U+1F50 */ 1472,
	/* U+03C5+0314 -> U+1F51 */ 1473,
	/* U+03C5+0342 -> U+1FE6 */ 1611,
	/* U+03C9+0300 -> U+1F7C */ 1512,
	/* U+03C9+0301 -> U+03CE */ 440,
	/* U+03C9+0313 -> U+1F60 */ 1484,
	/* U+03C9+0314 -> U+1F61 */ 1485,
	/* U+03C9+0342 -> U+1FF6 */ 1624,
	/* U+03C9+0345 -> U+1FF3 */ 1622,
	/* U+03CA+0300 -> U+1FD2 */ 1594,
	/* U+03CA+0301 -> U+0390 */ 428,
	/* U+03CA+0342 -> U+1FD7 */ 1597,
	/* U+03CB+0300 -> U+1FE2 */ 1607,
	/* U+03CB+0301 -> U+03B0 */ 435,
	/* U+03CB+0342 -> U+1FE7 */ 1612,
	/* U+03CE+0345 -> U+1FF4 */ 1623,
	/* U+03D2+0301 -> U+03D3 */ 444,
	/* U+03D2+0308 -> U+03D4 */ 445,
	/* U+0406+0308 -> U+0407 */ 457,
	/* U+0410+0306 -> U+04D0 */ 479,
	/* U+0410+0308 -> U+04D2 */ 481,
	/* U+0413+0301 -> U+0403 */ 456,
	/* U+0415+0300 -> U+0400 */ 454,
	/* U+0415+0306 -> U+04D6 */ 483,
	/* U+0415+0308 -> U+0401 */ 455,
	/* U+0416+0306 -> U+04C1 */ 477,
	/* U+0416+0308 -> U+04DC */ 487,
	/* U+0417+0308 -> U+04DE */ 489,
	/* U+0418+0300 -> U+040D */ 459,
	/* U+0418+0304 -> U+04E2 */ 491,
	/* U+0418+0306 -> U+0419 */ 461,
	/* U+0418+0308 -> U+04E4 */ 493,
	/* U+041A+0301 -> U+040C */ 458,
	/* U+041E+0308 -> U+04E6 */ 495,
	/* U+0423+0304 -> U+04EE */ 501,
	/* U+0423+0306 -> U+040E */ 460,
	/* U+0423+0308 -> U+04F0 */ 503,
	/* U+0423+030B -> U+04F2 */ 505,
	/* U+0427+0308 -> U+04F4 */ 507,
	/* U+042B+0308 -> U+04F8 */ 509,
	/* U+042D+0308 -> U+04EC */ 499,
	/* U+0430+0306 -> U+04D1 */ 480,
	/* U+0430+0308 -> U+04D3 */ 482,
	/* U+0433+0301 -> U+0453 */ 465,
	/* U+0435+0300 -> U+0450 */ 463,
	/* U+0435+0306 -> U+04D7 */ 484,
	/* U+0435+0308 -> U+0451 */ 464,
	/* U+0436+0306 -> U+04C2 */ 478,
	/* U+0436+0308 -> U+04DD */ 488,
	/* U+0437+0308 -> U+04DF */ 490,
	/* U+0438+0300 -> U+045D */ 468,
	/* U+0438+0304 -> U+04E3 */ 492,
	/* U+0438+0306 -> U+0439 */ 462,
	/* U+0438+0308 -> U+04E5 */ 494,
	/* U+043A+0301 -> U+045C */ 467,
	/* U+043E+0308 -> U+04E7 */ 496,
	/* U+0443+0304 -> U+04EF */ 502,
	/* U+0443+0306 -> U+045E */ 469,
	/* U+0443+0308 -> U+04F1 */ 504,
	/* U+0443+030B -> U+04F3 */ 506,
	/* U+0447+0308 -> U+04F5 */ 508,
	/* U+044B+0308 -> U+04F9 */ 510,
	/* U+044D+0308 -> U+04ED */ 500,
	/* U+0456+0308 -> U+0457 */ 466,
	/* U+0474+030F -> U+0476 */ 470,
	/* U+0475+030F -> U+0477 */ 471,
	/* U+04D8+0308 -> U+04DA */ 485,
	/* U+04D9+0308 -> U+04DB */ 486,
	/* U+04E8+0308 -> U+04EA */ 497,
	/* U+04E9+0308 -> U+04EB */ 498,
	/* U+0627+0653 -> U+0622 */ 574,
	/* U+0627+0654 -> U+0623 */ 575,
	/* U+0627+0655 -> U+0625 */ 577,
	/* U+0648+0654 -> U+0624 */ 576,
	/* U+064A+0654 -> U+0626 */ 578,
	/* U+06C1+0654 -> U+06C2 */ 606,
	/* U+06D2+0654 -> U+06D3 */ 607,
	/* U+06D5+0654 -> U+06C0 */ 605,
	/* U+0928+093C -> U+0929 */ 750,
	/* U+0930+093C -> U+0931 */ 751,
	/* U+0933+093C -> U+0934 */ 752,
	/* U+09C7+09BE -> U+09CB */ 768,
	/* U+09C7+09D7 -> U+09CC */ 769,
	/* U+0B47+0B3E -> U+0B4B */ 787,
	/* U+0B47+0B56 -> U+0B48 */ 786,
	/* U+0B47+0B57 -> U+0B4C */ 788,
	/* U+0B92+0BD7 -> U+0B94 */ 792,
	/* U+0BC6+0BBE -> U+0BCA */ 793,
	/* U+0BC6+0BD7 -> U+0BCC */ 795,
	/* U+0BC7+0BBE -> U+0BCB */ 794,
	/* U+0C46+0C56 -> U+0C48 */ 798,
	/* U+0CBF+0CD5 -> U+0CC0 */ 803,
	/* U+0CC6+0CC2 -> U+0CCA */ 806,
	/* U+0CC6+0CD5 -> U+0CC7 */ 804,
	/* U+0CC6+0CD6 -> U+0CC8 */ 805,
	/* U+0CCA+0CD5 -> U+0CCB */ 807,
	/* U+0D46+0D3E -> U+0D4A */ 811,
	/* U+0D46+0D57 -> U+0D4C */ 813,
	/* U+0D47+0D3E -> U+0D4B */ 812,
	/* U+0DD9+0DCA -> U+0DDA */ 816,
	/* U+0DD9+0DCF -> U+0DDC */ 817,
	/* U+0DD9+0DDF -> U+0DDE */ 819,
	/* U+0DDC+0DCA -> U+0DDD */ 818,
	/* U+1025+102E -> U+1026 */ 877,
	/* U+1B05+1B35 -> U+1B06 */ 937,
	/* U+1B07+1B35 -> U+1B08 */ 938,
	/* U+1B09+1B35 -> U+1B0A */ 939,
	/* U+1B0B+1B35 -> U+1B0C */ 940,
	/* U+1B0D+1B35 -> U+1B0E */ 941,
	/* U+1B11+1B35 -> U+1B12 */ 942,
	/* U+1B3A+1B35 -> U+1B3B */ 944,
	/* U+1B3C+1B35 -> U+1B3D */ 945,
	/* U+1B3E+1B35 -> U+1B40 */ 946,
	/* U+1B3F+1B35 -> U+1B41 */ 947,
	/* U+1B42+1B35 -> U+1B43 */ 948,
	/* U+1E36+0304 -> U+1E38 */ 1210,
	/* U+1E37+0304 -> U+1E39 */ 1211,
	/* U+1E5A+0304 -> U+1E5C */ 1246,
	/* U+1E5B+0304 -> U+1E5D */ 1247,
	/* U+1E62+0307 -> U+1E68 */ 1258,
	/* U+1E63+0307 -> U+1E69 */ 1259,
	/* U+1EA0+0302 -> U+1EAC */ 1322,
	/* U+1EA0+0306 -> U+1EB6 */ 1332,
	/* U+1EA1+0302 -> U+1EAD */ 1323,
	/* U+1EA1+0306 -> U+1EB7 */ 1333,
	/* U+1EB8+0302 -> U+1EC6 */ 1348,
	/* U+1EB9+0302 -> U+1EC7 */ 1349,
	/* U+1ECC+0302 -> U+1ED8 */ 1366,
	/* U+1ECD+0302 -> U+1ED9 */ 1367,
	/* U+1F00+0300 -> U+1F02 */ 1402,
	/* U+1F00+0301 -> U+1F04 */ 1404,
	/* U+1F00+0342 -> U+1F06 */ 1406,
	/* U+1F00+0345 -> U+1F80 */ 1514,
	/* U+1F01+0300 -> U+1F03 */ 1403,
	/* U+1F01+0301 -> U+1F05 */ 1405,
	/* U+1F01+0342 -> U+1F07 */ 1407,
	/* U+1F01+0345 -> U+1F81 */ 1515,
	/* U+1F02+0345 -> U+1F82 */ 1516,
	/* U+1F03+0345 -> U+1F83 */ 1517,
	/* U+1F04+0345 -> U+1F84 */ 1518,
	/* U+1F05+0345 -> U+1F85 */ 1519,
	/* U+1F06+0345 -> U+1F86 */ 1520,
	/* U+1F07+0345 -> U+1F87 */ 1521,
	/* U+1F08+0300 -> U+1F0A */ 1410,
	/* U+1F08+0301 -> U+1F0C */ 1412,
	/* U+1F08+0342 -> U+1F0E */ 1414,
	/* U+1F08+0345 -> U+1F88 */ 1522,
	/* U+1F09+0300 -> U+1F0B */ 1411,
	/* U+1F09+0301 -> U+1F0D */ 1413,
	/* U+1F09+0342 -> U+1F0F */ 1415,
	/* U+1F09+0345 -> U+1F89 */ 1523,
	/* U+1F0A+0345 -> U+1F8A */ 1524,
	/* U+1F0B+0345 -> U+1F8B */ 1525,
	/* U+1F0C+0345 -> U+1F8C */ 1526,
	/* U+1F0D+0345 -> U+1F8D */ 1527,
	/* U+1F0E+0345 -> U+1F8E */ 1528,
	/* U+1F0F+0345 -> U+1F8F */ 1529,
	/* U+1F10+0300 -> U+1F12 */ 1418,
	/* U+1F10+0301 -> U+1F14 */ 1420,
	/* U+1F11+0300 -> U+1F13 */ 1419,
	/* U+1F11+0301 -> U+1F15 */ 1421,
	/* U+1F18+0300 -> U+1F1A */ 1424,
	/* U+1F18+0301 -> U+1F1C */ 1426,
	/* U+1F19+0300 -> U+1F1B */ 1425,
	/* U+1F19+0301 -> U+1F1D */ 1427,
	/* U+1F20+0300 -> U+1F22 */ 1430,
	/* U+1F20+0301 -> U+1F24 */ 1432,
	/* U+1F20+0342 -> U+1F26 */ 1434,
	/* U+1F20+0345 -> U+1F90 */ 1530,
	/* U+1F21+0300 -> U+1F23 */ 1431,
	/* U+1F21+0301 -> U+1F25 */ 1433,
	/* U+1F21+0342 -> U+1F27 */ 1435,
	/* U+1F21+0345 -> U+1F91 */ 1531,
	/* U+1F22+0345 -> U+1F92 */ 1532,
	/* U+1F23+0345 -> U+1F93 */ 1533,
	/* U+1F24+0345 -> U+1F94 */ 1534,
	/* U+1F25+0345 -> U+1F95 */ 1535,
	/* U+1F26+0345 -> U+1F96 */ 1536,
	/* U+1F27+0345 -> U+1F97 */ 1537,
	/* U+1F28+0300 -> U+1F2A */ 1438,
	/* U+1F28+0301 -> U+1F2C */ 1440,
	/* U+1F28+0342 -> U+1F2E */ 1442,
	/* U+1F28+0345 -> U+1F98 */ 1538,
	/* U+1F29+0300 -> U+1F2B */ 1439,
	/* U+1F29+0301 -> U+1F2D */ 1441,
	/* U+1F29+0342 -> U+1F2F */ 1443,
	/* U+1F29+0345 -> U+1F99 */ 1539,
	/* U+1F2A+0345 -> U+1F9A */ 1540,
	/* U+1F2B+0345 -> U+1F9B */ 1541,
	/* U+1F2C+0345 -> U+1F9C */ 1542,
	/* U+1F2D+0345 -> U+1F9D */ 1543,
	/* U+1F2E+0345 -> U+1F9E */ 1544,
	/* U+1F2F+0345 -> U+1F9F */ 1545,
	/* U+1F30+0300 -> U+1F32 */ 1446,
	/* U+1F30+0301 -> U+1F34 */ 1448,
	/* U+1F30+0342 -> U+1F36 */ 1450,
	/* U+1F31+0300 -> U+1F33 */ 1447,
	/* U+1F31+0301 -> U+1F35 */ 1449,
	/* U+1F31+0342 -> U+1F37 */ 1451,
	/* U+1F38+0300 -> U+1F3A */ 1454,
	/* U+1F38+0301 -> U+1F3C */ 1456,
	/* U+1F38+0342 -> U+1F3E */ 1458,
	/* U+1F39+0300 -> U+1F3B */ 1455,
	/* U+1F39+0301 -> U+1F3D */ 1457,
	/* U+1F39+0342 -> U+1F3F */ 1459,
	/* U+1F40+0300 -> U+1F42 */ 1462,
	/* U+1F40+0301 -> U+1F44 */ 1464,
	/* U+1F41+0300 -> U+1F43 */ 1463,
	/* U+1F41+0301 -> U+1F45 */ 1465,
	/* U+1F48+0300 -> U+1F4A */ 1468,
	/* U+1F48+0301 -> U+1F4C */ 1470,
	/* U+1F49+0300 -> U+1F4B */ 1469,
	/* U+1F49+0301 -> U+1F4D */ 1471,
	/* U+1F50+0300 -> U+1F52 */ 1474,
	/* U+1F50+0301 -> U+1F54 */ 1476,
	/* U+1F50+0342 -> U+1F56 */ 1478,
	/* U+1F51+0300 -> U+1F53 */ 1475,
	/* U+1F51+0301 -> U+1F55 */ 1477,
	/* U+1F51+0342 -> U+1F57 */ 1479,
	/* U+1F59+0300 -> U+1F5B */ 1481,
	/* U+1F59+0301 -> U+1F5D */ 1482,
	/* U+1F59+0342 -> U+1F5F */ 1483,
	/* U+1F60+0300 -> U+1F62 */ 1486,
	/* U+1F60+0301 -> U+1F64 */ 1488,
	/* U+1F60+0342 -> U+1F66 */ 1490,
	/* U+1F60+0345 -> U+1FA0 */ 1546,
	/* U+1F61+0300 -> U+1F63 */ 1487,
	/* U+1F61+0301 -> U+1F65 */ 1489,
	/* U+1F61+0342 -> U+1F67 */ 1491,
	/* U+1F61+0345 -> U+1FA1 */ 1547,
	/* U+1F62+0345 -> U+1FA2 */ 1548,
	/* U+1F63+0345 -> U+1FA3 */ 1549,
	/* U+1F64+0345 -> U+1FA4 */ 1550,
	/* U+1F65+0345 -> U+1FA5 */ 1551,
	/* U+1F66+0345 -> U+1FA6 */ 1552,
	/* U+1F67+0345 -> U+1FA7 */ 1553,
	/* U+1F68+0300 -> U+1F6A */ 1494,
	/* U+1F68+0301 -> U+1F6C */ 1496,
	/* U+1F68+0342 -> U+1F6E */ 1498,
	/* U+1F68+0345 -> U+1FA8 */ 1554,
	/* U+1F69+0300 -> U+1F6B */ 1495,
	/* U+1F69+0301 -> U+1F6D */ 1497,
	/* U+1F69+0342 -> U+1F6F */ 1499,
	/* U+1F69+0345 -> U+1FA9 */ 1555,
	/* U+1F6A+0345 -> U+1FAA */ 1556,
	/* U+1F6B+0345 -> U+1FAB */ 1557,
	/* U+1F6C+0345 -> U+1FAC */ 1558,
	/* U+1F6D+0345 -> U+1FAD */ 1559,
	/* U+1F6E+0345 -> U+1FAE */ 1560,
	/* U+1F6F+0345 -> U+1FAF */ 1561,
	/* U+1F70+0345 -> U+1FB2 */ 1564,
	/* U+1F74+0345 -> U+1FC2 */ 1579,
	/* U+1F7C+0345 -> U+1FF2 */ 1621,
	/* U+1FB6+0345 -> U+1FB7 */ 1568,
	/* U+1FBF+0300 -> U+1FCD */ 1589,
	/* U+1FBF+0301 -> U+1FCE */ 1590,
	/* U+1FBF+0342 -> U+1FCF */ 1591,
	/* U+1FC6+0345 -> U+1FC7 */ 1583,
	/* U+1FF6+0345 -> U+1FF7 */ 1625,
	/* U+1FFE+0300 -> U+1FDD */ 1602,
	/* U+1FFE+0301 -> U+1FDE */ 1603,
	/* U+1FFE+0342 -> U+1FDF */ 1604,
	/* U+2190+0338 -> U+219A */ 1835,
	/* U+2192+0338 -> U+219B */ 1836,
	/* U+2194+0338 -> U+21AE */ 1837,
	/* U+21D0+0338 -> U+21CD */ 1838,
	/* U+21D2+0338 -> U+21CF */ 1840,
	/* U+21D4+0338 -> U+21CE */ 1839,
	/* U+2203+0338 -> U+2204 */ 1841,
	/* U+2208+0338 -> U+2209 */ 1842,
	/* U+220B+0338 -> U+220C */ 1843,
	/* U+2223+0338 -> U+2224 */ 1844,
	/* U+2225+0338 -> U+2226 */ 1845,
	/* U+223C+0338 -> U+2241 */ 1850,
	/* U+2243+0338 -> U+2244 */ 1851,
	/* U+2245+0338 -> U+2247 */ 1852,
	/* U+2248+0338 -> U+2249 */ 1853,
	/* U+224D+0338 -> U+226D */ 1856,
	/* U+2261+0338 -> U+2262 */ 1855,
	/* U+2264+0338 -> U+2270 */ 1859,
	/* U+2265+0338 -> U+2271 */ 1860,
	/* U+2272+0338 -> U+2274 */ 1861,
	/* U+2273+0338 -> U+2275 */ 1862,
	/* U+2276+0338 -> U+2278 */ 1863,
	/* U+2277+0338 -> U+2279 */ 1864,
	/* U+227A+0338 -> U+2280 */ 1865,
	/* U+227B+0338 -> U+2281 */ 1866,
	/* U+227C+0338 -> U+22E0 */ 1875,
	/* U+227D+0338 -> U+22E1 */ 1876,
	/* U+2282+0338 -> U+2284 */ 1867,
	/* U+2283+0338 -> U+2285 */ 1868,
	/* U+2286+0338 -> U+2288 */ 1869,
	/* U+2287+0338 -> U+2289 */ 1870,
	/* U+2291+0338 -> U+22E2 */ 1877,
	/* U+2292+0338 -> U+22E3 */ 1878,
	/* U+22A2+0338 -> U+22AC */ 1871,
	/* U+22A8+0338 -> U+22AD */ 1872,
	/* U+22A9+0338 -> U+22AE */ 1873,
	/* U+22AB+0338 -> U+22AF */ 1874,
	/* U+22B2+0338 -> U+22EA */ 1879,
	/* U+22B3+0338 -> U+22EB */ 1880,
	/* U+22B4+0338 -> U+22EC */ 1881,
	/* U+22B5+0338 -> U+22ED */ 1882,
	/* U+3046+3099 -> U+3094 */ 2320,
	/* U+304B+3099 -> U+304C */ 2295,
	/* U+304D+3099 -> U+304E */ 2296,
	/* U+304F+3099 -> U+3050 */ 2297,
	/* U+3051+3099 -> U+3052 */ 2298,
	/* U+3053+3099 -> U+3054 */ 2299,
	/* U+3055+3099 -> U+3056 */ 2300,
	/* U+3057+3099 -> U+3058 */ 2301,
	/* U+3059+3099 -> U+305A */ 2302,
	/* U+305B+3099 -> U+305C */ 2303,
	/* U+305D+3099 -> U+305E */ 2304,
	/* U+305F+3099 -> U+3060 */ 2305,
	/* U+3061+3099 -> U+3062 */ 2306,
	/* U+3064+3099 -> U+3065 */ 2307,
	/* U+3066+3099 -> U+3067 */ 2308,
	/* U+3068+3099 -> U+3069 */ 2309,
	/* U+306F+3099 -> U+3070 */ 2310,
	/* U+306F+309A -> U+3071 */ 2311,
	/* U+3072+3099 -> U+3073 */ 2312,
	/* U+3072+309A -> U+3074 */ 2313,
	/* U+3075+3099 -> U+3076 */ 2314,
	/* U+3075+309A -> U+3077 */ 2315,
	/* U+3078+3099 -> U+3079 */ 2316,
	/* U+3078+309A -> U+307A */ 2317,
	/* U+307B+3099 -> U+307C */ 2318,
	/* U+307B+309A -> U+307D */ 2319,
	/* U+309D+3099 -> U+309E */ 2325,
	/* U+30A6+3099 -> U+30F4 */ 2352,
	/* U+30AB+3099 -> U+30AC */ 2327,
	/* U+30AD+3099 -> U+30AE */ 2328,
	/* U+30AF+3099 -> U+30B0 */ 2329,
	/* U+30B1+3099 -> U+30B2 */ 2330,
	/* U+30B3+3099 -> U+30B4 */ 2331,
	/* U+30B5+3099 -> U+30B6 */ 2332,
	/* U+30B7+3099 -> U+30B8 */ 2333,
	/* U+30B9+3099 -> U+30BA */ 2334,
	/* U+30BB+3099 -> U+30BC */ 2335,
	/* U+30BD+3099 -> U+30BE */ 2336,
	/* U+30BF+3099 -> U+30C0 */ 2337,
	/* U+30C1+3099 -> U+30C2 */ 2338,
	/* U+30C4+3099 -> U+30C5 */ 2339,
	/* U+30C6+3099 -> U+30C7 */ 2340,
	/* U+30C8+3099 -> U+30C9 */ 2341,
	/* U+30CF+3099 -> U+30D0 */ 2342,
	/* U+30CF+309A -> U+30D1 */ 2343,
	/* U+30D2+3099 -> U+30D3 */ 2344,
	/* U+30D2+309A -> U+30D4 */ 2345,
	/* U+30D5+3099 -> U+30D6 */ 2346,
	/* U+30D5+309A -> U+30D7 */ 2347,
	/* U+30D8+3099 -> U+30D9 */ 2348,
	/* U+30D8+309A -> U+30DA */ 2349,
	/* U+30DB+3099 -> U+30DC */ 2350,
	/* U+30DB+309A -> U+30DD */ 2351,
	/* U+30EF+3099 -> U+30F7 */ 2353,
	/* U+30F0+3099 -> U+30F8 */ 2354,
	/* U+30F1+3099 -> U+30F9 */ 2355,
	/* U+30F2+3099 -> U+30FA */ 2356,
	/* U+30FD+3099 -> U+30FE */ 2357,
	/* U+11099+110BA -> U+1109A */ 4689,
	/* U+1109B+110BA -> U+1109C */ 4690,
	/* U+110A5+110BA -> U+110AB */ 4691,
	/* U+11131+11127 -> U+1112E */ 4697,
	/* U+11132+11127 -> U+1112F */ 4698,
	/* U+11347+1133E -> U+1134B */ 4710,
	/* U+11347+11357 -> U+1134C */ 4711,
	/* U+114B9+114B0 -> U+114BC */ 4729,
	/* U+114B9+114BA -> U+114BB */ 4728,
	/* U+114B9+114BD -> U+114BE */ 4730,
	/* U+115B8+115AF -> U+115BA */ 4733,
	/* U+115B9+115AF -> U+115BB */ 4734,
	/* U+11935+11930 -> U+11938 */ 4743
};

/* Perfect hash function for recomposition */
static int
Recomp_hash_func(const void *key)
{
	static const int16 h[1883] = {
		772,   773,   621,   32767, 32767, 387,   653,   196,
		32767, 32767, 855,   463,   -19,   651,   32767, 32767,
		32767, 364,   32767, 32767, -108,  32767, 32767, 32767,
		32767, 0,     -568,  32767, 32767, 32767, 0,     0,
		0,     -103,  364,   0,     210,   732,   0,     0,
		-506,  0,     0,     0,     32767, 32767, 0,     32767,
		407,   -140,  32767, 409,   32767, 772,   0,     86,
		842,   934,   32767, 32767, -499,  -355,  32767, 32767,
		532,   138,   174,   -243,  860,   1870,  742,   32767,
		32767, 339,   32767, 1290,  0,     32767, 32767, 0,
		-449,  -1386, 1633,  560,   561,   32767, 1219,  1004,
		139,   -804,  32767, -179,  141,   579,   1586,  32767,
		32767, 32767, 142,   199,   32767, 32767, 143,   0,
		32767, 32767, 314,   896,   32767, 32767, 428,   129,
		286,   -58,   0,     68,    32767, 0,     244,   -566,
		32767, 32767, 32767, 246,   32767, 32767, 0,     32767,
		32767, 271,   -108,  928,   32767, 715,   32767, 32767,
		-211,  -497,  32767, 0,     1055,  1339,  32767, 0,
		32767, 32767, -968,  -144,  32767, 32767, 248,   32767,
		-161,  32767, 32767, 282,   32767, -372,  0,     2,
		-137,  1116,  32767, 687,   32767, 459,   913,   0,
		461,   879,   -816,  443,   32767, 32767, 462,   1089,
		32767, 1054,  0,     314,   447,   -26,   480,   32767,
		64,    0,     0,     112,   32767, 66,    0,     646,
		603,   22,    -292,  0,     710,   475,   32767, 24,
		-781,  32767, 32767, 32767, 281,   307,   32767, 1289,
		32767, 0,     1064,  -149,  454,   118,   32767, 32767,
		0,     32767, -126,  0,     32767, 32767, 858,   32767,
		32767, 32767, 1029,  886,   665,   209,   0,     26,
		359,   0,     0,     -108,  -508,  -603,  894,   906,
		32767, 32767, 14,    0,     0,     534,   984,   876,
		32767, -93,   110,   -367,  167,   843,   32767, 32767,
		-947,  -290,  169,   0,     0,     32767, -42,   564,
		0,     -927,  32767, 817,   32767, 32767, 32767, 110,
		0,     32767, 32767, -38,   32767, 32767, -101,  694,
		-142,  190,   191,   1288,  32767, -687,  194,   -579,
		534,   -452,  0,     -72,   536,   765,   823,   266,
		-259,  684,   767,   32767, 654,   32767, 32767, 64,
		920,   32767, 32767, 32767, 0,     1653,  0,     0,
		32767, 32767, -452,  -222,  855,   0,     32767, -1153,
		127,   490,   449,   863,   32767, -144,  32767, -379,
		545,   32767, 32767, 32767, 530,   32767, 32767, 1331,
		611,   -612,  332,   545,   -73,   0,     604,   201,
		32767, -279,  338,   836,   340,   408,   32767, -60,
		-358,  32767, 343,   69,    707,   0,     -129,  582,
		32767, 0,     32767, 96,    392,   490,   639,   157,
		-4,    406,   32767, 32767, -571,  1077,  546,   32767,
		551,   0,     0,     0,     32767, 32767, 348,   32767,
		498,   -181,  0,     -433,  1057,  260,   0,     32767,
		32767, 397,   32767, 816,   -130,  32767, 624,   0,
		0,     32767, 32767, 32767, 485,   0,     32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 1222,
		-230,  32767, 797,   -538,  32767, 974,   32767, 32767,
		831,   70,    -658,  145,   0,     147,   0,     32767,
		1295,  32767, 0,     0,     895,   0,     0,     -385,
		491,   -287,  32767, -587,  32767, 32767, 32767, 813,
		-471,  -13,   32767, 32767, 32767, 0,     203,   411,
		470,   0,     -546,  -179,  146,   0,     0,     32767,
		-468,  32767, 0,     0,     32767, 32767, 32767, 211,
		32767, 32767, 0,     32767, 0,     52,    32767, 0,
		32767, 0,     692,   990,   32767, 32767, 32767, 56,
		-507,  784,   951,   0,     32767, 0,     697,   32767,
		187,   0,     32767, 32767, 430,   1209,  682,   32767,
		130,   0,     -25,   0,     -1006, 0,     32767, 214,
		433,   22,    0,     -1119, 32767, 285,   32767, 32767,
		32767, 216,   32767, 32767, 32767, 217,   527,   32767,
		32767, 32767, 829,   485,   419,   717,   620,   731,
		32767, 470,   0,     -145,  -620,  1162,  -644,  848,
		287,   -632,  32767, 32767, 32767, 32767, 381,   32767,
		510,   511,   -554,  -2,    32767, 0,     0,     698,
		32767, 32767, 436,   1154,  32767, 463,   32767, 32767,
		627,   517,   32767, 32767, 854,   579,   723,   396,
		110,   -42,   354,   32767, 664,   32767, 32767, 0,
		0,     32767, 65,    -163,  67,    140,   69,    341,
		70,    71,    402,   73,    623,   544,   624,   417,
		-1375, 648,   32767, -26,   904,   0,     548,   0,
		0,     32767, 32767, 855,   32767, 488,   -524,  599,
		130,   131,   32767, 32767, 542,   -1110, -324,  -462,
		32767, -405,  -440,  0,     0,     629,   850,   0,
		741,   257,   258,   32767, 32767, 0,     32767, 923,
		0,     32767, 0,     32767, 1559,  32767, 32767, 32767,
		671,   32767, 134,   32767, 32767, -336,  -104,  576,
		577,   829,   32767, 32767, 762,   902,   32767, 0,
		32767, 0,     1506,  887,   32767, 636,   601,   2465,
		426,   0,     236,   317,   427,   968,   32767, -975,
		-559,  -343,  341,   32767, 937,   241,   0,     32767,
		32767, 547,   32767, 32767, 32767, 32767, 32767, 789,
		0,     32767, 32767, 32767, 0,     0,     0,     32767,
		-192,  859,   1185,  1153,  69,    32767, 32767, 32767,
		-539,  32767, 32767, 0,     32767, 32767, 32767, 32767,
		640,   578,   32767, 32767, -766,  32767, 32767, 32767,
		32767, 1050,  -572,  32767, 32767, 32767, 32767, 1268,
		32767, 32767, 32767, 754,   32767, 32767, 1640,  179,
		804,   32767, 32767, 32767, 32767, 0,     684,   943,
		1006,  32767, 32767, 652,   0,     32767, 1041,  32767,
		718,   791,   32767, 274,   697,   32767, 32767, 0,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 735,
		0,     32767, 32767, 32767, 275,   358,   688,   32767,
		32767, 32767, 548,   -87,   770,   32767, -42,   0,
		551,   32767, 691,   222,   32767, 32767, 32767, 32767,
		0,     1273,  403,   -121,  806,   553,   554,   163,
		32767, 32767, 892,   825,   32767, 32767, -490,  32767,
		32767, 32767, 32767, 32767, -109,  744,   910,   32767,
		91,    32767, 32767, 0,     0,     32767, 32767, 32767,
		1521,  50,    701,   32767, 32767, 32767, 32767, 164,
		658,   32767, 288,   0,     32767, 0,     51,    0,
		32767, 32767, 32767, 32767, 555,   1547,  32767, 32767,
		595,   585,   429,   32767, -80,   32767, 1258,  0,
		540,   486,   -434,  865,   0,     192,   0,     884,
		0,     0,     0,     175,   555,   0,     32767, 32767,
		0,     32767, -566,  866,   591,   32767, 32767, 32767,
		32767, 32767, 496,   495,   -215,  32767, 849,   -772,
		32767, 32767, 502,   178,   483,   32767, 912,   793,
		794,   0,     32767, 32767, 32767, -556,  499,   838,
		32767, 32767, -506,  331,   0,     0,     -1096, 512,
		880,   0,     774,   -338,  649,   32767, 270,   32767,
		32767, -624,  328,   459,   32767, 32767, 32767, 32767,
		329,   -201,  -835,  813,   -879,  560,   0,     -212,
		-114,  35,    -494,  37,    523,   653,   751,   -653,
		-743,  32767, 1356,  818,   32767, 32767, 856,   0,
		44,    902,   0,     0,     0,     0,     32767, -26,
		526,   795,   456,   32767, 104,   -209,  -341,  133,
		-372,  0,     45,    110,   111,   0,     511,   47,
		114,   32767, 32767, 93,    48,    116,   -1031, -279,
		32767, 192,   0,     32767, 453,   415,   0,     -190,
		32767, 471,   240,   175,   29,    665,   684,   0,
		-11,   -95,   -344,  32767, 245,   148,   0,     530,
		0,     1185,  -615,  -712,  693,   784,   32767, 0,
		-776,  32767, 32767, -813,  0,     0,     0,     207,
		208,   32767, 674,   32767, 742,   -289,  249,   32767,
		520,   929,   -50,   781,   0,     -778,  32767, 0,
		302,   32767, 720,   -465,  0,     32767, 32767, 32767,
		0,     0,     32767, 833,   328,   806,   32767, -403,
		0,     32767, -77,   32767, 0,     441,   930,   32767,
		643,   0,     32767, 1938,  0,     1334,  381,   32767,
		216,   32767, 32767, 0,     32767, 484,   383,   0,
		242,   395,   0,     32767, 32767, 32767, -781,  355,
		356,   32767, 292,   706,   32767, 32767, 32767, 32767,
		32767, -410,  32767, 32767, 782,   32767, 189,   32767,
		32767, 943,   0,     -212,  407,   335,   0,     135,
		32767, 616,   0,     -497,  0,     -67,   853,   32767,
		700,   32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     459,   -48,   32767, 58,    0,
		-856,  1017,  32767, 59,    916,   -731,  32767, 940,
		-855,  347,   650,   0,     678,   32767, 0,     32767,
		32767, 530,   32767, 0,     -80,   32767, -730,  32767,
		1214,  799,   58,    651,   841,   0,     0,     -589,
		-1530, -478,  651,   652,   93,    576,   -1215, 32767,
		125,   32767, 1279,  32767, 32767, 0,     32767, 0,
		-367,  416,   -1236, 32767, 418,   32767, 815,   558,
		559,   781,   419,   32767, 739,   32767, 0,     32767,
		128,   570,   1349,  -298,  -66,   0,     147,   -488,
		32767, 590,   189,   274,   524,   32767, 1082,  -209,
		32767, 423,   32767, 32767, 975,   573,   32767, 424,
		32767, 32767, 1241,  32767, 32767, 32767, 32767, 32767,
		612,   391,   32767, 0,     -803,  1004,  -561,  32767,
		32767, 735,   870,   32767, 0,     32767, 32767, -123,
		99,    210,   600,   1294,  109,   1053,  32767, 307,
		834,   32767, 0,     1651,  32767, 644,   32767, 32767,
		0,     32767, -801,  385,   379,   32767, -368,  32767,
		32767, 830,   0,     32767, 32767, 739,   371,   372,
		-275,  32767, 32767, 331,   -780,  32767, 0,     1229,
		-1462, 913,   266,   827,   125,   32767, 32767, 32767,
		393,   32767, 631,   -33,   -883,  -661,  -204,  6,
		-19,   257,   8,     9,     118,   519,   615,   -541,
		-893,  0,     32767, 0,     1156,  15,    900,   32767,
		32767, 32767, 32767, 32767, 32767, 1022,  376,   0,
		32767, 32767, -972,  676,   840,   -661,  631,   58,
		0,     17,    32767, 0,     -799,  82,    0,     32767,
		32767, 680,   32767, 905,   0,     0,     32767, 32767,
		0,     0,     32767, 0,     828,   386,   802,   0,
		146,   0,     148,   32767, -1146, 0,     150,   151,
		-743,  153,   154,   32767, 32767, 442,   32767, 743,
		0,     0,     746,   0,     32767, 32767, 32767, 98,
		32767, 157,   0,     696,   0,     32767, 32767, -294,
		32767, 158,   159,   32767, 0,     32767, 160,   32767,
		933,   32767, 32767, -50,   759,   824,   162,   672,
		32767, 356,   0,     356,   32767, 32767, 0,     0,
		656,   692,   253,   254,   -374,  102,   256,   32767,
		0,     0,     32767, 32767, 259,   32767, 63,    260,
		510,   261,   32767, 0,     32767, 1061,  32767, 521,
		32767, 32767, 32767, 32767, 32767, 32767, 316,   317,
		846,   0,     32767, -500,  318,   0,     32767, 32767,
		263,   0,     790,   872,   32767, 32767, 32767, 2171,
		264,   32767, 32767, 32767, 32767, 486,   334,   465,
		32767, 466,   32767, 444,   606,   32767, 0,     445,
		320,   -317,  0,     520,   322,   718,   32767, 32767,
		32767, 0,     1013,  32767, 32767, 32767, 32767, 32767,
		32767, 611,   32767, 0,     0,     32767, 32767, -120,
		156,   613,   0,     0,     32767, -68,   32767, 622,
		32767, 32767, 32767, 32767, 32767, 455,   32767, 32767,
		32767, 403,   533,   0,     -161,  405,   95,    96,
		32767, 97,    32767, 0,     29,    0,     32767, 32767,
		30,    32767, 99,    32767, 32767, 0,     161,   32767,
		97,    0,     32,    32767, 32767, 0,     0,     315,
		32767, 32767, 414,   966,   0,     585,   32767, 32767,
		-616,  -256,  171,   172,   666,   101,   562,   563,
		32767, 95,    0,     0,     1492,  390,   -251,  103,
		32767, 0,     32767, 188,   1487,  32767, 0,     0,
		586,   668,   -126,  0,     0,     32767, 32767, 204,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 656,   32767, 32767,
		599,   0,     222,   32767, 0,     1368,  -412,  435,
		32767, 936,   32767, -17,   32767, 832,   32767, 437,
		0,     -518,  787,   32767, 864,   -449,  0,     636,
		713,   206,   592,   572,   0,     483,   -139,  32767,
		32767, 180,   818,   32767, 32767, 1304,  0,     32767,
		274,   0,     0,     0,     0,     705,   32767, 32767,
		32767, 0,     -272,  0,     502,   503,   319,   0,
		32767, 0,     13,    32767, 32767, 0,     32767, 270,
		737,   0,     32767, 32767, 32767, 901,   32767, 616,
		180,   32767, 721,   353,   32767, 0,     32767, 32767,
		-199,  0,     280,   788,   32767, 940,   32767, 51,
		0,     400,   53,    0,     54,    -637,  0,     -453,
		0,     0,     0,     380,   0,     32767, 504,   0,
		2049,  0,     -964,  32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 798,   32767, 32767, 32767, 0,
		538,   488,   0,     32767, -528,  57,    819,   32767,
		32767, 1244,  0,     488,   739,   908,   32767, 32767,
		0,     32767, 32767, 0,     55,    533,   0,     32767,
		814,   0,     32767, 458,   0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 776,   777,   920,   0,
		0,     755,   32767, 0,     32767, 32767, 0,     32767,
		55,    -954,  0,     372,   166,   218,   165,   857,
		221,   675,   0,     223,   224,   -155,  226,   32767,
		1851,  227,   32767, 32767, 1192,  0,     229,   0,
		-72,   0,     865,   0,     0,     -330,  0,     683,
		32767, -550,  -196,  725,   -573,  293,   102,   32767,
		-589,  296,   297,   298,   231,   -256,  300,   32767,
		32767, 301,   233,   868,   32767, 234,   0,     811,
		1187,  32767, 32767, 0,     32767, 518,   0,     361,
		362,   466,   0,     365,   32767, -179,  366,   367,
		874,   369,   305,   0,     32767, 0,     32767, 0,
		32767, 2000,  1215,  451,   652,   0,     0,     799,
		32767, 32767, 32767
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 8;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 17 + c;
	}
	return h[a % 1883] + h[b % 1883];
}

/* Hash lookup information for recomposition */
static const pg_unicode_recompinfo UnicodeRecompInfo =
{
	RecompInverseLookup,
	Recomp_hash_func,
	941
};
