#
# This is the insanely huge list of completions for gcc. Most of it is autogenerated, but it needs some hand editing...
#

#
# These are 'special' completions, ones that take some kind of parameter.
#

complete -c gcc -o std -d "Standard mode" -x -a '
	c89\t"ISO C90"
	iso9899:1990\t"ISO C90"
	iso9899:199409\t"ISO C90 as modified in amendment 1"
	c99\t"ISO C99"
	c9x \t"ISO C99"
	iso9899:1999\t"ISO C99"
	iso9899:199x\t"ISO C99"
	gnu89\t"ISO C90 plus GNU extentions"
	gnu99\t"ISO C99 plus GNU extentions"
	gnu9x\t"ISO C99 plus GNU extentions"
	c++98\t"ISO C++98"
	gnu++98\t"ISO C++98 plus GNU extentions"
'

for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17
    complete -c gcc -o ftemplate-depth-$i -d "Set maximum template depth"
end

complete -c gcc -s o -d 'Place output in file' -r
complete -c gcc -o aux-info -d 'Output to given file prototyped declarations for all functions from a translation unit' -r
complete -c gcc -o fabi-version -d 'Use specified version of the C++ ABI' -xa "0 1"
complete -c gcc -l sysroot -x -a '(__fish_complete_directories)' -d 'Use dir as the logical root directory for headers and libraries'


#
# These completions are autogenerated form the manual page using make_completions.py
#

complete -c gcc -o pass-exit-codes -d 'Return the highest error returned by any phase'
complete -c gcc -s c -d 'Compile or assemble the source files, but do not link'
complete -c gcc -s S -d 'Do not assemble'
complete -c gcc -s E -d 'Stop after preprocessing'
complete -c gcc -s v -d 'Print to stderr the commands executed to run compilation'
complete -c gcc -o \#\#\# -d 'Like -v except commands are not executed and all command arguments are quoted'
complete -c gcc -o pipe -d 'Use pipes not temp files for communication'
complete -c gcc -o combine -d 'Pass all the source files to the compiler at once'
complete -c gcc -l help -d 'Print help'
complete -c gcc -l target-help -d 'Print a description of target specific options for each tool'
complete -c gcc -l version -d 'Display the version number and copyrights'
complete -c gcc -o ansi -d 'Support all ISO C90 programs'
complete -c gcc -o fno-asm -d 'No "asm", "inline" or "typeof" as keyword, so code can use these as identifiers'
complete -c gcc -o fno-builtin -d 'Don’t recognize built-in functions without __builtin_ prefix'
complete -c gcc -o fno-builtin-function -d 'Don’t recognize built-in functions that do not begin with __builtin_ as prefix'
complete -c gcc -o fhosted -d 'Assert that compilation takes place in a hosted environment'
complete -c gcc -o ffreestanding -d 'Assert that compilation takes place in a freestanding environment'
complete -c gcc -o fms-extensions -d 'Accept some non-standard constructs used in Microsoft header files'
complete -c gcc -o trigraphs -d 'Support ISO C trigraphs'
complete -c gcc -o no-integrated-cpp -d 'Performs a compilation in two passes: preprocessing and compiling'
complete -c gcc -o traditional -o traditional-cpp -d 'Try to imitate pre-standard C preprocessors'
complete -c gcc -o fcond-mismatch -d 'Allow conditional expressions with mismatched types'
complete -c gcc -o funsigned-char -d 'Let "char" be unsigned, like "unsigned char"'
complete -c gcc -o fsigned-char -d 'Let "char" be signed, like "signed char"'
complete -c gcc -o fsigned-bitfields -d 'Treat bitfields as signed by default'
complete -c gcc -o funsigned-bitfields -d 'Treat bitfields as unsigned by default'
complete -c gcc -o fno-signed-bitfields -d 'Remove fsigned-bitfields'
complete -c gcc -o fno-unsigned-bitfields -d 'Remove funsinged-bitfields'
complete -c gcc -o fno-access-control -d 'Turn off all access checking'
complete -c gcc -o fcheck-new -d 'Check pointer returned by "operator new" is non-null before attempting to modify allocated storage'
complete -c gcc -o fconserve-space -d 'Put uninitialized or runtime-initialized global variables into the common segment, as C does'
complete -c gcc -o ffriend-injection -d 'Inject friend functions into enclosing namespace'
complete -c gcc -o fno-const-strings -d 'Give string constants type "char *" without const'
complete -c gcc -o fno-elide-constructors -d "Don't elide temporaries used to construct objects"
complete -c gcc -o fno-enforce-eh-specs -d 'Don’t generate code to check for violation of exception specifications at runtime'
complete -c gcc -o ffor-scope -d 'Limit scope of variables declared in a for-init-statement to the for loop itself, as specified by the C++ standard'
complete -c gcc -o fno-for-scope -d "Don't limit scope of vars declared in for loop to the for loop"
complete -c gcc -o fno-gnu-keywords -d 'Do not recognize "typeof" as a keyword, so code can use it as an identifier'
complete -c gcc -o fno-implicit-templates -d 'Never emit code for non-inline templates which are instantiated implicitly'
complete -c gcc -o fno-implicit-inline-templates -d 'Don’t emit code for implicit instantiations of inline templates, either'
complete -c gcc -o fno-implement-inlines -d 'Do not emit out-of-line copies of inline functions controlled by #pragma implementation'
complete -c gcc -o fms-extensions -d 'Disable pedantic warnings about constructs used in MFC'
complete -c gcc -o fno-nonansi-builtins -d 'Disable built-in declarations of functions that are not mandated by ANSI/ISO C'
complete -c gcc -o fno-operator-names -d 'Do not treat the operator name keywords "and", "bitand", "bitor", "compl", "not", "or" and "xor" as synonyms as keywords'
complete -c gcc -o fno-optional-diags -d 'Disable diagnostics that the standard says a compiler does not need to issue'
complete -c gcc -o fpermissive -d 'Downgrade some diagnostics about nonconformant code from errors to warnings'
complete -c gcc -o frepo -d 'Enable automatic template instantiation at link time'
complete -c gcc -o fno-rtti -d 'Disable generation of information about classes with virtual functions for use by dynamic_cast and typeid'
complete -c gcc -o fstats -d 'Emit statistics about front-end processing at the end of the compilation'
complete -c gcc -o fno-threadsafe-statics -d 'Do not emit the extra code to use the routines specified in the C++ ABI for thread-safe initialization of local statics'
complete -c gcc -o fuse-cxa-atexit -d 'Register destructors for objects with static storage duration with the "__cxa_atexit" function rather than the "atexit" function'
complete -c gcc -o fvisibility-inlines-hidden -d 'Mark inlined methods with "__attribute__ ((visibility ("hidden")))"'
complete -c gcc -o fno-weak -d 'Do not use weak symbol support'
complete -c gcc -o nostdinc++ -d 'Do not search for header files in the standard directories specific to C++'
complete -c gcc -o fno-default-inline -d 'Do not assume inline for functions defined inside a class scope'
complete -c gcc -o Wabi -d 'Warn when code is probably incompatible with the vendor-neutral C++ ABI'
complete -c gcc -o Wctor-dtor-privacy -d 'Warn when a class has no usable con/destructors'
complete -c gcc -o Wnon-virtual-dtor -d 'Warn when a class requires a virtual destructor but declares a non-virtual one'
complete -c gcc -o Wreorder -d 'Warn when the order of member initializers does not match the order in which they must be executed'
complete -c gcc -o Weffc++ -d 'Warn about violations of style guidelines from Scott Meyers’ Effective C++ book'
complete -c gcc -o Wno-deprecated -d '(C++ only) Do not warn about usage of deprecated features'
complete -c gcc -o Wstrict-null-sentinel -d '(C++ only) Warn also about the use of an uncasted "NULL" as sentinel'
complete -c gcc -o Wno-non-template-friend -d '(C++ only) Disable warnings when non-templatized friend functions are declared within a template'
complete -c gcc -o Wold-style-cast -d 'Warn if an C-style cast to a non-void type is used in a C++ program'
complete -c gcc -o Woverloaded-virtual -d '(C++ only) Warn when a function hides virtual functions from a base class'
complete -c gcc -o Wno-pmf-conversions -d '(C++ only) Disable the diagnostic for converting a bound pointer to member function to a plain pointer'
complete -c gcc -o Wsign-promo -d '(C++ only) Warn when overload resolution promotes from unsigned or enumerated type to a signed type'
complete -c gcc -o fconstant-string-class -d 'Use class-name as the name of the class to instantiate for each literal string specified with the syntax "@"'
complete -c gcc -o name -d 'Use class-name as the name of the class to instantiate for each literal string specified with the syntax "@"'
complete -c gcc -o fgnu-runtime -d 'Generate object code compatible with the standard GNU Objective-C runtime'
complete -c gcc -o fnext-runtime -d 'Generate output compatible with the NeXT runtime'
complete -c gcc -o fno-nil-receivers -d 'Assume that all Objective-C message dispatches (e'
complete -c gcc -o fobjc-call-cxx-cdtors -d 'For each Objective-C class, check if any of its instance variables is a C++ object with a non-trivial default constructor'
complete -c gcc -o fobjc-direct-dispatch -d 'Allow fast jumps to the message dispatcher'
complete -c gcc -o fobjc-exceptions -d 'Enable syntactic support for structured exception handling in Objective-C, similar to what is offered by C++ and Java'
complete -c gcc -o fobjc-gc -d 'Enable garbage collection (GC) in Objective-C and Objective-C++ programs'
complete -c gcc -o freplace-objc-classes -d 'Emit a special marker instructing ld(1) not to statically link in the resulting object file, and allow dyld(1) to load it in at run time instead'
complete -c gcc -o fzero-link -d 'When compiling for the NeXT runtime, the compiler ordinarily replaces calls to "objc_getClass("'
complete -c gcc -o gen-decls -d 'Dump interface declarations for all classes seen in the source file to a file named sourcename'
complete -c gcc -o Wassign-intercept -d 'Warn whenever an Objective-C assignment is being intercepted by the garbage collector'
complete -c gcc -o Wno-protocol -d 'If a class is declared to implement a protocol, a warning is issued for every method in the protocol that is not implemented by the class'
complete -c gcc -o Wselector -d 'Warn if multiple methods of different types for the same selector are found during compilation'
complete -c gcc -o Wstrict-selector-match -d 'Warn if multiple methods with differing argument and/or return types are found for a given selector when attempting to send a message using this selector to a receiver of type "id" or "Class"'
complete -c gcc -o Wundeclared-selector -d 'Warn if a "@selector('
complete -c gcc -o print-objc-runtime-info -d 'Generate C header describing the largest structure that is passed by value, if any'
complete -c gcc -o fmessage-length -d 'Try to format error messages so that they fit on lines of the specified number of characters' -x -a 80
complete -c gcc -o fdiagnostics-show-location -d 'Only meaningful in line-wrapping mode' -a once
complete -c gcc -o line -d 'Only meaningful in line-wrapping mode'
complete -c gcc -o fdiagnostics-show-options -d 'This option instructs the diagnostic machinery to add text to each diagnostic emitted, which indicates which command line option directly controls that diagnostic, when such an option is known to the diagnostic machinery'
complete -c gcc -o Wno- -d 'to turn off warnings; for example, -Wno-implicit'
complete -c gcc -o fsyntax-only -d 'Check the code for syntax errors, but don’t do anything beyond that'
complete -c gcc -o pedantic -d 'Issue all the warnings demanded by strict ISO C and ISO C++; reject all programs that use forbidden extensions'
complete -c gcc -o pedantic-errors -d 'Like -pedantic, except that errors are produced rather than warnings'
complete -c gcc -s w -d 'Inhibit all warning messages'
complete -c gcc -o Wno-import -d 'Inhibit warning messages about the use of #import'
complete -c gcc -o Wchar-subscripts -d 'Warn if an array subscript has type "char"'
complete -c gcc -o Wcomment -d 'Warn whenever a comment-start sequence appears in a comment'
complete -c gcc -o Wfatal-errors -d 'Abort compilation on the first error'
complete -c gcc -o Wformat -d 'Check calls to "printf" and "scanf", etc'
complete -c gcc -o Wformat-y2k -d 'With -Wformat, also warn about "strftime" formats which may yield only a two-digit year'
complete -c gcc -o Wno-format-extra-args -d 'With -Wformat, do not warn about excess arguments to "printf" or "scanf"'
complete -c gcc -o Wno-format-zero-length -d 'With -Wformat, do not warn about zero-length formats'
complete -c gcc -o Wformat-nonliteral -d 'With -Wformat, also warn if the format string is not a string literal'
complete -c gcc -o Wformat-security -d 'With -Wformat, also warn about uses of potentially insecure format functions'
complete -c gcc -o Wnonnull -d 'Warn about passing a null pointer for arguments marked as requiring non-null'
complete -c gcc -o Winit-self -d 'Warn about uninitialized variables which are initialized with themselves'
complete -c gcc -o Wimplicit-int -d 'Warn when a declaration does not specify a type'
complete -c gcc -o Wimplicit-function-declaration -d 'Give a warning (or error) whenever a function is used before being declared'
complete -c gcc -o Werror-implicit-function-declaration -d 'Give a warning (or error) whenever a function is used before being declared'
complete -c gcc -o Wimplicit -d 'Same as -Wimplicit-int and -Wimplicit-function-declaration'
complete -c gcc -o Wmain -d 'Warn if the type of main is suspicious'
complete -c gcc -o Wmissing-braces -d 'Warn if an aggregate or union initializer is not fully bracketed'
complete -c gcc -o Wmissing-include-dirs -d '(C, C++, Objective-C and Objective-C++ only) Warn if a user-supplied include directory does not exist'
complete -c gcc -o Wparentheses -d 'Warn if parentheses are omitted where confusing'
complete -c gcc -o Wsequence-point -d 'Warn about undefined semantics because of violations of sequence point rules in the C standard'
complete -c gcc -o Wreturn-type -d 'Warn whenever a function is defined with a return-type that defaults to "int"'
complete -c gcc -o Wswitch -o Wswitch-enum -d 'Warn whenever a "switch" statement lacks a "case" for a member of an enum'
complete -c gcc -o Wswitch-default -d 'Warn whenever a "switch" statement does not have a "default" case'
complete -c gcc -o Wtrigraphs -d 'Warn if any trigraphs are encountered that might change the meaning of the program (trigraphs within comments are not warned about)'
complete -c gcc -o Wunused-function -d 'Warn about unused functions'
complete -c gcc -o Wunused-label -d 'Warn about unused labels'
complete -c gcc -o Wunused-parameter -d 'Warn about unused function parameters'
complete -c gcc -o Wunused-variable -d 'Warn about unused variables'
complete -c gcc -o Wunused-value -d 'Warn whenever a statement computes a result that is explicitly not used'
complete -c gcc -o Wunused -d 'All the -Wunused options combined'
complete -c gcc -o Wuninitialized -d 'Warn if an automatic variable is used without being initialized'
complete -c gcc -o Wunknown-pragmas -d 'Warn when an unknown #pragma directive is encountered'
complete -c gcc -o Wno-pragmas -d 'Do not warn about misuses of pragmas'
complete -c gcc -o Wstrict-aliasing -d 'Warn about strict aliasing rules' -a 2
complete -c gcc -o Wall -d 'All of the above -W options combined'
complete -c gcc -o Wextra -d 'Enable warnings not enabled by -Wall'
complete -c gcc -o Wno-div-by-zero -d 'Do not warn about compile-time integer division by zero'
complete -c gcc -o Wsystem-headers -d 'Print warning messages for constructs found in system header files'
complete -c gcc -o Wfloat-equal -d 'Warn if floating point values are used in equality comparisons'
complete -c gcc -o Wtraditional -d '(C only) Warn about certain constructs that behave differently in traditional and ISO C'
complete -c gcc -o Wdeclaration-after-statement -d '(C only) Warn when a declaration is found after a statement in a block'
complete -c gcc -o Wundef -d 'Warn if an undefined identifier is evaluated in an #if directive'
complete -c gcc -o Wno-endif-labels -d 'Do not warn whenever an #else or an #endif are followed by text'
complete -c gcc -o Wshadow -d 'Warn if a local variable shadows another variable or if a built-in function is shadowed'
complete -c gcc -o Wlarger-than-len -d 'Warn whenever an object of larger than len bytes is defined'
complete -c gcc -o Wunsafe-loop-optimizations -d 'Warn if the loop cannot be optimized because the compiler could not assume anything on the bounds of the loop indices'
complete -c gcc -o Wpointer-arith -d 'Warn about anything that depends on the "size of" a function type or of "void"'
complete -c gcc -o Wbad-function-cast -d '(C only) Warn whenever a function call is cast to a non-matching type'
complete -c gcc -o Wc++-compat -d 'Warn about ISO C constructs that are outside of the common subset of ISO C and ISO C++, e'
complete -c gcc -o Wcast-qual -d 'Warn whenever a pointer is cast so as to remove a type qualifier from the target type'
complete -c gcc -o Wcast-align -d 'Warn whenever a pointer is cast such that the required alignment of the target is increased'
complete -c gcc -o Wwrite-strings -d 'When compiling C, give string constants the type "const char[length]" so that copying the address of one into a non-"const" "char *" pointer will get a warning; when compiling C++, warn about the deprecated conversion from string constants to "char *"'
complete -c gcc -o Wconversion -d 'Warn if a prototype causes a type conversion that is different from what would happen to the same argument in the absence of a prototype'
complete -c gcc -o Wsign-compare -d 'Warn when a comparison between signed and unsigned values could produce an incorrect result when the signed value is converted to unsigned'
complete -c gcc -o Waggregate-return -d 'Warn if any functions that return structures or unions are defined or called'
complete -c gcc -o Wno-attributes -d 'Do not warn if an unexpected "__attribute__" is used, such as unrecognized attributes, function attributes applied to variables, etc'
complete -c gcc -o Wstrict-prototypes -d '(C only) Warn if a function is declared or defined without specifying the argument types'
complete -c gcc -o Wold-style-definition -d '(C only) Warn if an old-style function definition is used'
complete -c gcc -o Wmissing-prototypes -d '(C only) Warn if a global function is defined without a previous prototype declaration'
complete -c gcc -o Wmissing-declarations -d '(C only) Warn if a global function is defined without a previous declaration'
complete -c gcc -o Wmissing-field-initializers -d 'Warn if a structure’s initializer has some fields missing'
complete -c gcc -o Wmissing-noreturn -d 'Warn about functions which might be candidates for attribute "noreturn"'
complete -c gcc -o Wmissing-format-attribute -d 'Warn about function pointers which might be candidates for "format" attributes'
complete -c gcc -o Wno-multichar -d 'Do not warn if a multicharacter constant (’FOOF’) is used'
complete -c gcc -o Wnormalized -d 'In ISO C and ISO C++, two identifiers are different if they are different sequences of characters' -x -a "none id nfc nfkc"
complete -c gcc -o Wno-deprecated-declarations -d 'Do not warn about uses of functions, variables, and types marked as deprecated by using the "deprecated" attribute'
complete -c gcc -o Wpacked -d 'Warn if a structure is given the packed attribute, but the packed attribute has no effect on the layout or size of the structure'
complete -c gcc -o Wpadded -d 'Warn if padding is included in a structure, either to align an element of the structure or to align the whole structure'
complete -c gcc -o Wredundant-decls -d 'Warn if anything is declared more than once in the same scope, even in cases where multiple declaration is valid and changes nothing'
complete -c gcc -o Wnested-externs -d '(C only) Warn if an "extern" declaration is encountered within a function'
complete -c gcc -o Wunreachable-code -d 'Warn if the compiler detects that code will never be executed'
complete -c gcc -o Winline -d 'Warn if a function can not be inlined and it was declared as inline'
complete -c gcc -o Wno-invalid-offsetof -d '(C++ only) Suppress warnings from applying the offsetof macro to a non-POD type'
complete -c gcc -o Wno-int-to-pointer-cast -d '(C only) Suppress warnings from casts to pointer type of an integer of a different size'
complete -c gcc -o Wno-pointer-to-int-cast -d '(C only) Suppress warnings from casts from a pointer to an integer type of a different size'
complete -c gcc -o Winvalid-pch -d 'Warn if a precompiled header is found in the search path but can’t be used'
complete -c gcc -o Wlong-long -d 'Warn if long long type is used'
complete -c gcc -o Wvariadic-macros -d 'Warn if variadic macros are used in pedantic ISO C90 mode, or the GNU alternate syntax when in pedantic ISO C99 mode'
complete -c gcc -o Wvolatile-register-var -d 'Warn if a register variable is declared volatile'
complete -c gcc -o Wdisabled-optimization -d 'Warn if a requested optimization pass is disabled'
complete -c gcc -o Wpointer-sign -d 'Warn for pointer argument passing or assignment with different signedness'
complete -c gcc -o Werror -d 'Make all warnings into errors'
complete -c gcc -o Wstack-protector -d 'Only active when -fstack-protector is active'
complete -c gcc -s g -d 'Produce debugging information in the operating system’s native format (stabs, COFF, XCOFF, or DWARF 2)'
complete -c gcc -o ggdb -d 'Produce debugging information for use by GDB'
complete -c gcc -o gstabs -d 'Produce debugging information in stabs format (if that is supported), without GDB extensions'
complete -c gcc -o feliminate-unused-debug-symbols -d 'Produce debugging information in stabs format (if that is supported), for only symbols that are actually used'
complete -c gcc -o gstabs+ -d 'Produce debugging information in stabs format (if that is supported), using GNU extensions understood only by the GNU debugger (GDB)'
complete -c gcc -o gcoff -d 'Produce debugging information in COFF format (if that is supported)'
complete -c gcc -o gxcoff -d 'Produce debugging information in XCOFF format (if that is supported)'
complete -c gcc -o gxcoff+ -d 'Produce debugging information in XCOFF format (if that is supported), using GNU extensions understood only by the GNU debugger (GDB)'
complete -c gcc -o gdwarf-2 -d 'Produce debugging information in DWARF version 2 format (if that is supported)'
complete -c gcc -o gvms -d 'Produce debugging information in VMS debug format (if that is supported)'
complete -c gcc -o glevel -d 'Request debugging information and also use level to specify how much information'
complete -c gcc -o ggdblevel -d 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gstabslevel -d 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gcofflevel -d 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gxcofflevel -d 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gvmslevel -d 'Request debugging information and also use level to specify how much information'
complete -c gcc -o feliminate-dwarf2-dups -d 'Compress DWARF2 debugging information by eliminating duplicated information about each symbol'
complete -c gcc -s p -d 'Generate extra code to write profile information suitable for the analysis program prof'
complete -c gcc -o pg -d 'Generate extra code to write profile information suitable for the analysis program gprof'
complete -c gcc -s Q -d 'Makes the compiler print out each function name as it is compiled, and print some statistics about each pass when it finishes'
complete -c gcc -o ftime-report -d 'Makes the compiler print some statistics about the time consumed by each pass when it finishes'
complete -c gcc -o fmem-report -d 'Makes the compiler print some statistics about permanent memory allocation when it finishes'
complete -c gcc -o fprofile-arcs -d 'Add code so that program flow arcs are instrumented'
complete -c gcc -l coverage -d 'Used to compile and link code instrumented for coverage analysis'
complete -c gcc -o ftest-coverage -d 'Produce a notes file that the gcov code-coverage utility can use to show program coverage'
complete -c gcc -o dletters -d 'Says to make debugging dumps during compilation at times specified by letters'
complete -c gcc -o fdump-rtl-pass -d 'Says to make debugging dumps during compilation at times specified by letters'
complete -c gcc -o fdump-unnumbered -d 'When doing debugging dumps (see -d option above), suppress instruction numbers and line number note output'
complete -c gcc -o fdump-translation-unit -d '(C++ only) Dump a representation of the tree structure for the entire translation unit to a file'
complete -c gcc -o fdump-translation-unit-options -d '(C++ only) Dump a representation of the tree structure for the entire translation unit to a file'
complete -c gcc -o fdump-class-hierarchy -d '(C++ only) Dump a representation of each class’s hierarchy and virtual function table layout to a file'
complete -c gcc -o fdump-class-hierarchy-options -d '(C++ only) Dump a representation of each class’s hierarchy and virtual function table layout to a file'
complete -c gcc -o fdump-ipa-switch -d 'Control the dumping at various stages of inter-procedural analysis language tree to a file'
complete -c gcc -o fdump-tree-switch -d 'Control the dumping at various stages of processing the intermediate language tree to a file'
complete -c gcc -o fdump-tree-switch-options -d 'Control the dumping at various stages of processing the intermediate language tree to a file'
complete -c gcc -o ftree-vectorizer-verbose -d 'Controls the amount of debugging output the vectorizer prints' -x -a "1 2 3 4 5"
complete -c gcc -o frandom-seed -d 'Provides a seed that GCC uses when it would otherwise use random numbers' -x
complete -c gcc -o fsched-verbose -d 'On targets that use instruction scheduling, this option controls the amount of debugging output the scheduler prints' -x -a "1 2 3 4 5"
complete -c gcc -o save-temps -d 'Store the usual "temporary" intermediate files permanently; place them in the current directory and name them based on the source file'
complete -c gcc -o time -d 'Report the CPU time taken by each subprocess in the compilation sequence'
complete -c gcc -o fvar-tracking -d 'Run variable tracking pass'
complete -c gcc -o print-file-name -r -d 'Print the full absolute name of the library file library that would be used when linking---and don\'t do anything else'
complete -c gcc -o print-multi-directory -d 'Print the directory name corresponding to the multilib selected by any other switches present in the command line'
complete -c gcc -o print-multi-lib -d 'Print the mapping from multilib directory names to compiler switches that enable them'
complete -c gcc -o print-prog-name -r -d 'Like -print-file-name, but searches for a program such as cpp'
complete -c gcc -o print-libgcc-file-name -d 'Same as -print-file-name=libgcc'
complete -c gcc -o print-search-dirs -d 'Print the name of the configured installation directory and a list of program and library directories gcc will search---and don’t do anything else'
complete -c gcc -o dumpmachine -d 'Print the compiler’s target machine (for example, i686-pc-linux-gnu)---and don’t do anything else'
complete -c gcc -o dumpversion -d 'Print the compiler version (for example, 3.0,6.3 or 7)---and don’t do anything else'
complete -c gcc -o dumpspecs -d 'Print the compiler’s built-in specs---and don’t do anything else'
complete -c gcc -o feliminate-unused-debug-types -d 'Normally, when producing DWARF2 output, GCC will emit debugging information for all types declared in a compilation unit, regardless of whether or not they are actually used in that compilation unit'
complete -c gcc -o O -d 'Optimize'
complete -c gcc -o O1 -d 'Optimize'
complete -c gcc -o O2 -d 'Optimize even more'
complete -c gcc -o O3 -d 'Optimize yet more'
complete -c gcc -o O0 -d 'Do not optimize'
complete -c gcc -o Os -d 'Optimize for size'
complete -c gcc -o Ofast -d 'Disregard strict standards compliance'
complete -c gcc -o Og -d 'Optimize debugging experience'
complete -c gcc -o Oz -d 'Optimize aggressively for size rather than speed'
complete -c gcc -o fno-default-inline -d 'Do not make member functions inline by default merely because they are defined inside the class scope (C++ only)'
complete -c gcc -o fno-defer-pop -d 'Always pop the arguments to each function call as soon as that function returns'
complete -c gcc -o fforce-mem -d 'Force memory operands to be copied into registers before doing arithmetic on them'
complete -c gcc -o fforce-addr -d 'Force memory address constants to be copied into registers before doing arithmetic on them'
complete -c gcc -o fomit-frame-pointer -d 'Don’t keep the frame pointer in a register for functions that don’t need one'
complete -c gcc -o foptimize-sibling-calls -d 'Optimize sibling and tail recursive calls'
complete -c gcc -o fno-inline -d 'Don’t pay attention to the "inline" keyword'
complete -c gcc -o finline-functions -d 'Integrate all simple functions into their callers'
complete -c gcc -o finline-functions-called-once -d 'Consider all "static" functions called once for inlining into their caller even if they are not marked "inline"'
complete -c gcc -o fearly-inlining -d 'Inline functions marked by "always_inline" and functions whose body seems smaller than the function call overhead early before doing -fprofile-generate instrumentation and real inlining pass'
complete -c gcc -o finline-limit -d 'By default, GCC limits the size of functions that can be inlined' -x -a "1 2 3 4 5"
complete -c gcc -o fkeep-inline-functions -d 'In C, emit "static" functions that are declared "inline" into the object file, even if the function has been inlined into all of its callers'
complete -c gcc -o fkeep-static-consts -d 'Emit variables declared "static const" when optimization isn’t turned on, even if the variables aren’t referenced'
complete -c gcc -o fmerge-constants -d 'Attempt to merge identical constants (string constants and floating point constants) across compilation units'
complete -c gcc -o fmerge-all-constants -d 'Attempt to merge identical constants and identical variables'
complete -c gcc -o fmodulo-sched -d 'Perform swing modulo scheduling immediately before the first scheduling pass'
complete -c gcc -o fno-branch-count-reg -d 'Do not use "decrement and branch" instructions on a count register, but instead generate a sequence of instructions that decrement a register, compare it against zero, then branch based upon the result'
complete -c gcc -o fno-function-cse -d 'Do not put function addresses in registers; make each instruction that calls a constant function contain the function’s address explicitly'
complete -c gcc -o fno-zero-initialized-in-bss -d 'If the target supports a BSS section, GCC by default puts variables that are initialized to zero into BSS'
complete -c gcc -o fbounds-check -d 'For front-ends that support it, generate additional code to check that indices used to access arrays are within the declared range'
complete -c gcc -o fmudflap -d 'For front-ends that support it (C and C++), instrument all risky pointer/array dereferencing operations, some standard library string/heap functions, and some other associated constructs with range/validity tests'
complete -c gcc -o fmudflapth -d 'For front-ends that support it (C and C++), instrument all risky pointer/array dereferencing operations, some standard library string/heap functions, and some other associated constructs with range/validity tests'
complete -c gcc -o fmudflapir -d 'For front-ends that support it (C and C++), instrument all risky pointer/array dereferencing operations, some standard library string/heap functions, and some other associated constructs with range/validity tests'
complete -c gcc -o fstrength-reduce -d 'Perform the optimizations of loop strength reduction and elimination of iteration variables'
complete -c gcc -o fthread-jumps -d 'Perform optimizations where we check to see if a jump branches to a location where another comparison subsumed by the first is found'
complete -c gcc -o fcse-follow-jumps -d 'In common subexpression elimination, scan through jump instructions when the target of the jump is not reached by any other path'
complete -c gcc -o fcse-skip-blocks -d 'This is similar to -fcse-follow-jumps, but causes CSE to follow jumps which conditionally skip over blocks'
complete -c gcc -o frerun-cse-after-loop -d 'Re-run common subexpression elimination after loop optimizations has been performed'
complete -c gcc -o frerun-loop-opt -d 'Run the loop optimizer twice'
complete -c gcc -o fgcse -d 'Perform a global common subexpression elimination pass'
complete -c gcc -o fgcse-lm -d 'Global common subexpression elimination will attempt to move loads which are only killed by stores into themselves'
complete -c gcc -o fgcse-sm -d 'A store motion pass is run after global common subexpression elimination'
complete -c gcc -o fgcse-las -d 'The global common subexpression elimination pass eliminates redundant loads that come after stores to the same memory location (both partial and full redundancies)'
complete -c gcc -o fgcse-after-reload -d 'When -fgcse-after-reload is enabled, a redundant load elimination pass is performed after reload'
complete -c gcc -o floop-optimize -d 'Perform loop optimizations: move constant expressions out of loops, simplify exit test conditions and optionally do strength-reduction as well'
complete -c gcc -o floop-optimize2 -d 'Perform loop optimizations using the new loop optimizer'
complete -c gcc -o funsafe-loop-optimizations -d 'The loop optimizer will assume that loop indices do not overflow, and that the loops with nontrivial exit condition are not infinite'
complete -c gcc -o fcrossjumping -d 'Perform cross-jumping transformation'
complete -c gcc -o fif-conversion -d 'Attempt to transform conditional jumps into branch-less equivalents'
complete -c gcc -o fif-conversion2 -d 'Use conditional execution (where available) to transform conditional jumps into branch-less equivalents'
complete -c gcc -o fdelete-null-pointer-checks -d 'Use global dataflow analysis to identify and eliminate useless checks for null pointers'
complete -c gcc -o fexpensive-optimizations -d 'Perform a number of minor optimizations that are relatively expensive'
complete -c gcc -o foptimize-register-move -d 'Attempt to reassign register numbers in move instructions and as operands of other simple instructions in order to maximize the amount of register tying'
complete -c gcc -o fregmove -d 'Attempt to reassign register numbers in move instructions and as operands of other simple instructions in order to maximize the amount of register tying'
complete -c gcc -o fdelayed-branch -d 'If supported for the target machine, attempt to reorder instructions to exploit instruction slots available after delayed branch instructions'
complete -c gcc -o fschedule-insns -d 'If supported for the target machine, attempt to reorder instructions to eliminate execution stalls due to required data being unavailable'
complete -c gcc -o fschedule-insns2 -d 'Similar to -fschedule-insns, but requests an additional pass of instruction scheduling after register allocation has been done'
complete -c gcc -o fno-sched-interblock -d 'Don’t schedule instructions across basic blocks'
complete -c gcc -o fno-sched-spec -d 'Don’t allow speculative motion of non-load instructions'
complete -c gcc -o fsched-spec-load -d 'Allow speculative motion of some load instructions'
complete -c gcc -o fsched-spec-load-dangerous -d 'Allow speculative motion of more load instructions'
complete -c gcc -o fsched-stalled-insns -d 'Define how many insns (if any) can be moved prematurely from the queue of stalled insns into the ready list, during the second scheduling pass'
complete -c gcc -o fsched-stalled-insns-dep -d 'Define how many insn groups (cycles) will be examined for a dependency on a stalled insn that is candidate for premature removal from the queue of stalled insns'
complete -c gcc -o fsched2-use-superblocks -d 'When scheduling after register allocation, do use superblock scheduling algorithm'
complete -c gcc -o fsched2-use-traces -d 'Use -fsched2-use-superblocks algorithm when scheduling after register allocation and additionally perform code duplication in order to increase the size of superblocks using tracer pass'
complete -c gcc -o freschedule-modulo-scheduled-loops -d 'The modulo scheduling comes before the traditional scheduling, if a loop was modulo scheduled we may want to prevent the later scheduling passes from changing its schedule, we use this option to control that'
complete -c gcc -o fcaller-saves -d 'Enable values to be allocated in registers that will be clobbered by function calls, by emitting extra instructions to save and restore the registers around such calls'
complete -c gcc -o ftree-pre -d 'Perform Partial Redundancy Elimination (PRE) on trees'
complete -c gcc -o ftree-fre -d 'Perform Full Redundancy Elimination (FRE) on trees'
complete -c gcc -o ftree-copy-prop -d 'Perform copy propagation on trees'
complete -c gcc -o ftree-store-copy-prop -d 'Perform copy propagation of memory loads and stores'
complete -c gcc -o ftree-salias -d 'Perform structural alias analysis on trees'
complete -c gcc -o ftree-sink -d 'Perform forward store motion on trees'
complete -c gcc -o ftree-ccp -d 'Perform sparse conditional constant propagation (CCP) on trees'
complete -c gcc -o ftree-store-ccp -d 'Perform sparse conditional constant propagation (CCP) on trees'
complete -c gcc -o ftree-dce -d 'Perform dead code elimination (DCE) on trees'
complete -c gcc -o ftree-dominator-opts -d 'Perform a variety of simple scalar cleanups based on a dominator tree traversal'
complete -c gcc -o ftree-ch -d 'Perform loop header copying on trees'
complete -c gcc -o ftree-loop-optimize -d 'Perform loop optimizations on trees'
complete -c gcc -o ftree-loop-linear -d 'Perform linear loop transformations on tree'
complete -c gcc -o ftree-loop-im -d 'Perform loop invariant motion on trees'
complete -c gcc -o ftree-loop-ivcanon -d 'Create a canonical counter for number of iterations in the loop for that determining number of iterations requires complicated analysis'
complete -c gcc -o fivopts -d 'Perform induction variable optimizations on trees'
complete -c gcc -o ftree-sra -d 'Perform scalar replacement of aggregates'
complete -c gcc -o ftree-copyrename -d 'Perform copy renaming on trees'
complete -c gcc -o ftree-ter -d 'Perform temporary expression replacement during the SSA->normal phase'
complete -c gcc -o ftree-lrs -d 'Perform live range splitting during the SSA->normal phase'
complete -c gcc -o ftree-vectorize -d 'Perform loop vectorization on trees'
complete -c gcc -o ftree-vect-loop-version -d 'Perform loop versioning when doing loop vectorization on trees'
complete -c gcc -o ftree-vrp -d 'Perform Value Range Propagation on trees'
complete -c gcc -o ftracer -d 'Perform tail duplication to enlarge superblock size'
complete -c gcc -o funroll-loops -d 'Unroll loops whose number of iterations can be determined at compile time or upon entry to the loop'
complete -c gcc -o funroll-all-loops -d 'Unroll all loops, even if their number of iterations is uncertain when the loop is entered'
complete -c gcc -o fsplit-ivs-in-unroller -d 'Enables expressing of values of induction variables in later iterations of the unrolled loop using the value in the first iteration'
complete -c gcc -o fvariable-expansion-in-unroller -d 'With this option, the compiler will create multiple copies of some local variables when unrolling a loop which can result in superior code'
complete -c gcc -o fprefetch-loop-arrays -d 'Generate instructions to prefetch memory to improve the performance of loops that access large arrays'
complete -c gcc -o fno-peephole -d 'Disable any machine-specific peephole optimizations'
complete -c gcc -o fno-peephole2 -d 'Disable any machine-specific peephole optimizations'
complete -c gcc -o fno-guess-branch-probability -d 'Do not guess branch probabilities using heuristics'
complete -c gcc -o freorder-blocks -d 'Reorder basic blocks in the compiled function in order to reduce number of taken branches and improve code locality'
complete -c gcc -o freorder-blocks-and-partition -d 'In addition to reordering basic blocks in the compiled function, in order to reduce number of taken branches, partitions hot and cold basic blocks into separate sections of the assembly and '
complete -c gcc -o freorder-functions -d 'Reorder functions in the object file in order to improve code locality'
complete -c gcc -o fstrict-aliasing -d 'Allows the compiler to assume the strictest aliasing rules applicable to the language being compiled'
complete -c gcc -o falign-functions -d 'Align the start of functions to the next power-of-two greater than n, skipping up to n bytes'
complete -c gcc -o falign-functions -d 'Align the start of functions to the next power-of-two greater than n, skipping up to n bytes'
complete -c gcc -o falign-labels -d 'Align all branch targets to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-labels -d 'Align all branch targets to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-loops -d 'Align loops to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-loops -d 'Align loops to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-jumps -d 'Align branch targets to a power-of-two boundary, for branch targets where the targets can only be reached by jumping, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-jumps -d 'Align branch targets to a power-of-two boundary, for branch targets where the targets can only be reached by jumping, skipping up to n bytes like -falign-functions'
complete -c gcc -o funit-at-a-time -d 'Parse the whole compilation unit before starting to produce code'
complete -c gcc -o fweb -d 'Constructs webs as commonly used for register allocation purposes and assign each web individual pseudo register'
complete -c gcc -o fwhole-program -d 'Assume that the current compilation unit represents whole program being compiled'
complete -c gcc -o fno-cprop-registers -d 'After register allocation and post-register allocation instruction splitting, perform a copy-propagation pass to try to reduce scheduling dependencies and occasionally eliminate the copy'
complete -c gcc -o fprofile-generate -d 'Enable options usually used for instrumenting application to produce profile useful for later recompilation with profile feedback based optimization'
complete -c gcc -o fprofile-use -d 'Enable profile feedback directed optimizations, and optimizations generally profitable only with profile feedback available'
complete -c gcc -o ffloat-store -d 'Do not store floating point variables in registers, and inhibit other options that might change whether a floating point value is taken from a register or memory'
complete -c gcc -o ffast-math -d 'Sets -fno-math-errno, -funsafe-math-optimizations, -fno-trapping-math, -ffinite-math-only, -fno-rounding-math, -fno-signaling-nans and fcx-limited-range'
complete -c gcc -o fno-math-errno -d 'Do not set ERRNO after calling math functions that are executed with a single instruction, e'
complete -c gcc -o funsafe-math-optimizations -d 'Allow optimizations for floating-point arithmetic that (a) assume that arguments and results are valid and (b) may violate IEEE or ANSI standards'
complete -c gcc -o ffinite-math-only -d 'Allow optimizations for floating-point arithmetic that assume arguments and results are not NaNs or +-Infs'
complete -c gcc -o fno-trapping-math -d 'Compile code assuming that floating-point operations cannot generate user-visible traps'
complete -c gcc -o frounding-math -d 'Disable transformations and optimizations that assume default floating point rounding behavior'
complete -c gcc -o fsignaling-nans -d 'Compile code assuming that IEEE signaling NaNs may generate uservisible traps during floating-point operations'
complete -c gcc -o fsingle-precision-constant -d 'Treat floating point constant as single precision constant instead of implicitly converting it to double precision constant'
complete -c gcc -o fcx-limited-range -d 'When enabled, states that a range reduction step is not needed when performing complex division'
complete -c gcc -o fno-cx-limited-range -d 'When enabled, states that a range reduction step is not needed when performing complex division'
complete -c gcc -o fbranch-probabilities -d 'After running a program with -fprofile-arcs, one can compile it again with this option, to improve optimizations based on the number of times each branch was taken'
complete -c gcc -o fprofile-values -d 'If combined with -fprofile-arcs, it adds code so that some data about values of expressions in the program is gathered'
complete -c gcc -o fvpt -d 'If combined with -fprofile-arcs, it instructs the compiler to add a code to gather information about values of expressions'
complete -c gcc -o frename-registers -d 'Attempt to avoid false dependencies in scheduled code by making use of registers left over after register allocation'
complete -c gcc -o ftracer -d 'Perform tail duplication to enlarge superblock size'
complete -c gcc -o funroll-loops -d 'Unroll loops whose number of iterations can be determined at compile time or upon entry to the loop'
complete -c gcc -o funroll-all-loops -d 'Unroll all loops, even if their number of iterations is uncertain when the loop is entered'
complete -c gcc -o fpeel-loops -d 'Peels the loops for that there is enough information that they do not roll much (from profile feedback)'
complete -c gcc -o fmove-loop-invariants -d 'Enables the loop invariant motion pass in the new loop optimizer'
complete -c gcc -o funswitch-loops -d 'Move branches with loop invariant conditions out of the loop, with duplicates of the loop on both branches (modified according to result of the condition)'
complete -c gcc -o fprefetch-loop-arrays -d 'If supported by the target machine, generate instructions to prefetch memory to improve the performance of loops that access large arrays'
complete -c gcc -o ffunction-sections -d 'Place each function or data item into its own section in the output file if the target supports arbitrary sections'
complete -c gcc -o fdata-sections -d 'Place each function or data item into its own section in the output file if the target supports arbitrary sections'
complete -c gcc -o fbranch-target-load-optimize -d 'Perform branch target register load optimization before prologue / epilogue threading'
complete -c gcc -o fbranch-target-load-optimize2 -d 'Perform branch target register load optimization after prologue / epilogue threading'
complete -c gcc -o fbtr-bb-exclusive -d 'When performing branch target register load optimization, don’t reuse branch target registers in within any basic block'
complete -c gcc -o fstack-protector -d 'Emit extra code to check for buffer overflows, such as stack smashing attacks'
complete -c gcc -o fstack-protector-all -d 'Like -fstack-protector except that all functions are protected'
complete -c gcc -l param -d 'In some places, GCC uses various constants to control the amount of optimization that is done'
complete -c gcc -o Xpreprocessor -d 'Pass option as an option to the preprocessor'
complete -c gcc -s D -d 'Predefine name as a macro, with definition 1'
complete -c gcc -s D -d 'The contents of definition are tokenized and processed as if they appeared during translation phase three in a #define directive'
complete -c gcc -s U -d 'Cancel any previous definition of name, either built in or provided with a -D option'
complete -c gcc -o undef -d 'Do not predefine any system-specific or GCC-specific macros'
complete -c gcc -s I -d 'Add the directory dir to the list of directories to be searched for header files'
complete -c gcc -s o -d 'Write output to file'
complete -c gcc -o Wall -d 'Turns on all optional warnings which are desirable for normal code'
complete -c gcc -o Wcomment -d 'Warn whenever a comment-start sequence /* appears in a /* comment, or whenever a backslash-newline appears in a // comment'
complete -c gcc -o Wcomments -d 'Warn whenever a comment-start sequence /* appears in a /* comment, or whenever a backslash-newline appears in a // comment'
complete -c gcc -o Wtrigraphs -d 'Most trigraphs in comments cannot affect the meaning of the program'
complete -c gcc -o Wtraditional -d 'Warn about certain constructs that behave differently in traditional and ISO C'
complete -c gcc -o Wimport -d 'Warn the first time #import is used'
complete -c gcc -o Wundef -d 'Warn whenever an identifier which is not a macro is encountered in an #if directive, outside of defined'
complete -c gcc -o Wunused-macros -d 'Warn about macros defined in the main file that are unused'
complete -c gcc -o Wendif-labels -d 'Warn whenever an #else or an #endif are followed by text'
complete -c gcc -o Werror -d 'Make all warnings into hard errors'
complete -c gcc -o Wsystem-headers -d 'Issue warnings for code in system headers'
complete -c gcc -s w -d 'Suppress all warnings, including those which GNU CPP issues by default'
complete -c gcc -o pedantic -d 'Issue all the mandatory diagnostics listed in the C standard'
complete -c gcc -o pedantic-errors -d 'Issue all the mandatory diagnostics, and make all mandatory diagnostics into errors'
complete -c gcc -s M -d 'Instead of outputting the result of preprocessing, output a rule suitable for make describing the dependencies of the main source file'
complete -c gcc -o MM -d 'Like -M but do not mention header files that are found in system header directories, nor header files that are included, directly or indirectly, from such a header'
complete -c gcc -o MF -d 'When used with -M or -MM, specifies a file to write the dependencies to'
complete -c gcc -o MG -d 'In conjunction with an option such as -M requesting dependency generation, -MG assumes missing header files are generated files and adds them to the dependency list without raising an error'
complete -c gcc -o MP -d 'Instructs CPP to add a phony target for each dependency other than the main file, causing each to depend on nothing'
complete -c gcc -o MT -d 'Change the target of the rule emitted by dependency generation'
complete -c gcc -o MQ -d 'Same as -MT, but it quotes any characters which are special to Make'
complete -c gcc -o MD -d 'is equivalent to -M -MF file, except that -E is not implied'
complete -c gcc -o MMD -d 'Like -MD except mention only user header files, not system header files'
complete -c gcc -o fpch-deps -d 'When using precompiled headers, this flag will cause the dependency-output flags to also list the files from the precompiled header’s dependencies'
complete -c gcc -o fpch-preprocess -d 'Allows use of a precompiled header together with -E'
complete -c gcc -s x -d 'Specify the source language' -a 'c  c-header  cpp-output
c++  c++-header  c++-cpp-output objective-c  objective-c-header  objective-c-cpp-output
objective-c++ objective-c++-header objective-c++-cpp-output
assembler  assembler-with-cpp ada f77  f77-cpp-input f95  f95-cpp-input go brig'
complete -c gcc -o std -d 'Specify the standard to which the code should conform'
complete -c gcc -o ansi -d 'Specify the standard to which the code should conform'
complete -c gcc -o I- -d 'Split the include path'
complete -c gcc -o nostdinc -d 'Do not search the standard system directories for header files'
complete -c gcc -o nostdinc++ -d 'Do not search for header files in the C++-specific standard directories, but do still search the other standard directories'
complete -c gcc -o include -d 'Process file as if "#include "file"" appeared as the first line of the primary source file'
complete -c gcc -o imacros -d 'Exactly like -include, except that any output produced by scanning file is thrown away'
complete -c gcc -o idirafter -d 'Search dir for header files, but do it after all directories specified with -I and the standard system directories have been exhausted'
complete -c gcc -o iprefix -d 'Specify prefix as the prefix for subsequent -iwithprefix options'
complete -c gcc -o iwithprefix -d 'Append dir to prefix defined with -iprefix, and add the result to the include search path. Add to same place as -I'
complete -c gcc -o iwithprefixbefore -d 'Append dir to prefix defined with -iprefix, and add the result to the include search path. Add to same place as -idirafter'
complete -c gcc -o isysroot -d 'Like the --sysroot option, but only to header files'
complete -c gcc -o isystem -d 'Search dir for header files, after all directories specified by -I but before the standard system directories'
complete -c gcc -o iquote -d 'Search dir only for header files requested with "#include "file""'
complete -c gcc -o fdollars-in-identifiers -d 'Accept $ in identifiers'
complete -c gcc -o fextended-identifiers -d 'Accept universal character names in identifiers'
complete -c gcc -o fpreprocessed -d 'Indicate to the preprocessor that the input file has already been preprocessed'
complete -c gcc -o ftabstop -d 'Set the distance between tab stops'
complete -c gcc -o fexec-charset -d 'Set the execution character set, used for string and character constants' -a "(__fish_print_encodings)"
complete -c gcc -o fwide-exec-charset -d 'Set the wide execution character set, used for wide string and character constants' -a "(__fish_print_encodings)"
complete -c gcc -o finput-charset -d 'Set the input character set, used for translation from the character set of the input file to the source character set used by GCC' -a "(__fish_print_encodings)"
complete -c gcc -o fworking-directory -d 'Enable generation of linemarkers in the preprocessor output that will let the compiler know the current working directory at the time of preprocessing'
complete -c gcc -o fno-show-column -d 'Do not print column numbers in diagnostics'
complete -c gcc -s A -d 'Make an assertion with the predicate predicate and answer answer'
complete -c gcc -s A -d 'Cancel an assertion with the predicate predicate and answer answer' -x
complete -c gcc -o predicate -d 'Cancel an assertion with the predicate predicate and answer answer' -x
complete -c gcc -o dCHARS -d 'CHARS is a sequence of one or more of the following characters, and must not be preceded by a space'
complete -c gcc -s P -d 'Inhibit generation of linemarkers in the output from the preprocessor'
complete -c gcc -s C -d 'Do not discard comments'
complete -c gcc -o CC -d 'Do not discard comments, including during macro expansion'
complete -c gcc -o traditional-cpp -d 'Try to imitate the behavior of old-fashioned C preprocessors, as opposed to ISO C preprocessors'
complete -c gcc -o trigraphs -d 'Process trigraph sequences'
complete -c gcc -o remap -d 'Enable special code to work around file systems which only permit very short file names, such as MS-DOS'
complete -c gcc -l help -d 'Print text describing all the command line options instead of preprocessing anything'
complete -c gcc -l target-help -d 'Print text describing all the command line options instead of preprocessing anything'
complete -c gcc -s v -d 'Verbose mode'
complete -c gcc -s H -d 'Print the name of each header file used, in addition to other normal activities'
complete -c gcc -o version -d 'Print out GNU CPP’s version number'
complete -c gcc -l version -d 'Print out GNU CPP’s version number'
complete -c gcc -o Xassembler -d 'Pass option as an option to the assembler'
complete -c gcc -s c -d 'Compile or assemble the source files, but do not link.'
complete -c gcc -s S -d 'Stop after the stage of compilation proper; do not assemble'
complete -c gcc -s E -d 'Stop after the preprocessing stage; do not run the compiler proper'
complete -c gcc -o llibrary -d 'Search the library named library when linking'
complete -c gcc -a '-l(path basename /usr/lib/lib*.so* | string match -r -g "^lib(.*?)\.so.*")'
complete -c gcc -s l -d 'Search the library named library when linking'
complete -c gcc -o ldl -d 'Search the dynamic loader library when linking'
complete -c gcc -o lm -d 'Search the math library when linking'
complete -c gcc -o lz -d 'Search the zlib library when linking'
complete -c gcc -o lrt -d 'Search the realtime extensions library when linking'
complete -c gcc -o lobjc -d 'You need this special case of the -l option in order to link an Objective-C or Objective-C++ program'
complete -c gcc -o nostartfiles -d 'Do not use the standard system startup files when linking'
complete -c gcc -o nodefaultlibs -d 'Do not use the standard system libraries when linking'
complete -c gcc -o nostdlib -d 'Do not use the standard system startup files or libraries when linking'
complete -c gcc -o pie -d 'Produce a position independent executable on targets which support it'
complete -c gcc -o rdynamic -d 'Pass the flag -export-dynamic to the ELF linker, on targets that support it'
complete -c gcc -s s -d 'Remove all symbol table and relocation information from the executable'
complete -c gcc -o static -d 'On systems that support dynamic linking, this prevents linking with the shared libraries'
complete -c gcc -o shared -d 'Produce a shared object which can then be linked with other objects to form an executable'
complete -c gcc -o shared-libgcc -d 'Force shared libgcc'
complete -c gcc -o static-libgcc -d 'Force static libgcc'
complete -c gcc -o symbolic -d 'Bind references to global symbols when building a shared object'
complete -c gcc -o Xlinker -d 'Pass option as an option to the linker'
complete -c gcc -s u -d 'Pretend the symbol symbol is undefined, to force linking of library modules to define it'
complete -c gcc -o Idir -d 'Add dir to the head of the list of directories to be searched for header files'
complete -c gcc -o iquotedir -d 'Add dir to the head of the list of directories to be searched for header files only for the case of #include "file"'
complete -c gcc -o L -d 'Add dir to the list of directories to be searched for -l'
complete -c gcc -o B -d 'Specifies where to find the executables, libraries, include files, and data files of the compiler itself'
complete -c gcc -o specs -r -d 'Process file after the compiler reads in the standard specs file'
complete -c gcc -l sysroot -x -a '(__fish_complete_directories)' -d 'Use dir as the logical root directory for headers and libraries'
complete -c gcc -o I- -d 'Deprecated'
complete -c gcc -s b -d 'The argument machine specifies the target machine for compilation'
complete -c gcc -s V -d 'The argument version specifies which version of GCC to run'
complete -c gcc -o EL -d 'Compile code for little endian mode'
complete -c gcc -o EB -d 'Compile code for big endian mode'
complete -c gcc -o mmangle-cpu -d 'Prepend the name of the cpu to all public symbol names'
complete -c gcc -o mcpu -d 'Compile code for ARC variant cpu' -x
complete -c gcc -o mabi -d 'Generate code for the specified ABI' -x
complete -c gcc -o mapcs-frame -d 'Generate a stack frame that is compliant with the ARM Procedure Call Standard for all functions, even if this is not strictly necessary for correct execution of the code'
complete -c gcc -o mapcs -d 'This is a synonym for -mapcs-frame'
complete -c gcc -o mthumb-interwork -d 'Generate code which supports calling between the ARM and Thumb instruction sets'
complete -c gcc -o mno-sched-prolog -d 'Prevent the reordering of instructions in the function prolog, or the merging of those instruction with the instructions in the function’s body'
complete -c gcc -o mhard-float -d 'Generate output containing floating point instructions'
complete -c gcc -o msoft-float -d 'Generate output containing library calls for floating point'
complete -c gcc -o mfloat-abi -d 'Specifies which ABI to use for floating point values' -x
complete -c gcc -o mlittle-endian -d 'Generate code for a processor running in little-endian mode'
complete -c gcc -o mbig-endian -d 'Generate code for a processor running in big-endian mode; the default is to compile code for a little-endian processor'
complete -c gcc -o mwords-little-endian -d 'Only applies when generating code for big-endian processors'
complete -c gcc -o mcpu -d 'This specifies the name of the target ARM processor' -x
complete -c gcc -o mtune -d 'Tune output for this cpu without restricting the instructions to it'
complete -c gcc -o march -d 'This specifies the name of the target ARM architecture' -x
complete -c gcc -o mfpu -x -d 'This specifies what floating point hardware (or hardware emulation) is available on the target'
complete -c gcc -o mfpe -x -d 'This specifies what floating point hardware (or hardware emulation) is available on the target'
complete -c gcc -o mfp -x -d 'This specifies what floating point hardware (or hardware emulation) is available on the target'
complete -c gcc -o mstructure-size-boundary -x -d 'The size of all structures and unions will be rounded up to a multiple of the number of bits set by this option'
complete -c gcc -o mabort-on-noreturn -d 'Generate a call to the function "abort" at the end of a "noreturn" function'
complete -c gcc -o mlong-calls -d 'Perform function calls by first loading the address of the function into a register and then performing a subroutine call on it'
complete -c gcc -o mno-long-calls -d 'Do not perform function calls by first loading the address of the function into a register and then performing a subroutine call on it'
complete -c gcc -o mnop-fun-dllimport -d 'Disable support for the "dllimport" attribute'
complete -c gcc -o msingle-pic-base -d 'Treat the register used for PIC addressing as read-only, rather than loading it in the prologue for each function'
complete -c gcc -o mpic-register -x -d 'Specify the register to be used for PIC addressing'
complete -c gcc -o mcirrus-fix-invalid-insns -d 'Insert NOPs into the instruction stream to in order to work around problems with invalid Maverick instruction combinations'
complete -c gcc -o mpoke-function-name -d 'Write the name of each function into the text section, directly preceding the function prologue'
complete -c gcc -o mthumb -d 'Generate code for the 16-bit Thumb instruction set'
complete -c gcc -o mtpcs-frame -d 'Generate a stack frame that is compliant with the Thumb Procedure Call Standard for all non-leaf functions'
complete -c gcc -o mtpcs-leaf-frame -d 'Generate a stack frame that is compliant with the Thumb Procedure Call Standard for all leaf functions'
complete -c gcc -o mcallee-super-interworking -d 'Gives all externally visible functions in the file being compiled an ARM instruction set header which switches to Thumb mode before executing the rest of the function'
complete -c gcc -o mcaller-super-interworking -d 'Allow calls via function pointers (including virtual functions) to execute correctly regardless of whether the target code has been compiled for interworking'
complete -c gcc -o mtp -x -d 'Specify the access model for the thread local storage pointer'
complete -c gcc -o mmcu -x -d 'Specify ATMEL AVR instruction set or MCU type'
complete -c gcc -o msize -d 'Output instruction sizes to the asm file'
complete -c gcc -o minit-stack -x -d 'Specify the initial stack address, which may be a symbol or numeric value, __stack is the default'
complete -c gcc -o mno-interrupts -d 'Generated code is not compatible with hardware interrupts'
complete -c gcc -o mcall-prologues -d 'Functions prologues/epilogues expanded as call to appropriate subroutines'
complete -c gcc -o mno-tablejump -d 'Do not generate tablejump insns which sometimes increase code size'
complete -c gcc -o mtiny-stack -d 'Change only the low 8 bits of the stack pointer'
complete -c gcc -o mint8 -d 'Assume int to be 8 bit integer'
complete -c gcc -o momit-leaf-frame-pointer -d 'Don’t keep the frame pointer in a register for leaf functions'
complete -c gcc -o mspecld-anomaly -d 'When enabled, the compiler will ensure that the generated code does not contain speculative loads after jump instructions'
complete -c gcc -o mno-specld-anomaly -d 'Don’t generate extra code to prevent speculative loads from occurring'
complete -c gcc -o mcsync-anomaly -d 'Ensure that the generated code does not contain CSYNC or SSYNC instructions too soon after conditional branches'
complete -c gcc -o mno-csync-anomaly -d 'Don’t generate extra code to prevent CSYNC or SSYNC instructions from occurring too soon after a conditional branch'
complete -c gcc -o mlow-64k -d 'Compiler is free to take advantage of the knowledge that the entire program fits into the low 64k of memory'
complete -c gcc -o mno-low-64k -d 'Assume that the program is arbitrarily large'
complete -c gcc -o mid-shared-library -d 'Generate code that supports shared libraries via the library ID method'
complete -c gcc -o mno-id-shared-library -d 'Generate code that doesn’t assume ID based shared libraries are being used'
complete -c gcc -o mshared-library-id -x -d 'Specified the identification number of the ID based shared library being compiled'
complete -c gcc -o mlong-calls -d 'Perform function calls by first loading the address of the function into a register and then performing a subroutine call on it'
complete -c gcc -o mno-long-calls -d 'Does not perform function calls by first loading the address of the function into a register and then performing a subroutine call on it'
complete -c gcc -o march -d 'Generate code for the specified architecture'
complete -c gcc -o mcpu -d 'Generate code for the specified architecture'
complete -c gcc -o type -d 'Generate code for the specified architecture'
complete -c gcc -o mtune -d 'Tune to architecture-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o type -d 'Tune to architecture-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o mmax-stack-frame -d '=n Warn when the stack frame of a function exceeds n bytes'
complete -c gcc -o melinux-stacksize -d '=n Only available with the cris-axis-aout target'
complete -c gcc -o metrax4 -d 'Synonym for -march=v3'
complete -c gcc -o metrax100 -d 'Synonym for -march=v8'
complete -c gcc -o mmul-bug-workaround -d 'Work around a bug in the "muls" and "mulu" instructions for CPU models where it applies'
complete -c gcc -o mno-mul-bug-workaround -d 'Work around a bug in the "muls" and "mulu" instructions for CPU models where it applies'
complete -c gcc -o mpdebug -d 'Enable CRIS-specific verbose debug-related information in the assembly code'
complete -c gcc -o mcc-init -d 'Do not use condition-code results from previous instruction; always emit compare and test instructions before use of condition codes'
complete -c gcc -o mno-side-effects -d 'Do not emit instructions with side-effects in addressing modes other than post-increment'
complete -c gcc -o mstack-align -d 'Arranges for the stack-frame to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mno-stack-align -d 'Eliminate arrangements for the stack-frame to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mdata-align -d 'Arranges for the individual data to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mno-data-align -d 'Eliminate arrangements for the individual data to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mconst-align -d 'Arranges for the constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mno-const-align -d 'Eliminate arrangements for the constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o m32-bit -d 'Arrange for stack-frame, writable data and constants to all be 32-bit, 16-bit or 8-bit aligned'
complete -c gcc -o m16-bit -d 'Arrange for stack-frame, writable data and constants to all be 32-bit, 16-bit or 8-bit aligned'
complete -c gcc -o m8-bit -d 'Arrange for stack-frame, writable data and constants to all be 32-bit, 16-bit or 8-bit aligned'
complete -c gcc -o mno-prologue-epilogue -d 'With -mno-prologue-epilogue, the normal function prologue and epilogue that sets up the stack-frame are omitted and no return instructions or return sequences are generated in the code'
complete -c gcc -o mprologue-epilogue -d 'With -mno-prologue-epilogue, the normal function prologue and epilogue that sets up the stack-frame are omitted and no return instructions or return sequences are generated in the code'
complete -c gcc -o mno-gotplt -d 'With -fpic and -fPIC, don’t generate instruction sequences that load addresses for functions from the PLT part of the GOT rather than (traditional on other architectures) calls to the PLT'
complete -c gcc -o mgotplt -d 'With -fpic and -fPIC, generate instruction sequences that load addresses for functions from the PLT part of the GOT rather than (traditional on other architectures) calls to the PLT'
complete -c gcc -o maout -d 'Legacy no-op flag only recognized with the cris-axis-aout target'
complete -c gcc -o melf -d 'Legacy no-op flag only recognized with the cris-axis-elf and cris-axis-linux-gnu targets'
complete -c gcc -o melinux -d 'Only recognized with the cris-axis-aout target, where it selects a GNU/linux-like multilib, include files and instruction set for -march=v8'
complete -c gcc -o mlinux -d 'Legacy no-op flag only recognized with the cris-axis-linux-gnu target'
complete -c gcc -o sim -d 'When recognized for the cris-axis-aout and cris-axis-elf arranges to link with input-output functions from a simulator library'
complete -c gcc -o sim2 -d 'Like -sim, but pass linker options to locate initialized data at 0x40000000 and zero-initialized data at 0x80000000'
complete -c gcc -o mmac -d 'Enable the use of multiply-accumulate instructions'
complete -c gcc -o mpush-args -d 'Push instructions will be used to pass outgoing arguments when functions are called'
complete -c gcc -o Fdir -d 'Add the framework dir to the list of directories to be searched for headers'
complete -c gcc -o gused -d 'Emit debugging information for symbols that are used'
complete -c gcc -o gfull -d 'Emit debugging information for all symbols and types'
complete -c gcc -o mmacosx-version-min -d '=version The earliest version of MacOS X that this executable will run on is version'
complete -c gcc -o mone-byte-bool -d 'Override the defaults for bool so that sizeof(bool)==1'
complete -c gcc -o mfix-and-continue -d 'Generate code suitable for fast turn around development'
complete -c gcc -o ffix-and-continue -d 'Generate code suitable for fast turn around development'
complete -c gcc -o findirect-data -d 'Generate code suitable for fast turn around development'
complete -c gcc -o all_load -d 'Loads all members of static archive libraries'
complete -c gcc -o arch_errors_fatal -d 'Cause the errors having to do with files that have the wrong architecture to be fatal'
complete -c gcc -o bind_at_load -d 'Causes the output file to be marked such that the dynamic linker will bind all undefined references when the file is loaded or launched'
complete -c gcc -o bundle -d 'Produce a Mach-o bundle format file'
complete -c gcc -o bundle_loader -d 'Specifies the executable that will be loading the build output file being linked'
complete -c gcc -o dynamiclib -d 'When enabled, GCC will produce a dynamic library instead of an executable when linking, using the Darwin libtool command'
complete -c gcc -o force_cpusubtype_ALL -d 'This causes GCC’s output file to have the ALL subtype, instead of one controlled by the -mcpu or -march option'
complete -c gcc -o allowable_client -d 'These options are passed to the Darwin linker'
complete -c gcc -o client_name -d 'These options are passed to the Darwin linker'
complete -c gcc -o compatibility_version -d 'These options are passed to the Darwin linker'
complete -c gcc -o current_version -d 'These options are passed to the Darwin linker'
complete -c gcc -o dead_strip -d 'These options are passed to the Darwin linker'
complete -c gcc -o dependency-file -d 'These options are passed to the Darwin linker'
complete -c gcc -o dylib_file -d 'These options are passed to the Darwin linker'
complete -c gcc -o dylinker_install_name -d 'These options are passed to the Darwin linker'
complete -c gcc -o dynamic -d 'These options are passed to the Darwin linker'
complete -c gcc -o exported_symbols_list -d 'These options are passed to the Darwin linker'
complete -c gcc -o filelist -d 'These options are passed to the Darwin linker'
complete -c gcc -o flat_namespace -d 'These options are passed to the Darwin linker'
complete -c gcc -o force_flat_namespace -d 'These options are passed to the Darwin linker'
complete -c gcc -o headerpad_max_install_names -d 'These options are passed to the Darwin linker'
complete -c gcc -o image_base -d 'These options are passed to the Darwin linker'
complete -c gcc -o init -d 'These options are passed to the Darwin linker'
complete -c gcc -o install_name -d 'These options are passed to the Darwin linker'
complete -c gcc -o keep_private_externs -d 'These options are passed to the Darwin linker'
complete -c gcc -o multi_module -d 'These options are passed to the Darwin linker'
complete -c gcc -o multiply_defined -d 'These options are passed to the Darwin linker'
complete -c gcc -o multiply_defined_unused -d 'These options are passed to the Darwin linker'
complete -c gcc -o noall_load -d 'These options are passed to the Darwin linker'
complete -c gcc -o no_dead_strip_inits_and_terms -d 'These options are passed to the Darwin linker'
complete -c gcc -o nofixprebinding -d 'These options are passed to the Darwin linker'
complete -c gcc -o nomultidefs -d 'These options are passed to the Darwin linker'
complete -c gcc -o noprebind -d 'These options are passed to the Darwin linker'
complete -c gcc -o noseglinkedit -d 'These options are passed to the Darwin linker'
complete -c gcc -o pagezero_size -d 'These options are passed to the Darwin linker'
complete -c gcc -o prebind -d 'These options are passed to the Darwin linker'
complete -c gcc -o prebind_all_twolevel_modules -d 'These options are passed to the Darwin linker'
complete -c gcc -o private_bundle -d 'These options are passed to the Darwin linker'
complete -c gcc -o read_only_relocs -d 'These options are passed to the Darwin linker'
complete -c gcc -o sectalign -d 'These options are passed to the Darwin linker'
complete -c gcc -o sectobjectsymbols -d 'These options are passed to the Darwin linker'
complete -c gcc -o whyload -d 'These options are passed to the Darwin linker'
complete -c gcc -o seg1addr -d 'These options are passed to the Darwin linker'
complete -c gcc -o sectcreate -d 'These options are passed to the Darwin linker'
complete -c gcc -o sectobjectsymbols -d 'These options are passed to the Darwin linker'
complete -c gcc -o sectorder -d 'These options are passed to the Darwin linker'
complete -c gcc -o segaddr -d 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_only_addr -d 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_write_addr -d 'These options are passed to the Darwin linker'
complete -c gcc -o seg_addr_table -d 'These options are passed to the Darwin linker'
complete -c gcc -o seg_addr_table_filename -d 'These options are passed to the Darwin linker'
complete -c gcc -o seglinkedit -d 'These options are passed to the Darwin linker'
complete -c gcc -o segprot -d 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_only_addr -d 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_write_addr -d 'These options are passed to the Darwin linker'
complete -c gcc -o single_module -d 'These options are passed to the Darwin linker'
complete -c gcc -o static -d 'These options are passed to the Darwin linker'
complete -c gcc -o sub_library -d 'These options are passed to the Darwin linker'
complete -c gcc -o sub_umbrella -d 'These options are passed to the Darwin linker'
complete -c gcc -o twolevel_namespace -d 'These options are passed to the Darwin linker'
complete -c gcc -o umbrella -d 'These options are passed to the Darwin linker'
complete -c gcc -o undefined -d 'These options are passed to the Darwin linker'
complete -c gcc -o unexported_symbols_list -d 'These options are passed to the Darwin linker'
complete -c gcc -o weak_reference_mismatches -d 'These options are passed to the Darwin linker'
complete -c gcc -o whatsloaded -d 'These options are passed to the Darwin linker'
complete -c gcc -o mno-soft-float -d 'Use (do not use) the hardware floating-point instructions for floating-point operations'
complete -c gcc -o msoft-float -d 'Use (do not use) the hardware floating-point instructions for floating-point operations'
complete -c gcc -o mfp-reg -d 'Generate code that uses (does not use) the floating-point register set'
complete -c gcc -o mno-fp-regs -d 'Generate code that uses (does not use) the floating-point register set'
complete -c gcc -o mieee -d 'The Alpha architecture implements floating-point hardware optimized for maximum performance'
complete -c gcc -o mieee-with-inexact -d 'This is like -mieee except the generated code also maintains the IEEE inexact-flag'
complete -c gcc -o mfp-trap-mode -d 'This option controls what floating-point related traps are enabled'
complete -c gcc -o mode -d 'This option controls what floating-point related traps are enabled'
complete -c gcc -o mfp-rounding-mode -d 'Selects the IEEE rounding mode'
complete -c gcc -o mode -d 'Selects the IEEE rounding mode'
complete -c gcc -o mtrap-precision -d 'In the Alpha architecture, floating point traps are imprecise'
complete -c gcc -o precision -d 'In the Alpha architecture, floating point traps are imprecise'
complete -c gcc -o mieee-conformant -d 'This option marks the generated code as IEEE conformant'
complete -c gcc -o mbuild-constants -d 'This option require to construct all integer constants using code (maximum is six)'
complete -c gcc -o malpha-as -d 'Select whether to generate code to be assembled by the vendor-supplied assembler (-malpha-as) or by the GNU assembler -mgas'
complete -c gcc -o mgas -d 'Select whether to generate code to be assembled by the vendor-supplied assembler (-malpha-as) or by the GNU assembler -mgas'
complete -c gcc -o mbwx -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-bwx -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mcix -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-cix -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mfix -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-fix -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mmax -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-max -d 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mfloat-vax -d 'Generate code that uses (does not use) VAX F and G floating point arithmetic instead of IEEE single and double precision'
complete -c gcc -o mfloat-ieee -d 'Generate code that uses (does not use) VAX F and G floating point arithmetic instead of IEEE single and double precision'
complete -c gcc -o mexplicit-relocs -d 'Older Alpha assemblers provided no way to generate symbol relocations except via assembler macros'
complete -c gcc -o mno-explicit-relocs -d 'Older Alpha assemblers provided no way to generate symbol relocations except via assembler macros'
complete -c gcc -o msmall-data -d 'When -mexplicit-relocs is in effect, static data is accessed via gp-relative relocations'
complete -c gcc -o mlarge-data -d 'When -mexplicit-relocs is in effect, static data is accessed via gp-relative relocations'
complete -c gcc -o msmall-text -d 'Assumes that the code of the entire program (or shared library) fits in 4MB, and is thus reachable with a branch instruction'
complete -c gcc -o mlarge-text -d 'Does not assume that the code of the entire program (or shared library) fits in 4MB, and is thus reachable with a branch instruction'
complete -c gcc -o mcpu -d '=cpu_type Set the instruction set and instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mtune -d '=cpu_type Set only the instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mmemory-latency -d '=time Sets the latency the scheduler should assume for typical memory references as seen by the application'
complete -c gcc -o mvms-return-codes -d 'Return VMS condition codes from main'
complete -c gcc -o mgpr-32 -d 'Only use the first 32 general purpose registers'
complete -c gcc -o mgpr-64 -d 'Use all 64 general purpose registers'
complete -c gcc -o mfpr-32 -d 'Use only the first 32 floating point registers'
complete -c gcc -o mfpr-64 -d 'Use hardware instructions for floating point operations'
complete -c gcc -o mhard-float -d 'Use hardware instructions for floating point operations'
complete -c gcc -o msoft-float -d 'Use library routines for floating point operations'
complete -c gcc -o malloc-cc -d 'Dynamically allocate condition code registers'
complete -c gcc -o mfixed-cc -d 'Do not try to dynamically allocate condition code registers, only use "icc0" and "fcc0"'
complete -c gcc -o mdword -d 'Change ABI to use double word insns'
complete -c gcc -o mno-dword -d 'Do not use double word instructions'
complete -c gcc -o mdouble -d 'Use floating point double instructions'
complete -c gcc -o mno-double -d 'Do not use floating point double instructions'
complete -c gcc -o mmedia -d 'Use media instructions'
complete -c gcc -o mno-media -d 'Do not use media instructions'
complete -c gcc -o mmuladd -d 'Use multiply and add/subtract instructions'
complete -c gcc -o mno-muladd -d 'Do not use multiply and add/subtract instructions'
complete -c gcc -o mfdpic -d 'Select the FDPIC ABI, that uses function descriptors to represent pointers to functions'
complete -c gcc -o minline-plt -d 'Enable inlining of PLT entries in function calls to functions that are not known to bind locally'
complete -c gcc -o mTLS -d 'Assume a large TLS segment when generating thread-local code'
complete -c gcc -o mtls -d 'Do not assume a large TLS segment when generating thread-local code'
complete -c gcc -o mgprel-ro -d 'Enable the use of "GPREL" relocations in the FDPIC ABI for data that is known to be in read-only sections'
complete -c gcc -o multilib-library-pic -d 'Link with the (library, not FD) pic libraries'
complete -c gcc -o mlinked-fp -d 'Follow the EABI requirement of always creating a frame pointer whenever a stack frame is allocated'
complete -c gcc -o mlong-calls -d 'Use indirect addressing to call functions outside the current compilation unit'
complete -c gcc -o malign-labels -d 'Try to align labels to an 8-byte boundary by inserting nops into the previous packet'
complete -c gcc -o mlibrary-pic -d 'Generate position-independent EABI code'
complete -c gcc -o macc-4 -d 'Use only the first four media accumulator registers'
complete -c gcc -o macc-8 -d 'Use all eight media accumulator registers'
complete -c gcc -o mpack -d 'Pack VLIW instructions'
complete -c gcc -o mno-pack -d 'Do not pack VLIW instructions'
complete -c gcc -o mno-eflags -d 'Do not mark ABI switches in e_flags'
complete -c gcc -o mcond-move -d 'Enable the use of conditional-move instructions (default)'
complete -c gcc -o mno-cond-move -d 'Disable the use of conditional-move instructions'
complete -c gcc -o mscc -d 'Enable the use of conditional set instructions (default)'
complete -c gcc -o mno-scc -d 'Disable the use of conditional set instructions'
complete -c gcc -o mcond-exec -d 'Enable the use of conditional execution (default)'
complete -c gcc -o mno-cond-exec -d 'Disable the use of conditional execution'
complete -c gcc -o mvliw-branch -d 'Run a pass to pack branches into VLIW instructions (default)'
complete -c gcc -o mno-vliw-branch -d 'Do not run a pass to pack branches into VLIW instructions'
complete -c gcc -o mmulti-cond-exec -d 'Enable optimization of "&&" and "││" in conditional execution (default)'
complete -c gcc -o mno-multi-cond-exec -d 'Disable optimization of "&&" and "││" in conditional execution'
complete -c gcc -o mnested-cond-exec -d 'Enable nested conditional execution optimizations (default)'
complete -c gcc -o mno-nested-cond-exec -d 'Disable nested conditional execution optimizations'
complete -c gcc -o moptimize-membar -d 'This switch removes redundant "membar" instructions from the compiler generated code'
complete -c gcc -o mno-optimize-membar -d 'This switch disables the automatic removal of redundant "membar" instructions from the generated code'
complete -c gcc -o mtomcat-stats -d 'Cause gas to print out tomcat statistics'
complete -c gcc -o mcpu -d '=cpu Select the processor type for which to generate code'
complete -c gcc -o mrelax -d 'Shorten some address references at link time, when possible; uses the linker option -relax'
complete -c gcc -o mh -d 'Generate code for the H8/300H'
complete -c gcc -o ms -d 'Generate code for the H8S'
complete -c gcc -o mn -d 'Generate code for the H8S and H8/300H in the normal mode'
complete -c gcc -o ms2600 -d 'Generate code for the H8S/2600'
complete -c gcc -o mint32 -d 'Make "int" data 32 bits by default'
complete -c gcc -o malign-300 -d 'On the H8/300H and H8S, use the same alignment rules as for the H8/300'
complete -c gcc -o march -d 'Generate code for the specified architecture'
complete -c gcc -o type -d 'Generate code for the specified architecture'
complete -c gcc -o mpa-risc-1-0 -d 'Synonyms for -march=1'
complete -c gcc -o mpa-risc-1-1 -d 'Synonyms for -march=1'
complete -c gcc -o mpa-risc-2-0 -d 'Synonyms for -march=1'
complete -c gcc -o mbig-switch -d 'Generate code suitable for big switch tables'
complete -c gcc -o mjump-in-delay -d 'Fill delay slots of function calls with unconditional jump instructions by modifying the return pointer for the function call to be the target of the conditional jump'
complete -c gcc -o mdisable-fpregs -d 'Prevent floating point registers from being used in any manner'
complete -c gcc -o mdisable-indexing -d 'Prevent the compiler from using indexing address modes'
complete -c gcc -o mno-space-regs -d 'Generate code that assumes the target has no space registers'
complete -c gcc -o mfast-indirect-calls -d 'Generate code that assumes calls never cross space boundaries'
complete -c gcc -o mfixed-range -d 'Generate code treating the given register range as fixed registers'
complete -c gcc -o range -d 'Generate code treating the given register range as fixed registers'
complete -c gcc -o mlong-load-store -d 'Generate 3-instruction load and store sequences as sometimes required by the HP-UX 10 linker'
complete -c gcc -o mportable-runtime -d 'Use the portable calling conventions proposed by HP for ELF systems'
complete -c gcc -o mgas -d 'Enable the use of assembler directives only GAS understands'
complete -c gcc -o mschedule -d 'Schedule code according to the constraints for the machine type cpu-type'
complete -c gcc -o type -d 'Schedule code according to the constraints for the machine type cpu-type'
complete -c gcc -o mlinker-opt -d 'Enable the optimization pass in the HP-UX linker'
complete -c gcc -o msoft-float -d 'Generate output containing library calls for floating point'
complete -c gcc -o msio -d 'Generate the predefine, "_SIO", for server IO'
complete -c gcc -o mgnu-ld -d 'Use GNU ld specific options'
complete -c gcc -o mhp-ld -d 'Use HP ld specific options'
complete -c gcc -o mlong-calls -d 'Generate code that uses long call sequences'
complete -c gcc -o munix -d 'Generate compiler predefines and select a startfile for the specified UNIX standard'
complete -c gcc -o std -d 'Generate compiler predefines and select a startfile for the specified UNIX standard'
complete -c gcc -o nolibdld -d 'Suppress the generation of link options to search libdld'
complete -c gcc -o static -d 'The HP-UX implementation of setlocale in libc has a dependency on libdld'
complete -c gcc -o threads -d 'Add support for multithreading with the dce thread library under HP-UX'
complete -c gcc -o mtune -d 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o type -d 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o march -d 'Generate instructions for the machine type cpu-type'
complete -c gcc -o type -d 'Generate instructions for the machine type cpu-type'
complete -c gcc -o mcpu -d 'A deprecated synonym for -mtune'
complete -c gcc -o type -d 'A deprecated synonym for -mtune'
complete -c gcc -o m386 -d 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o m486 -d 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o mpentium -d 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o mpentiumpro -d 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o mfpmath -d '=unit Generate floating point arithmetics for selected unit unit'
complete -c gcc -o masm -d '=dialect Output asm instructions using selected dialect'
complete -c gcc -o mieee-fp -d 'Control whether or not the compiler uses IEEE floating point comparisons'
complete -c gcc -o mno-ieee-fp -d 'Control whether or not the compiler uses IEEE floating point comparisons'
complete -c gcc -o msoft-float -d 'Generate output containing library calls for floating point'
complete -c gcc -o mno-fp-ret-in-387 -d 'Do not use the FPU registers for return values of functions'
complete -c gcc -o mno-fancy-math-387 -d 'Some 387 emulators do not support the "sin", "cos" and "sqrt" instructions for the 387'
complete -c gcc -o malign-double -d 'Aligns "double", "long double", and "long long" variables on a two word boundary'
complete -c gcc -o mno-align-double -d 'Aligns "double", "long double", and "long long" variables on a one word boundary'
complete -c gcc -o m96bit-long-double -d 'These switches control the size of "long double" type'
complete -c gcc -o m128bit-long-double -d 'These switches control the size of "long double" type'
complete -c gcc -o mmlarge-data-threshold -d '=number When -mcmodel=medium is specified, the data greater than threshold are placed in large data section'
complete -c gcc -o msvr3-shlib -d 'Control whether GCC places uninitialized local variables into the "bss" or "data" segments'
complete -c gcc -o mno-svr3-shlib -d 'Control whether GCC places uninitialized local variables into the "bss" or "data" segments'
complete -c gcc -o mrtd -d 'Use a different function-calling convention, in which functions that take a fixed number of arguments return with the "ret" num instruction, which pops their arguments while returning'
complete -c gcc -o mregparm -d '=num Control how many registers are used to pass integer arguments'
complete -c gcc -o msseregparm -d 'Use SSE register passing conventions for float and double arguments and return values'
complete -c gcc -o mpreferred-stack-boundary -d '=num Attempt to keep the stack boundary aligned to a 2 raised to num byte boundary'
complete -c gcc -o mmmx -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-mmx -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o msse -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-sse -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o msse2 -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-sse2 -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o msse3 -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-sse3 -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mmni -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-mni -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o m3dnow -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-3dnow -d 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mpush-args -d 'Use PUSH operations to store outgoing parameters'
complete -c gcc -o mno-push-args -d 'Use PUSH operations to store outgoing parameters'
complete -c gcc -o maccumulate-outgoing-args -d 'The maximum amount of space required for outgoing arguments will be computed in the function prologue'
complete -c gcc -o mthreads -d 'Support thread-safe exception handling on Mingw32'
complete -c gcc -o mno-align-stringops -d 'Do not align destination of inlined string operations'
complete -c gcc -o minline-all-stringops -d 'By default GCC inlines string operations only when destination is known to be aligned at least to 4 byte boundary'
complete -c gcc -o momit-leaf-frame-pointer -d 'Don’t keep the frame pointer in a register for leaf functions'
complete -c gcc -o mtls-direct-seg-refs -d 'Controls whether TLS variables may be accessed with offsets from the TLS segment register (%gs for 32-bit, %fs for 64-bit), or whether the thread base pointer must be added'
complete -c gcc -o mno-tls-direct-seg-refs -d 'Controls whether TLS variables may be accessed with offsets from the TLS segment register (%gs for 32-bit, %fs for 64-bit), or whether the thread base pointer must be added'
complete -c gcc -o m32 -d 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o m64 -d 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mno-red-zone -d 'Do not use a so called red zone for x86-64 code'
complete -c gcc -o mcmodel -d '=small Generate code for the small code model: the program and its symbols must be linked in the lower 2 GB of the address space'
complete -c gcc -o mcmodel -d '=kernel Generate code for the kernel code model'
complete -c gcc -o mcmodel -d '=medium Generate code for the medium model: The program is linked in the lower 2 GB of the address space but symbols can be located anywhere in the address space'
complete -c gcc -o mcmodel -d '=large Generate code for the large model: This model makes no assumptions about addresses and sizes of sections'
complete -c gcc -o mbig-endian -d 'Generate code for a big endian target'
complete -c gcc -o mlittle-endian -d 'Generate code for a little endian target'
complete -c gcc -o mgnu-as -d 'Generate (or don’t) code for the GNU assembler'
complete -c gcc -o mno-gnu-as -d 'Generate (or don’t) code for the GNU assembler'
complete -c gcc -o mgnu-ld -d 'Generate (or don’t) code for the GNU linker'
complete -c gcc -o mno-gnu-ld -d 'Generate (or don’t) code for the GNU linker'
complete -c gcc -o mno-pic -d 'Generate code that does not use a global pointer register'
complete -c gcc -o mvolatile-asm-stop -d 'Generate (or don’t) a stop bit immediately before and after volatile asm statements'
complete -c gcc -o mno-volatile-asm-stop -d 'Generate (or don’t) a stop bit immediately before and after volatile asm statements'
complete -c gcc -o mregister-names -d 'Generate (or don’t) in, loc, and out register names for the stacked registers'
complete -c gcc -o mno-register-names -d 'Generate (or don’t) in, loc, and out register names for the stacked registers'
complete -c gcc -o mno-sdata -d 'Disable (or enable) optimizations that use the small data section'
complete -c gcc -o msdata -d 'Disable (or enable) optimizations that use the small data section'
complete -c gcc -o mconstant-gp -d 'Generate code that uses a single constant global pointer value'
complete -c gcc -o mauto-pic -d 'Generate code that is self-relocatable'
complete -c gcc -o minline-float-divide-min-latency -d 'Generate code for inline divides of floating point values using the minimum latency algorithm'
complete -c gcc -o minline-float-divide-max-throughput -d 'Generate code for inline divides of floating point values using the maximum throughput algorithm'
complete -c gcc -o minline-int-divide-min-latency -d 'Generate code for inline divides of integer values using the minimum latency algorithm'
complete -c gcc -o minline-int-divide-max-throughput -d 'Generate code for inline divides of integer values using the maximum throughput algorithm'
complete -c gcc -o minline-sqrt-min-latency -d 'Generate code for inline square roots using the minimum latency algorithm'
complete -c gcc -o minline-sqrt-max-throughput -d 'Generate code for inline square roots using the maximum throughput algorithm'
complete -c gcc -o mno-dwarf2-asm -d 'Don’t (or do) generate assembler code for the DWARF2 line number debugging info'
complete -c gcc -o mdwarf2-asm -d 'Don’t (or do) generate assembler code for the DWARF2 line number debugging info'
complete -c gcc -o mearly-stop-bits -d 'Allow stop bits to be placed earlier than immediately preceding the instruction that triggered the stop bit'
complete -c gcc -o mno-early-stop-bits -d 'Allow stop bits to be placed earlier than immediately preceding the instruction that triggered the stop bit'
complete -c gcc -o mfixed-range -d 'Generate code treating the given register range as fixed registers'
complete -c gcc -o range -d 'Generate code treating the given register range as fixed registers'
complete -c gcc -o mtls-size -d 'Specify bit size of immediate TLS offsets'
complete -c gcc -o size -d 'Specify bit size of immediate TLS offsets'
complete -c gcc -o mtune -d 'Tune the instruction scheduling for a particular CPU, Valid values are itanium, itanium1, merced, itanium2, and mckinley'
complete -c gcc -o type -d 'Tune the instruction scheduling for a particular CPU, Valid values are itanium, itanium1, merced, itanium2, and mckinley'
complete -c gcc -o mt -d 'Add support for multithreading using the POSIX threads library'
complete -c gcc -o pthread -d 'Add support for multithreading using the POSIX threads library'
complete -c gcc -o milp32 -d 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mlp64 -d 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mcpu -d '=name Select the CPU for which code is generated'
complete -c gcc -o msim -d 'Specifies that the program will be run on the simulator'
complete -c gcc -o memregs -d '=number Specifies the number of memory-based pseudo-registers GCC will use during code generation'
complete -c gcc -o m32r2 -d 'Generate code for the M32R/2'
complete -c gcc -o m32rx -d 'Generate code for the M32R/X'
complete -c gcc -o m32r -d 'Generate code for the M32R'
complete -c gcc -o mmodel -d '=small Assume all objects live in the lower 16MB of memory (so that their addresses can be loaded with the "ld24" instruction), and assume all subroutines are reachable with the "bl" instruction'
complete -c gcc -o mmodel -d '=medium Assume objects may be anywhere in the 32-bit address space (the compiler will generate "seth/add3" instructions to load their addresses), and assume all subroutines are reachable with the "bl" instruction'
complete -c gcc -o mmodel -d '=large Assume objects may be anywhere in the 32-bit address space (the compiler will generate "seth/add3" instructions to load their addresses), and assume subroutines may not be reachable with the "bl" instruction (the compiler will generate the much slower "seth/add3/jl" instruction sequence)'
complete -c gcc -o msdata -d '=none Disable use of the small data area'
complete -c gcc -o msdata -d '=sdata Put small global and static data in the small data area, but do not generate special code to reference them'
complete -c gcc -o msdata -d '=use Put small global and static data in the small data area, and generate special instructions to reference them'
complete -c gcc -s G -d 'Put global and static objects less than or equal to num bytes into the small data or bss sections instead of the normal data or bss sections'
complete -c gcc -o mdebug -d 'Makes the M32R specific code in the compiler display some statistics that might help in debugging programs'
complete -c gcc -o malign-loops -d 'Align all loops to a 32-byte boundary'
complete -c gcc -o mno-align-loops -d 'Do not enforce a 32-byte alignment for loops'
complete -c gcc -o missue-rate -d '=number Issue number instructions per cycle'
complete -c gcc -o mbranch-cost -d '=number number can only be 1 or 2'
complete -c gcc -o mflush-trap -d '=number Specifies the trap number to use to flush the cache'
complete -c gcc -o mno-flush-trap -d 'Specifies that the cache cannot be flushed by using a trap'
complete -c gcc -o mflush-func -d '=name Specifies the name of the operating system function to call to flush the cache'
complete -c gcc -o mno-flush-func -d 'Indicates that there is no OS function for flushing the cache'
complete -c gcc -o m68000 -d 'Generate output for a 68000'
complete -c gcc -o mc68000 -d 'Generate output for a 68000'
complete -c gcc -o m68020 -d 'Generate output for a 68020'
complete -c gcc -o mc68020 -d 'Generate output for a 68020'
complete -c gcc -o m68881 -d 'Generate output containing 68881 instructions for floating point'
complete -c gcc -o m68030 -d 'Generate output for a 68030'
complete -c gcc -o m68040 -d 'Generate output for a 68040'
complete -c gcc -o m68060 -d 'Generate output for a 68060'
complete -c gcc -o mcpu32 -d 'Generate output for a CPU32'
complete -c gcc -o m5200 -d 'Generate output for a 520X "coldfire" family cpu'
complete -c gcc -o m68020-40 -d 'Generate output for a 68040, without using any of the new instructions'
complete -c gcc -o m68020-60 -d 'Generate output for a 68060, without using any of the new instructions'
complete -c gcc -o msoft-float -d 'Generate output containing library calls for floating point'
complete -c gcc -o mshort -d 'Consider type "int" to be 16 bits wide, like "short int"'
complete -c gcc -o mnobitfield -d 'Do not use the bit-field instructions'
complete -c gcc -o mbitfield -d 'Do use the bit-field instructions'
complete -c gcc -o mrtd -d 'Use a different function-calling convention, in which functions that take a fixed number of arguments return with the "rtd" instruction, which pops their arguments while returning'
complete -c gcc -o malign-int -d 'Make GCC align "int", "long", "long long", "float", "double", and "long double" variables on a 32-bit boundary'
complete -c gcc -o mno-align-int -d 'Make GCC aligns "int", "long", "long long", "float", "double", and "long double" variables on 16-bit boundary'
complete -c gcc -o mpcrel -d 'Use the pc-relative addressing mode of the 68000 directly, instead of using a global offset table'
complete -c gcc -o mno-strict-align -d 'Do not (do) assume that unaligned memory references will be handled by the system'
complete -c gcc -o mstrict-align -d 'Do not (do) assume that unaligned memory references will be handled by the system'
complete -c gcc -o msep-data -d 'Generate code that allows the data segment to be located in a different area of memory from the text segment'
complete -c gcc -o mno-sep-data -d 'Generate code that assumes that the data segment follows the text segment'
complete -c gcc -o mid-shared-library -d 'Generate code that supports shared libraries via the library ID method'
complete -c gcc -o mno-id-shared-library -d 'Generate code that doesn’t assume ID based shared libraries are being used'
complete -c gcc -o mshared-library-id -d '=n Specified the identification number of the ID based shared library being compiled'
complete -c gcc -o m6811 -d 'Generate output for a 68HC11'
complete -c gcc -o m68hc11 -d 'Generate output for a 68HC11'
complete -c gcc -o m6812 -d 'Generate output for a 68HC12'
complete -c gcc -o m68hc12 -d 'Generate output for a 68HC12'
complete -c gcc -o m68S12 -d 'Generate output for a 68HCS12'
complete -c gcc -o m68hcs12 -d 'Generate output for a 68HCS12'
complete -c gcc -o mauto-incdec -d 'Enable the use of 68HC12 pre and post auto-increment and autodecrement addressing modes'
complete -c gcc -o minmax -d 'Enable the use of 68HC12 min and max instructions'
complete -c gcc -o nominmax -d 'Enable the use of 68HC12 min and max instructions'
complete -c gcc -o mlong-calls -d 'Treat all calls as being far away (near)'
complete -c gcc -o mno-long-calls -d 'Treat all calls as being far away (near)'
complete -c gcc -o mshort -d 'Consider type "int" to be 16 bits wide, like "short int"'
complete -c gcc -o msoft-reg-count -d '=count Specify the number of pseudo-soft registers which are used for the code generation'
complete -c gcc -o mhardlit -d 'Inline constants into the code stream if it can be done in two instructions or less'
complete -c gcc -o mno-hardlit -d 'Inline constants into the code stream if it can be done in two instructions or less'
complete -c gcc -o mdiv -d 'Use the divide instruction'
complete -c gcc -o mno-div -d 'Use the divide instruction'
complete -c gcc -o mrelax-immediate -d 'Allow arbitrary sized immediates in bit operations'
complete -c gcc -o mno-relax-immediate -d 'Allow arbitrary sized immediates in bit operations'
complete -c gcc -o mwide-bitfields -d 'Always treat bit-fields as int-sized'
complete -c gcc -o mno-wide-bitfields -d 'Always treat bit-fields as int-sized'
complete -c gcc -o m4byte-functions -d 'Force all functions to be aligned to a four byte boundary'
complete -c gcc -o mno-4byte-functions -d 'Force all functions to be aligned to a four byte boundary'
complete -c gcc -o mcallgraph-data -d 'Emit callgraph information'
complete -c gcc -o mno-callgraph-data -d 'Emit callgraph information'
complete -c gcc -o mslow-bytes -d 'Prefer word access when reading byte quantities'
complete -c gcc -o mno-slow-bytes -d 'Prefer word access when reading byte quantities'
complete -c gcc -o mlittle-endian -d 'Generate code for a little endian target'
complete -c gcc -o mbig-endian -d 'Generate code for a little endian target'
complete -c gcc -o m210 -d 'Generate code for the 210 processor'
complete -c gcc -o m340 -d 'Generate code for the 210 processor'
complete -c gcc -o EB -d 'Generate big-endian code'
complete -c gcc -o EL -d 'Generate little-endian code'
complete -c gcc -o march -d '=arch Generate code that will run on arch, which can be the name of a generic MIPS ISA, or the name of the processor'
complete -c gcc -o mtune -d '=arch Optimize for arch'
complete -c gcc -o mips1 -d 'Equivalent to -march=mips1'
complete -c gcc -o mips2 -d 'Equivalent to -march=mips2'
complete -c gcc -o mips3 -d 'Equivalent to -march=mips3'
complete -c gcc -o mips4 -d 'Equivalent to -march=mips4'
complete -c gcc -o mips32 -d 'Equivalent to -march=mips32'
complete -c gcc -o mips32r2 -d 'Equivalent to -march=mips32r2'
complete -c gcc -o mips64 -d 'Equivalent to -march=mips64'
complete -c gcc -o mips16 -d 'Generate MIPS16 code'
complete -c gcc -o mno-mips16 -d 'Do not generate MIPS16 code'
complete -c gcc -o mabi -d '=eabi Generate code for the given ABI'
complete -c gcc -o mabicalls -d 'Generate (do not generate) SVR4-style position-independent code'
complete -c gcc -o mno-abicalls -d 'Generate (do not generate) SVR4-style position-independent code'
complete -c gcc -o mxgot -d 'Lift (do not lift) the usual restrictions on the size of the global offset table'
complete -c gcc -o mno-xgot -d 'Lift (do not lift) the usual restrictions on the size of the global offset table'
complete -c gcc -o mgp32 -d 'Assume that general-purpose registers are 32 bits wide'
complete -c gcc -o mgp64 -d 'Assume that general-purpose registers are 64 bits wide'
complete -c gcc -o mfp32 -d 'Assume that floating-point registers are 32 bits wide'
complete -c gcc -o mfp64 -d 'Assume that floating-point registers are 64 bits wide'
complete -c gcc -o mhard-float -d 'Use floating-point coprocessor instructions'
complete -c gcc -o msoft-float -d 'Do not use floating-point coprocessor instructions'
complete -c gcc -o msingle-float -d 'Assume that the floating-point coprocessor only supports singleprecision operations'
complete -c gcc -o mdouble-float -d 'Assume that the floating-point coprocessor supports double-precision operations'
complete -c gcc -o mdsp -d 'Use (do not use) the MIPS DSP ASE'
complete -c gcc -o mno-dsp -d 'Use (do not use) the MIPS DSP ASE'
complete -c gcc -o mpaired-single -d 'Use (do not use) paired-single floating-point instructions'
complete -c gcc -o mno-paired-single -d 'Use (do not use) paired-single floating-point instructions'
complete -c gcc -o mips3d -d 'Use (do not use) the MIPS-3D ASE'
complete -c gcc -o mno-mips3d -d 'Use (do not use) the MIPS-3D ASE'
complete -c gcc -o mlong64 -d 'Force "long" types to be 64 bits wide'
complete -c gcc -o mlong32 -d 'Force "long", "int", and pointer types to be 32 bits wide'
complete -c gcc -o msym32 -d 'Assume that all symbols have 32-bit values, regardless of the selected ABI'
complete -c gcc -o mno-sym32 -d 'Do not assume that all symbols have 32-bit values, regardless of the selected ABI'
complete -c gcc -s G -d 'Put global and static items less than or equal to num bytes into the small data or bss section instead of the normal one'
complete -c gcc -o membedded-data -d 'Allocate variables if possible to the read-only data section first, then in the small data section, otherwise in data'
complete -c gcc -o mno-embedded-data -d 'Does not allocate variables if possible to the read-only data section first, then in the small data section, otherwise in data'
complete -c gcc -o muninit-const-in-rodata -d 'Put uninitialized "const" variables in the read-only data section'
complete -c gcc -o mno-uninit-const-in-rodata -d 'Put uninitialized "const" variables in the read-only data section'
complete -c gcc -o msplit-addresses -d 'Enable (disable) use of the "%hi()" and "%lo()" assembler relocation operators'
complete -c gcc -o mno-split-addresses -d 'Enable (disable) use of the "%hi()" and "%lo()" assembler relocation operators'
complete -c gcc -o mexplicit-relocs -d 'Use (do not use) assembler relocation operators when dealing with symbolic addresses'
complete -c gcc -o mno-explicit-relocs -d 'Use (do not use) assembler relocation operators when dealing with symbolic addresses'
complete -c gcc -o mcheck-zero-division -d 'Trap (do not trap) on integer division by zero'
complete -c gcc -o mno-check-zero-division -d 'Trap (do not trap) on integer division by zero'
complete -c gcc -o mdivide-traps -d 'MIPS systems check for division by zero by generating either a conditional trap or a break instruction'
complete -c gcc -o mdivide-breaks -d 'MIPS systems check for division by zero by generating either a conditional trap or a break instruction'
complete -c gcc -o mmemcpy -d 'Force (do not force) the use of "memcpy()" for non-trivial block moves'
complete -c gcc -o mno-memcpy -d 'Force (do not force) the use of "memcpy()" for non-trivial block moves'
complete -c gcc -o mlong-calls -d 'Disable (do not disable) use of the "jal" instruction'
complete -c gcc -o mno-long-calls -d 'Disable (do not disable) use of the "jal" instruction'
complete -c gcc -o mmad -d 'Enable (disable) use of the "mad", "madu" and "mul" instructions, as provided by the R4650 ISA'
complete -c gcc -o mno-mad -d 'Enable (disable) use of the "mad", "madu" and "mul" instructions, as provided by the R4650 ISA'
complete -c gcc -o mfused-madd -d 'Enable (disable) use of the floating point multiply-accumulate instructions, when they are available'
complete -c gcc -o mno-fused-madd -d 'Enable (disable) use of the floating point multiply-accumulate instructions, when they are available'
complete -c gcc -o nocpp -d 'Tell the MIPS assembler to not run its preprocessor over user assembler files (with a '
complete -c gcc -o mfix-r4000 -d 'Work around certain R4000 CPU errata'
complete -c gcc -o mno-fix-r4000 -d 'Does not work around certain R4000 CPU errata'
complete -c gcc -o mfix-r4400 -d 'Work around certain R4400 CPU errata'
complete -c gcc -o mno-fix-r4400 -d 'Does not work around certain R4400 CPU errata'
complete -c gcc -o mfix-vr4120 -d 'Work around certain VR4120 errata'
complete -c gcc -o mno-fix-vr4120 -d 'Does not work around certain VR4120 errata'
complete -c gcc -o mfix-vr4130 -d 'Work around the VR4130 "mflo"/"mfhi" errata'
complete -c gcc -o mfix-sb1 -d 'Work around certain SB-1 CPU core errata'
complete -c gcc -o mno-fix-sb1 -d 'Does not work around certain SB-1 CPU core errata'
complete -c gcc -o mflush-func -d 'Specifies the function to call to flush the I and D caches'
complete -c gcc -o mno-flush-func -d 'Specifies to not call the function to flush the I and D caches'
complete -c gcc -o mbranch-likely -d 'Enable use of Branch Likely instructions, regardless of the default for the selected architecture'
complete -c gcc -o mno-branch-likely -d 'Disable use of Branch Likely instructions, regardless of the default for the selected architecture'
complete -c gcc -o mfp-exceptions -d 'Specifies whether FP exceptions are enabled'
complete -c gcc -o mno-fp-exceptions -d 'Specifies whether FP exceptions are enabled'
complete -c gcc -o mvr4130-align -d 'VR4130 pipeline is two-way superscalar, but can only issue two instructions together if the first one is 8-byte aligned'
complete -c gcc -o mno-vr4130-align -d 'VR4130 pipeline is two-way superscalar, but can only issue two instructions together if the first one is 8-byte aligned'
complete -c gcc -o mlibfuncs -d 'Specify that intrinsic library functions are being compiled, passing all values in registers, no matter the size'
complete -c gcc -o mno-libfuncs -d 'Specify that intrinsic library functions are being compiled, passing all values in registers, no matter the size'
complete -c gcc -o mepsilon -d 'Generate floating-point comparison instructions that compare with respect to the "rE" epsilon register'
complete -c gcc -o mno-epsilon -d 'Generate floating-point comparison instructions that compare with respect to the "rE" epsilon register'
complete -c gcc -o mabi -d '=gnu Generate code that passes function parameters and return values that (in the called function) are seen as registers $0 and up, as opposed to the GNU ABI which uses global registers $231 and up'
complete -c gcc -o mzero-extend -d 'When reading data from memory in sizes shorter than 64 bits, use zero-extending load instructions by default, rather than sign-extending ones'
complete -c gcc -o mno-zero-extend -d 'When reading data from memory in sizes shorter than 64 bits, do not use zero-extending load instructions by default, rather than sign-extending ones'
complete -c gcc -o mknuthdiv -d 'Make the result of a division yielding a remainder have the same sign as the divisor'
complete -c gcc -o mno-knuthdiv -d 'Make the result of a division yielding a remainder have the same sign as the divisor'
complete -c gcc -o mtoplevel-symbols -d 'Prepend a : to all global symbols, so the assembly code can be used with the "PREFIX" assembly directive'
complete -c gcc -o mno-toplevel-symbols -d 'Do not prepend a : to all global symbols, so the assembly code can be used with the "PREFIX" assembly directive'
complete -c gcc -o melf -d 'Generate an executable in the ELF format, rather than the default mmo format used by the mmix simulator'
complete -c gcc -o mbranch-predict -d 'Use (do not use) the probable-branch instructions, when static branch prediction indicates a probable branch'
complete -c gcc -o mno-branch-predict -d 'Use (do not use) the probable-branch instructions, when static branch prediction indicates a probable branch'
complete -c gcc -o mbase-addresses -d 'Generate (do not generate) code that uses base addresses'
complete -c gcc -o mno-base-addresses -d 'Generate (do not generate) code that uses base addresses'
complete -c gcc -o msingle-exit -d 'Force (do not force) generated code to have a single exit point in each function'
complete -c gcc -o mno-single-exit -d 'Force (do not force) generated code to have a single exit point in each function'
complete -c gcc -o mmult-bug -d 'Generate code to avoid bugs in the multiply instructions for the MN10300 processors'
complete -c gcc -o mno-mult-bug -d 'Do not generate code to avoid bugs in the multiply instructions for the MN10300 processors'
complete -c gcc -o mam33 -d 'Generate code which uses features specific to the AM33 processor'
complete -c gcc -o mno-am33 -d 'Do not generate code which uses features specific to the AM33 processor'
complete -c gcc -o mreturn-pointer-on-d0 -d 'When generating a function which returns a pointer, return the pointer in both "a0" and "d0"'
complete -c gcc -o mno-crt0 -d 'Do not link in the C run-time initialization object file'
complete -c gcc -o mrelax -d 'Tell the linker it should perform a relaxation optimization to shorten branches, calls and absolute memory addresses'
complete -c gcc -o march -d 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o type -d 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o mbacc -d 'Use byte loads and stores when generating code'
complete -c gcc -o mno-bacc -d 'Do not use byte loads and stores when generating code'
complete -c gcc -o msim -d 'Do not link in the C run-time initialization object file crti'
complete -c gcc -o mno-crt0 -d 'Do not link in the C run-time initialization object file crti'
complete -c gcc -o mfpu -d 'Use hardware FPP floating point'
complete -c gcc -o msoft-float -d 'Do not use hardware floating point'
complete -c gcc -o mac0 -d 'Return floating-point results in ac0 (fr0 in Unix assembler syntax)'
complete -c gcc -o mno-ac0 -d 'Return floating-point results in memory'
complete -c gcc -o m40 -d 'Generate code for a PDP-11/40'
complete -c gcc -o m45 -d 'Generate code for a PDP-11/45'
complete -c gcc -o m10 -d 'Generate code for a PDP-11/10'
complete -c gcc -o mbcopy-builtin -d 'Use inline "movmemhi" patterns for copying memory'
complete -c gcc -o mbcopy -d 'Do not use inline "movmemhi" patterns for copying memory'
complete -c gcc -o mint16 -d 'Use 16-bit "int"'
complete -c gcc -o mno-int32 -d 'Use 16-bit "int"'
complete -c gcc -o mint32 -d 'Use 32-bit "int"'
complete -c gcc -o mno-int16 -d 'Use 32-bit "int"'
complete -c gcc -o mfloat64 -d 'Use 64-bit "float"'
complete -c gcc -o mno-float32 -d 'Use 64-bit "float"'
complete -c gcc -o mfloat32 -d 'Use 32-bit "float"'
complete -c gcc -o mno-float64 -d 'Use 32-bit "float"'
complete -c gcc -o mabshi -d 'Use "abshi2" pattern'
complete -c gcc -o mno-abshi -d 'Do not use "abshi2" pattern'
complete -c gcc -o mbranch-expensive -d 'Pretend that branches are expensive'
complete -c gcc -o mbranch-cheap -d 'Do not pretend that branches are expensive'
complete -c gcc -o msplit -d 'Generate code for a system with split I&D'
complete -c gcc -o mno-split -d 'Generate code for a system without split I&D'
complete -c gcc -o munix-asm -d 'Use Unix assembler syntax'
complete -c gcc -o mdec-asm -d 'Use DEC assembler syntax'
complete -c gcc -o mpower -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-power -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpower2 -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-power2 -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc-gpopt -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc-gpopt -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc-gfxopt -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc-gfxopt -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc64 -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc64 -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mmfcrf -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-mfcrf -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpopcntb -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-popcntb -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mfprnd -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-fprnd -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mmfpgpr -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-mfpgpr -d 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mnew-mnemonics -d 'Select which mnemonics to use in the generated assembler code'
complete -c gcc -o mold-mnemonics -d 'Select which mnemonics to use in the generated assembler code'
complete -c gcc -o mcpu -d '=cpu_type Set architecture type, register usage, choice of mnemonics, and instruction scheduling parameters for type cpu_type'
complete -c gcc -o mtune -d '=cpu_type Set the instruction scheduling parameters for cpu_type, but do not set the architecture type, register usage, or choice of mnemonics, as -mcpu=cpu_type'
complete -c gcc -o mswdiv -d 'Generate code to compute division as reciprocal estimate and iterative refinement, creating opportunities for increased throughput'
complete -c gcc -o mno-swdiv -d 'Do not generate code to compute division as reciprocal estimate and iterative refinement, creating opportunities for increased throughput'
complete -c gcc -o maltivec -d 'Generate code that uses AltiVec instructions, and also enable the use of built-in functions that allow more direct access to the AltiVec instruction set'
complete -c gcc -o mno-altivec -d 'Generate code that does not use AltiVec instructions, and also enable the use of built-in functions that allow more direct access to the AltiVec instruction set'
complete -c gcc -o mvrsave -d 'Generate VRSAVE instructions when generating AltiVec code'
complete -c gcc -o mno-vrsave -d 'Generate VRSAVE instructions when generating AltiVec code'
complete -c gcc -o msecure-plt -d 'Generate code that allows ld and ld'
complete -c gcc -o mbss-plt -d 'Generate code that uses a BSS '
complete -c gcc -o misel -d 'This switch enables or disables the generation of ISEL instructions'
complete -c gcc -o mno-isel -d 'This switch enables or disables the generation of ISEL instructions'
complete -c gcc -o misel -d '=yes/no This switch has been deprecated'
complete -c gcc -o mspe -d 'This switch enables or disables the generation of SPE simd instructions'
complete -c gcc -o mno-isel -d 'This switch enables or disables the generation of SPE simd instructions'
complete -c gcc -o mspe -d '=yes/no Deprecated'
complete -c gcc -o mfloat-gprs -d 'This switch enables or disables the generation of floating point operations on the general purpose registers'
complete -c gcc -o m32 -d 'Generate code for 32-bit or 64-bit environments of Darwin and SVR4 targets (including GNU/Linux)'
complete -c gcc -o m64 -d 'Generate code for 32-bit or 64-bit environments of Darwin and SVR4 targets (including GNU/Linux)'
complete -c gcc -o mfull-toc -d 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o mno-fp-in-toc -d 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o mno-sum-in-toc -d 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o mminimal-toc -d 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o maix64 -d 'Enable 64-bit AIX ABI and calling convention: 64-bit pointers, 64-bit "long" type, and the infrastructure needed to support them'
complete -c gcc -o maix32 -d 'Enable 64-bit AIX ABI and calling convention: 64-bit pointers, 64-bit "long" type, and the infrastructure needed to support them'
complete -c gcc -o mxl-compat -d 'Produce code that conforms more closely to IBM XL compiler semantics when using AIX-compatible ABI'
complete -c gcc -o mno-xl-compat -d 'Produce code that conforms more closely to IBM XL compiler semantics when using AIX-compatible ABI'
complete -c gcc -o mpe -d 'Support IBM RS/6000 SP Parallel Environment (PE)'
complete -c gcc -o malign-natural -d 'On AIX, 32-bit Darwin, and 64-bit PowerPC GNU/Linux, the option -malign-natural overrides the ABI-defined alignment of larger types, such as floating-point doubles, on their natural size-based boundary'
complete -c gcc -o malign-power -d 'On AIX, 32-bit Darwin, and 64-bit PowerPC GNU/Linux, the option -malign-natural overrides the ABI-defined alignment of larger types, such as floating-point doubles, on their natural size-based boundary'
complete -c gcc -o msoft-float -d 'Generate code that does not use (uses) the floating-point register set'
complete -c gcc -o mhard-float -d 'Generate code that does not use (uses) the floating-point register set'
complete -c gcc -o mmultiple -d 'Generate code that uses (does not use) the load multiple word instructions and the store multiple word instructions'
complete -c gcc -o mno-multiple -d 'Generate code that uses (does not use) the load multiple word instructions and the store multiple word instructions'
complete -c gcc -o mstring -d 'Generate code that uses the load string and store string word instructions to save registers and do small block moves'
complete -c gcc -o mno-string -d 'Generate code that does not use the load string and store string word instructions to save registers and do small block moves'
complete -c gcc -o mupdate -d 'Generate code that uses the load or store instructions that update the base register to the address of the calculated memory location'
complete -c gcc -o mno-update -d 'Generate code that does not use the load or store instructions that update the base register to the address of the calculated memory location'
complete -c gcc -o mfused-madd -d 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mno-fused-madd -d 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mno-bit-align -d 'On System V.4 and embedded PowerPC do not force structures and unions that contain bit-fields to be aligned to the base type of the bit-field.'
complete -c gcc -o mbit-align -d 'On System V.4 and embedded PowerPC do force structures and unions that contain bit-fields to be aligned to the base type of the bit-field'
complete -c gcc -o mno-strict-align -d 'On System V.4 and embedded PowerPC do not assume that unaligned memory references are handled by the system'
complete -c gcc -o mstrict-align -d 'On System V.4 and embedded PowerPC do assume that unaligned memory references are handled by the syste'
complete -c gcc -o mrelocatable -d 'On embedded PowerPC generate code that allows the program to be relocated to a different address at runtime'
complete -c gcc -o mno-relocatable -d 'On embedded PowerPC generate code that does not allow the program to be relocated to a different address at runtime'
complete -c gcc -o mrelocatable-lib -d 'On embedded PowerPC generate code that allows the program to be relocated to a different address at runtime'
complete -c gcc -o mno-relocatable-lib -d 'On embedded PowerPC generate code that does not allow the program to be relocated to a different address at runtime'
complete -c gcc -o mno-toc -d 'On System V.4 and embedded PowerPC do not assume that register 2 contains a pointer to a global area pointing to the addresses used in the program'
complete -c gcc -o mtoc -d 'On System V.4 and embedded PowerPC do assume that register 2 contains a pointer to a global area pointing to the addresses used in the program'
complete -c gcc -o mlittle -d 'On System V.4 and embedded PowerPC compile code for the processor in little-endian mode'
complete -c gcc -o mlittle-endian -d 'On System V.4 and embedded PowerPC compile code for the processor in little-endian mode'
complete -c gcc -o mbig -d 'On System V.4 and embedded PowerPC compile code for the processor in big-endian mode'
complete -c gcc -o mbig-endian -d 'On System V.4 and embedded PowerPC compile code for the processor in big-endian mode'
complete -c gcc -o mdynamic-no-pic -d 'On Darwin and Mac OS X, compile code so that it is not relocatable, but that its external references are relocatable'
complete -c gcc -o mprioritize-restricted-insns -d '=priority Controls the priority that is assigned to dispatch-slot restricted instructions during the second scheduling pass'
complete -c gcc -o msched-costly-dep -d '=dependence_type Controls which dependences are considered costly by the target during instruction scheduling'
complete -c gcc -o minsert-sched-nops -d '=scheme Controls which nop insertion scheme will be used during the second scheduling pass'
complete -c gcc -o mcall-sysv -d 'Specify both -mcall-sysv and -meabi options'
complete -c gcc -o mcall-sysv-eabi -d 'Specify both -mcall-sysv and -meabi options'
complete -c gcc -o mcall-sysv-noeabi -d 'Specify both -mcall-sysv and -mno-eabi options'
complete -c gcc -o mcall-linux -d 'On System V.4 and embedded PowerPC compile code for the Linux-based GNU system'
complete -c gcc -o mcall-netbsd -d 'On System V.4 and embedded PowerPC compile code for the NetBSD operating system'
complete -c gcc -o maix-struct-return -d 'Return all structures in memory (as specified by the AIX ABI)'
complete -c gcc -o msvr4-struct-return -d 'Return structures smaller than 8 bytes in registers (as specified by the SVR4 ABI)'
complete -c gcc -o mabi -d 'Extend the current ABI with a particular extension, or remove such extension'
complete -c gcc -o type -d 'Extend the current ABI with a particular extension, or remove such extension'
complete -c gcc -o mabi -d '=spe Extend the current ABI with SPE ABI extensions'
complete -c gcc -o mabi -d 'Disable Booke SPE ABI extensions for the current ABI'
complete -c gcc -o spe -d 'Disable Booke SPE ABI extensions for the current ABI'
complete -c gcc -o mabi -d '=ibmlongdouble Change the current ABI to use IBM extended precision long double'
complete -c gcc -o mabi -d '=ieeelongdouble Change the current ABI to use IEEE extended precision long double'
complete -c gcc -o mprototype -d 'On System V.4 and embedded PowerPC assume that all calls to variable argument functions are properly prototyped'
complete -c gcc -o mno-prototype -d 'On System V.4 and embedded PowerPC does not assume that all calls to variable argument functions are properly prototyped'
complete -c gcc -o msim -d 'On embedded PowerPC systems, assume that the startup module is called sim-crt0'
complete -c gcc -o mmvme -d 'On embedded PowerPC systems, assume that the startup module is called crt0'
complete -c gcc -o mads -d 'On embedded PowerPC systems, assume that the startup module is called crt0'
complete -c gcc -o myellowknife -d 'On embedded PowerPC systems, assume that the startup module is called crt0'
complete -c gcc -o mvxworks -d 'On System V.4 and embedded PowerPC, specify that you are compiling for a VxWorks system'
complete -c gcc -o mwindiss -d 'Specify that you are compiling for the WindISS simulation environment'
complete -c gcc -o memb -d 'On embedded PowerPC systems, set the PPC_EMB bit in the ELF flags header to indicate that eabi extended relocations are used'
complete -c gcc -o meabi -d 'On System V.4 and embedded PowerPC do adhere to the Embedded Applications Binary Interface (EABI), which is a set of modifications to the System V.4 specs'
complete -c gcc -o mno-eabi -d 'On System V.4 and embedded PowerPC do not adhere to the Embedded Applications Binary Interface (EABI), which is a set of modifications to the System V.4 specifications'
complete -c gcc -o msdata -d '=eabi On System V.4 and embedded PowerPC, put small initialized const global and static data in the .sdata2, which is pointed to by register r2. Put small initialized non-const global and static data in the .sdata, which is pointed to by register r13. Put small uninitialized global and static data in the .sbss, which is adjacent to the .sdata. This option is incompatible with -mrelocatable and sets -memb'
complete -c gcc -o msdata -d '=sysv On System V.4 and embedded PowerPC, put small global and static data in the .sdata, which is pointed to by register r13. Put small uninitialized global and static data in the .sbss, which is adjacent to the .sdata. This option is incompatible with -mrelocatable'
complete -c gcc -o msdata -d '=default On System V.4 and embedded PowerPC, if -meabi is used, compile code the same as -msdata=eabi, otherwise same as -msdata=sysv'
complete -c gcc -o msdata -d '=data On System V.4 and embedded PowerPC, put small global data in the .sdata section. Put small uninitialized global data in the .sbss section. Do not use register r13 to address small data. Default behavior unless other -msdata options are used'
complete -c gcc -o msdata -d 'Enable optimizations that use the small data section. This may be useful for working around optimizer bugs'
complete -c gcc -o mno-sdata -d 'Disable optimizations that use the small data section. This may be useful for working around optimizer bugs'
complete -c gcc -s G -d 'On embedded PowerPC, put global and static items less than or equal to num bytes into the small data or bss sections instead of the normal'
complete -c gcc -o mregnames -d 'On System V.4 and embedded PowerPC do emit register names in the assembly language output using symbolic forms'
complete -c gcc -o mno-regnames -d 'On System V.4 and embedded PowerPC do not emit register names in the assembly language output using symbolic forms'
complete -c gcc -o mlongcall -d 'Default to making all function calls indirectly, using a register, so that functions which reside further than 32 megabytes (33,554,432 bytes) from the current location can be called'
complete -c gcc -o mno-longcall -d 'Default to making all function calls indirectly, using a register, so that functions which reside further than 32 megabytes (33,554,432 bytes) from the current location can be called'
complete -c gcc -o pthread -d 'Adds support for multithreading with the pthreads library'
complete -c gcc -o mhard-float -d 'Use (do not use) the hardware floating-point instructions and registers for floating-point operations'
complete -c gcc -o msoft-float -d 'Use (do not use) the hardware floating-point instructions and registers for floating-point operations'
complete -c gcc -o mlong-double-64 -d 'These switches control the size of "long double" type'
complete -c gcc -o mlong-double-128 -d 'These switches control the size of "long double" type'
complete -c gcc -o mbackchain -d 'Store (do not store) the address of the caller’s frame as backchain pointer into the callee’s stack frame'
complete -c gcc -o mno-backchain -d 'Store (do not store) the address of the caller’s frame as backchain pointer into the callee’s stack frame'
complete -c gcc -o mpacked-stack -d 'Use (do not use) the packed stack layout'
complete -c gcc -o mno-packed-stack -d 'Use (do not use) the packed stack layout'
complete -c gcc -o msmall-exec -d 'Generate (or do not generate) code using the "bras" instruction to do subroutine calls'
complete -c gcc -o mno-small-exec -d 'Generate (or do not generate) code using the "bras" instruction to do subroutine calls'
complete -c gcc -o m64 -d 'When -m31 is specified, generate code compliant to the GNU/Linux for S/390 ABI'
complete -c gcc -o m31 -d 'When -m31 is specified, generate code compliant to the GNU/Linux for S/390 ABI'
complete -c gcc -o mzarch -d 'When -mzarch is specified, generate code using the instructions available on z/Architecture'
complete -c gcc -o mesa -d 'When -mzarch is specified, generate code using the instructions available on z/Architecture'
complete -c gcc -o mmvcle -d 'Generate (or do not generate) code using the "mvcle" instruction to perform block moves'
complete -c gcc -o mno-mvcle -d 'Generate (or do not generate) code using the "mvcle" instruction to perform block moves'
complete -c gcc -o mdebug -d 'Print (or do not print) additional debug information when compiling'
complete -c gcc -o mno-debug -d 'Print (or do not print) additional debug information when compiling'
complete -c gcc -o march -d 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o type -d 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o mtune -d 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o type -d 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o mtpf-trace -d 'Generate code that adds (does not add) in TPF OS specific branches to trace routines in the operating system'
complete -c gcc -o mno-tpf-trace -d 'Generate code that adds (does not add) in TPF OS specific branches to trace routines in the operating system'
complete -c gcc -o mfused-madd -d 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mno-fused-madd -d 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mwarn-framesize -d '=framesize Emit a warning if the current function exceeds the given frame size'
complete -c gcc -o mwarn-dynamicstack -d 'Emit a warning if the function calls alloca or uses dynamically sized arrays'
complete -c gcc -o mstack-guard -d 'These arguments always have to be used in conjunction'
complete -c gcc -o mstack-size -d 'These arguments always have to be used in conjunction'
complete -c gcc -o size -d 'These arguments always have to be used in conjunction'
complete -c gcc -o m1 -d 'Generate code for the SH1'
complete -c gcc -o m2 -d 'Generate code for the SH2'
complete -c gcc -o m2e -d 'Generate code for the SH2e'
complete -c gcc -o m3 -d 'Generate code for the SH3'
complete -c gcc -o m3e -d 'Generate code for the SH3e'
complete -c gcc -o m4-nofpu -d 'Generate code for the SH4 without a floating-point unit'
complete -c gcc -o m4-single-only -d 'Generate code for the SH4 with a floating-point unit that only supports single-precision arithmetic'
complete -c gcc -o m4-single -d 'Generate code for the SH4 assuming the floating-point unit is in single-precision mode by default'
complete -c gcc -o m4 -d 'Generate code for the SH4'
complete -c gcc -o m4a-nofpu -d 'Generate code for the SH4al-dsp, or for a SH4a in such a way that the floating-point unit is not used'
complete -c gcc -o m4a-single-only -d 'Generate code for the SH4a, in such a way that no double-precision floating point operations are used'
complete -c gcc -o m4a-single -d 'Generate code for the SH4a assuming the floating-point unit is in single-precision mode by default'
complete -c gcc -o m4a -d 'Generate code for the SH4a'
complete -c gcc -o m4al -d 'Same as -m4a-nofpu, except that it implicitly passes -dsp to the assembler'
complete -c gcc -o mb -d 'Compile code for the processor in big endian mode'
complete -c gcc -o ml -d 'Compile code for the processor in little endian mode'
complete -c gcc -o mdalign -d 'Align doubles at 64-bit boundaries'
complete -c gcc -o mrelax -d 'Shorten some address references at link time, when possible; uses the linker option -relax'
complete -c gcc -o mbigtable -d 'Use 32-bit offsets in "switch" tables'
complete -c gcc -o mfmovd -d 'Enable the use of the instruction "fmovd"'
complete -c gcc -o mhitachi -d 'Comply with the calling conventions defined by Renesas'
complete -c gcc -o mrenesas -d 'Comply with the calling conventions defined by Renesas'
complete -c gcc -o mno-renesas -d 'Comply with the calling conventions defined for GCC before the Renesas conventions were available'
complete -c gcc -o mnomacsave -d 'Mark the "MAC" register as call-clobbered, even if -mhitachi is given'
complete -c gcc -o mieee -d 'Increase IEEE-compliance of floating-point code'
complete -c gcc -o misize -d 'Dump instruction size and location in the assembly code'
complete -c gcc -o mpadstruct -d 'Deprecated'
complete -c gcc -o mspace -d 'Optimize for space instead of speed'
complete -c gcc -o mprefergot -d 'When generating position-independent code, emit function calls using the Global Offset Table instead of the Procedure Linkage Table'
complete -c gcc -o musermode -d 'Generate a library function call to invalidate instruction cache entries, after fixing up a trampoline'
complete -c gcc -o multcost -d '=number Set the cost to assume for a multiply insn'
complete -c gcc -o mdiv -d '=strategy Set the division strategy to use for SHmedia code'
complete -c gcc -o mdivsi3_libfunc -d '=name Set the name of the library function used for 32 bit signed division to name'
complete -c gcc -o madjust-unroll -d 'Throttle unrolling to avoid thrashing target registers'
complete -c gcc -o mindexed-addressing -d 'Enable the use of the indexed addressing mode for SHmedia32/SHcompact'
complete -c gcc -o mgettrcost -d '=number Set the cost assumed for the gettr instruction to number'
complete -c gcc -o mpt-fixed -d 'Assume pt* instructions won’t trap'
complete -c gcc -o minvalid-symbols -d 'Assume symbols might be invalid'
complete -c gcc -o mapp-regs -d 'Generate output using the global registers 2 through 4, which the SPARC SVR4 ABI reserves for applications'
complete -c gcc -o mno-app-regs -d 'Does not generate output using the global registers 2 through 4, which the SPARC SVR4 ABI reserves for applications'
complete -c gcc -o mfpu -d 'Generate output containing floating point instructions'
complete -c gcc -o mhard-float -d 'Generate output containing floating point instructions'
complete -c gcc -o mno-fpu -d 'Generate output containing library calls for floating point'
complete -c gcc -o msoft-float -d 'Generate output containing library calls for floating point'
complete -c gcc -o mhard-quad-float -d 'Generate output containing quad-word (long double) floating point instructions'
complete -c gcc -o msoft-quad-float -d 'Generate output containing library calls for quad-word (long double) floating point instructions'
complete -c gcc -o mno-unaligned-doubles -d 'Assume that doubles have 8 byte alignment'
complete -c gcc -o munaligned-doubles -d 'Assume that doubles have 8 byte alignment'
complete -c gcc -o mfaster-structs -d 'Assumes that structures should have 8 byte alignment'
complete -c gcc -o mno-faster-structs -d 'Does not assume that structures should have 8 byte alignment'
complete -c gcc -o mimpure-text -d 'Used in addition to -shared, tells to not pass -z text to the linker when linking a shared object'
complete -c gcc -o mcpu -d '=cpu_type Set the instruction set, register set, and instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mtune -d '=cpu_type Set the instruction scheduling parameters for cpu_type, but do not set the instruction set or register set that the option -mcpu=cpu_type would'
complete -c gcc -o mv8plus -d 'With -mv8plus, GCC generates code for the SPARC-V8+ ABI'
complete -c gcc -o mno-v8plus -d 'With -mv8plus, GCC generates code for the SPARC-V8+ ABI'
complete -c gcc -o mvis -d 'With -mvis, GCC generates code that takes advantage of the UltraSPARC Visual Instruction Set extensions'
complete -c gcc -o mno-vis -d 'With -mvis, GCC generates code that takes advantage of the UltraSPARC Visual Instruction Set extensions'
complete -c gcc -o mlittle-endian -d 'Generate code for a processor running in little-endian mode'
complete -c gcc -o m32 -d 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o m64 -d 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mcmodel -d '=medlow Generate code for the Medium/Low code model: 64-bit addresses, programs must be linked in the low 32 bits of memory'
complete -c gcc -o mcmodel -d '=medmid Generate code for the Medium/Middle code model: 64-bit addresses, programs must be linked in the low 44 bits of memory, the text and data segments must be less than 2GB in size and the data segment must be located within 2GB of the text segment'
complete -c gcc -o mcmodel -d '=medany Generate code for the Medium/Anywhere code model: 64-bit addresses, programs may be linked anywhere in memory, the text and data segments must be less than 2GB in size and the data segment must be located within 2GB of the text segment'
complete -c gcc -o mcmodel -d '=embmedany Generate code for the Medium/Anywhere code model for embedded systems: 64-bit addresses, the text and data segments must be less than 2GB in size, both starting anywhere in memory (determined at link time)'
complete -c gcc -o mstack-bias -d 'With -mstack-bias, GCC assumes that the stack pointer, and frame pointer if present, are offset by -2047 which must be added back when making stack frame references'
complete -c gcc -o mno-stack-bias -d 'With -mstack-bias, GCC assumes that the stack pointer, and frame pointer if present, are offset by -2047 which must be added back when making stack frame references'
complete -c gcc -o threads -d 'Add support for multithreading using the Solaris threads library'
complete -c gcc -o pthreads -d 'Add support for multithreading using the POSIX threads library'
complete -c gcc -o pthread -d 'This is a synonym for -pthreads'
complete -c gcc -s G -d 'Create a shared object'
complete -c gcc -o Qy -d 'Identify the versions of each tool used by the compiler, in a "'
complete -c gcc -o Qn -d 'Refrain from adding "'
complete -c gcc -o mcpu -d '=cpu_type Set the instruction set, register set, and instruction scheduling parameters for cpu_type'
complete -c gcc -o mbig-memory -d 'Generates code for the big or small memory model'
complete -c gcc -o mbig -d 'Generates code for the big or small memory model'
complete -c gcc -o msmall-memory -d 'Generates code for the big or small memory model'
complete -c gcc -o msmall -d 'Generates code for the big or small memory model'
complete -c gcc -o mbk -d 'Allow (disallow) allocation of general integer operands into the block count register BK'
complete -c gcc -o mno-bk -d 'Allow (disallow) allocation of general integer operands into the block count register BK'
complete -c gcc -o mdb -d 'Enable (disable) generation of code using decrement and branch, DBcond(D), instructions'
complete -c gcc -o mno-db -d 'Enable (disable) generation of code using decrement and branch, DBcond(D), instructions'
complete -c gcc -o mdp-isr-reload -d 'Force the DP register to be saved on entry to an interrupt service routine (ISR), reloaded to point to the data section, and restored on exit from the ISR'
complete -c gcc -o mparanoid -d 'Force the DP register to be saved on entry to an interrupt service routine (ISR), reloaded to point to the data section, and restored on exit from the ISR'
complete -c gcc -o mmpyi -d 'For the C3x use the 24-bit MPYI instruction for integer multiplies instead of a library call to guarantee 32-bit results'
complete -c gcc -o mno-mpyi -d 'For the C3x use the 24-bit MPYI instruction for integer multiplies instead of a library call to guarantee 32-bit results'
complete -c gcc -o mfast-fix -d 'The C3x/C4x FIX instruction to convert a floating point value to an integer value chooses the nearest integer less than or equal to the floating point value rather than to the nearest integer'
complete -c gcc -o mno-fast-fix -d 'The C3x/C4x FIX instruction to convert a floating point value to an integer value chooses the nearest integer less than or equal to the floating point value rather than to the nearest integer'
complete -c gcc -o mrptb -d 'Enable (disable) generation of repeat block sequences using the RPTB instruction for zero overhead looping'
complete -c gcc -o mno-rptb -d 'Enable (disable) generation of repeat block sequences using the RPTB instruction for zero overhead looping'
complete -c gcc -o mrpts -d 'Enable (disable) the use of the single instruction repeat instruction RPTS'
complete -c gcc -o mno-rpts -d 'Enable (disable) the use of the single instruction repeat instruction RPTS'
complete -c gcc -o mloop-unsigned -d 'The maximum iteration count when using RPTS and RPTB (and DB on the C40) is 2^{31 + 1} since these instructions test if the iteration count is negative to terminate the loop'
complete -c gcc -o mno-loop-unsigned -d 'The maximum iteration count when using RPTS and RPTB (and DB on the C40) is 2^{31 + 1} since these instructions test if the iteration count is negative to terminate the loop'
complete -c gcc -o mti -d 'Try to emit an assembler syntax that the TI assembler (asm30) is happy with'
complete -c gcc -o mregparm -d 'Generate code that uses registers (stack) for passing arguments to functions'
complete -c gcc -o mmemparm -d 'Generate code that uses registers (stack) for passing arguments to functions'
complete -c gcc -o mparallel-insns -d 'Allow the generation of parallel instructions'
complete -c gcc -o mno-parallel-insns -d 'Allow the generation of parallel instructions'
complete -c gcc -o mparallel-mpy -d 'Allow the generation of MPY││ADD and MPY││SUB parallel instructions, provided -mparallel-insns is also specified'
complete -c gcc -o mno-parallel-mpy -d 'Allow the generation of MPY││ADD and MPY││SUB parallel instructions, provided -mparallel-insns is also specified'
complete -c gcc -o mlong-calls -d 'Treat all calls as being far away (near)'
complete -c gcc -o mno-long-calls -d 'Treat all calls as being far away (near)'
complete -c gcc -o mep -d 'Optimize basic blocks that use the same index pointer 4 or more times to copy pointer into the "ep" register, and use the shorter "sld" and "sst" instructions'
complete -c gcc -o mno-ep -d 'Do not optimize basic blocks that use the same index pointer 4 or more times to copy pointer into the "ep" register, and use the shorter "sld" and "sst" instructions'
complete -c gcc -o mno-prolog-function -d 'Do not use (do use) external functions to save and restore registers at the prologue and epilogue of a function'
complete -c gcc -o mprolog-function -d 'Do not use (do use) external functions to save and restore registers at the prologue and epilogue of a function'
complete -c gcc -o mspace -d 'Try to make the code as small as possible'
complete -c gcc -o mtda -d '=n Put static or global variables whose size is n bytes or less into the tiny data area that register "ep" points to'
complete -c gcc -o msda -d '=n Put static or global variables whose size is n bytes or less into the small data area that register "gp" points to'
complete -c gcc -o mzda -d '=n Put static or global variables whose size is n bytes or less into the first 32 kilobytes of memory'
complete -c gcc -o mv850 -d 'Specify that the target processor is the V850'
complete -c gcc -o mbig-switch -d 'Generate code suitable for big switch tables'
complete -c gcc -o mapp-regs -d 'Will cause r2 and r5 to be used in the code generated by the compiler'
complete -c gcc -o mno-app-regs -d 'Will cause r2 and r5 to be treated as fixed registers'
complete -c gcc -o mv850e1 -d 'Specify that the target processor is the V850E1'
complete -c gcc -o mv850e -d 'Specify that the target processor is the V850E'
complete -c gcc -o mdisable-callt -d 'Will suppress generation of the CALLT instruction for the v850e and v850e1 flavors of the v850 architecture'
complete -c gcc -o munix -d 'Do not output certain jump instructions (i.e. "aobleq") the Unix assembler for the VAX cannot handle across long ranges'
complete -c gcc -o mgnu -d 'Do output those jump instructions, on the assumption that you will assemble with the GNU assembler'
complete -c gcc -o mg -d 'Output code for g-format floating point numbers instead of d-format'
complete -c gcc -o msim -d 'Choose startup files and linker script suitable for the simulator'
complete -c gcc -o mconst16 -d 'Enable or disable use of "CONST16" instructions for loading constant values'
complete -c gcc -o mno-const16 -d 'Enable or disable use of "CONST16" instructions for loading constant values'
complete -c gcc -o mfused-madd -d 'Enable or disable use of fused multiply/add and multiply/subtract instructions in the floating-point option'
complete -c gcc -o mno-fused-madd -d 'Enable or disable use of fused multiply/add and multiply/subtract instructions in the floating-point option'
complete -c gcc -o mtext-section-literals -d 'Control the treatment of literal pools'
complete -c gcc -o mno-text-section-literals -d 'Control the treatment of literal pools'
complete -c gcc -o mtarget-align -d 'Instructs the assembler to automatically align instructions to reduce branch penalties at the expense of some code density'
complete -c gcc -o mno-target-align -d 'Instructs the assembler to not automatically align instructions to reduce branch penalties at the expense of some code density'
complete -c gcc -o mlongcalls -d 'Tell assembler to translate direct calls to indirect calls'
complete -c gcc -o mno-longcalls -d 'Tell assembler to not translate direct calls to indirect calls'
complete -c gcc -o fbounds-check -d 'Generate additional code to check that indices used to access arrays are within the declared range'
complete -c gcc -o ftrapv -d 'Generates traps for signed overflow on addition, subtraction, multiplication operations'
complete -c gcc -o fwrapv -d 'Assume that signed arithmetic overflow of addition, subtraction and multiplication wraps around using twos-complement representation'
complete -c gcc -o fexceptions -d 'Enable exception handling'
complete -c gcc -o fnon-call-exceptions -d 'Generate code that allows trapping instructions to throw exceptions'
complete -c gcc -o funwind-tables -d 'Similar to -fexceptions, except that it will just generate any needed static data, but will not affect in any other way'
complete -c gcc -o fasynchronous-unwind-tables -d 'Generate unwind table in dwarf2 format'
complete -c gcc -o fpcc-struct-return -d 'Return "short" "struct" and "union" values in memory like longer ones, rather than in registers'
complete -c gcc -o freg-struct-return -d 'Return "struct" and "union" values in registers when possible'
complete -c gcc -o fshort-enums -d 'Allocate to an "enum" type only as many bytes as it needs for the declared range of possible values'
complete -c gcc -o fshort-double -d 'Use the same size for "double" as for "float"'
complete -c gcc -o fshort-wchar -d 'Override the underlying type for wchar_t to be short unsigned int instead of the default for the target'
complete -c gcc -o fshared-data -d 'Requests that the data and non-"const" variables of this compilation be shared data rather than private data'
complete -c gcc -o fno-common -d 'In C, allocate even uninitialized global variables in the data section of the object file, rather than as common blocks'
complete -c gcc -o fno-ident -d 'Ignore the #ident directive'
complete -c gcc -o finhibit-size-directive -d 'Don’t output a "'
complete -c gcc -o fverbose-asm -d 'Put extra commentary information in the generated assembly code to make it more readable'
complete -c gcc -o fpic -d 'Generate position-independent code (PIC) suitable for use in a shared library, if supported for the target machine'
complete -c gcc -o fPIC -d 'Emit position-independent code, suitable for dynamic linking and avoiding any limit on the size of the global offset table'
complete -c gcc -o fpie -d 'Similar to -fpic and -fPIC, but generated position independent code can be only linked into executables'
complete -c gcc -o fPIE -d 'Similar to -fpic and -fPIC, but generated position independent code can be only linked into executables'
complete -c gcc -o fno-jump-tables -d 'Do not use jump tables for switch statements even where it would be more efficient than other code generation strategies'
complete -c gcc -o ffixed-reg -d 'Treat the register named reg as a fixed register; generated code should never refer to it (except perhaps as a stack pointer, frame pointer or in some other fixed role)'
complete -c gcc -o fcall-used-reg -d 'Treat the register named reg as an allocable register that is clobbered by function calls'
complete -c gcc -o fcall-saved-reg -d 'Treat the register named reg as an allocable register saved by functions'
complete -c gcc -o fpack-struct -d 'Without a value specified, pack all structure members together without holes' -x
complete -c gcc -o finstrument-functions -d 'Generate instrumentation calls for entry and exit to functions'
complete -c gcc -o fstack-check -d 'Generate code to verify that you do not go beyond the boundary of the stack'
complete -c gcc -o fstack-limit-register -d 'Generate code to ensure that the stack does not grow beyond the value of a register'
complete -c gcc -o fstack-limit-symbol -d 'Generate code to ensure that the stack does not grow beyond the address of a symbol'
complete -c gcc -o fno-stack-limit -d 'Does not generate code to ensure that the stack does not grow beyond a certain value, either the value of a register or the address of a symbol'
complete -c gcc -o fargument-alias -d 'Specify the possible relationships among parameters and between parameters and global data'
complete -c gcc -o fargument-noalias -d 'Specify the possible relationships among parameters and between parameters and global data'
complete -c gcc -o fargument-noalias-global -d 'Specify the possible relationships among parameters and between parameters and global data'
complete -c gcc -o fleading-underscore -d 'This flag and -fno-leading-underscore, forcibly change the way C symbols are represented in the object file'
complete -c gcc -o ftls-model -d '=model Alter the thread-local storage model to be used'
complete -c gcc -o fvisibility -a 'default internal hidden protected' -d 'Set the default ELF image symbol visibility'
complete -c gcc -o fopenmp -d 'Enable handling of OpenMP directives "#pragma omp" in C/C++ and "!$omp" in Fortran'
