/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomial448
extends IntegerPolynomial {
    private static final int POWER = 448;
    private static final int NUM_LIMBS = 16;
    private static final int BITS_PER_LIMB = 28;
    public static final BigInteger MODULUS = TWO.pow(448).subtract(TWO.pow(224)).subtract(BigInteger.valueOf(1L));

    public IntegerPolynomial448() {
        super(28, 16, 1, MODULUS);
    }

    private void modReduceIn(long[] lArray, int n, long l) {
        int n2 = n - 16;
        lArray[n2] = lArray[n2] + l;
        int n3 = n - 8;
        lArray[n3] = lArray[n3] + l;
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[this.numLimbs - 1] >> this.bitsPerLimb;
        int n = this.numLimbs - 1;
        lArray[n] = lArray[n] - (l << this.bitsPerLimb);
        this.modReduceIn(lArray, this.numLimbs, l);
    }

    @Override
    protected void reduce(long[] lArray) {
        long l = this.carryValue(lArray[14]);
        lArray[14] = lArray[14] - (l << 28);
        lArray[15] = lArray[15] + l;
        long l2 = this.carryValue(lArray[15]);
        lArray[15] = lArray[15] - (l2 << 28);
        lArray[0] = lArray[0] + l2;
        lArray[8] = lArray[8] + l2;
        this.carry(lArray, 0, 15);
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[0] * lArray2[10] + lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1] + lArray[10] * lArray2[0];
        long l12 = lArray[0] * lArray2[11] + lArray[1] * lArray2[10] + lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2] + lArray[10] * lArray2[1] + lArray[11] * lArray2[0];
        long l13 = lArray[0] * lArray2[12] + lArray[1] * lArray2[11] + lArray[2] * lArray2[10] + lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3] + lArray[10] * lArray2[2] + lArray[11] * lArray2[1] + lArray[12] * lArray2[0];
        long l14 = lArray[0] * lArray2[13] + lArray[1] * lArray2[12] + lArray[2] * lArray2[11] + lArray[3] * lArray2[10] + lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4] + lArray[10] * lArray2[3] + lArray[11] * lArray2[2] + lArray[12] * lArray2[1] + lArray[13] * lArray2[0];
        long l15 = lArray[0] * lArray2[14] + lArray[1] * lArray2[13] + lArray[2] * lArray2[12] + lArray[3] * lArray2[11] + lArray[4] * lArray2[10] + lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5] + lArray[10] * lArray2[4] + lArray[11] * lArray2[3] + lArray[12] * lArray2[2] + lArray[13] * lArray2[1] + lArray[14] * lArray2[0];
        long l16 = lArray[0] * lArray2[15] + lArray[1] * lArray2[14] + lArray[2] * lArray2[13] + lArray[3] * lArray2[12] + lArray[4] * lArray2[11] + lArray[5] * lArray2[10] + lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6] + lArray[10] * lArray2[5] + lArray[11] * lArray2[4] + lArray[12] * lArray2[3] + lArray[13] * lArray2[2] + lArray[14] * lArray2[1] + lArray[15] * lArray2[0];
        long l17 = lArray[1] * lArray2[15] + lArray[2] * lArray2[14] + lArray[3] * lArray2[13] + lArray[4] * lArray2[12] + lArray[5] * lArray2[11] + lArray[6] * lArray2[10] + lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7] + lArray[10] * lArray2[6] + lArray[11] * lArray2[5] + lArray[12] * lArray2[4] + lArray[13] * lArray2[3] + lArray[14] * lArray2[2] + lArray[15] * lArray2[1];
        long l18 = lArray[2] * lArray2[15] + lArray[3] * lArray2[14] + lArray[4] * lArray2[13] + lArray[5] * lArray2[12] + lArray[6] * lArray2[11] + lArray[7] * lArray2[10] + lArray[8] * lArray2[9] + lArray[9] * lArray2[8] + lArray[10] * lArray2[7] + lArray[11] * lArray2[6] + lArray[12] * lArray2[5] + lArray[13] * lArray2[4] + lArray[14] * lArray2[3] + lArray[15] * lArray2[2];
        long l19 = lArray[3] * lArray2[15] + lArray[4] * lArray2[14] + lArray[5] * lArray2[13] + lArray[6] * lArray2[12] + lArray[7] * lArray2[11] + lArray[8] * lArray2[10] + lArray[9] * lArray2[9] + lArray[10] * lArray2[8] + lArray[11] * lArray2[7] + lArray[12] * lArray2[6] + lArray[13] * lArray2[5] + lArray[14] * lArray2[4] + lArray[15] * lArray2[3];
        long l20 = lArray[4] * lArray2[15] + lArray[5] * lArray2[14] + lArray[6] * lArray2[13] + lArray[7] * lArray2[12] + lArray[8] * lArray2[11] + lArray[9] * lArray2[10] + lArray[10] * lArray2[9] + lArray[11] * lArray2[8] + lArray[12] * lArray2[7] + lArray[13] * lArray2[6] + lArray[14] * lArray2[5] + lArray[15] * lArray2[4];
        long l21 = lArray[5] * lArray2[15] + lArray[6] * lArray2[14] + lArray[7] * lArray2[13] + lArray[8] * lArray2[12] + lArray[9] * lArray2[11] + lArray[10] * lArray2[10] + lArray[11] * lArray2[9] + lArray[12] * lArray2[8] + lArray[13] * lArray2[7] + lArray[14] * lArray2[6] + lArray[15] * lArray2[5];
        long l22 = lArray[6] * lArray2[15] + lArray[7] * lArray2[14] + lArray[8] * lArray2[13] + lArray[9] * lArray2[12] + lArray[10] * lArray2[11] + lArray[11] * lArray2[10] + lArray[12] * lArray2[9] + lArray[13] * lArray2[8] + lArray[14] * lArray2[7] + lArray[15] * lArray2[6];
        long l23 = lArray[7] * lArray2[15] + lArray[8] * lArray2[14] + lArray[9] * lArray2[13] + lArray[10] * lArray2[12] + lArray[11] * lArray2[11] + lArray[12] * lArray2[10] + lArray[13] * lArray2[9] + lArray[14] * lArray2[8] + lArray[15] * lArray2[7];
        long l24 = lArray[8] * lArray2[15] + lArray[9] * lArray2[14] + lArray[10] * lArray2[13] + lArray[11] * lArray2[12] + lArray[12] * lArray2[11] + lArray[13] * lArray2[10] + lArray[14] * lArray2[9] + lArray[15] * lArray2[8];
        long l25 = lArray[9] * lArray2[15] + lArray[10] * lArray2[14] + lArray[11] * lArray2[13] + lArray[12] * lArray2[12] + lArray[13] * lArray2[11] + lArray[14] * lArray2[10] + lArray[15] * lArray2[9];
        long l26 = lArray[10] * lArray2[15] + lArray[11] * lArray2[14] + lArray[12] * lArray2[13] + lArray[13] * lArray2[12] + lArray[14] * lArray2[11] + lArray[15] * lArray2[10];
        long l27 = lArray[11] * lArray2[15] + lArray[12] * lArray2[14] + lArray[13] * lArray2[13] + lArray[14] * lArray2[12] + lArray[15] * lArray2[11];
        long l28 = lArray[12] * lArray2[15] + lArray[13] * lArray2[14] + lArray[14] * lArray2[13] + lArray[15] * lArray2[12];
        long l29 = lArray[13] * lArray2[15] + lArray[14] * lArray2[14] + lArray[15] * lArray2[13];
        long l30 = lArray[14] * lArray2[15] + lArray[15] * lArray2[14];
        long l31 = lArray[15] * lArray2[15];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31);
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31) {
        l9 += l25;
        l17 += l25;
        l10 += l26;
        l18 += l26;
        l11 += l27;
        l19 += l27;
        l12 += l28;
        l20 += l28;
        l15 += l31;
        lArray[4] = l5 + (l21 += l29);
        lArray[12] = (l13 += l29) + l21;
        lArray[5] = l6 + (l22 += l30);
        lArray[13] = (l14 += l30) + l22;
        lArray[6] = l7 + (l23 += l31);
        lArray[7] = l8 + l24;
        l16 += l24;
        long l32 = this.carryValue(l15 += l23);
        lArray[14] = l15 - (l32 << 28);
        long l33 = this.carryValue(l16 += l32);
        lArray[15] = l16 - (l33 << 28);
        lArray[0] = l + (l17 += l33);
        lArray[8] = l9 + l17;
        lArray[1] = l2 + l18;
        lArray[9] = l10 + l18;
        lArray[2] = l3 + l19;
        lArray[10] = l11 + l19;
        lArray[3] = l4 + l20;
        lArray[11] = l12 + l20;
        this.carry(lArray, 0, 15);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * lArray[0] * lArray[1];
        long l3 = lArray[1] * lArray[1] + 2L * lArray[0] * lArray[2];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = lArray[2] * lArray[2] + 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]);
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = lArray[3] * lArray[3] + 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]);
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = lArray[4] * lArray[4] + 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]);
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = lArray[5] * lArray[5] + 2L * (lArray[0] * lArray[10] + lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]);
        long l12 = 2L * (lArray[0] * lArray[11] + lArray[1] * lArray[10] + lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = lArray[6] * lArray[6] + 2L * (lArray[0] * lArray[12] + lArray[1] * lArray[11] + lArray[2] * lArray[10] + lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]);
        long l14 = 2L * (lArray[0] * lArray[13] + lArray[1] * lArray[12] + lArray[2] * lArray[11] + lArray[3] * lArray[10] + lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = lArray[7] * lArray[7] + 2L * (lArray[0] * lArray[14] + lArray[1] * lArray[13] + lArray[2] * lArray[12] + lArray[3] * lArray[11] + lArray[4] * lArray[10] + lArray[5] * lArray[9] + lArray[6] * lArray[8]);
        long l16 = 2L * (lArray[0] * lArray[15] + lArray[1] * lArray[14] + lArray[2] * lArray[13] + lArray[3] * lArray[12] + lArray[4] * lArray[11] + lArray[5] * lArray[10] + lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = lArray[8] * lArray[8] + 2L * (lArray[1] * lArray[15] + lArray[2] * lArray[14] + lArray[3] * lArray[13] + lArray[4] * lArray[12] + lArray[5] * lArray[11] + lArray[6] * lArray[10] + lArray[7] * lArray[9]);
        long l18 = 2L * (lArray[2] * lArray[15] + lArray[3] * lArray[14] + lArray[4] * lArray[13] + lArray[5] * lArray[12] + lArray[6] * lArray[11] + lArray[7] * lArray[10] + lArray[8] * lArray[9]);
        long l19 = lArray[9] * lArray[9] + 2L * (lArray[3] * lArray[15] + lArray[4] * lArray[14] + lArray[5] * lArray[13] + lArray[6] * lArray[12] + lArray[7] * lArray[11] + lArray[8] * lArray[10]);
        long l20 = 2L * (lArray[4] * lArray[15] + lArray[5] * lArray[14] + lArray[6] * lArray[13] + lArray[7] * lArray[12] + lArray[8] * lArray[11] + lArray[9] * lArray[10]);
        long l21 = lArray[10] * lArray[10] + 2L * (lArray[5] * lArray[15] + lArray[6] * lArray[14] + lArray[7] * lArray[13] + lArray[8] * lArray[12] + lArray[9] * lArray[11]);
        long l22 = 2L * (lArray[6] * lArray[15] + lArray[7] * lArray[14] + lArray[8] * lArray[13] + lArray[9] * lArray[12] + lArray[10] * lArray[11]);
        long l23 = lArray[11] * lArray[11] + 2L * (lArray[7] * lArray[15] + lArray[8] * lArray[14] + lArray[9] * lArray[13] + lArray[10] * lArray[12]);
        long l24 = 2L * (lArray[8] * lArray[15] + lArray[9] * lArray[14] + lArray[10] * lArray[13] + lArray[11] * lArray[12]);
        long l25 = lArray[12] * lArray[12] + 2L * (lArray[9] * lArray[15] + lArray[10] * lArray[14] + lArray[11] * lArray[13]);
        long l26 = 2L * (lArray[10] * lArray[15] + lArray[11] * lArray[14] + lArray[12] * lArray[13]);
        long l27 = lArray[13] * lArray[13] + 2L * (lArray[11] * lArray[15] + lArray[12] * lArray[14]);
        long l28 = 2L * (lArray[12] * lArray[15] + lArray[13] * lArray[14]);
        long l29 = lArray[14] * lArray[14] + 2L * lArray[13] * lArray[15];
        long l30 = 2L * lArray[14] * lArray[15];
        long l31 = lArray[15] * lArray[15];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31);
    }
}

