/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.TestJNDIBulkOps;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestJNDIBulkOps {
    static final String FILENAME = "BulkJndiTest.txt";
    private static final Logger log = Logger.getLogger(TestJNDIBulkOps.class.getName());

    public static void main(String[] args) {
        log.addHandler(new ConsoleHandler());
        log.setLevel(Level.FINE);
        Properties properties = new Properties();
        properties = CBUtility.readPropertyFile(FILENAME);
        if (properties.size() == 0) {
            log.warning("Can't find: BulkJndiTest.txt");
            return;
        }
        new TestJNDIBulkOps(args, properties);
    }

    public TestJNDIBulkOps(String[] args, Properties properties) {
        String url = null;
        String user = null;
        String pwd = null;
        String version = "3";
        String referral = "follow";
        boolean useSSL = false;
        boolean tracing = false;
        boolean debugFlag = false;
        boolean terminateFlag = false;
        boolean printstackFlag = false;
        try {
            block18: for (int i = 0; i < args.length; ++i) {
                String arg = args[i].charAt(0) != '-' ? args[i] : args[i].substring(1);
                switch (arg.charAt(0)) {
                    case '?': 
                    case 'H': 
                    case 'h': {
                        if (args.length > i + 1) {
                            System.out.println(args[i + 1]);
                        } else {
                            return;
                        }
                    }
                    case 'D': 
                    case 'd': {
                        debugFlag = true;
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        terminateFlag = true;
                        continue block18;
                    }
                    case 'P': 
                    case 'p': {
                        pwd = args[++i];
                        continue block18;
                    }
                    case 'R': 
                    case 'r': {
                        referral = args[++i];
                        continue block18;
                    }
                    case 'S': 
                    case 's': {
                        useSSL = true;
                        continue block18;
                    }
                    case 'T': 
                    case 't': {
                        tracing = true;
                        continue block18;
                    }
                    case 'U': 
                    case 'u': {
                        user = args[++i];
                        continue block18;
                    }
                    case 'V': 
                    case 'v': {
                        version = args[++i];
                        continue block18;
                    }
                    case 'X': 
                    case 'x': {
                        printstackFlag = true;
                        continue block18;
                    }
                    default: {
                        System.out.println("\n\nInvalid command line argument: -" + arg);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error reading command line arguments.");
            System.exit(-1);
        }
        int numberOfThreads = -1;
        int numberOfIterations = -1;
        try {
            numberOfThreads = Integer.parseInt(properties.getProperty("NumberOfThreads").toString());
            numberOfIterations = Integer.parseInt(properties.getProperty("NumberOfIterations").toString());
            if (numberOfThreads <= 0 || numberOfThreads > 20) {
                System.out.println("Problem accessing the number of threads you wish to run.  Check the property file 'BulkJndiTest.txt' and make sure the 'NumberOfThreads' entry contains a valid integer between 1 and 10.");
                System.exit(-1);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Problem accessing the number of threads you wish to run.  Check the property file 'BulkJndiTest.txt' and make sure the  'NumberOfThreads' entry contains a valid integer between 1 and 10.  Also check that the 'NumberOfIterations' contains a valid integer.");
            System.exit(-1);
        }
        url = properties.getProperty("ComputerName").toString() + ":" + properties.getProperty("Port").toString();
        if (url == null) {
            System.out.println("Problem accessing the computer name from the property file 'BulkJndiTest.txt'.Please check that a valid name is supplied in the 'ComputerName' entry.");
            System.exit(-1);
        }
        Thread[] threads = new Thread[]{new Thread((Runnable)new Test(this, properties.getProperty("ThreadOneLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread ONE"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadTwoLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread TWO"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadThreeLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread THREE"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadFourLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread FOUR"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadFiveLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread FIVE"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadSixLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread SIX"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadSevenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread SEVEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadEightLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread EIGHT"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadNineLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread NINE"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadTenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread TEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadElevenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread ELEVEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadTwelveLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread TWELVE"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadThreeteenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread THIRTEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadFourteenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread FOURTEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadFifteenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread FIFTTEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadSixteenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread SIXTEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadSeventeenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread SEVENTEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadEighteenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread EIGHTEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadNineteenLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread NINETEEN"), new Thread((Runnable)new Test(this, properties.getProperty("ThreadTwentyLDIFFileName").toString(), url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag, numberOfIterations), "Test Thread TWENTY")};
        for (int i = 0; i < numberOfThreads; ++i) {
            try {
                threads[i].start();
                System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nStarting Thread: " + threads[i].getName() + "\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
                continue;
            }
            catch (IllegalThreadStateException e) {
                System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nError Starting Thread: " + threads[i].getName() + "\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + e);
            }
        }
    }
}

