@ECHO OFF
rem Licensed to the Apache Software Foundation (ASF) under one or more
rem contributor license agreements.  See the NOTICE file distributed with
rem this work for additional information regarding copyright ownership.
rem The ASF licenses this file to You under the Apache License, Version 2.0
rem (the "License"); you may not use this file except in compliance with
rem the License.  You may obtain a copy of the License at
rem
rem     https://www.apache.org/licenses/LICENSE-2.0
rem
rem Unless required by applicable law or agreed to in writing, software
rem distributed under the License is distributed on an "AS IS" BASIS,
rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
rem See the License for the specific language governing permissions and
rem limitations under the License.

rem ---------------------------------------------------------------------------
rem Test script for procrun
rem to run it you need:
rem 1 - the commons-daemon-*-tests.jar
rem 2 - procrun.exe in a subdirectory (usually something like WIN10_X64_EXE_RELEASE\prunsrv.exe)
rem 3 - use cmd/c test.bat in the command Prompt (cmd)
rem the test are OK once test.bat Done!!! is displayed at the test of the bat script.

SETLOCAL ENABLEEXTENSIONS
SETLOCAL EnableDelayedExpansion
SET mypath=%cd%
WHERE /r ..\..\ prunsrv.exe 1>in.txt
SET /p myserv=<in.txt
WHERE /r ..\..\..\..\..\..\..\target *-tests.jar  1>in.txt
SET /p myjar=<in.txt
ECHO "myserv: %myserv%"
ECHO "myjar: %myjar%"
ECHO "%mypath: %mypath%"

echo "cleaning..."
call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "Stop service failed"
)
call mybanner deleting
%myserv% //DS//TestService
if %errorlevel% equ 9 (
  echo "delete failed, not installed"
) else (
  if %errorlevel% neq 0 (
    echo "delete failed"
    exit 1
  )
)
call cleanstd
echo "cleaned"

rem install the service to test DAEMON-383
echo ""
call mybanner "install java service test DAEMON-383"
echo ""
%myserv% //IS//TestService --Description="Procrun tests" --DisplayName="Test Service" --Install=%myserv% --StartMode=exe --StartPath=%mypath% --StartImage=cmd.exe ++StartParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon" --StopMode=exe --StopPath=%mypath% --StopImage=cmd.exe ++StopParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 1" --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)

call startservice
call testservice

rem ask the service to write in stdoout and stderr
java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 5
java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 6

rem the files:
rem rw-r--r-- 1 Administrator None      0 Apr 28 00:55 testservice-stderr.2025-04-28.log
rem rw-r--r-- 1 Administrator None      0 Apr 28 00:55 testservice-stdout.2025-04-28.log
rem should NOT be empty
call isemptystd.bat

call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "No timeout No wait stop failed"
  %myserv% //PS//TestService
  exit 1
)
call deleteservice
call cleanstd

echo ""
call mybanner "install jvm service test DAEMON-383"
echo ""
%myserv% //IS//TestService --Description="Procrun jvm tests" --DisplayName="Test Service" --Install=%myserv% --JavaHome %JAVA_HOME% --StartMode=jvm --StartPath=%mypath% --StartClass=org.apache.commons.daemon.ProcrunDaemon --StartMethod=start ++StartParams=procstart --StopMode=jvm --StopClass=org.apache.commons.daemon.ProcrunDaemon --StopMethod=stop ++StopParams 1 --Classpath=%myjar% --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)

call startservice
call testservice

rem ask the service to write in stdoout and stderr
java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 5
java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 6

rem check out stdout and stderr files
call isemptystd.bat

call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "No timeout No wait stop failed"
  %myserv% //PS//TestService
  exit 1
)
call deleteservice
call cleanstd

rem install service with notimeout and no wait
echo ""
call mybanner "install service with no timeout and use no waitiing in the test program"
echo ""
%myserv% //IS//TestService --Description="Procrun tests" --DisplayName="Test Service" --Install=%myserv% --StartMode=exe --StartPath=%mypath% --StartImage=cmd.exe ++StartParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon" --StopMode=exe --StopPath=%mypath% --StopImage=cmd.exe ++StopParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 1" --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)

call startservice
call testservice
call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "No timeout No wait stop failed"
  %myserv% //PS//TestService
  exit 1
)

rem start the service and make the java part to stop
call startservice
java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 1
if %errorlevel% neq 0 (
  echo "sending command 1 to the java part failed"
  exit 1
)
java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 0
if %errorlevel% equ 0 (
  echo "command 1 to the java part failed, service still there"
  exit 1
)
echo "Stop an exited service..."
call stopservice
call deleteservice

rem install service with timeout 10 and use 60 sec wait in the test program
echo ""
call mybanner "install service with timeout 10 and 60 sec wait"
echo ""
%myserv% //IS//TestService --Description="Procrun tests" --DisplayName="Test Service" --Install=%myserv% --StartMode=exe --StartPath=%mypath% --StartImage=cmd.exe ++StartParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon" --StopMode=exe --StopPath=%mypath% --StopImage=cmd.exe ++StopParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 2" --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto --StopTimeout 10
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)
call startservice
call testservice
call mybanner "stopping timeout 10 and wait 60"
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "timeout 10 and wait 60 failed"
  %myserv% //PS//TestService
  exit 1
)
call deleteservice

rem install service with timeout 10 and use 60+60 sec wait program (block the stop command for 60 sec and simulate another 60 sec wait before stopping.
rem the client will take 60 sec to stop the server
echo ""
call mybanner "install service with timeout 10 and 60+60 sec wait"
echo ""
%myserv% //IS//TestService --Description="Procrun tests" --DisplayName="Test Service" --Install=%myserv% --StartMode=exe --StartPath=%mypath% --StartImage=cmd.exe ++StartParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon" --StopMode=exe --StopPath=%mypath% --StopImage=cmd.exe ++StopParams="/c java  -cp %myjar% org.apache.commons.daemon.ProcrunDaemon 4" --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto --StopTimeout 10
if %errorlevel% neq 0 (
  echo "install service with timeout 10 and 60+60 sec wait failed"
  exit 1
)
call startservice
call testservice
call mybanner "stopping service with timeout 10 and 60+60 sec wait"
%myserv% //SS//TestService
if %errorlevel% equ 0 (
  echo "timeout 10 and wait 60+60 should have failed"
  %myserv% //PS//TestService
  dir %mypath%
  type %mypath%\*.log
  exit 1
)

rem the service is still running wait for it.
rem procrun kills the child processes
call waituntilstop
if %errorlevel% neq 0 (
  echo "Not stopped"
  %myserv% //PS//TestService
  exit 1
)

call mybanner deleting
%myserv% //DS//TestService
if %errorlevel% equ 9 (
  echo "delete failed, not installed"
) else (
  if %errorlevel% neq 0 (
    echo "delete failed"
    echo "%errorlevel%"
    %myserv% //PS//TestService
    exit 1
  )
)

rem java service tests, basically use java as exe
echo ""
call mybanner "install java service with timeout 10 and 60 sec wait"
echo ""
%myserv% //IS//TestService --Description="Procrun tests" --DisplayName="Test Service" --Install=%myserv% --StartMode=Java --StartPath=%mypath% --Classpath=%myjar% --StartClass=org.apache.commons.daemon.ProcrunDaemon --StartMethod=main --StopMode=Java --StopPath=%mypath% --StopClass=org.apache.commons.daemon.ProcrunDaemon --StopMethod=main ++StopParams="2" --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto --StopTimeout 10
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)

call startservice
call testservice
call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "java service tests timeout 10 and wait 60 failed"
  %myserv% //PS//TestService
  exit 1
)
call deleteservice

rem install jvm service with notimeout and no wait
echo ""
echo "install jvm service with notimeout and no wait"
echo "JAVA_HOME : %JAVA_HOME%"
echo ""
%myserv% //IS//TestService --Description="Procrun jvm tests" --DisplayName="Test Service" --Install=%myserv% --JavaHome %JAVA_HOME% --StartMode=jvm --StartPath=%mypath% --StartClass=org.apache.commons.daemon.ProcrunDaemon --StartMethod=start ++StartParams=procstart --StopMode=jvm --StopClass=org.apache.commons.daemon.ProcrunDaemon --StopMethod=stop ++StopParams 1 --Classpath=%myjar% --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)
call startservice
call testservice
call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% neq 0 (
  echo "jvm service tests notimeout and no wait failed"
  %myserv% //PS//TestService
  exit 1
)
call deleteservice

rem install jvm service with 10 timeout and 60 wait
echo ""
echo "install jvm service with 10 timeout and 60 wait"
echo ""
%myserv% //IS//TestService --Description="Procrun jvm tests" --DisplayName="Test Service" --Install=%myserv% --StartMode=jvm --JavaHome %JAVA_HOME% --StartPath=%mypath% --StartClass=org.apache.commons.daemon.ProcrunDaemon --StartMethod=start ++StartParams=procstart --StopMode=jvm --StopClass=org.apache.commons.daemon.ProcrunDaemon --StopMethod=stop ++StopParams 3 --Classpath=%myjar% --LogPath=%mypath% --LogLevel=Debug --StdOutput=auto --StdError=auto --StopTimeout=10
if %errorlevel% neq 0 (
  echo "install failed"
  exit 1
)
call startservice
call testservice
call mybanner stopping
%myserv% //SS//TestService
if %errorlevel% equ 0 (
  echo "jvm service tests 10 timeout and 60 wait should have failed"
  %myserv% //PS//TestService
  dir %mypath%
  type %mypath%\*.log
  exit 1
)
call deleteservice

call mybanner "test.bat Done!!!"
