/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;

public class Interrupt
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Iterator it = this.m_args.iterator();
        while (it.hasNext()) {
            Long uniqueID = Etc.safeGetLong(it.next(), "thread ID");
            ObjectReference oRef = this.m_debugger.getStore().get(uniqueID);
            if (oRef == null) {
                throw new JDEException("Invalid ThreadID, or the thread is dead");
            }
            if (oRef instanceof ThreadReference) {
                ((ThreadReference)oRef).interrupt();
                continue;
            }
            throw new JDEException("The object is not a thread");
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, null, true);
    }

    public Object clone() {
        return new Interrupt();
    }
}

