/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_SENSOR_NUMBERS_OEM_DELL_SPEC_H
#define IPMI_SENSOR_NUMBERS_OEM_DELL_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Dell Poweredge R610
 * Dell Poweredge R710
 */

#define IPMI_SENSOR_NUMBER_OEM_DELL_ECC_CORRECTABLE_ERRORS                              0x01
#define IPMI_SENSOR_NUMBER_OEM_DELL_ECC_UNCORRECTABLE_ERRORS                            0x02
#define IPMI_SENSOR_NUMBER_OEM_DELL_IO_CHANNEL_CHECK                                    0x03
#define IPMI_SENSOR_NUMBER_OEM_DELL_PCI_PARITY_ERROR                                    0x04
#define IPMI_SENSOR_NUMBER_OEM_DELL_PCI_SYSTEM_ERROR                                    0x05
#define IPMI_SENSOR_NUMBER_OEM_DELL_EVENT_LOGGING_FOR_CORRECTABLE_ECC_EVENTS_DISABLED   0x06
#define IPMI_SENSOR_NUMBER_OEM_DELL_EVENT_LOGGING_DISABLED                              0x07
#define IPMI_SENSOR_NUMBER_OEM_DELL_UNKNOWN_ERROR                                       0x08
#define IPMI_SENSOR_NUMBER_OEM_DELL_CPU_INTERNAL_ERROR                                  0x09
#define IPMI_SENSOR_NUMBER_OEM_DELL_CPU_PROTOCOL_ERROR                                  0x0A
#define IPMI_SENSOR_NUMBER_OEM_DELL_CPU_BUS_PERR                                        0x0B
#define IPMI_SENSOR_NUMBER_OEM_DELL_CPU_BUS_INITIALIZATION_ERROR                        0x0C
#define IPMI_SENSOR_NUMBER_OEM_DELL_CPU_MACHINE_CHECK_ERROR                             0x0D
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_SPARE                                        0x11
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_MIRROR                                       0x12
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_RAID                                         0x13
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_HOT_ADD                                      0x14
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_HOT_REMOVE                                   0x15
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_HOT_FAILURE                                  0x16
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_REDUNDANCY_REGAINED                          0x17
#define IPMI_SENSOR_NUMBER_OEM_DELL_FATAL_PCI_EXPRESS_ERRORS                            0x18
#define IPMI_SENSOR_NUMBER_OEM_DELL_CHIPSET_ERROR                                       0x19
#define IPMI_SENSOR_NUMBER_OEM_DELL_ERROR_REGISTER_POINTER                              0x1A
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEMORY_CORRECTABLE_ECC_WARNING_OR_CRITICAL_EXCEEDED 0x1B
#define IPMI_SENSOR_NUMBER_OEM_DELL_CRC_MEMORY_ERROR                                    0x1C
#define IPMI_SENSOR_NUMBER_OEM_DELL_USB_OVER_CURRENT                                    0x1D
#define IPMI_SENSOR_NUMBER_OEM_DELL_POST_FATAL_ERROR                                    0x1E
#define IPMI_SENSOR_NUMBER_OEM_DELL_INCOMPATIBLE_BMC_FIRMWARE                           0x1F
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEM_OVERTEMP                                        0x20
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEM_FATAL_SB_CRC                                    0x21
#define IPMI_SENSOR_NUMBER_OEM_DELL_MEM_FATAL_NB_CRC                                    0x22
#define IPMI_SENSOR_NUMBER_OEM_DELL_OS_WATCHDOG_TIMER                                   0x23
#define IPMI_SENSOR_NUMBER_OEM_DELL_LINK_TUNING_ERROR                                   0x24
#define IPMI_SENSOR_NUMBER_OEM_DELL_LT_FLEXADDR                                         0x25
#define IPMI_SENSOR_NUMBER_OEM_DELL_NON_FATAL_PCI_EXPRESS_ERRORS                        0x26
#define IPMI_SENSOR_NUMBER_OEM_DELL_FATAL_IO_ERROR                                      0x27
#define IPMI_SENSOR_NUMBER_OEM_DELL_MSR_INFO_LOG                                        0x28
#define IPMI_SENSOR_NUMBER_OEM_DELL_QPI_LINK_ERROR_SENSOR                               0x29
#define IPMI_SENSOR_NUMBER_OEM_DELL_TXT_SX_SENTER_COMMAND_ERROR                         0x2A
#define IPMI_SENSOR_NUMBER_OEM_DELL_IDPT_MEMORY_ONLINE_FAILURE                          0x2B

/*
 * Dell Poweredge C410x
 */

#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FB_TEMP      0x17
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_BOARD_TEMP_1 0x01
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_BOARD_TEMP_2 0x02
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_BOARD_TEMP_3 0x03
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_BOARD_TEMP_4 0x04
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_BOARD_TEMP_5 0x05
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_BOARD_TEMP_6 0x06
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_1_TEMP  0x07
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_2_TEMP  0x08
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_3_TEMP  0x09
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_4_TEMP  0x0A
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_5_TEMP  0x0B
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_6_TEMP  0x0C
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_7_TEMP  0x0D
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_8_TEMP  0x0E
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_9_TEMP  0x0F
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_10_TEMP 0x10
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_11_TEMP 0x11
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_12_TEMP 0x12
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_13_TEMP 0x13
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_14_TEMP 0x14
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_15_TEMP 0x15
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_16_TEMP 0x16
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_1_WATT  0x50
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_2_WATT  0x51
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_3_WATT  0x52
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_4_WATT  0x53
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_5_WATT  0x54
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_6_WATT  0x55
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_7_WATT  0x56
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_8_WATT  0x57
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_9_WATT  0x58
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_10_WATT 0x59
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_11_WATT 0x5A
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_12_WATT 0x5B
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_13_WATT 0x5C
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_14_WATT 0x5D
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_15_WATT 0x5E
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PCIE_16_WATT 0x5F
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PSU_1_WATT   0x60
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PSU_2_WATT   0x61
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PSU_3_WATT   0x62
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_PSU_4_WATT   0x63
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_1        0x80
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_2        0x81
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_3        0x82
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_4        0x83
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_5        0x84
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_6        0x85
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_7        0x86
#define IPMI_SENSOR_NUMBER_OEM_DELL_C410X_FAN_8        0x87

#ifdef __cplusplus
}
#endif

#endif /* IPMI_SENSOR_NUMBERS_OEM_DELL_SPEC_H */
