/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextField
extends TextComponent {
    private static transient long next_textfield_number;
    private static final long serialVersionUID = -2966288784432217853L;
    private int columns;
    private char echoChar;
    private ActionListener action_listeners;

    public TextField() {
        this("", 0);
    }

    public TextField(String text) {
        this(text, text == null ? 0 : text.length());
    }

    public TextField(int columns) {
        this("", columns);
    }

    public TextField(String text, int columns) {
        super(text);
        this.columns = columns < 0 ? 0 : columns;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + columns);
        }
        this.columns = columns;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char echoChar) {
        this.setEchoCharacter(echoChar);
    }

    public void setEchoCharacter(char echoChar) {
        this.echoChar = echoChar;
        TextFieldPeer peer = (TextFieldPeer)this.getPeer();
        if (peer != null) {
            peer.setEchoChar(echoChar);
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getColumns());
    }

    public Dimension getMinimumSize(int columns) {
        return this.minimumSize(columns);
    }

    @Override
    public Dimension minimumSize() {
        return this.minimumSize(this.getColumns());
    }

    public Dimension minimumSize(int columns) {
        if (this.isMinimumSizeSet()) {
            return new Dimension(this.minSize);
        }
        TextFieldPeer peer = (TextFieldPeer)this.getPeer();
        if (peer == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return peer.getMinimumSize(columns);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getColumns());
    }

    public Dimension getPreferredSize(int columns) {
        return this.preferredSize(columns);
    }

    @Override
    public Dimension preferredSize() {
        return this.preferredSize(this.getColumns());
    }

    public Dimension preferredSize(int columns) {
        if (this.isPreferredSizeSet()) {
            return new Dimension(this.prefSize);
        }
        TextFieldPeer peer = (TextFieldPeer)this.getPeer();
        if (peer == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return peer.getPreferredSize(columns);
    }

    @Override
    public void addNotify() {
        if (this.getPeer() != null) {
            return;
        }
        this.setPeer(this.getToolkit().createTextField(this));
        super.addNotify();
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
        this.enableEvents(128L);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, listener);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    @Override
    protected String paramString() {
        return String.valueOf(this.getClass().getName()) + "(columns=" + this.getColumns() + ",echoChar=" + this.getEchoChar();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ActionListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.action_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    String generateName() {
        return "textfield" + TextField.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_textfield_number++;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return new AccessibleAWTTextField();
    }

    protected class AccessibleAWTTextField
    extends TextComponent.AccessibleAWTTextComponent {
        private static final long serialVersionUID = 6219164359235943158L;

        protected AccessibleAWTTextField() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }
    }
}

