/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

public class BasicSliderUI
extends SliderUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected TrackListener trackListener;
    protected Insets focusInsets;
    protected Insets insetCache;
    protected Rectangle contentRect;
    protected Rectangle focusRect;
    protected Rectangle thumbRect;
    protected Rectangle tickRect;
    protected Rectangle labelRect;
    protected Rectangle trackRect;
    public static final int MAX_SCROLL = 2;
    public static final int MIN_SCROLL = -2;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int POSITIVE_SCROLL = 1;
    protected int trackBuffer;
    protected boolean leftToRightCache;
    protected Timer scrollTimer;
    protected JSlider slider;
    private transient Color shadowColor;
    private transient Color highlightColor;
    private transient Color focusColor;
    boolean dragging;

    public BasicSliderUI(JSlider b) {
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent b) {
        return new BasicSliderUI((JSlider)b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JSlider) {
            this.slider = (JSlider)c;
            this.focusRect = new Rectangle();
            this.contentRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.trackRect = new Rectangle();
            this.tickRect = new Rectangle();
            this.labelRect = new Rectangle();
            this.insetCache = this.slider.getInsets();
            this.leftToRightCache = !this.slider.getInverted();
            this.scrollTimer = new Timer(200, null);
            this.scrollTimer.setRepeats(true);
            this.installDefaults(this.slider);
            this.installListeners(this.slider);
            this.installKeyboardActions(this.slider);
            this.calculateFocusRect();
            this.calculateContentRect();
            this.calculateThumbSize();
            this.calculateTrackBuffer();
            this.calculateTrackRect();
            this.calculateThumbLocation();
            this.calculateTickRect();
            this.calculateLabelRect();
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallKeyboardActions(this.slider);
        this.uninstallListeners(this.slider);
        this.scrollTimer = null;
        this.focusRect = null;
        this.contentRect = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.tickRect = null;
        this.labelRect = null;
        this.focusInsets = null;
    }

    protected void installDefaults(JSlider slider) {
        LookAndFeel.installColors(slider, "Slider.background", "Slider.foreground");
        LookAndFeel.installBorder(slider, "Slider.border");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = UIManager.getInsets("Slider.focusInsets");
        slider.setOpaque(true);
    }

    protected TrackListener createTrackListener(JSlider slider) {
        return new TrackListener();
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    protected ComponentListener createComponentListener(JSlider slider) {
        return new ComponentHandler();
    }

    protected FocusListener createFocusListener(JSlider slider) {
        return new FocusHandler();
    }

    protected ScrollListener createScrollListener(JSlider slider) {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new PropertyChangeHandler();
    }

    protected void installListeners(JSlider slider) {
        this.propertyChangeListener = this.createPropertyChangeListener(slider);
        this.componentListener = this.createComponentListener(slider);
        this.trackListener = this.createTrackListener(slider);
        this.focusListener = this.createFocusListener(slider);
        this.changeListener = this.createChangeListener(slider);
        this.scrollListener = this.createScrollListener(slider);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        slider.addComponentListener(this.componentListener);
        slider.addMouseListener(this.trackListener);
        slider.addMouseMotionListener(this.trackListener);
        slider.addFocusListener(this.focusListener);
        slider.getModel().addChangeListener(this.changeListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    protected void uninstallListeners(JSlider slider) {
        slider.removePropertyChangeListener(this.propertyChangeListener);
        slider.removeComponentListener(this.componentListener);
        slider.removeMouseListener(this.trackListener);
        slider.removeMouseMotionListener(this.trackListener);
        slider.removeFocusListener(this.focusListener);
        slider.getModel().removeChangeListener(this.changeListener);
        this.scrollTimer.removeActionListener(this.scrollListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.trackListener = null;
        this.focusListener = null;
        this.changeListener = null;
        this.scrollListener = null;
    }

    protected void installKeyboardActions(JSlider slider) {
        InputMap keyMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(slider, 0, keyMap);
        ActionMap map = this.getActionMap();
        SwingUtilities.replaceUIActionMap(slider, map);
    }

    protected void uninstallKeyboardActions(JSlider slider) {
        SwingUtilities.replaceUIActionMap(slider, null);
        SwingUtilities.replaceUIInputMap(slider, 0, null);
    }

    public Dimension getPreferredHorizontalSize() {
        Dimension dim = UIManager.getDimension("Slider.horizontalSize");
        if (dim == null) {
            dim = new Dimension(200, 21);
        }
        return dim;
    }

    public Dimension getPreferredVerticalSize() {
        Dimension dim = UIManager.getDimension("Slider.verticalSize");
        if (dim == null) {
            dim = new Dimension(21, 200);
        }
        return dim;
    }

    public Dimension getMinimumHorizontalSize() {
        Dimension dim = UIManager.getDimension("Slider.minimumHorizontalSize");
        if (dim == null) {
            dim = new Dimension(36, 21);
        }
        return dim;
    }

    public Dimension getMinimumVerticalSize() {
        Dimension dim = UIManager.getDimension("Slider.minimumVerticalSize");
        if (dim == null) {
            dim = new Dimension(21, 36);
        }
        return dim;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension dim;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 0) {
            dim = new Dimension(this.getPreferredHorizontalSize());
            dim.height = this.insetCache.top + this.insetCache.bottom;
            dim.height += this.focusInsets.top + this.focusInsets.bottom;
            dim.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        } else {
            dim = new Dimension(this.getPreferredVerticalSize());
            dim.width = this.insetCache.left + this.insetCache.right;
            dim.width += this.focusInsets.left + this.focusInsets.right;
            dim.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        }
        return dim;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension dim;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 0) {
            dim = new Dimension(this.getMinimumHorizontalSize());
            dim.height = this.insetCache.top + this.insetCache.bottom;
            dim.height += this.focusInsets.top + this.focusInsets.bottom;
            dim.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        } else {
            dim = new Dimension(this.getMinimumVerticalSize());
            dim.width = this.insetCache.left + this.insetCache.right;
            dim.width += this.focusInsets.left + this.focusInsets.right;
            dim.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        }
        return dim;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension dim = this.getPreferredSize(c);
        if (this.slider.getOrientation() == 0) {
            dim.width = Short.MAX_VALUE;
        } else {
            dim.height = Short.MAX_VALUE;
        }
        return dim;
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
        this.focusRect.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
    }

    protected void calculateThumbSize() {
        Dimension d = this.getThumbSize();
        this.thumbRect.width = d.width;
        this.thumbRect.height = d.height;
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - this.focusInsets.left - this.focusInsets.right;
        this.contentRect.height = this.focusRect.height - this.focusInsets.top - this.focusInsets.bottom;
    }

    protected void calculateThumbLocation() {
        int value = this.slider.getValue();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.x = this.xPositionForValue(value) - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + 1;
        } else {
            this.thumbRect.x = this.trackRect.x + 1;
            this.thumbRect.y = this.yPositionForValue(value) - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        if (this.slider.getOrientation() == 0) {
            int w = Math.max(this.getWidthOfLowValueLabel(), this.getWidthOfHighValueLabel());
            this.trackBuffer = Math.max(this.thumbRect.width / 2, w / 2);
        } else {
            int h = Math.max(this.getHeightOfLowValueLabel(), this.getHeightOfHighValueLabel());
            this.trackBuffer = Math.max(this.thumbRect.height / 2, h / 2);
        }
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(11, 20);
        }
        return new Dimension(20, 11);
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int center = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                center += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                center += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - center - 1) / 2;
            this.trackRect.width = this.contentRect.width - 2 * this.trackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int center = this.thumbRect.width;
            if (this.slider.getPaintTicks()) {
                center += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                center += this.getWidthOfWidestLabel();
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - center - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - 2 * this.trackBuffer;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            this.tickRect.x = this.trackRect.x + this.trackRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.width = this.getTickLength();
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintLabels()) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                this.labelRect.x = this.tickRect.x;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width;
                this.labelRect.height = 0;
            }
        } else if (this.slider.getPaintLabels()) {
            this.labelRect.x = this.tickRect.x + this.tickRect.width;
            this.labelRect.y = this.tickRect.y - this.trackBuffer;
            this.labelRect.width = this.getWidthOfWidestLabel();
            this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
        } else {
            this.labelRect.x = this.tickRect.x + this.tickRect.width;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected int getWidthOfWidestLabel() {
        int widest = 0;
        Dictionary table = this.slider.getLabelTable();
        if (table != null) {
            Enumeration list2 = this.slider.getLabelTable().elements();
            while (list2.hasMoreElements()) {
                Component label = (Component)list2.nextElement();
                widest = Math.max(label.getPreferredSize().width, widest);
            }
        }
        return widest;
    }

    protected int getHeightOfTallestLabel() {
        int tallest = 0;
        if (this.slider.getLabelTable() == null) {
            return 0;
        }
        Enumeration list2 = this.slider.getLabelTable().elements();
        while (list2.hasMoreElements()) {
            Component label;
            Dimension pref;
            Object comp = list2.nextElement();
            if (!(comp instanceof Component) || (pref = (label = (Component)comp).getPreferredSize()) == null || pref.height <= tallest) continue;
            tallest = pref.height;
        }
        return tallest;
    }

    protected int getWidthOfHighValueLabel() {
        Component highValueLabel = this.getHighestValueLabel();
        if (highValueLabel != null) {
            return highValueLabel.getPreferredSize().width;
        }
        return 0;
    }

    protected int getWidthOfLowValueLabel() {
        Component lowValueLabel = this.getLowestValueLabel();
        if (lowValueLabel != null) {
            return lowValueLabel.getPreferredSize().width;
        }
        return 0;
    }

    protected int getHeightOfHighValueLabel() {
        Component highValueLabel = this.getHighestValueLabel();
        if (highValueLabel != null) {
            return highValueLabel.getPreferredSize().height;
        }
        return 0;
    }

    protected int getHeightOfLowValueLabel() {
        Component lowValueLabel = this.getLowestValueLabel();
        if (lowValueLabel != null) {
            return lowValueLabel.getPreferredSize().height;
        }
        return 0;
    }

    protected boolean drawInverted() {
        return this.slider.getInverted();
    }

    protected Component getLowestValueLabel() {
        Integer key = new Integer(Integer.MAX_VALUE);
        Dictionary labelTable = this.slider.getLabelTable();
        if (labelTable == null) {
            return null;
        }
        Enumeration list2 = labelTable.keys();
        while (list2.hasMoreElements()) {
            Integer tmpKey;
            Object value = list2.nextElement();
            if (!(value instanceof Integer) || (tmpKey = (Integer)value) >= key) continue;
            key = tmpKey;
        }
        Object comp = labelTable.get(key);
        if (!(comp instanceof Component)) {
            return null;
        }
        return (Component)comp;
    }

    protected Component getHighestValueLabel() {
        Integer key = new Integer(Integer.MIN_VALUE);
        Dictionary labelTable = this.slider.getLabelTable();
        if (labelTable == null) {
            return null;
        }
        Enumeration list2 = labelTable.keys();
        while (list2.hasMoreElements()) {
            Integer tmpKey;
            Object value = list2.nextElement();
            if (!(value instanceof Integer) || (tmpKey = (Integer)value) <= key) continue;
            key = tmpKey;
        }
        Object comp = labelTable.get(key);
        if (!(comp instanceof Component)) {
            return null;
        }
        return (Component)comp;
    }

    public void paint(Graphics g, JComponent c) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        if (this.slider.getPaintTrack() && this.hitClip(g, this.trackRect)) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintTicks() && this.hitClip(g, this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && this.hitClip(g, this.labelRect)) {
            this.paintLabels(g);
        }
        if (this.slider.hasFocus() && this.hitClip(g, this.focusRect)) {
            this.paintFocus(g);
        }
        if (this.hitClip(g, this.thumbRect)) {
            this.paintThumb(g);
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.slider.getInsets();
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateThumbLocation();
        this.calculateTickRect();
        this.calculateLabelRect();
    }

    public void paintFocus(Graphics g) {
        Color saved_color = g.getColor();
        g.setColor(this.getFocusColor());
        g.drawRect(this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        g.setColor(saved_color);
    }

    public void paintTrack(Graphics g) {
        int height;
        int width;
        Color saved_color = g.getColor();
        Point a = new Point(this.trackRect.x, this.trackRect.y + 1);
        Point b = new Point(a);
        Point c = new Point(a);
        Point d = new Point(a);
        if (this.slider.getOrientation() == 0) {
            width = this.trackRect.width;
            height = this.thumbRect.height / 4 == 0 ? 1 : this.thumbRect.height / 4;
            a.translate(0, this.trackRect.height / 2 - height / 2);
            b.translate(0, this.trackRect.height / 2 + height / 2);
            c.translate(this.trackRect.width, this.trackRect.height / 2 + height / 2);
            d.translate(this.trackRect.width, this.trackRect.height / 2 - height / 2);
        } else {
            width = this.thumbRect.width / 4 == 0 ? 1 : this.thumbRect.width / 4;
            height = this.trackRect.height;
            a.translate(this.trackRect.width / 2 - width / 2, 0);
            b.translate(this.trackRect.width / 2 - width / 2, this.trackRect.height);
            c.translate(this.trackRect.width / 2 + width / 2, this.trackRect.height);
            d.translate(this.trackRect.width / 2 + width / 2, 0);
        }
        g.setColor(Color.GRAY);
        g.fillRect(a.x, a.y, width, height);
        g.setColor(this.getHighlightColor());
        g.drawLine(b.x, b.y, c.x, c.y);
        g.drawLine(c.x, c.y, d.x, d.y);
        g.setColor(this.getShadowColor());
        g.drawLine(b.x, b.y, a.x, a.y);
        g.drawLine(a.x, a.y, d.x, d.y);
        g.setColor(saved_color);
    }

    public void paintTicks(Graphics g) {
        int i;
        int max = this.slider.getMaximum();
        int min = this.slider.getMinimum();
        int majorSpace = this.slider.getMajorTickSpacing();
        int minorSpace = this.slider.getMinorTickSpacing();
        if (majorSpace > 0) {
            if (this.slider.getOrientation() == 0) {
                g.translate(0, this.tickRect.y);
                i = min;
                while (i <= max) {
                    this.paintMajorTickForHorizSlider(g, this.tickRect, this.xPositionForValue(i));
                    i += majorSpace;
                }
                g.translate(0, -this.tickRect.y);
            } else {
                g.translate(this.tickRect.x, 0);
                i = min;
                while (i <= max) {
                    this.paintMajorTickForVertSlider(g, this.tickRect, this.yPositionForValue(i));
                    i += majorSpace;
                }
                g.translate(-this.tickRect.x, 0);
            }
        }
        if (minorSpace > 0) {
            if (this.slider.getOrientation() == 0) {
                g.translate(0, this.tickRect.y);
                i = min;
                while (i <= max) {
                    this.paintMinorTickForHorizSlider(g, this.tickRect, this.xPositionForValue(i));
                    i += minorSpace;
                }
                g.translate(0, -this.tickRect.y);
            } else {
                g.translate(this.tickRect.x, 0);
                i = min;
                while (i <= max) {
                    this.paintMinorTickForVertSlider(g, this.tickRect, this.yPositionForValue(i));
                    i += minorSpace;
                }
                g.translate(-this.tickRect.x, 0);
            }
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        int y = this.tickRect.height / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x, y + this.tickRect.height / 4);
        g.setColor(saved);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        int y = this.tickRect.height / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x, y + this.tickRect.height / 2);
        g.setColor(saved);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        int x = this.tickRect.width / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x + this.tickRect.width / 4, y);
        g.setColor(saved);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        int x = this.tickRect.width / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x + this.tickRect.width / 2, y);
        g.setColor(saved);
    }

    public void paintLabels(Graphics g) {
        Dictionary table = this.slider.getLabelTable();
        if (table != null) {
            int min = this.slider.getMinimum();
            int max = this.slider.getMaximum();
            Enumeration list2 = table.keys();
            while (list2.hasMoreElements()) {
                Integer key = (Integer)list2.nextElement();
                int value = key;
                if (value < min || value > max) continue;
                Component label = (Component)table.get(key);
                if (this.slider.getOrientation() == 0) {
                    g.translate(0, this.labelRect.y);
                    this.paintHorizontalLabel(g, value, label);
                    g.translate(0, -this.labelRect.y);
                    continue;
                }
                g.translate(this.labelRect.x, 0);
                this.paintVerticalLabel(g, value, label);
                g.translate(-this.labelRect.x, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        int center = this.xPositionForValue(value);
        int left = center - label.getPreferredSize().width / 2;
        g.translate(left, 0);
        label.paint(g);
        g.translate(-left, 0);
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        int center = this.yPositionForValue(value);
        int top = center - label.getPreferredSize().height / 2;
        g.translate(0, top);
        label.paint(g);
        g.translate(0, -top);
    }

    public void paintThumb(Graphics g) {
        Polygon all;
        Polygon light;
        Polygon dark;
        Polygon bright;
        Color saved_color = g.getColor();
        Point a = new Point(this.thumbRect.x, this.thumbRect.y);
        Point b = new Point(a);
        Point c = new Point(a);
        Point d = new Point(a);
        Point e = new Point(a);
        if (this.slider.getOrientation() == 0) {
            int turnPoint = this.thumbRect.height * 3 / 4;
            b.translate(this.thumbRect.width - 1, 0);
            c.translate(this.thumbRect.width - 1, turnPoint);
            d.translate(this.thumbRect.width / 2 - 1, this.thumbRect.height - 1);
            e.translate(0, turnPoint);
            bright = new Polygon(new int[]{b.x - 1, a.x, e.x, d.x}, new int[]{b.y, a.y, e.y, d.y}, 4);
            dark = new Polygon(new int[]{b.x, c.x, d.x + 1}, new int[]{b.y, c.y - 1, d.y}, 3);
            light = new Polygon(new int[]{b.x - 1, c.x - 1, d.x + 1}, new int[]{b.y + 1, c.y - 1, d.y - 1}, 3);
            all = new Polygon(new int[]{a.x + 1, b.x - 2, c.x - 2, d.x, e.x + 1}, new int[]{a.y + 1, b.y + 1, c.y - 1, d.y - 1, e.y}, 5);
        } else {
            int turnPoint = this.thumbRect.width * 3 / 4 - 1;
            b.translate(turnPoint, 0);
            c.translate(this.thumbRect.width - 1, this.thumbRect.height / 2);
            d.translate(turnPoint, this.thumbRect.height - 1);
            e.translate(0, this.thumbRect.height - 1);
            bright = new Polygon(new int[]{c.x - 1, b.x, a.x, e.x}, new int[]{c.y - 1, b.y, a.y, e.y - 1}, 4);
            dark = new Polygon(new int[]{c.x, d.x, e.x}, new int[]{c.y, d.y, e.y}, 3);
            light = new Polygon(new int[]{c.x - 1, d.x, e.x + 1}, new int[]{c.y, d.y - 1, e.y - 1}, 3);
            all = new Polygon(new int[]{a.x + 1, b.x, c.x - 2, c.x - 2, d.x, e.x + 1}, new int[]{a.y + 1, b.y + 1, c.y - 1, c.y, d.y - 2, e.y - 2}, 6);
        }
        g.setColor(Color.WHITE);
        g.drawPolyline(bright.xpoints, bright.ypoints, bright.npoints);
        g.setColor(Color.BLACK);
        g.drawPolyline(dark.xpoints, dark.ypoints, dark.npoints);
        g.setColor(Color.GRAY);
        g.drawPolyline(light.xpoints, light.ypoints, light.npoints);
        g.setColor(Color.LIGHT_GRAY);
        g.drawPolyline(all.xpoints, all.ypoints, all.npoints);
        g.fillPolygon(all);
        g.setColor(saved_color);
    }

    public void setThumbLocation(int x, int y) {
        Rectangle union = new Rectangle(this.thumbRect);
        this.thumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, union);
        this.slider.repaint(union);
    }

    public void scrollByBlock(int direction) {
        int unit = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
        int moveTo = this.slider.getValue();
        moveTo = direction > 0 ? (moveTo += unit) : (moveTo -= unit);
        if (this.slider.getSnapToTicks()) {
            moveTo = this.findClosestTick(moveTo);
        }
        this.slider.setValue(moveTo);
    }

    public void scrollByUnit(int direction) {
        int moveTo = this.slider.getValue();
        moveTo = direction > 0 ? ++moveTo : --moveTo;
        if (this.slider.getSnapToTicks()) {
            moveTo = this.findClosestTick(moveTo);
        }
        this.slider.setValue(moveTo);
    }

    protected void scrollDueToClickInTrack(int dir) {
        this.scrollTimer.stop();
        this.scrollListener.setDirection(dir);
        this.scrollListener.setScrollByBlock(true);
        this.scrollTimer.start();
    }

    protected int xPositionForValue(int value) {
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.width;
        double range = max - min;
        double pixPerVal = (double)len / range;
        int left = this.trackRect.x;
        int right = left + this.trackRect.width - 1;
        int xpos = !this.drawInverted() ? left + (int)Math.round(pixPerVal * ((double)value - (double)min)) : right - (int)Math.round(pixPerVal * ((double)value - (double)min));
        xpos = Math.max(left, xpos);
        xpos = Math.min(right, xpos);
        return xpos;
    }

    protected int yPositionForValue(int value) {
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.height;
        double range = max - min;
        double pixPerVal = (double)len / range;
        int top = this.trackRect.y;
        int bottom = top + this.trackRect.height - 1;
        int ypos = !this.drawInverted() ? top + (int)Math.round(pixPerVal * ((double)max - (double)value)) : top + (int)Math.round(pixPerVal * ((double)value - (double)min));
        ypos = Math.max(top, ypos);
        ypos = Math.min(bottom, ypos);
        return ypos;
    }

    public int valueForYPosition(int yPos) {
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.height;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = !this.drawInverted() ? (len - (yPos - this.trackRect.y)) * (max - min) / len + min : (yPos - this.trackRect.y) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public int valueForXPosition(int xPos) {
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.width;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = !this.drawInverted() ? (xPos - this.trackRect.x) * (max - min) / len + min : (len - (xPos - this.trackRect.x)) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    int findClosestTick(int value) {
        int lowerBound;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int majorSpace = this.slider.getMajorTickSpacing();
        int minorSpace = this.slider.getMinorTickSpacing();
        int minor = min - value;
        int major = min - value;
        if (majorSpace <= 0 && minorSpace <= 0) {
            return value;
        }
        if (majorSpace > 0) {
            lowerBound = (value - min) / majorSpace;
            int majLower = majorSpace * lowerBound + min;
            int majHigher = majorSpace * (lowerBound + 1) + min;
            major = majHigher <= max && majHigher - value <= value - majLower ? majHigher - value : majLower - value;
        }
        if (minorSpace > 0) {
            lowerBound = value / minorSpace;
            int minLower = minorSpace * lowerBound;
            int minHigher = minorSpace * (lowerBound + 1);
            minor = minHigher <= max && minHigher - value <= value - minLower ? minHigher - value : minLower - value;
        }
        if (Math.abs(minor) > Math.abs(major)) {
            return value + major;
        }
        return value + minor;
    }

    InputMap getInputMap(int condition) {
        if (condition == 0) {
            return (InputMap)UIManager.get("Slider.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("Slider.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.put("Slider.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("positiveUnitIncrement", new AbstractAction("positiveUnitIncrement"){

            public void actionPerformed(ActionEvent event) {
                JSlider slider = (JSlider)event.getSource();
                BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                if (slider.getInverted()) {
                    ui.scrollByUnit(-1);
                } else {
                    ui.scrollByUnit(1);
                }
            }
        });
        map.put("negativeUnitIncrement", new AbstractAction("negativeUnitIncrement"){

            public void actionPerformed(ActionEvent event) {
                JSlider slider = (JSlider)event.getSource();
                BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                if (slider.getInverted()) {
                    ui.scrollByUnit(1);
                } else {
                    ui.scrollByUnit(-1);
                }
            }
        });
        map.put("positiveBlockIncrement", new AbstractAction("positiveBlockIncrement"){

            public void actionPerformed(ActionEvent event) {
                JSlider slider = (JSlider)event.getSource();
                BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                if (slider.getInverted()) {
                    ui.scrollByBlock(-1);
                } else {
                    ui.scrollByBlock(1);
                }
            }
        });
        map.put("negativeBlockIncrement", new AbstractAction("negativeBlockIncrement"){

            public void actionPerformed(ActionEvent event) {
                JSlider slider = (JSlider)event.getSource();
                BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                if (slider.getInverted()) {
                    ui.scrollByBlock(1);
                } else {
                    ui.scrollByBlock(-1);
                }
            }
        });
        map.put("minScroll", new AbstractAction("minScroll"){

            public void actionPerformed(ActionEvent event) {
                JSlider slider = (JSlider)event.getSource();
                if (slider.getInverted()) {
                    slider.setValue(slider.getMaximum());
                } else {
                    slider.setValue(slider.getMinimum());
                }
            }
        });
        map.put("maxScroll", new AbstractAction("maxScroll"){

            public void actionPerformed(ActionEvent event) {
                JSlider slider = (JSlider)event.getSource();
                if (slider.getInverted()) {
                    slider.setValue(slider.getMinimum());
                } else {
                    slider.setValue(slider.getMaximum());
                }
            }
        });
        return map;
    }

    private boolean hitClip(Graphics g, Rectangle r) {
        return g.hitClip(r.x, r.y, r.width, r.height);
    }

    public class ActionScroller
    extends AbstractAction {
        public ActionScroller(JSlider slider, int dir, boolean block) {
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            BasicSliderUI.this.calculateThumbLocation();
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            BasicSliderUI.this.calculateGeometry();
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            BasicSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent e) {
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("orientation") || prop.equals("inverted") || prop.equals("labelTable") || prop.equals("majorTickSpacing") || prop.equals("minorTickSpacing") || prop.equals("paintTicks") || prop.equals("paintTrack") || prop.equals("paintLabels")) {
                BasicSliderUI.this.calculateGeometry();
                BasicSliderUI.this.slider.repaint();
            } else if (e.getPropertyName().equals("model")) {
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                oldModel.removeChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.slider.getModel().addChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.calculateThumbLocation();
                BasicSliderUI.this.slider.repaint();
            }
        }
    }

    public class ScrollListener
    implements ActionListener {
        private transient int direction;
        private transient boolean block;

        public ScrollListener() {
            this.direction = 1;
            this.block = false;
        }

        public ScrollListener(int dir, boolean block) {
            this.direction = dir;
            this.block = block;
        }

        public void actionPerformed(ActionEvent e) {
            if (!BasicSliderUI.this.trackListener.shouldScroll(this.direction)) {
                BasicSliderUI.this.scrollTimer.stop();
                return;
            }
            if (this.block) {
                BasicSliderUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderUI.this.scrollByUnit(this.direction);
            }
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.block = block;
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent e) {
            BasicSliderUI.this.dragging = true;
            if (BasicSliderUI.this.slider.isEnabled()) {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                if (BasicSliderUI.this.slider.getValueIsAdjusting()) {
                    int value = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) - this.offset : BasicSliderUI.this.valueForYPosition(this.currentMouseY) - this.offset;
                    BasicSliderUI.this.slider.setValue(value);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (BasicSliderUI.this.slider.isEnabled()) {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                int value = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) : BasicSliderUI.this.valueForYPosition(this.currentMouseY);
                if (BasicSliderUI.this.slider.getSnapToTicks()) {
                    value = BasicSliderUI.this.findClosestTick(value);
                }
                if (!BasicSliderUI.this.thumbRect.contains(e.getPoint())) {
                    if (value > BasicSliderUI.this.slider.getValue()) {
                        BasicSliderUI.this.scrollDueToClickInTrack(1);
                    } else {
                        BasicSliderUI.this.scrollDueToClickInTrack(-1);
                    }
                } else {
                    BasicSliderUI.this.slider.setValueIsAdjusting(true);
                    this.offset = value - BasicSliderUI.this.slider.getValue();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            BasicSliderUI.this.dragging = false;
            if (BasicSliderUI.this.slider.isEnabled()) {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                if (BasicSliderUI.this.slider.getValueIsAdjusting()) {
                    BasicSliderUI.this.slider.setValueIsAdjusting(false);
                    if (BasicSliderUI.this.slider.getSnapToTicks()) {
                        BasicSliderUI.this.slider.setValue(BasicSliderUI.this.findClosestTick(BasicSliderUI.this.slider.getValue()));
                    }
                }
                if (BasicSliderUI.this.scrollTimer != null) {
                    BasicSliderUI.this.scrollTimer.stop();
                }
            }
            BasicSliderUI.this.slider.repaint();
        }

        public boolean shouldScroll(int direction) {
            int value = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) : BasicSliderUI.this.valueForYPosition(this.currentMouseY);
            if (direction == 1) {
                return value > BasicSliderUI.this.slider.getValue();
            }
            return value < BasicSliderUI.this.slider.getValue();
        }
    }
}

