/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.typedesc;

import com.sun.star.lib.uno.typedesc.FieldDescription;
import com.sun.star.lib.uno.typedesc.MethodDescription;
import com.sun.star.lib.uno.typeinfo.AttributeTypeInfo;
import com.sun.star.lib.uno.typeinfo.MemberTypeInfo;
import com.sun.star.lib.uno.typeinfo.MethodTypeInfo;
import com.sun.star.lib.uno.typeinfo.ParameterTypeInfo;
import com.sun.star.lib.uno.typeinfo.TypeInfo;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeDescription {
    private static final Cache cache = new Cache();
    private final TypeClass typeClass;
    private final String typeName;
    private final String arrayTypeName;
    private final Class<?> zClass;
    private final TypeDescription[] superTypes;
    private final TypeDescription componentType;
    private final boolean hasTypeArguments;
    private final FieldDescription[] fieldDescriptions;
    private MethodDescription[] methodDescriptions = null;
    private MethodDescription[] superMethodDescriptions;

    public static TypeDescription getTypeDescription(String string) throws ClassNotFoundException {
        Type type = new Type(string);
        if (type.getTypeClass() == TypeClass.UNKNOWN) {
            type = string.startsWith("[]") ? new Type(string, TypeClass.SEQUENCE) : new Type(Class.forName(string));
        }
        return TypeDescription.get(type);
    }

    public static TypeDescription getTypeDescription(Class<?> clazz) {
        return TypeDescription.getDefinitely(new Type(clazz));
    }

    public static TypeDescription getTypeDescription(Type type) throws ClassNotFoundException {
        TypeDescription typeDescription = type.getTypeDescription();
        if (typeDescription == null) {
            typeDescription = TypeDescription.getTypeDescription(type.getTypeName());
            type.setTypeDescription(typeDescription);
        }
        return typeDescription;
    }

    public static TypeDescription getTypeDescription(TypeClass typeClass) {
        switch (typeClass.getValue()) {
            case 0: {
                return TypeDescription.getDefinitely(Type.VOID);
            }
            case 2: {
                return TypeDescription.getDefinitely(Type.BOOLEAN);
            }
            case 3: {
                return TypeDescription.getDefinitely(Type.BYTE);
            }
            case 4: {
                return TypeDescription.getDefinitely(Type.SHORT);
            }
            case 5: {
                return TypeDescription.getDefinitely(Type.UNSIGNED_SHORT);
            }
            case 6: {
                return TypeDescription.getDefinitely(Type.LONG);
            }
            case 7: {
                return TypeDescription.getDefinitely(Type.UNSIGNED_LONG);
            }
            case 8: {
                return TypeDescription.getDefinitely(Type.HYPER);
            }
            case 9: {
                return TypeDescription.getDefinitely(Type.UNSIGNED_HYPER);
            }
            case 10: {
                return TypeDescription.getDefinitely(Type.FLOAT);
            }
            case 11: {
                return TypeDescription.getDefinitely(Type.DOUBLE);
            }
            case 1: {
                return TypeDescription.getDefinitely(Type.CHAR);
            }
            case 12: {
                return TypeDescription.getDefinitely(Type.STRING);
            }
            case 13: {
                return TypeDescription.getDefinitely(Type.TYPE);
            }
            case 14: {
                return TypeDescription.getDefinitely(Type.ANY);
            }
        }
        return null;
    }

    public static boolean isTypeClassSimple(TypeClass typeClass) {
        return TypeDescription.getTypeDescription(typeClass) != null;
    }

    public TypeDescription getSuperType() {
        return this.superTypes == null || this.superTypes.length == 0 ? null : this.superTypes[0];
    }

    public MethodDescription[] getMethodDescriptions() {
        this.initMethodDescriptions();
        return this.methodDescriptions;
    }

    public MethodDescription getMethodDescription(int n) {
        this.initMethodDescriptions();
        return n < 0 ? null : (n < this.superMethodDescriptions.length ? this.superMethodDescriptions[n] : (n - this.superMethodDescriptions.length < this.methodDescriptions.length ? this.methodDescriptions[n - this.superMethodDescriptions.length] : null));
    }

    public MethodDescription getMethodDescription(String string) {
        int n;
        this.initMethodDescriptions();
        for (n = 0; n < this.superMethodDescriptions.length; ++n) {
            if (!this.superMethodDescriptions[n].getName().equals(string)) continue;
            return this.superMethodDescriptions[n];
        }
        for (n = 0; n < this.methodDescriptions.length; ++n) {
            if (!this.methodDescriptions[n].getName().equals(string)) continue;
            return this.methodDescriptions[n];
        }
        return null;
    }

    public FieldDescription[] getFieldDescriptions() {
        return this.fieldDescriptions;
    }

    public FieldDescription getFieldDescription(String string) {
        for (int i = 0; i < this.fieldDescriptions.length; ++i) {
            if (!this.fieldDescriptions[i].getName().equals(string)) continue;
            return this.fieldDescriptions[i];
        }
        return this.superTypes != null && this.superTypes.length == 1 ? this.superTypes[0].getFieldDescription(string) : null;
    }

    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    public TypeDescription getComponentType() {
        return this.componentType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getArrayTypeName() {
        return this.arrayTypeName;
    }

    public Class<?> getZClass() {
        return this.zClass;
    }

    public boolean hasTypeArguments() {
        return this.hasTypeArguments;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.getTypeClass() + ", " + this.getTypeName() + "]";
    }

    private static TypeDescription getDefinitely(Type type) {
        try {
            return TypeDescription.get(type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("this cannot happen: " + classNotFoundException);
        }
    }

    private static TypeDescription get(Type type) throws ClassNotFoundException {
        String string = type.getTypeName();
        TypeDescription typeDescription = cache.get(string);
        if (typeDescription == null) {
            typeDescription = TypeDescription.create(type);
            cache.put(typeDescription);
        }
        return typeDescription;
    }

    private static TypeDescription create(Type type) throws ClassNotFoundException {
        TypeClass typeClass = type.getTypeClass();
        String string = type.getTypeName();
        Class<?> clazz = type.getZClass();
        if (clazz == null) {
            throw new ClassNotFoundException("UNO type " + type);
        }
        switch (typeClass.getValue()) {
            case 0: {
                return new TypeDescription(typeClass, string, "[Ljava.lang.Void;", clazz, null, null);
            }
            case 2: {
                return new TypeDescription(typeClass, string, "[Z", clazz, null, null);
            }
            case 3: {
                return new TypeDescription(typeClass, string, "[B", clazz, null, null);
            }
            case 4: 
            case 5: {
                return new TypeDescription(typeClass, string, "[S", clazz, null, null);
            }
            case 6: 
            case 7: {
                return new TypeDescription(typeClass, string, "[I", clazz, null, null);
            }
            case 8: 
            case 9: {
                return new TypeDescription(typeClass, string, "[J", clazz, null, null);
            }
            case 10: {
                return new TypeDescription(typeClass, string, "[F", clazz, null, null);
            }
            case 11: {
                return new TypeDescription(typeClass, string, "[D", clazz, null, null);
            }
            case 1: {
                return new TypeDescription(typeClass, string, "[C", clazz, null, null);
            }
            case 12: {
                return new TypeDescription(typeClass, string, "[Ljava.lang.String;", clazz, null, null);
            }
            case 13: {
                return new TypeDescription(typeClass, string, "[Lcom.sun.star.uno.Type;", clazz, null, null);
            }
            case 14: {
                return new TypeDescription(typeClass, string, "[Ljava.lang.Object;", clazz, null, null);
            }
            case 20: {
                TypeDescription typeDescription = TypeDescription.getTypeDescription(string.substring("[]".length()));
                return new TypeDescription(typeClass, string, "[" + clazz.getName(), clazz, null, typeDescription);
            }
            case 15: {
                return new TypeDescription(typeClass, string, "[L" + clazz.getName() + ";", clazz, null, null);
            }
            case 17: {
                TypeDescription[] typeDescriptionArray;
                Class<?> clazz2 = clazz.getSuperclass();
                if (clazz2 != Object.class) {
                    TypeDescription[] typeDescriptionArray2 = new TypeDescription[1];
                    typeDescriptionArray = typeDescriptionArray2;
                    typeDescriptionArray2[0] = TypeDescription.get(new Type(clazz2));
                } else {
                    typeDescriptionArray = null;
                }
                TypeDescription[] typeDescriptionArray3 = typeDescriptionArray;
                return new TypeDescription(typeClass, string, "[L" + clazz.getName() + ";", clazz, typeDescriptionArray3, null);
            }
            case 19: {
                TypeDescription[] typeDescriptionArray;
                if (string.equals("com.sun.star.uno.Exception") || string.equals("com.sun.star.uno.RuntimeException")) {
                    typeDescriptionArray = null;
                } else {
                    TypeDescription[] typeDescriptionArray4 = new TypeDescription[1];
                    typeDescriptionArray = typeDescriptionArray4;
                    typeDescriptionArray4[0] = TypeDescription.get(new Type(clazz.getSuperclass()));
                }
                TypeDescription[] typeDescriptionArray5 = typeDescriptionArray;
                return new TypeDescription(typeClass, string, "[L" + clazz.getName() + ";", clazz, typeDescriptionArray5, null);
            }
            case 22: {
                List list = new List();
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    Type type2 = new Type(classArray[i]);
                    if (type2.getTypeClass() != TypeClass.INTERFACE) continue;
                    TypeDescription typeDescription = TypeDescription.getDefinitely(type2);
                    TypeDescription[] typeDescriptionArray = typeDescription.superTypes;
                    for (int j = 0; j < typeDescriptionArray.length; ++j) {
                        list.add(typeDescriptionArray[j]);
                    }
                    list.add(typeDescription);
                }
                return new TypeDescription(typeClass, string, "[L" + clazz.getName() + ";", clazz, list.toArray(), null);
            }
        }
        throw new IllegalArgumentException("given type has bad type class");
    }

    private TypeDescription(TypeClass typeClass, String string, String string2, Class<?> clazz, TypeDescription[] typeDescriptionArray, TypeDescription typeDescription) {
        this.typeClass = typeClass;
        this.typeName = string;
        this.arrayTypeName = string2;
        this.zClass = clazz;
        this.superTypes = typeDescriptionArray;
        this.componentType = typeDescription;
        TypeDescription[] typeDescriptionArray2 = this.calculateTypeArguments();
        this.hasTypeArguments = typeDescriptionArray2 != null;
        this.fieldDescriptions = this.calculateFieldDescriptions(typeDescriptionArray2);
    }

    private synchronized void initMethodDescriptions() {
        if (this.methodDescriptions != null || this.typeClass != TypeClass.INTERFACE) {
            return;
        }
        if (this.superTypes.length == 0) {
            this.superMethodDescriptions = new MethodDescription[0];
            this.methodDescriptions = new MethodDescription[]{new MethodDescription("queryInterface", 0, false, new TypeDescription[]{TypeDescription.getDefinitely(Type.TYPE)}, new TypeDescription[]{null}, TypeDescription.getDefinitely(Type.ANY), null), new MethodDescription("acquire", 1, true, new TypeDescription[0], new TypeDescription[0], TypeDescription.getDefinitely(Type.VOID), null), new MethodDescription("release", 2, true, new TypeDescription[0], new TypeDescription[0], TypeDescription.getDefinitely(Type.VOID), null)};
        } else {
            int n;
            Object[] objectArray;
            int n2 = 0;
            ArrayList<MethodDescription> arrayList = new ArrayList<MethodDescription>();
            for (int i = 0; i < this.superTypes.length; ++i) {
                objectArray = this.superTypes[i].getMethodDescriptions();
                for (n = 0; n < objectArray.length; ++n) {
                    arrayList.add(new MethodDescription((MethodDescription)objectArray[n], n2++));
                }
            }
            this.superMethodDescriptions = arrayList.toArray(new MethodDescription[arrayList.size()]);
            ArrayList<MethodDescription> arrayList2 = new ArrayList<MethodDescription>();
            objectArray = this.getTypeInfo();
            n = objectArray == null ? 0 : objectArray.length;
            int n3 = 0;
            Method[] methodArray = this.zClass.getDeclaredMethods();
            int n4 = 0;
            while (n4 < n) {
                Object object;
                Object object2;
                TypeDescription[] typeDescriptionArray;
                Object object3;
                Object object4;
                Object object5;
                TypeInfo typeInfo;
                if (objectArray[n4] instanceof AttributeTypeInfo) {
                    if (((AttributeTypeInfo)(typeInfo = (AttributeTypeInfo)objectArray[n4++])).getIndex() != n3) {
                        throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": entries not ordererd");
                    }
                    object5 = "get" + typeInfo.getName();
                    object4 = this.findMethod(methodArray, (String)object5);
                    object3 = ((AttributeTypeInfo)typeInfo).getUnoType();
                    typeDescriptionArray = object3 == null ? TypeDescription.getTypeDescription(((Method)object4).getReturnType(), typeInfo) : TypeDescription.getDefinitely((Type)object3);
                    arrayList2.add(new MethodDescription((String)object5, n3++ + n2, false, new TypeDescription[0], new TypeDescription[0], (TypeDescription)typeDescriptionArray, (Method)object4));
                    if (((AttributeTypeInfo)typeInfo).isReadOnly()) continue;
                    object2 = "set" + typeInfo.getName();
                    object = this.findMethod(methodArray, (String)object2);
                    arrayList2.add(new MethodDescription((String)object2, n3++ + n2, false, new TypeDescription[]{typeDescriptionArray}, new TypeDescription[]{null}, TypeDescription.getDefinitely(Type.VOID), (Method)object));
                    continue;
                }
                if (((MethodTypeInfo)(typeInfo = (MethodTypeInfo)objectArray[n4++])).getIndex() != n3) {
                    throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": entries not ordererd");
                }
                object5 = this.findMethod(methodArray, typeInfo.getName());
                object4 = ((Method)object5).getParameterTypes();
                object3 = new TypeDescription[((Class<?>[])object4).length];
                typeDescriptionArray = new TypeDescription[((Class<?>[])object4).length];
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    TypeDescription typeDescription;
                    object = null;
                    if (n4 < n && objectArray[n4] instanceof ParameterTypeInfo && ((ParameterTypeInfo)objectArray[n4]).getIndex() == i) {
                        object = (ParameterTypeInfo)objectArray[n4++];
                    }
                    Type type = object == null ? null : ((ParameterTypeInfo)object).getUnoType();
                    TypeDescription typeDescription2 = typeDescription = type == null ? TypeDescription.getTypeDescription(object4[i], (TypeInfo)object) : TypeDescription.getDefinitely(type);
                    if (object == null || ((ParameterTypeInfo)object).isIN()) {
                        object3[i] = typeDescription;
                    }
                    if (object == null || !((ParameterTypeInfo)object).isOUT()) continue;
                    typeDescriptionArray[i] = typeDescription;
                }
                object2 = ((MethodTypeInfo)typeInfo).getUnoType();
                arrayList2.add(new MethodDescription(typeInfo.getName(), n3++ + n2, ((MethodTypeInfo)typeInfo).isOneway(), (TypeDescription[])object3, typeDescriptionArray, object2 == null ? TypeDescription.getTypeDescription(((Method)object5).getReturnType(), typeInfo) : TypeDescription.getDefinitely((Type)object2), (Method)object5));
            }
            this.methodDescriptions = arrayList2.toArray(new MethodDescription[arrayList2.size()]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TypeDescription[] calculateTypeArguments() {
        int n;
        if (this.typeClass != TypeClass.STRUCT) {
            return null;
        }
        int n2 = this.typeName.indexOf(60);
        if (n2 < 0) {
            return null;
        }
        ArrayList<TypeDescription> arrayList = new ArrayList<TypeDescription>();
        do {
            int n3 = 0;
            block6: for (n = ++n2; n != this.typeName.length(); ++n) {
                switch (this.typeName.charAt(n)) {
                    case ',': {
                        if (n3 != 0) break;
                        break block6;
                    }
                    case '<': {
                        ++n3;
                        break;
                    }
                    case '>': {
                        if (n3 == 0) break block6;
                        --n3;
                    }
                }
            }
            if (n == this.typeName.length()) continue;
            Type type = new Type(this.typeName.substring(n2, n));
            if (type.getZClass() == null) {
                throw new IllegalArgumentException("UNO type name \"" + this.typeName + "\" contains bad type argument \"" + this.typeName.substring(n2, n) + "\"");
            }
            arrayList.add(TypeDescription.getDefinitely(type));
        } while ((n2 = n) != this.typeName.length() && this.typeName.charAt(n2) != '>');
        if (n2 == this.typeName.length() - 1 && this.typeName.charAt(n2) == '>' && !arrayList.isEmpty()) {
            return arrayList.toArray(new TypeDescription[arrayList.size()]);
        }
        throw new IllegalArgumentException("UNO type name \"" + this.typeName + "\" is syntactically invalid");
    }

    private FieldDescription[] calculateFieldDescriptions(TypeDescription[] typeDescriptionArray) {
        if (this.typeClass != TypeClass.STRUCT && this.typeClass != TypeClass.EXCEPTION) {
            return null;
        }
        TypeInfo[] typeInfoArray = this.getTypeInfo();
        int n = typeInfoArray == null ? 0 : typeInfoArray.length;
        TypeDescription typeDescription = this.getSuperType();
        FieldDescription[] fieldDescriptionArray = typeDescription == null ? null : typeDescription.getFieldDescriptions();
        int n2 = fieldDescriptionArray == null ? 0 : fieldDescriptionArray.length;
        FieldDescription[] fieldDescriptionArray2 = new FieldDescription[n2 + n];
        if (n2 != 0) {
            System.arraycopy(fieldDescriptionArray, 0, fieldDescriptionArray2, 0, n2);
        }
        for (int i = 0; i < n; ++i) {
            Field field;
            MemberTypeInfo memberTypeInfo = (MemberTypeInfo)typeInfoArray[i];
            if (memberTypeInfo.getIndex() != i) {
                throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": entries not ordererd");
            }
            try {
                field = this.zClass.getDeclaredField(memberTypeInfo.getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": " + noSuchFieldException);
            }
            Type type = memberTypeInfo.getUnoType();
            int n3 = memberTypeInfo.getTypeParameterIndex();
            fieldDescriptionArray2[i + n2] = new FieldDescription(memberTypeInfo.getName(), i + n2, n3 >= 0 ? typeDescriptionArray[n3] : (type == null ? TypeDescription.getTypeDescription(field.getType(), memberTypeInfo) : TypeDescription.getDefinitely(type)), field);
        }
        return fieldDescriptionArray2;
    }

    private TypeInfo[] getTypeInfo() {
        try {
            return (TypeInfo[])this.zClass.getDeclaredField("UNOTYPEINFO").get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": " + illegalAccessException);
        }
    }

    private Method findMethod(Method[] methodArray, String string) {
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            return methodArray[i];
        }
        throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": no method " + string);
    }

    private static TypeDescription getTypeDescription(Class<?> clazz, TypeInfo typeInfo) {
        return TypeDescription.getDefinitely(new Type(clazz, typeInfo != null && (typeInfo.isUnsigned() || typeInfo.isInterface())));
    }

    private static final class Cache {
        private final HashMap<String, Entry> map = new HashMap();
        private final ReferenceQueue<TypeDescription> queue = new ReferenceQueue();

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypeDescription get(String string) {
            HashMap<String, Entry> hashMap = this.map;
            synchronized (hashMap) {
                this.cleanUp();
                Entry entry = this.map.get(string);
                return entry == null ? null : (TypeDescription)entry.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(TypeDescription typeDescription) {
            HashMap<String, Entry> hashMap = this.map;
            synchronized (hashMap) {
                this.cleanUp();
                this.map.put(typeDescription.getTypeName(), new Entry(typeDescription, this.queue));
            }
        }

        private void cleanUp() {
            Reference<TypeDescription> reference;
            Entry entry;
            while ((entry = (Entry)(reference = this.queue.poll())) != null) {
                this.map.remove(entry.typeName);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Entry
        extends SoftReference<TypeDescription> {
            public final String typeName;

            public Entry(TypeDescription typeDescription, ReferenceQueue<TypeDescription> referenceQueue) {
                super(typeDescription, referenceQueue);
                this.typeName = typeDescription.getTypeName();
            }
        }
    }

    private static final class List {
        private final ArrayList<TypeDescription> list = new ArrayList();

        private List() {
        }

        public void add(TypeDescription typeDescription) {
            if (!this.list.contains(typeDescription)) {
                this.list.add(typeDescription);
            }
        }

        public TypeDescription[] toArray() {
            return this.list.toArray(new TypeDescription[this.list.size()]);
        }
    }
}

