/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import org.jcodings.Encoding;
import org.jruby.RubyEncoding;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class GetsLexerSource
extends LexerSource {
    private IRubyObject io;
    private Encoding encoding;

    public GetsLexerSource(String sourceName, int line, IRubyObject io) {
        super(sourceName, line);
        this.io = io;
        this.encoding = this.frobnicateEncoding();
    }

    public final Encoding frobnicateEncoding() {
        if (!this.io.respondsTo("encoding")) {
            return null;
        }
        IRubyObject encodingObject = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "encoding");
        return encodingObject instanceof RubyEncoding ? ((RubyEncoding)encodingObject).getEncoding() : this.io.getRuntime().getDefaultExternalEncoding();
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public ByteList gets() {
        IRubyObject result = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "gets");
        if (result.isNil()) {
            return null;
        }
        ByteList bytelist = result.convertToString().getByteList();
        bytelist.setEncoding(this.encoding);
        return bytelist;
    }
}

