/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.tools.SimpleConsumerPerformance;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SimpleConsumerPerformance$ {
    public static final SimpleConsumerPerformance$ MODULE$;

    static {
        new SimpleConsumerPerformance$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        Logger logger = Logger.getLogger(this.getClass());
        SimpleConsumerPerformance.ConsumerPerfConfig config = new SimpleConsumerPerformance.ConsumerPerfConfig(args);
        if (!config.hideHeader()) {
            if (config.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        SimpleConsumer consumer = new SimpleConsumer(config.url().getHost(), config.url().getPort(), 30000, 2 * config.fetchSize(), config.clientId());
        TopicAndPartition topicAndPartition = new TopicAndPartition(config.topic(), config.partition());
        OffsetRequest request = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(config.fromLatest() ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.EarliestTime(), 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        long offset = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
        long startMs = System.currentTimeMillis();
        boolean done = false;
        long totalBytesRead = 0L;
        long totalMessagesRead = 0L;
        boolean consumedInterval = false;
        long lastReportTime = startMs;
        long lastBytesRead = 0L;
        long lastMessagesRead = 0L;
        while (true) {
            void var21_15;
            void var19_14;
            void var12_10;
            long l;
            void var14_11;
            void var4_4;
            void var7_7;
            void var3_3;
            if (done) {
                long reportTime = System.currentTimeMillis();
                double elapsed = (double)(reportTime - startMs) / 1000.0;
                if (!config.showDetailedStats()) {
                    double totalMBRead = (double)totalBytesRead * 1.0 / (double)0x100000;
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)reportTime)), BoxesRunTime.boxToInteger((int)config.fetchSize()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsed)), BoxesRunTime.boxToLong((long)totalMessagesRead), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead / elapsed))})));
                }
                System.exit(0);
                return;
            }
            FetchRequest request2 = new FetchRequestBuilder().clientId(var3_3.clientId()).addFetch(var3_3.topic(), var3_3.partition(), (long)var7_7, var3_3.fetchSize()).build();
            FetchResponse fetchResponse = var4_4.fetch(request2);
            IntRef messagesRead = new IntRef(0);
            IntRef bytesRead = new IntRef(0);
            ByteBufferMessageSet messageSet = fetchResponse.messageSet(var3_3.topic(), var3_3.partition());
            messageSet.foreach(new Serializable(messagesRead, bytesRead){
                public static final long serialVersionUID = 0L;
                private final IntRef messagesRead$1;
                private final IntRef bytesRead$1;

                public final void apply(MessageAndOffset message) {
                    ++this.messagesRead$1.elem;
                    this.bytesRead$1.elem += message.message().payloadSize();
                }
                {
                    this.messagesRead$1 = messagesRead$1;
                    this.bytesRead$1 = bytesRead$1;
                }
            });
            if (messagesRead.elem == 0 || var14_11 > var3_3.numMessages()) {
                boolean bl = true;
            } else {
                var7_7 += (long)messageSet.validBytes();
            }
            var12_10 += (long)bytesRead.elem;
            var14_11 += (long)messagesRead.elem;
            if ((bl += messagesRead.elem) <= var3_3.reportingInterval()) continue;
            if (var3_3.showDetailedStats()) {
                long reportTime = System.currentTimeMillis();
                double elapsed = (double)(reportTime - l) / 1000.0;
                double totalMBRead = (double)(var12_10 - var19_14) * 1.0 / (double)0x100000;
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.dateFormat().format(BoxesRunTime.boxToLong((long)reportTime)), BoxesRunTime.boxToInteger((int)var3_3.fetchSize()), BoxesRunTime.boxToDouble((double)((double)var12_10 * 1.0 / (double)0x100000)), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsed)), BoxesRunTime.boxToLong((long)var14_11), BoxesRunTime.boxToDouble((double)((double)(var14_11 - var21_15) / elapsed))})));
            }
            l = SystemTime$.MODULE$.milliseconds();
            var19_14 = var12_10;
            var21_15 = var14_11;
            boolean bl = false;
        }
    }

    private SimpleConsumerPerformance$() {
        MODULE$ = this;
    }
}

