/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.stringio.StringIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.msgpack.jruby.Decoder;

@JRubyClass(name={"MessagePack::Unpacker"})
public class Unpacker
extends RubyObject {
    private IRubyObject stream;
    private IRubyObject data;
    private Decoder decoder;
    private final RubyClass underflowErrorClass;

    public Unpacker(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.underflowErrorClass = ruby.getModule("MessagePack").getClass("UnderflowError");
    }

    @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length > 0 && !(iRubyObjectArray[iRubyObjectArray.length - 1] instanceof RubyHash) && !(iRubyObjectArray[0] instanceof RubyHash)) {
            this.setStream(threadContext, iRubyObjectArray[0]);
        }
        return this;
    }

    @JRubyMethod(required=2)
    public IRubyObject execute(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.executeLimit(threadContext, iRubyObject, iRubyObject2, null);
    }

    @JRubyMethod(name={"execute_limit"}, required=3)
    public IRubyObject executeLimit(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Decoder decoder;
        block3: {
            RubyString rubyString = iRubyObject.asString();
            int n = RubyNumeric.fix2int((IRubyObject)iRubyObject2);
            int n2 = iRubyObject3 == null || iRubyObject3.isNil() ? -1 : RubyNumeric.fix2int((IRubyObject)iRubyObject3);
            ByteList byteList = rubyString.getByteList();
            if (n2 == -1) {
                n2 = byteList.length() - n;
            }
            decoder = new Decoder(threadContext.getRuntime(), byteList.unsafeBytes(), byteList.begin() + n, n2);
            try {
                this.data = null;
                this.data = decoder.next();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() == this.underflowErrorClass) break block3;
                throw raiseException;
            }
        }
        return threadContext.getRuntime().newFixnum(decoder.offset());
    }

    @JRubyMethod(name={"data"})
    public IRubyObject getData(ThreadContext threadContext) {
        if (this.data == null) {
            return threadContext.getRuntime().getNil();
        }
        return this.data;
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject finished_p(ThreadContext threadContext) {
        return this.data == null ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
    }

    @JRubyMethod(required=1)
    public IRubyObject feed(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList = iRubyObject.asString().getByteList();
        if (this.decoder == null) {
            this.decoder = new Decoder(threadContext.getRuntime(), byteList.unsafeBytes(), byteList.begin(), byteList.length());
        } else {
            this.decoder.feed(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"feed_each"}, required=1)
    public IRubyObject feedEach(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        this.feed(threadContext, iRubyObject);
        this.each(threadContext, block);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext threadContext, Block block) {
        if (block.isGiven()) {
            block5: {
                if (this.decoder != null) {
                    try {
                        while (this.decoder.hasNext()) {
                            block.yield(threadContext, this.decoder.next());
                        }
                    }
                    catch (RaiseException raiseException) {
                        if (raiseException.getException().getType() == this.underflowErrorClass) break block5;
                        throw raiseException;
                    }
                }
            }
            return this;
        }
        return this.callMethod(threadContext, "to_enum");
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext threadContext) {
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext threadContext) {
        if (this.decoder != null) {
            this.decoder.reset();
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"stream"})
    public IRubyObject getStream(ThreadContext threadContext) {
        if (this.stream == null) {
            return threadContext.getRuntime().getNil();
        }
        return this.stream;
    }

    @JRubyMethod(name={"stream="}, required=1)
    public IRubyObject setStream(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString;
        if (iRubyObject instanceof StringIO) {
            rubyString = iRubyObject.callMethod(threadContext, "string").asString();
        } else if (iRubyObject instanceof RubyIO) {
            rubyString = iRubyObject.callMethod(threadContext, "read").asString();
        } else {
            throw threadContext.getRuntime().newTypeError(iRubyObject, "IO");
        }
        ByteList byteList = rubyString.getByteList();
        this.stream = iRubyObject;
        this.decoder = null;
        this.decoder = new Decoder(threadContext.getRuntime(), byteList.unsafeBytes(), byteList.begin(), byteList.length());
        return this.getStream(threadContext);
    }

    static class UnpackerAllocator
    implements ObjectAllocator {
        UnpackerAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Unpacker(ruby, rubyClass);
        }
    }
}

