/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.osgi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.felix.framework.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class LoggerImpl
extends Logger {
    private final File logFile;

    public LoggerImpl(File logFile) {
        this.logFile = logFile;
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void doLog(Bundle bundle, ServiceReference sr, int level, String msg, Throwable throwable) {
        String strLevel;
        String s = "";
        if (sr != null) {
            s = s + "SvcRef " + sr + " ";
        } else if (bundle != null) {
            s = s + "Bundle " + bundle.toString() + " ";
        }
        s = s + msg;
        switch (level) {
            case 4: {
                strLevel = "DEBUG";
                break;
            }
            case 1: {
                strLevel = "ERROR";
                break;
            }
            case 3: {
                strLevel = "INFO";
                break;
            }
            case 2: {
                strLevel = "WARNING";
                break;
            }
            default: {
                strLevel = "UNKNOWNN[" + level + "]";
            }
        }
        if (throwable != null) {
            if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                throwable = ((BundleException)throwable).getNestedException();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            s = s + "\n" + sw.getBuffer();
        }
        this._log(strLevel, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _log(String level, String msg) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.logFile, true)));
            bw.write(level + " [" + new Date() + "]:\n" + msg + "\n");
        }
        catch (IOException ioe) {
            System.out.println(level + " [" + new Date() + "]:\n" + msg + "\n");
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

