/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples;

import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Game {
    public static final String GAME_TITLE = "My Game";
    private static final int FRAMERATE = 60;
    private static boolean finished;
    private static float angle;

    private Game() {
    }

    public static void main(String[] args) {
        try {
            Game.init();
            Game.run();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Sys.alert((String)GAME_TITLE, (String)"An error occured and the game will exit.");
        }
        finally {
            Game.cleanup();
        }
        System.exit(0);
    }

    private static void init() throws Exception {
        Display.setTitle((String)GAME_TITLE);
        Display.setFullscreen((boolean)true);
        Display.setVSyncEnabled((boolean)true);
        Display.create();
        AL.create();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Display.getDisplayMode().getWidth(), (double)0.0, (double)Display.getDisplayMode().getHeight(), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)Display.getDisplayMode().getWidth(), (int)Display.getDisplayMode().getHeight());
    }

    private static void run() {
        while (!finished) {
            Display.update();
            if (Display.isCloseRequested()) {
                finished = true;
                continue;
            }
            if (Display.isActive()) {
                Game.logic();
                Game.render();
                Display.sync((int)60);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Game.logic();
            if (!Display.isVisible() && !Display.isDirty()) continue;
            Game.render();
        }
    }

    private static void cleanup() {
        AL.destroy();
        Display.destroy();
    }

    private static void logic() {
        if (Keyboard.isKeyDown((int)1)) {
            finished = true;
        }
        angle += 2.0f;
    }

    private static void render() {
        GL11.glClear((int)17408);
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(Display.getDisplayMode().getWidth() / 2), (float)(Display.getDisplayMode().getHeight() / 2), (float)0.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)-50, (int)-50);
        GL11.glVertex2i((int)50, (int)-50);
        GL11.glVertex2i((int)50, (int)50);
        GL11.glVertex2i((int)-50, (int)50);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

