/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.postgresql.core.JdbcCallParseInfo;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.SqlCommand;
import org.postgresql.core.SqlCommandType;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Parser {
    private static final int[] NO_BINDS = new int[0];

    public static List<NativeQuery> parseJdbcSql(String query, boolean standardConformingStrings, boolean withParameters, boolean splitStatements, boolean isAutoCommit, boolean isBatchedReWriteConfigured) {
        if (!withParameters && !splitStatements) {
            return Collections.singletonList(new NativeQuery(query, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)));
        }
        int fragmentStart = 0;
        int inParen = 0;
        char[] aChars = query.toCharArray();
        StringBuilder nativeSql = new StringBuilder(query.length() + 10);
        ArrayList<Integer> bindPositions = null;
        List<NativeQuery> nativeQueries = null;
        boolean isCurrentReWriteCompatible = false;
        boolean isValuesFound = false;
        int valuesBraceOpenPosition = -1;
        int valuesBraceClosePosition = -1;
        boolean isInsertPresent = false;
        boolean isReturningPresent = false;
        SqlCommandType currentCommandType = SqlCommandType.BLANK;
        boolean whitespaceOnly = true;
        int keyWordCount = 0;
        int keywordStart = -1;
        for (int i = 0; i < aChars.length; ++i) {
            char aChar = aChars[i];
            boolean isKeyWordChar = false;
            whitespaceOnly &= aChar == ';' || Character.isWhitespace(aChar);
            switch (aChar) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, standardConformingStrings);
                    break;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    break;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    break;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    break;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    break;
                }
                case ')': {
                    if (--inParen != 0 || !isValuesFound) break;
                    valuesBraceClosePosition = nativeSql.length() + i - fragmentStart;
                    break;
                }
                case '?': {
                    nativeSql.append(aChars, fragmentStart, i - fragmentStart);
                    if (i + 1 < aChars.length && aChars[i + 1] == '?') {
                        nativeSql.append('?');
                        ++i;
                    } else if (!withParameters) {
                        nativeSql.append('?');
                    } else {
                        if (bindPositions == null) {
                            bindPositions = new ArrayList<Integer>();
                        }
                        bindPositions.add(nativeSql.length());
                        int bindIndex = bindPositions.size();
                        nativeSql.append(NativeQuery.bindName(bindIndex));
                    }
                    fragmentStart = i + 1;
                    break;
                }
                case ';': {
                    if (inParen != 0 || !splitStatements) break;
                    if (!whitespaceOnly) {
                        nativeSql.append(aChars, fragmentStart, i - fragmentStart);
                        whitespaceOnly = true;
                    }
                    fragmentStart = i + 1;
                    if (nativeSql.length() > 0) {
                        if (nativeQueries == null) {
                            nativeQueries = new ArrayList<NativeQuery>();
                        }
                        nativeQueries.add(new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions), SqlCommand.createStatementTypeInfo(currentCommandType, isBatchedReWriteConfigured, valuesBraceOpenPosition, valuesBraceClosePosition, isReturningPresent, nativeQueries.size())));
                    }
                    if (bindPositions != null) {
                        bindPositions.clear();
                    }
                    nativeSql.setLength(0);
                    currentCommandType = SqlCommandType.BLANK;
                    isReturningPresent = false;
                    valuesBraceOpenPosition = -1;
                    valuesBraceClosePosition = -1;
                    break;
                }
                default: {
                    boolean bl = isKeyWordChar = aChars[i] >= 'a' && aChars[i] <= 'z' || aChars[i] >= 'A' && aChars[i] <= 'Z';
                    if (!isKeyWordChar || keywordStart >= 0) break;
                    keywordStart = i;
                }
            }
            if (!(keywordStart < 0 || i != aChars.length - 1 && isKeyWordChar)) {
                int wordLength = (isKeyWordChar ? i + 1 : i) - keywordStart;
                if (wordLength == 6 && Parser.parseUpdateKeyword(aChars, keywordStart)) {
                    currentCommandType = SqlCommandType.UPDATE;
                } else if (wordLength == 6 && Parser.parseDeleteKeyword(aChars, keywordStart)) {
                    currentCommandType = SqlCommandType.DELETE;
                } else if (wordLength == 4 && Parser.parseMoveKeyword(aChars, keywordStart)) {
                    currentCommandType = SqlCommandType.MOVE;
                } else if (wordLength == 6 && Parser.parseInsertKeyword(aChars, keywordStart)) {
                    if (!isInsertPresent && (nativeQueries == null || nativeQueries.isEmpty())) {
                        isCurrentReWriteCompatible = keyWordCount == 0;
                        isInsertPresent = true;
                        currentCommandType = SqlCommandType.INSERT;
                    } else {
                        isCurrentReWriteCompatible = false;
                    }
                } else if (wordLength == 9 && Parser.parseReturningKeyword(aChars, keywordStart)) {
                    isReturningPresent = true;
                } else if (wordLength == 6 && Parser.parseValuesKeyword(aChars, keywordStart)) {
                    isValuesFound = true;
                }
                keywordStart = -1;
                ++keyWordCount;
            }
            if (aChar != '(' || ++inParen != 1 || !isValuesFound || valuesBraceOpenPosition != -1) continue;
            valuesBraceOpenPosition = nativeSql.length() + i - fragmentStart;
        }
        if (!isValuesFound || bindPositions == null) {
            isCurrentReWriteCompatible = false;
        }
        if (!isCurrentReWriteCompatible) {
            valuesBraceOpenPosition = -1;
            valuesBraceClosePosition = -1;
        }
        if (fragmentStart < aChars.length && !whitespaceOnly) {
            nativeSql.append(aChars, fragmentStart, aChars.length - fragmentStart);
        }
        if (nativeSql.length() == 0) {
            return nativeQueries != null ? nativeQueries : Collections.emptyList();
        }
        NativeQuery lastQuery = new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions), SqlCommand.createStatementTypeInfo(currentCommandType, isBatchedReWriteConfigured, valuesBraceOpenPosition, valuesBraceClosePosition, isReturningPresent, nativeQueries == null ? 0 : nativeQueries.size()));
        if (nativeQueries == null) {
            return Collections.singletonList(lastQuery);
        }
        if (!whitespaceOnly) {
            nativeQueries.add(lastQuery);
        }
        return nativeQueries;
    }

    private static int[] toIntArray(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return NO_BINDS;
        }
        int[] res = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static int parseSingleQuotes(char[] query, int offset, boolean standardConformingStrings) {
        if (standardConformingStrings && offset >= 2 && (query[offset - 1] == 'e' || query[offset - 1] == 'E') && Parser.charTerminatesIdentifier(query[offset - 2])) {
            standardConformingStrings = false;
        }
        if (standardConformingStrings) {
            while (++offset < query.length) {
                switch (query[offset]) {
                    case '\'': {
                        return offset;
                    }
                }
            }
        } else {
            block8: while (++offset < query.length) {
                switch (query[offset]) {
                    case '\\': {
                        ++offset;
                        continue block8;
                    }
                    case '\'': {
                        return offset;
                    }
                }
            }
        }
        return query.length;
    }

    public static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    public static int parseDollarQuotes(char[] query, int offset) {
        if (!(offset + 1 >= query.length || offset != 0 && Parser.isIdentifierContChar(query[offset - 1]))) {
            int endIdx = -1;
            if (query[offset + 1] == '$') {
                endIdx = offset + 1;
            } else if (Parser.isDollarQuoteStartChar(query[offset + 1])) {
                for (int d = offset + 2; d < query.length; ++d) {
                    if (query[d] == '$') {
                        endIdx = d;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(query[d])) break;
                }
            }
            if (endIdx > 0) {
                int tagIdx = offset;
                int tagLen = endIdx - offset + 1;
                offset = endIdx;
                ++offset;
                while (offset < query.length) {
                    if (query[offset] == '$' && Parser.subArraysEqual(query, tagIdx, offset, tagLen)) {
                        offset += tagLen - 1;
                        break;
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }

    public static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (offset + 1 < query.length && query[++offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    public static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    public static boolean parseDeleteKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 100 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    public static boolean parseInsertKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 105 && (query[offset + 1] | 0x20) == 110 && (query[offset + 2] | 0x20) == 115 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 116;
    }

    public static boolean parseMoveKeyword(char[] query, int offset) {
        if (query.length < offset + 4) {
            return false;
        }
        return (query[offset] | 0x20) == 109 && (query[offset + 1] | 0x20) == 111 && (query[offset + 2] | 0x20) == 118 && (query[offset + 3] | 0x20) == 101;
    }

    public static boolean parseReturningKeyword(char[] query, int offset) {
        if (query.length < offset + 9) {
            return false;
        }
        return (query[offset] | 0x20) == 114 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 116 && (query[offset + 3] | 0x20) == 117 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 110 && (query[offset + 6] | 0x20) == 105 && (query[offset + 7] | 0x20) == 110 && (query[offset + 8] | 0x20) == 103;
    }

    public static boolean parseUpdateKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 117 && (query[offset + 1] | 0x20) == 112 && (query[offset + 2] | 0x20) == 100 && (query[offset + 3] | 0x20) == 97 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    public static boolean parseValuesKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 118 && (query[offset + 1] | 0x20) == 97 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 117 && (query[offset + 4] | 0x20) == 101 && (query[offset + 5] | 0x20) == 115;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    public static boolean isOperatorChar(char c) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c) != -1;
    }

    public static boolean isIdentifierStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f';
    }

    public static boolean isIdentifierContChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f' || c >= '0' && c <= '9' || c == '$';
    }

    public static boolean charTerminatesIdentifier(char c) {
        return c == '\"' || Parser.isSpace(c) || Parser.isOperatorChar(c);
    }

    public static boolean isDollarQuoteStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f';
    }

    public static boolean isDollarQuoteContChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f' || c >= '0' && c <= '9';
    }

    private static boolean subArraysEqual(char[] arr, int offA, int offB, int len) {
        if (offA < 0 || offB < 0 || offA >= arr.length || offB >= arr.length || offA + len > arr.length || offB + len > arr.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (arr[offA + i] == arr[offB + i]) continue;
            return false;
        }
        return true;
    }

    public static JdbcCallParseInfo modifyJdbcCall(String jdbcSql, boolean stdStrings, int serverVersion, int protocolVersion) throws SQLException {
        String sql = jdbcSql;
        boolean isFunction = false;
        boolean outParmBeforeFunc = false;
        int len = jdbcSql.length();
        int state = 1;
        boolean inQuotes = false;
        boolean inEscape = false;
        int startIndex = -1;
        int endIndex = -1;
        boolean syntaxError = false;
        int i = 0;
        block10: while (i < len && !syntaxError) {
            char ch = jdbcSql.charAt(i);
            switch (state) {
                case 1: {
                    if (ch == '{') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    i = len;
                    continue block10;
                }
                case 2: {
                    if (ch == '?') {
                        isFunction = true;
                        outParmBeforeFunc = true;
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (ch == 'c' || ch == 'C') {
                        state += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 3: {
                    if (ch == '=') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 4: {
                    if (ch == 'c' || ch == 'C') {
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 5: {
                    if ((ch == 'c' || ch == 'C') && i + 4 <= len && jdbcSql.substring(i, i + 4).equalsIgnoreCase("call")) {
                        isFunction = true;
                        i += 4;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        ++state;
                        startIndex = ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 7: {
                    if (ch == '\'') {
                        inQuotes = !inQuotes;
                        ++i;
                        continue block10;
                    }
                    if (inQuotes && ch == '\\' && !stdStrings) {
                        i += 2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '{') {
                        inEscape = !inEscape;
                        ++i;
                        continue block10;
                    }
                    if (!inQuotes && ch == '}') {
                        if (!inEscape) {
                            endIndex = i++;
                            ++state;
                            continue block10;
                        }
                        inEscape = false;
                        continue block10;
                    }
                    if (!inQuotes && ch == ';') {
                        syntaxError = true;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + state);
        }
        if (i == len && !syntaxError) {
            if (state == 1) {
                return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
            }
            if (state != 8) {
                syntaxError = true;
            }
        }
        if (syntaxError) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", i), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (serverVersion < 80100 || protocolVersion != 3) {
            sql = "select " + jdbcSql.substring(startIndex, endIndex) + " as result";
            return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
        }
        String s = jdbcSql.substring(startIndex, endIndex);
        StringBuilder sb = new StringBuilder(s);
        if (outParmBeforeFunc) {
            boolean needComma = false;
            int opening = s.indexOf(40) + 1;
            int closing = s.indexOf(41);
            for (int j = opening; j < closing; ++j) {
                if (Character.isWhitespace(sb.charAt(j))) continue;
                needComma = true;
                break;
            }
            if (needComma) {
                sb.insert(opening, "?,");
            } else {
                sb.insert(opening, "?");
            }
        }
        sql = "select * from " + sb.toString() + " as result";
        return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
    }
}

