/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import org.postgresql.core.NativeQuery;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.core.v3.SimpleQuery;

public class BatchedQuery
extends SimpleQuery {
    private String sql;
    private final int valuesBraceOpenPosition;
    private final int valuesBraceClosePosition;
    private final int batchSize;
    private BatchedQuery[] blocks;

    public BatchedQuery(NativeQuery query, ProtocolConnectionImpl protoConnection, int valuesBraceOpenPosition, int valuesBraceClosePosition) {
        super(query, protoConnection);
        this.valuesBraceOpenPosition = valuesBraceOpenPosition;
        this.valuesBraceClosePosition = valuesBraceClosePosition;
        this.batchSize = 1;
    }

    private BatchedQuery(BatchedQuery src, int batchSize) {
        super(src);
        this.valuesBraceOpenPosition = src.valuesBraceOpenPosition;
        this.valuesBraceClosePosition = src.valuesBraceClosePosition;
        this.batchSize = batchSize;
    }

    public BatchedQuery deriveForMultiBatch(int valueBlock) {
        BatchedQuery bq;
        if (this.getBatchSize() != 1) {
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        if (valueBlock == 1) {
            return this;
        }
        int index = Integer.numberOfTrailingZeros(valueBlock) - 1;
        if (valueBlock > 128 || valueBlock != 1 << index + 1) {
            throw new IllegalArgumentException("Expected value block should be a power of 2 smaller or equal to 128. Actual block is " + valueBlock);
        }
        if (this.blocks == null) {
            this.blocks = new BatchedQuery[7];
        }
        if ((bq = this.blocks[index]) == null) {
            this.blocks[index] = bq = new BatchedQuery(this, valueBlock);
        }
        return bq;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    String getNativeSql() {
        if (this.sql != null) {
            return this.sql;
        }
        String nativeSql = super.getNativeSql();
        int batchSize = this.getBatchSize();
        if (batchSize < 2) {
            this.sql = nativeSql;
            return this.sql;
        }
        if (nativeSql == null) {
            this.sql = "";
            return this.sql;
        }
        int valuesBlockCharCount = 0;
        int[] bindPositions = this.getNativeQuery().bindPositions;
        int[] chunkStart = new int[1 + bindPositions.length];
        int[] chunkEnd = new int[1 + bindPositions.length];
        chunkStart[0] = this.valuesBraceOpenPosition;
        chunkEnd[0] = bindPositions[0];
        valuesBlockCharCount += chunkEnd[0] - chunkStart[0];
        for (int i = 0; i < bindPositions.length; ++i) {
            int startIndex;
            int endIndex;
            int n = endIndex = i < bindPositions.length - 1 ? bindPositions[i + 1] : this.valuesBraceClosePosition + 1;
            for (startIndex = bindPositions[i] + 2; startIndex < endIndex && Character.isDigit(nativeSql.charAt(startIndex)); ++startIndex) {
            }
            chunkStart[i + 1] = startIndex;
            chunkEnd[i + 1] = endIndex;
            valuesBlockCharCount += chunkEnd[i + 1] - chunkStart[i + 1];
        }
        int length = nativeSql.length();
        length += NativeQuery.calculateBindLength(bindPositions.length * batchSize);
        length -= NativeQuery.calculateBindLength(bindPositions.length);
        StringBuilder s = new StringBuilder(length += (valuesBlockCharCount + 1) * (batchSize - 1));
        s.append(nativeSql, 0, this.valuesBraceClosePosition + 1);
        int pos = bindPositions.length + 1;
        for (int i = 2; i <= batchSize; ++i) {
            s.append(',');
            s.append(nativeSql, chunkStart[0], chunkEnd[0]);
            for (int j = 1; j < chunkStart.length; ++j) {
                NativeQuery.appendBindName(s, pos++);
                s.append(nativeSql, chunkStart[j], chunkEnd[j]);
            }
        }
        s.append(nativeSql, this.valuesBraceClosePosition + 1, nativeSql.length());
        this.sql = s.toString();
        assert (s.length() == length) : "Predicted length != actual: " + length + " !=" + s.length();
        return this.sql;
    }

    @Override
    public String toString() {
        return this.getNativeSql();
    }
}

