/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf + 0.0lf) => 0.0lf
 * (0.0lf + -1.3333333333333333lf) => -1.3333333333333333lf
 * (0.0lf + 0.84999999999999998lf) => 0.84999999999999998lf
 * (-1.3333333333333333lf + 0.0lf) => -1.3333333333333333lf
 * (-1.3333333333333333lf + -1.3333333333333333lf) => -2.6666666666666665lf
 * (-1.3333333333333333lf + 0.84999999999999998lf) => -0.48333333333333328lf
 * (0.84999999999999998lf + 0.0lf) => 0.84999999999999998lf
 * (0.84999999999999998lf + -1.3333333333333333lf) => -0.48333333333333328lf
 * (0.84999999999999998lf + 0.84999999999999998lf) => 1.7lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf + 0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf + -1.3333333333333333lf), -1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array1;
  double[distance((0.0lf + 0.84999999999999998lf), 0.84999999999999998lf) <= 8.4999999999999999e-06lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf + 0.0lf), -1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array3;
  double[distance((-1.3333333333333333lf + -1.3333333333333333lf), -2.6666666666666665lf) <= 2.6666666666666667e-05lf ? 1 : -1] array4;
  double[distance((-1.3333333333333333lf + 0.84999999999999998lf), -0.48333333333333328lf) <= 4.8333333333333334e-06lf ? 1 : -1] array5;
  double[distance((0.84999999999999998lf + 0.0lf), 0.84999999999999998lf) <= 8.4999999999999999e-06lf ? 1 : -1] array6;
  double[distance((0.84999999999999998lf + -1.3333333333333333lf), -0.48333333333333328lf) <= 4.8333333333333334e-06lf ? 1 : -1] array7;
  double[distance((0.84999999999999998lf + 0.84999999999999998lf), 1.7lf) <= 1.7e-05lf ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
