/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * step(-2.0, vec3(-2.0, -0.66666669, 0.66666669)) => vec3(1.0, 1.0, 1.0)
 * step(-2.0, vec3(2.0, -2.0, -0.66666669)) => vec3(1.0, 1.0, 1.0)
 * step(-0.66666669, vec3(-2.0, -0.66666669, 0.66666669)) => vec3(0.0, 1.0, 1.0)
 * step(-0.66666669, vec3(2.0, -2.0, -0.66666669)) => vec3(1.0, 0.0, 1.0)
 * step(0.66666669, vec3(-2.0, -0.66666669, 0.66666669)) => vec3(0.0, 0.0, 1.0)
 * step(0.66666669, vec3(2.0, -2.0, -0.66666669)) => vec3(1.0, 0.0, 0.0)
 * step(2.0, vec3(-2.0, -0.66666669, 0.66666669)) => vec3(0.0, 0.0, 0.0)
 * step(2.0, vec3(2.0, -2.0, -0.66666669)) => vec3(1.0, 0.0, 0.0)
 */
#version 120

void main()
{
  float[distance(step(-2.0, vec3(-2.0, -0.66666669, 0.66666669)), vec3(1.0, 1.0, 1.0)) <= 1.7320508e-05 ? 1 : -1] array0;
  float[distance(step(-2.0, vec3(2.0, -2.0, -0.66666669)), vec3(1.0, 1.0, 1.0)) <= 1.7320508e-05 ? 1 : -1] array1;
  float[distance(step(-0.66666669, vec3(-2.0, -0.66666669, 0.66666669)), vec3(0.0, 1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array2;
  float[distance(step(-0.66666669, vec3(2.0, -2.0, -0.66666669)), vec3(1.0, 0.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array3;
  float[distance(step(0.66666669, vec3(-2.0, -0.66666669, 0.66666669)), vec3(0.0, 0.0, 1.0)) <= 9.9999997e-06 ? 1 : -1] array4;
  float[distance(step(0.66666669, vec3(2.0, -2.0, -0.66666669)), vec3(1.0, 0.0, 0.0)) <= 9.9999997e-06 ? 1 : -1] array5;
  float[distance(step(2.0, vec3(-2.0, -0.66666669, 0.66666669)), vec3(0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array6;
  float[distance(step(2.0, vec3(2.0, -2.0, -0.66666669)), vec3(1.0, 0.0, 0.0)) <= 9.9999997e-06 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
