/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * roundEven(vec3(-2.0, -1.8333334, -1.6666666)) => vec3(-2.0, -2.0, -2.0)
 * roundEven(vec3(-1.5, -1.3333334, -1.1666666)) => vec3(-2.0, -1.0, -1.0)
 * roundEven(vec3(-1.0, -0.83333331, -0.66666669)) => vec3(-1.0, -1.0, -1.0)
 * roundEven(vec3(-0.5, -0.33333334, -0.16666667)) => vec3(-0.0, -0.0, -0.0)
 * roundEven(vec3(0.0, 0.16666667, 0.33333334)) => vec3(0.0, 0.0, 0.0)
 * roundEven(vec3(0.5, 0.66666669, 0.83333331)) => vec3(0.0, 1.0, 1.0)
 * roundEven(vec3(1.0, 1.1666666, 1.3333334)) => vec3(1.0, 1.0, 1.0)
 * roundEven(vec3(1.5, 1.6666666, 1.8333334)) => vec3(2.0, 2.0, 2.0)
 * roundEven(vec3(2.0, -2.0, -1.8333334)) => vec3(2.0, -2.0, -2.0)
 */
#version 130

void main()
{
  float[distance(roundEven(vec3(-2.0, -1.8333334, -1.6666666)), vec3(-2.0, -2.0, -2.0)) <= 3.4641016e-05 ? 1 : -1] array0;
  float[distance(roundEven(vec3(-1.5, -1.3333334, -1.1666666)), vec3(-2.0, -1.0, -1.0)) <= 2.4494897e-05 ? 1 : -1] array1;
  float[distance(roundEven(vec3(-1.0, -0.83333331, -0.66666669)), vec3(-1.0, -1.0, -1.0)) <= 1.7320508e-05 ? 1 : -1] array2;
  float[distance(roundEven(vec3(-0.5, -0.33333334, -0.16666667)), vec3(-0.0, -0.0, -0.0)) <= 0.0 ? 1 : -1] array3;
  float[distance(roundEven(vec3(0.0, 0.16666667, 0.33333334)), vec3(0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array4;
  float[distance(roundEven(vec3(0.5, 0.66666669, 0.83333331)), vec3(0.0, 1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array5;
  float[distance(roundEven(vec3(1.0, 1.1666666, 1.3333334)), vec3(1.0, 1.0, 1.0)) <= 1.7320508e-05 ? 1 : -1] array6;
  float[distance(roundEven(vec3(1.5, 1.6666666, 1.8333334)), vec3(2.0, 2.0, 2.0)) <= 3.4641016e-05 ? 1 : -1] array7;
  float[distance(roundEven(vec3(2.0, -2.0, -1.8333334)), vec3(2.0, -2.0, -2.0)) <= 3.4641016e-05 ? 1 : -1] array8;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
