/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(0.0) => 0.0
 * atan(1e-10) => 1e-10
 * atan(-1e-10) => -1e-10
 * atan(0.1) => 0.099668652
 * atan(-0.1) => -0.099668652
 * atan(1.0) => 0.78539819
 * atan(-1.0) => -0.78539819
 * atan(10.0) => 1.4711276
 * atan(-10.0) => -1.4711276
 * atan(1e+10) => 1.5707964
 * atan(-1e+10) => -1.5707964
 */
#version 120

void main()
{
  float[distance(atan(0.0), 0.0) <= 9.9999997e-05 ? 1 : -1] array0;
  float[distance(atan(1e-10), 1e-10) <= 9.9999997e-05 ? 1 : -1] array1;
  float[distance(atan(-1e-10), -1e-10) <= 9.9999997e-05 ? 1 : -1] array2;
  float[distance(atan(0.1), 0.099668652) <= 9.9999997e-05 ? 1 : -1] array3;
  float[distance(atan(-0.1), -0.099668652) <= 9.9999997e-05 ? 1 : -1] array4;
  float[distance(atan(1.0), 0.78539819) <= 0.00078539818 ? 1 : -1] array5;
  float[distance(atan(-1.0), -0.78539819) <= 0.00078539818 ? 1 : -1] array6;
  float[distance(atan(10.0), 1.4711276) <= 0.0014711276 ? 1 : -1] array7;
  float[distance(atan(-10.0), -1.4711276) <= 0.0014711276 ? 1 : -1] array8;
  float[distance(atan(1e+10), 1.5707964) <= 0.0015707964 ? 1 : -1] array9;
  float[distance(atan(-1e+10), -1.5707964) <= 0.0015707964 ? 1 : -1] array10;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length());
}
