/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (mat2(1.6, 1.53, 0.75999999, -1.0) != mat2(1.6, 1.53, 0.75999999, -1.0)) => false
 * (mat2(1.6, 1.53, 0.75999999, -1.0) != mat2(-0.13, -1.4, -0.87, 1.4)) => true
 * (mat2(-0.13, -1.4, -0.87, 1.4) != mat2(1.6, 1.53, 0.75999999, -1.0)) => true
 * (mat2(-0.13, -1.4, -0.87, 1.4) != mat2(-0.13, -1.4, -0.87, 1.4)) => false
 */
#version 120

void main()
{
  float[(mat2(1.6, 1.53, 0.75999999, -1.0) != mat2(1.6, 1.53, 0.75999999, -1.0)) == false ? 1 : -1] array0;
  float[(mat2(1.6, 1.53, 0.75999999, -1.0) != mat2(-0.13, -1.4, -0.87, 1.4)) == true ? 1 : -1] array1;
  float[(mat2(-0.13, -1.4, -0.87, 1.4) != mat2(1.6, 1.53, 0.75999999, -1.0)) == true ? 1 : -1] array2;
  float[(mat2(-0.13, -1.4, -0.87, 1.4) != mat2(-0.13, -1.4, -0.87, 1.4)) == false ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
