/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec4(-1.65, 1.33, 1.9299999, 0.75999999) != vec4(-1.65, 1.33, 1.9299999, 0.75999999)) => false
 * (vec4(-1.65, 1.33, 1.9299999, 0.75999999) != vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) => true
 * (vec4(0.80000001, -0.15000001, -0.50999999, 0.0) != vec4(-1.65, 1.33, 1.9299999, 0.75999999)) => true
 * (vec4(0.80000001, -0.15000001, -0.50999999, 0.0) != vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) => false
 */
#version 120

void main()
{
  float[(vec4(-1.65, 1.33, 1.9299999, 0.75999999) != vec4(-1.65, 1.33, 1.9299999, 0.75999999)) == false ? 1 : -1] array0;
  float[(vec4(-1.65, 1.33, 1.9299999, 0.75999999) != vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) == true ? 1 : -1] array1;
  float[(vec4(0.80000001, -0.15000001, -0.50999999, 0.0) != vec4(-1.65, 1.33, 1.9299999, 0.75999999)) == true ? 1 : -1] array2;
  float[(vec4(0.80000001, -0.15000001, -0.50999999, 0.0) != vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) == false ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
