/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * step(-2.0, -2.0) => 1.0
 * step(-2.0, -0.66666669) => 1.0
 * step(-2.0, 0.66666669) => 1.0
 * step(-2.0, 2.0) => 1.0
 * step(-0.66666669, -2.0) => 0.0
 * step(-0.66666669, -0.66666669) => 1.0
 * step(-0.66666669, 0.66666669) => 1.0
 * step(-0.66666669, 2.0) => 1.0
 * step(0.66666669, -2.0) => 0.0
 * step(0.66666669, -0.66666669) => 0.0
 * step(0.66666669, 0.66666669) => 1.0
 * step(0.66666669, 2.0) => 1.0
 * step(2.0, -2.0) => 0.0
 * step(2.0, -0.66666669) => 0.0
 * step(2.0, 0.66666669) => 0.0
 * step(2.0, 2.0) => 1.0
 */
#version 120

void main()
{
  float[distance(step(-2.0, -2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array0;
  float[distance(step(-2.0, -0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array1;
  float[distance(step(-2.0, 0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array2;
  float[distance(step(-2.0, 2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array3;
  float[distance(step(-0.66666669, -2.0), 0.0) <= 0.0 ? 1 : -1] array4;
  float[distance(step(-0.66666669, -0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array5;
  float[distance(step(-0.66666669, 0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array6;
  float[distance(step(-0.66666669, 2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array7;
  float[distance(step(0.66666669, -2.0), 0.0) <= 0.0 ? 1 : -1] array8;
  float[distance(step(0.66666669, -0.66666669), 0.0) <= 0.0 ? 1 : -1] array9;
  float[distance(step(0.66666669, 0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array10;
  float[distance(step(0.66666669, 2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array11;
  float[distance(step(2.0, -2.0), 0.0) <= 0.0 ? 1 : -1] array12;
  float[distance(step(2.0, -0.66666669), 0.0) <= 0.0 ? 1 : -1] array13;
  float[distance(step(2.0, 0.66666669), 0.0) <= 0.0 ? 1 : -1] array14;
  float[distance(step(2.0, 2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array15;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
