/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(vec2(-2.0, -1.4285715)) => vec2(-2.0, -1.0)
 * round(vec2(-0.85714287, -0.2857143)) => vec2(-1.0, -0.0)
 * round(vec2(0.2857143, 0.85714287)) => vec2(0.0, 1.0)
 * round(vec2(1.4285715, 2.0)) => vec2(1.0, 2.0)
 */
#version 130

void main()
{
  float[distance(round(vec2(-2.0, -1.4285715)), vec2(-2.0, -1.0)) <= 2.236068e-05 ? 1 : -1] array0;
  float[distance(round(vec2(-0.85714287, -0.2857143)), vec2(-1.0, -0.0)) <= 9.9999997e-06 ? 1 : -1] array1;
  float[distance(round(vec2(0.2857143, 0.85714287)), vec2(0.0, 1.0)) <= 9.9999997e-06 ? 1 : -1] array2;
  float[distance(round(vec2(1.4285715, 2.0)), vec2(1.0, 2.0)) <= 2.236068e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
