/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration;

import com.projity.configuration.Configuration;
import com.projity.configuration.FieldDictionary;
import com.projity.configuration.NamedItem;
import com.projity.field.Field;
import com.projity.functor.ScheduleIntervalGenerator;
import com.projity.graphic.configuration.FormFormat;
import com.projity.graphic.configuration.TexturedShape;
import com.projity.strings.Messages;
import org.apache.commons.digester.Digester;

public class BarFormat
implements NamedItem {
    public static final String category = "BarFormatCategory";
    String name = null;
    String id = null;
    int row = 0;
    String intervalGenerator = null;
    ScheduleIntervalGenerator scheduleIntervalGenerator = null;
    String from;
    String to;
    Field fromField = null;
    Field toField = null;
    TexturedShape start = null;
    TexturedShape middle = null;
    TexturedShape end = null;
    FormFormat form = null;
    boolean main = false;
    public static final int MIN_FOREGROUND_LAYER = 1;
    public static final int MAX_FOREGROUND_LAYER = 499;
    public static final int MIN_LINK_LAYER = 500;
    public static final int MAX_LINK_LAYER = 999;
    public static final int MIN_BACKGROUND_LAYER = 1000;
    public static final int MAX_BACKGROUND_LAYER = 1499;
    int layer = 1000;
    String fieldId = null;
    Field field = null;

    public String getCategory() {
        return category;
    }

    public TexturedShape getEnd() {
        return this.end;
    }

    public void setEnd(TexturedShape texturedShape) {
        texturedShape.build();
        this.end = texturedShape;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
        this.fromField = Configuration.getFieldFromId(string);
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) {
        this.to = string;
        this.toField = Configuration.getFieldFromId(string);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public TexturedShape getMiddle() {
        return this.middle;
    }

    public void setMiddle(TexturedShape texturedShape) {
        texturedShape.build();
        this.middle = texturedShape;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public TexturedShape getStart() {
        return this.start;
    }

    public void setStart(TexturedShape texturedShape) {
        texturedShape.build();
        this.start = texturedShape;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public String getIntervalGenerator() {
        return this.intervalGenerator;
    }

    public void setIntervalGenerator(String string) {
        this.intervalGenerator = string;
    }

    public ScheduleIntervalGenerator getScheduleIntervalGenerator() {
        if (this.intervalGenerator != null && this.scheduleIntervalGenerator == null) {
            try {
                this.scheduleIntervalGenerator = (ScheduleIntervalGenerator)Class.forName(this.intervalGenerator).newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return this.scheduleIntervalGenerator;
    }

    public boolean isMain() {
        return this.main || this.intervalGenerator != null;
    }

    public void setMain(boolean bl) {
        this.main = bl;
    }

    public FormFormat getForm() {
        return this.form;
    }

    public void setForm(FormFormat formFormat) {
        this.form = formFormat;
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/bar/format", "com.projity.graphic.configuration.BarFormat");
        digester.addSetProperties("*/bar/format");
        digester.addSetNext("*/bar/format", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/bar/format/start", "com.projity.graphic.configuration.TexturedShape");
        digester.addSetProperties("*/bar/format/start");
        digester.addSetNext("*/bar/format/start", "setStart", "com.projity.graphic.configuration.TexturedShape");
        digester.addObjectCreate("*/bar/format/middle", "com.projity.graphic.configuration.TexturedShape");
        digester.addSetProperties("*/bar/format/middle");
        digester.addSetNext("*/bar/format/middle", "setMiddle", "com.projity.graphic.configuration.TexturedShape");
        digester.addObjectCreate("*/bar/format/end", "com.projity.graphic.configuration.TexturedShape");
        digester.addSetProperties("*/bar/format/end");
        digester.addSetNext("*/bar/format/end", "setEnd", "com.projity.graphic.configuration.TexturedShape");
        digester.addObjectCreate("*/bar/format/form", "com.projity.graphic.configuration.FormFormat");
        digester.addSetProperties("*/bar/format/form");
        digester.addSetNext("*/bar/format/form", "setForm", "com.projity.graphic.configuration.FormFormat");
        FormFormat.addDigesterEvents(digester);
    }

    public Field getFromField() {
        return this.fromField;
    }

    public Field getToField() {
        return this.toField;
    }

    public int getNumberOfSections() {
        int n = 0;
        if (this.start != null) {
            ++n;
        }
        if (this.middle != null) {
            ++n;
        }
        if (this.end != null) {
            ++n;
        }
        return n;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String string) {
        this.fieldId = string;
        this.getField();
    }

    public Field getField() {
        if (this.field == null || this.field.getId() != this.fieldId) {
            if (this.fieldId == null) {
                this.field = null;
            }
            this.field = FieldDictionary.getInstance().getFieldFromId(this.fieldId);
        }
        return this.field;
    }
}

