/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.model;

import com.projity.association.Association;
import com.projity.association.AssociationList;
import com.projity.document.Document;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeBridge;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.grouping.core.hierarchy.HierarchyUtils;
import com.projity.grouping.core.hierarchy.MutableNodeHierarchy;
import com.projity.grouping.core.hierarchy.NodeHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.grouping.core.model.NodeModelUtil;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentService;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Task;
import com.projity.pm.task.TaskLinkReference;
import com.projity.pm.task.TaskLinkReferenceImpl;
import com.projity.undo.ModelFieldEdit;
import com.projity.undo.NodeCreationEdit;
import com.projity.undo.NodeDeletionEdit;
import com.projity.undo.NodeImplChangeAndValueSetEdit;
import com.projity.undo.NodeImplChangeEdit;
import com.projity.undo.NodePasteEdit;
import com.projity.undo.UndoController;
import com.projity.util.Environment;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeModel
implements NodeModel {
    protected NodeHierarchy hierarchy;
    protected NodeModelDataFactory dataFactory = null;
    private static ImplComparator implComparatorInstance = null;
    protected UndoController undoController;
    protected boolean local;
    protected boolean master = true;

    public DefaultNodeModel() {
        this.hierarchy = new MutableNodeHierarchy();
    }

    public DefaultNodeModel(NodeModelDataFactory nodeModelDataFactory) {
        this();
        this.dataFactory = nodeModelDataFactory;
    }

    DefaultNodeModel(NodeHierarchy nodeHierarchy, NodeModelDataFactory nodeModelDataFactory) {
        this.hierarchy = nodeHierarchy;
        this.dataFactory = nodeModelDataFactory;
    }

    @Override
    public void addBefore(LinkedList linkedList, Node node, int n) {
        boolean bl;
        Node node2;
        Node node3;
        if (linkedList.size() == 0) {
            return;
        }
        if (linkedList.size() == 1) {
            node3 = null;
            Node node4 = (Node)linkedList.removeLast();
            node2 = null;
            bl = true;
        } else {
            node3 = (Node)linkedList.removeFirst();
            Node node5 = (Node)linkedList.removeLast();
            node2 = (Node)node5.getParent();
            bl = node2 == node3;
            node2 = bl ? node3 : (Node)node3.getParent();
            this.remove(linkedList, 0);
        }
        linkedList.add(node);
        this.add(node2, linkedList, bl ? 0 : node2.getIndex(node3) + 1, 0);
        this.getDataFactory().setGroupDirty(true);
    }

    @Override
    public void addBefore(Node node, Node node2, int n) {
        Node node3 = (Node)node.getParent();
        this.add(node3, node2, node3.getIndex(node), n);
    }

    @Override
    public void addBefore(Node node, List list, int n) {
        Node node2 = (Node)node.getParent();
        this.add(node2, list, node2.getIndex(node), n);
    }

    @Override
    public void add(Node node, Node node2, int n) {
        this.add(node, node2, -1, n);
    }

    @Override
    public void add(Node node, Node node2, int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node2);
        this.add(node, arrayList, n, n2);
    }

    @Override
    public void add(Node node, List list, int n) {
        this.add(node, list, -1, n);
    }

    @Override
    public void add(Node node, List list, int n, int n2) {
        this.hierarchy.add(node, list, n, n2);
        if (DefaultNodeModel.isUndo(n2)) {
            this.postEdit(new NodeCreationEdit(this, node, list, n));
        }
    }

    @Override
    public void add(Node node, int n) {
        this.add((Node)this.hierarchy.getRoot(), node, n);
    }

    @Override
    public Node newNode(Node node, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        Object object = node.children();
        while (object.hasMoreElements()) {
            Node node2 = (Node)object.nextElement();
            if (n4 == n3) {
                if (node2.getImpl() instanceof Assignment) {
                    ++n3;
                } else {
                    Node node3 = NodeFactory.getInstance().createVoidNode();
                    this.add(node, node3, n3, 3);
                    return node3;
                }
            }
            ++n4;
        }
        object = NodeFactory.getInstance().createVoidNode();
        this.add(node, (Node)object, -1, 3);
        return object;
    }

    @Override
    public void paste(Node node, List list, int n, int n2) {
        this.hierarchy.paste(node, list, n, this, n2);
        if (DefaultNodeModel.isUndo(n2)) {
            this.postEdit(new NodePasteEdit(this, node, list, n));
        }
    }

    public boolean isAncestor(Node node, Node node2) {
        if (node2 == null) {
            return false;
        }
        if (node == node2) {
            return true;
        }
        return this.isAncestor(node, this.getParent(node2));
    }

    public boolean isAncestorOrDescendant(Node node, Node node2) {
        return this.isAncestor(node, node2) || this.isAncestor(node2, node);
    }

    public boolean testAncestorOrDescendant(Node node, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.isAncestorOrDescendant(node, (Node)iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void move(Node node, List list, int n, int n2) {
        if (!this.testAncestorOrDescendant(node, list)) {
            return;
        }
        List list2 = this.cut(list, false, n2);
        this.paste(node, list2, n, n2);
    }

    @Override
    public void addImplCollection(Node node, Collection collection, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Node node2 = NodeFactory.getInstance().createNode(iterator.next());
            this.add(node, node2, n);
        }
    }

    @Override
    public void remove(Node node, int n) {
        this.remove(node, n, true, true);
    }

    @Override
    public void remove(Node node, int n, boolean bl) {
        this.remove(node, n, true, bl);
    }

    public void remove(Node node, int n, boolean bl, boolean bl2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        this.remove(arrayList, n, bl, bl2);
    }

    @Override
    public void remove(List list, int n) {
        this.remove(list, n, true);
    }

    @Override
    public void remove(List list, int n, boolean bl) {
        this.remove(list, n, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List list, int n, boolean bl, boolean bl2) {
        if (this.undoController != null && DefaultNodeModel.isUndo(n)) {
            this.undoController.getEditSupport().beginUpdate();
        }
        try {
            Object object;
            ArrayList arrayList = new ArrayList();
            HierarchyUtils.extractParents(list, arrayList);
            if (bl) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (Node)iterator.next();
                    if (!(object.getImpl() instanceof Assignment)) continue;
                    iterator.remove();
                }
            }
            boolean bl3 = false;
            object = new ArrayList();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (NodeBridge nodeBridge : arrayList) {
                if (NodeModelUtil.nodeIsSubproject(nodeBridge)) {
                    bl3 = true;
                }
                NodeBridge nodeBridge2 = (NodeBridge)nodeBridge.getParent();
                object.add(nodeBridge2);
                arrayList2.add(new Integer(nodeBridge2.getIndex(nodeBridge)));
            }
            if (!this.confirmRemove(arrayList)) {
                return;
            }
            if (this.undoController != null && DefaultNodeModel.isUndo(n) && bl3) {
                this.undoController.clear();
            }
            this.hierarchy.remove(arrayList, this, n, bl2);
            this.hierarchy.checkEndVoidNodes(n);
            if (this.undoController != null && !bl3 && DefaultNodeModel.isUndo(n)) {
                this.postEdit(new NodeDeletionEdit(this, (List)object, arrayList, arrayList2));
            }
        }
        finally {
            if (this.undoController != null && DefaultNodeModel.isUndo(n)) {
                this.undoController.getEditSupport().endUpdate();
            }
        }
    }

    @Override
    public void removeAll(int n) {
        this.hierarchy.removeAll(this, n);
    }

    @Override
    public boolean removeApartFromHierarchy(Node node, boolean bl, int n, boolean bl2) {
        if (!DefaultNodeModel.isEvent(n)) {
            return true;
        }
        if (node.getImpl() instanceof Assignment) {
            Assignment assignment = (Assignment)node.getImpl();
            AssignmentService.getInstance().remove(assignment, bl, (Object)this, DefaultNodeModel.isUndo(n));
        } else if (this.dataFactory != null && !node.isVoid()) {
            this.dataFactory.remove(node.getImpl(), this, false, DefaultNodeModel.isUndo(n), bl2);
        }
        return true;
    }

    @Override
    public List cut(List list, int n) {
        return this.cut(list, true, n);
    }

    public List cut(List list, boolean bl, int n) {
        List list2 = this.copy(list, bl, n);
        this.remove(list, n);
        return list2;
    }

    @Override
    public List copy(List list, int n) {
        return this.copy(list, true, n);
    }

    public List copy(List list, boolean bl, int n) {
        Object object;
        TaskLinkReference taskLinkReference;
        Object object2;
        ArrayList arrayList = new ArrayList(list.size());
        HierarchyUtils.extractParents(list, arrayList);
        if (!bl) {
            return arrayList;
        }
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        HashSet<Dependency> hashSet2 = new HashSet<Dependency>();
        HashSet<Dependency> hashSet3 = new HashSet<Dependency>();
        Iterator<Object> iterator = arrayList.listIterator();
        while (iterator.hasNext()) {
            Node object32 = (Node)iterator.next();
            object2 = this.cloneNode(object32, null, hashMap, hashSet2, hashSet3);
            this.cloneBranch(object32, (Node)object2, hashSet, hashMap, hashSet2, hashSet3);
            iterator.remove();
            iterator.add(object2);
        }
        if (Environment.isKeepExternalLinks()) {
            Dependency dependency;
            TaskLinkReference taskLinkReference2;
            for (Dependency dependency2 : hashSet3) {
                object2 = (TaskLinkReference)dependency2.getPredecessor();
                taskLinkReference = (TaskLinkReference)dependency2.getSuccessor();
                object = (Task)hashMap.get(object2);
                taskLinkReference2 = (Task)hashMap.get(taskLinkReference);
                if (object == null) {
                    object = new TaskLinkReferenceImpl(object2.getUniqueId(), object2.getProject());
                }
                if (taskLinkReference2 == null) {
                    taskLinkReference2 = new TaskLinkReferenceImpl(taskLinkReference.getUniqueId(), taskLinkReference.getProject());
                }
                dependency = Dependency.getInstance((HasDependencies)object, taskLinkReference2, dependency2.getDependencyType(), dependency2.getLag());
                dependency.setDirty(true);
                object.getDependencyList(false).add(dependency);
                taskLinkReference2.getDependencyList(true).add(dependency);
                hashSet2.remove(dependency);
            }
            for (Dependency dependency3 : hashSet2) {
                object2 = (TaskLinkReference)dependency3.getPredecessor();
                taskLinkReference = (TaskLinkReference)dependency3.getSuccessor();
                object = (TaskLinkReference)hashMap.get(object2);
                taskLinkReference2 = (TaskLinkReference)hashMap.get(taskLinkReference);
                if (object == null) {
                    object = new TaskLinkReferenceImpl(object2.getUniqueId(), object2.getProject());
                }
                if (taskLinkReference2 == null) {
                    taskLinkReference2 = new TaskLinkReferenceImpl(taskLinkReference.getUniqueId(), taskLinkReference.getProject());
                }
                dependency = Dependency.getInstance((HasDependencies)object, taskLinkReference2, dependency3.getDependencyType(), dependency3.getLag());
                dependency.setDirty(true);
                object.getDependencyList(false).add(dependency);
                taskLinkReference2.getDependencyList(true).add(dependency);
            }
        } else {
            for (Dependency dependency : hashSet2) {
                if (!hashSet3.contains(dependency)) continue;
                object2 = (Task)hashMap.get(dependency.getPredecessor());
                taskLinkReference = (Task)hashMap.get(dependency.getSuccessor());
                if (object2 == null || taskLinkReference == null) continue;
                object = Dependency.getInstance((HasDependencies)object2, taskLinkReference, dependency.getDependencyType(), dependency.getLag());
                ((Dependency)object).setDirty(true);
                ((Task)object2).getDependencyList(false).add((Association)object);
                ((Task)taskLinkReference).getDependencyList(true).add((Association)object);
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.addAssignments((Node)iterator.next());
        }
        iterator = arrayList.listIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.cleanBranch(node);
        }
        return arrayList;
    }

    private void cloneBranch(Node node, Node node2, Set set, Map map, Set<Dependency> set2, Set<Dependency> set3) {
        ListIterator listIterator = node.childrenIterator();
        while (listIterator.hasNext()) {
            Node node3 = (Node)listIterator.next();
            if (node3.getImpl() instanceof Assignment) {
                set.add(node2);
                continue;
            }
            Node node4 = this.cloneNode(node3, node2, map, set2, set3);
            this.cloneBranch(node3, node4, set, map, set2, set3);
        }
    }

    private Node cloneNode(Node node, Node node2, Map map, Set<Dependency> set, Set<Dependency> set2) {
        Object object;
        Object object2 = node.getImpl();
        Object object3 = this.cloneNodeImpl(object2);
        map.put(object2, object3);
        if (object2 instanceof Task) {
            object = (Task)object2;
            set.addAll(((Task)object).getDependencyList(true));
            set2.addAll(((Task)object).getDependencyList(false));
        }
        object = node2 == null ? null : node2.getImpl();
        NodeModelDataFactory nodeModelDataFactory = this.getFactory(object);
        nodeModelDataFactory.addUnvalidatedObject(object3, this, object);
        Node node3 = NodeFactory.getInstance().createNode(object3);
        if (node2 != null) {
            node2.add(node3);
        }
        if (object != null && object instanceof Task) {
            ((Task)object).setWbsChildrenNodes(this.getHierarchy().getChildren(node2));
        }
        return node3;
    }

    private Object cloneNodeImpl(Object object) {
        if (object instanceof VoidNodeImpl) {
            return new VoidNodeImpl();
        }
        if (object instanceof NormalTask) {
            return ((NormalTask)object).clone();
        }
        if (object instanceof ResourceImpl) {
            return ((ResourceImpl)object).clone();
        }
        return null;
    }

    private void cleanBranch(Node node) {
        ListIterator listIterator = node.childrenIterator();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            this.cleanNodeImpl(node2.getImpl());
            this.cleanBranch(node2);
        }
    }

    private void cleanNodeImpl(Object object) {
        if (object instanceof NormalTask) {
            ((NormalTask)object).cleanClone();
        } else if (object instanceof ResourceImpl) {
            ((ResourceImpl)object).cleanClone();
        }
    }

    private void addAssignments(Node node) {
        if (node.getImpl() instanceof HasAssignments) {
            AssociationList associationList = ((HasAssignments)node.getImpl()).getAssignments();
            if (associationList == null) {
                return;
            }
            ListIterator listIterator = associationList.listIterator(associationList.size());
            while (listIterator.hasPrevious()) {
                Assignment assignment = (Assignment)listIterator.previous();
                if (assignment.isDefault()) continue;
                Node node2 = NodeFactory.getInstance().createNode(assignment);
                node.insert(node2, 0);
            }
        }
    }

    @Override
    public Object clone() {
        return new DefaultNodeModel((NodeHierarchy)this.hierarchy.clone(), this.dataFactory);
    }

    @Override
    public Iterator iterator() {
        return this.hierarchy.iterator();
    }

    @Override
    public Iterator iterator(Node node) {
        return this.hierarchy.iterator(node);
    }

    @Override
    public Iterator shallowIterator(int n, boolean bl) {
        return this.hierarchy.shallowIterator(n, bl);
    }

    @Override
    public NodeHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public void setHierarchy(NodeHierarchy nodeHierarchy) {
        this.hierarchy = nodeHierarchy;
    }

    @Override
    public boolean hasChildren(Node node) {
        return !this.hierarchy.isLeaf(node);
    }

    @Override
    public boolean isSummary(Node node) {
        return this.hierarchy.isSummary(node);
    }

    @Override
    public Node search(Object object, Comparator comparator) {
        return this.hierarchy.search(object, comparator);
    }

    public static ImplComparator getImplComparatorInstance() {
        if (implComparatorInstance == null) {
            implComparatorInstance = new ImplComparator();
        }
        return implComparatorInstance;
    }

    @Override
    public Node search(Object object) {
        return this.search(object, DefaultNodeModel.getImplComparatorInstance());
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.hierarchy.addTreeModelListener(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.hierarchy.getChild(object, n);
    }

    @Override
    public int getChildCount(Object object) {
        return this.hierarchy.getChildCount(object);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.hierarchy.getIndexOfChild(object, object2);
    }

    @Override
    public Object getRoot() {
        return this.hierarchy.getRoot();
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.hierarchy.isLeaf(object);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.hierarchy.removeTreeModelListener(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.hierarchy.valueForPathChanged(treePath, object);
    }

    @Override
    public void setFieldValue(Field field, Node node, Object object, Object object2, FieldContext fieldContext, int n) throws FieldParseException {
        Object object3 = field.getValue(node, this, fieldContext);
        field.setValue(node, this, object, object2, fieldContext);
        if (DefaultNodeModel.isUndo(n)) {
            this.postEdit(new ModelFieldEdit(this, field, node, object, object2, object3, fieldContext));
        }
    }

    @Override
    public Node replaceImplAndSetFieldValue(Node node, LinkedList linkedList, Field field, Object object, Object object2, FieldContext fieldContext, int n) throws FieldParseException {
        Node node2;
        if (linkedList != null && linkedList.size() > 0 && (node2 = (Node)linkedList.getFirst()) != null && node2.isInSubproject() && node.getSubprojectLevel() < node2.getSubprojectLevel()) {
            while (node.getSubprojectLevel() < node2.getSubprojectLevel()) {
                node2 = (Node)node2.getParent();
            }
            LinkedList<Node> linkedList2 = new LinkedList<Node>();
            linkedList2.add(node2);
            for (Node node3 : linkedList) {
                Node node4;
                for (node4 = (Node)node3.getParent(); node4 != null && node4 != node2; node4 = (Node)node4.getParent()) {
                }
                if (node4 == node2) continue;
                linkedList2.add(node3);
            }
            Object object3 = node2.getImpl();
            NodeModelDataFactory nodeModelDataFactory = this.getFactory(object3);
            return this.replaceImplAndSetFieldValue(node, linkedList2, nodeModelDataFactory.createUnvalidatedObject(this, object3), field, object, object2, fieldContext, n);
        }
        node2 = (Node)node.getParent();
        Object object4 = node2 == this.getHierarchy().getRoot() ? null : node2.getImpl();
        NodeModelDataFactory nodeModelDataFactory = this.getFactory(object4);
        return this.replaceImplAndSetFieldValue(node, linkedList, nodeModelDataFactory.createUnvalidatedObject(this, object4), field, object, object2, fieldContext, n);
    }

    private NodeModelDataFactory getFactory(Object object) {
        if (object == null) {
            return this.dataFactory;
        }
        return this.dataFactory.getFactoryToUseForChildOfParent(object);
    }

    @Override
    public Node replaceImplAndSetFieldValue(Node node, LinkedList linkedList, Object object, Field field, Object object2, Object object3, FieldContext fieldContext, int n) throws FieldParseException {
        Iterator iterator;
        Object object4;
        Object object5;
        Object object6;
        ArrayList<NodeImplChangeAndValueSetEdit.Position> arrayList = null;
        if (linkedList != null) {
            object6 = (LinkedList)linkedList.clone();
            object5 = (Node)((LinkedList)object6).removeFirst();
            object4 = (Node)object5.getParent();
            ((LinkedList)object6).add(node);
            if (this.getUndoableEditSupport() != null & DefaultNodeModel.isUndo(n)) {
                arrayList = new ArrayList<NodeImplChangeAndValueSetEdit.Position>(((LinkedList)object6).size());
                iterator = ((AbstractSequentialList)object6).iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    arrayList.add(new NodeImplChangeAndValueSetEdit.Position((Node)node2.getParent(), node2, node2.getParent().getIndex(node2)));
                }
            }
            this.remove((List)object6, 0);
            this.add((Node)object4, (List)object6, object4.getIndex((TreeNode)object5) + 1, 0);
        }
        object5 = (object6 = (Node)node.getParent()) == this.getHierarchy().getRoot() ? null : object6.getImpl();
        object4 = this.getFactory(object5);
        object4.addUnvalidatedObject(object, this, object5);
        iterator = node.getImpl();
        node.setImpl(object);
        try {
            field.setValue(node, this, null, object3, fieldContext);
        }
        catch (FieldParseException fieldParseException) {
            object4.rollbackUnvalidated(this, object);
            throw fieldParseException;
        }
        object4.validateObject(object, this, object2, null, true);
        this.hierarchy.renumber();
        this.hierarchy.checkEndVoidNodes(n ^ 1);
        this.getHierarchy().fireInsertion(new Node[]{node});
        if (DefaultNodeModel.isUndo(n)) {
            this.postEdit(new NodeImplChangeAndValueSetEdit(this, node, linkedList, arrayList, iterator, field, object3, fieldContext, object2));
        }
        return node;
    }

    @Override
    public Node replaceImpl(Node node, Object object, Object object2, int n) {
        Node node2 = this.getParent(node);
        Object object3 = node2 == this.getHierarchy().getRoot() ? null : node2.getImpl();
        NodeModelDataFactory nodeModelDataFactory = this.getFactory(object3);
        nodeModelDataFactory.addUnvalidatedObject(object, this, object3);
        Object object4 = node.getImpl();
        node.setImpl(object);
        nodeModelDataFactory.validateObject(object, this, object2, null, false);
        this.hierarchy.renumber();
        this.getHierarchy().fireRemoval(new Node[]{node});
        this.hierarchy.checkEndVoidNodes(n);
        if (DefaultNodeModel.isUndo(n)) {
            this.postEdit(new NodeImplChangeEdit(this, node, object4, object2));
        }
        return node;
    }

    @Override
    public NodeModelDataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public void setDataFactory(NodeModelDataFactory nodeModelDataFactory) {
        this.dataFactory = nodeModelDataFactory;
    }

    @Override
    public List getChildren(Node node) {
        return this.getHierarchy().getChildren(node);
    }

    @Override
    public Node getParent(Node node) {
        return this.getHierarchy().getParent(node);
    }

    @Override
    public Document getDocument() {
        return null;
    }

    public static boolean isEvent(int n) {
        return (n & 1) == 1;
    }

    public static boolean isUndo(int n) {
        return (n & 2) == 2;
    }

    @Override
    public UndoController getUndoController() {
        return this.undoController;
    }

    @Override
    public void setUndoController(UndoController undoController) {
        this.undoController = undoController;
    }

    @Override
    public UndoableEditSupport getUndoableEditSupport() {
        if (this.undoController == null) {
            return null;
        }
        return this.undoController.getEditSupport();
    }

    public void postEdit(UndoableEdit undoableEdit) {
        if (this.getUndoableEditSupport() != null) {
            this.getUndoableEditSupport().postEdit(undoableEdit);
        }
    }

    @Override
    public boolean confirmRemove(List list) {
        return true;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean bl) {
        this.local = bl;
    }

    @Override
    public boolean isMaster() {
        return this.master;
    }

    @Override
    public void setMaster(boolean bl) {
        this.master = bl;
    }

    public static class ImplComparator
    implements Comparator {
        ImplComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((Node)object).getImpl() == object2) {
                return 0;
            }
            return 1;
        }
    }
}

