/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.help.HelpUtil;
import com.projity.menu.HyperLinkToolTip;
import com.projity.menu.MenuActionConstants;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.util.gui.resource.JToolbarSeparator;

public class TabbedNavigation
implements MenuActionConstants,
Serializable {
    private static final long serialVersionUID = -270788624568075685L;
    ExtTabbedPane tabbedPane;
    MenuManager menuManager;
    ArrayList actions = new ArrayList();
    int oldSelected = -1;
    DocumentFrame currentFrame;
    private JToolBar currentBar = null;
    private static int eventNum = 0;
    private JPopupMenu trackingPopup = null;
    private int resourceTabCount = 0;
    private static Color backgroundSelected = new Color(125, 157, 230);
    private Color backgroundUnselected = UIManager.getColor("TabbedPane.unselectedBackground");
    private ArrayList<JButton> trackingButtons = new ArrayList();

    public JComponent createContentPanel(MenuManager menuManager, JToolBar jToolBar, int n, int n2, boolean bl) {
        this.menuManager = menuManager;
        menuManager.add(this);
        boolean bl2 = n2 == 1;
        int n3 = bl2 ? 45 : 15;
        FormLayout formLayout = new FormLayout("p:grow", "fill:" + n3 + "dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPane = new ExtTabbedPane();
        this.tabbedPane.setTabPlacement(n2);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
            AbstractButton abstractButton;
            Action action;
            Component component = jToolBar.getComponent(i);
            if (component instanceof JToolbarSeparator) {
                ++n5;
            }
            if (!(component instanceof AbstractButton) || n != -1 && n != n5 || (action = (abstractButton = (AbstractButton)component).getAction()) == menuManager.getActionFromId("TrackingGantt") || action == menuManager.getActionFromId("Projects")) continue;
            JComponent jComponent = bl2 ? this.createSubPanel(action, bl) : this.dummy();
            jComponent.setBorder(BorderFactory.createEmptyBorder());
            if (Environment.isNewLook() && !Environment.isNewLaf()) {
                jComponent.setOpaque(false);
            }
            String string = HyperLinkToolTip.extractTip(abstractButton.getToolTipText());
            this.tabbedPane.addTab(string, jComponent);
            if (action == menuManager.getActionFromId("Resources")) {
                this.resourceTabCount = n4;
            }
            this.tabbedPane.setToolTipTextAt(n4, string);
            this.actions.add(action);
            ++n4;
        }
        defaultFormBuilder.add(this.tabbedPane);
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        return jPanel;
    }

    public void setAllButResourceDisabled(boolean bl) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (i == this.resourceTabCount) continue;
            this.tabbedPane.setEnabledAt(i, !bl);
        }
    }

    private JPanel dummy() {
        JPanel jPanel = new JPanel();
        jPanel.setSize(jPanel.getSize().width, 0);
        return jPanel;
    }

    private JComponent createSubPanel(Action action, boolean bl) {
        String string = null;
        boolean bl2 = false;
        if (action == this.menuManager.getActionFromId("Gantt")) {
            string = "GanttToolBar";
            bl2 = true;
        } else if (action == this.menuManager.getActionFromId("TrackingGantt")) {
            string = "TrackingGanttToolBar";
            bl2 = true;
        } else if (action == this.menuManager.getActionFromId("TaskUsageDetail")) {
            string = "TaskUsageDetailToolBar";
        } else if (action == this.menuManager.getActionFromId("ResourceUsageDetail")) {
            string = "ResourceUsageDetailToolBar";
        } else if (action == this.menuManager.getActionFromId("Network")) {
            string = "NetworkToolBar";
        } else if (action == this.menuManager.getActionFromId("WBS")) {
            string = "WBSToolBar";
        } else if (action == this.menuManager.getActionFromId("RBS")) {
            string = "RBSToolBar";
        } else if (action == this.menuManager.getActionFromId("Resources")) {
            string = "ResourceToolBar";
        } else if (action == this.menuManager.getActionFromId("Report")) {
            string = "ReportToolBar";
        }
        if (string == null) {
            return this.dummy();
        }
        JToolBar jToolBar = this.menuManager.getToolBar(string);
        jToolBar.setFloatable(false);
        if (bl2) {
            jToolBar.addSeparator(new Dimension(20, 20));
            JComponent jComponent = this.tracking();
            jToolBar.add(jComponent);
            HelpUtil.addDocHelp(jComponent, "Tracking_Menu");
        }
        jToolBar.addSeparator(new Dimension(40, 20));
        return jToolBar;
    }

    private JComponent tracking() {
        final JButton jButton = new JButton(Messages.getString("Spreadsheet.Task.tracking"), IconManager.getIcon("print.down")){

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (this.getToolTipText().startsWith("<html>")) {
                    return new Point(0, this.getHeight() - 2);
                }
                return super.getToolTipLocation(mouseEvent);
            }

            public JToolTip createToolTip() {
                if (this.getToolTipText().startsWith("<html>")) {
                    HyperLinkToolTip hyperLinkToolTip = new HyperLinkToolTip();
                    hyperLinkToolTip.setComponent(this);
                    return hyperLinkToolTip;
                }
                return super.createToolTip();
            }
        };
        jButton.setHorizontalTextPosition(10);
        String string = "SFTracking";
        String string2 = this.menuManager.getString(string + ".tooltip");
        if (string2 != null) {
            String string3 = this.menuManager.getStringOrNull(string + ".help");
            String string4 = this.menuManager.getStringOrNull(string + ".demo");
            String string5 = this.menuManager.getStringOrNull(string + ".doc");
            if (string5 != null) {
                string2 = HyperLinkToolTip.helpTipText(string2, string3, string4, string5);
            }
            jButton.setToolTipText(string2);
        }
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TabbedNavigation.this.trackingPopup == null) {
                    TabbedNavigation.this.trackingPopup = TabbedNavigation.this.menuManager.getPopupMenu("SFTracking");
                }
                TabbedNavigation.this.trackingPopup.show(jButton, 0, jButton.getHeight());
            }
        });
        this.trackingButtons.add(jButton);
        return jButton;
    }

    public void setActivatedView(String string, boolean bl) {
        if (!bl) {
            return;
        }
        int n = this.indexOfViewId(string);
        if (n != -1 && n != this.tabbedPane.getSelectedIndex()) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    private void dumpTabNames() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            System.out.println("tab " + i + " title: " + this.tabbedPane.getTitleAt(i) + "action " + this.actions.get(i).hashCode());
        }
    }

    private int indexOfViewId(String string) {
        Action action = this.menuManager.getActionFromId(string);
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.actions.get(i) != action) continue;
            return i;
        }
        return -1;
    }

    private void addFilterToolBar(JToolBar jToolBar) {
        if (this.currentFrame != null) {
            this.currentBar = jToolBar;
            this.currentFrame.getFilterToolBarManager().addButtons(jToolBar);
        }
    }

    private void removeFilterToolBar(JToolBar jToolBar) {
        if (this.currentFrame != null) {
            this.currentFrame.getFilterToolBarManager().removeButtons(jToolBar);
        }
    }

    public void setCurrentFrame(DocumentFrame documentFrame) {
        if (this.currentFrame != null) {
            this.removeFilterToolBar(this.currentBar);
        }
        this.currentFrame = documentFrame;
        this.initFilterToolBar();
    }

    public void initFilterToolBar() {
        JComponent jComponent = (JComponent)this.tabbedPane.getSelectedComponent();
        if (jComponent instanceof JToolBar) {
            this.addFilterToolBar((JToolBar)jComponent);
        }
    }

    public void setTrackingEnabled(boolean bl) {
        for (JButton jButton : this.trackingButtons) {
            jButton.setEnabled(bl);
        }
    }

    private class ExtTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 7993870683783896098L;

        ExtTabbedPane() {
            this.setCursor(Cursor.getPredefinedCursor(12));
            Font font = new Font("Verdana", 1, 11);
            this.setFont(font);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = ExtTabbedPane.this.getSelectedIndex();
                    AbstractAction abstractAction = null;
                    if (TabbedNavigation.this.oldSelected != -1) {
                        JComponent jComponent = (JComponent)TabbedNavigation.this.tabbedPane.getComponentAt(TabbedNavigation.this.oldSelected);
                        if (jComponent instanceof JToolBar) {
                            TabbedNavigation.this.removeFilterToolBar((JToolBar)jComponent);
                        }
                        abstractAction = (AbstractAction)TabbedNavigation.this.actions.get(n);
                        abstractAction.actionPerformed(new ActionEvent(this, eventNum++, "click"));
                        TabbedNavigation.this.tabbedPane.setForegroundAt(TabbedNavigation.this.oldSelected, Color.BLACK);
                        TabbedNavigation.this.tabbedPane.setBackgroundAt(TabbedNavigation.this.oldSelected, TabbedNavigation.this.backgroundUnselected);
                        JComponent jComponent2 = (JComponent)TabbedNavigation.this.tabbedPane.getSelectedComponent();
                        if (jComponent2 instanceof JToolBar) {
                            TabbedNavigation.this.addFilterToolBar((JToolBar)jComponent2);
                        }
                    }
                    TabbedNavigation.this.tabbedPane.setForegroundAt(n, Color.WHITE);
                    TabbedNavigation.this.tabbedPane.setBackgroundAt(n, backgroundSelected);
                    TabbedNavigation.this.oldSelected = n;
                }
            });
            GraphicManager.getInstance().getLafManager().setUI(this);
        }

        public void updateUI() {
        }
    }
}

