/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractActionFromEditGroup;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.WatcherInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.WatchersOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.ui.WatchersPanel;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import java.util.List;

public class ViewWatchersAction
extends AbstractActionFromEditGroup {
    private WatchersOperation myWatchersOperation;

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.getViewEditorsOperationName();
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        this.myWatchersOperation = new WatchersOperation(context.getSelectedFiles());
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.veiw.watchers", (Object[])new Object[0]), this.myWatchersOperation);
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        if (successfully) {
            List<WatcherInfo> watchers = this.myWatchersOperation.getWatchers();
            String filePath = CvsVfsUtil.getFileFor(context.getSelectedFile()).getAbsolutePath();
            Project project = context.getProject();
            if (project == null) {
                return;
            }
            if (watchers.isEmpty()) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)CvsBundle.message((String)"message.error.no.watchers.for.file", (Object[])new Object[]{filePath}), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
            } else {
                tabbedWindow.addTab(CvsBundle.message((String)"message.watchers.for.file", (Object[])new Object[]{filePath}), new WatchersPanel(watchers), true, true, true, true, null, "cvs.watchers");
            }
        }
    }
}

