/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ext;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionUtil;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorkerImpl;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProviderImpl;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionUtil;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.cvsSupport2.javacvsImpl.io.StreamLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class ExtConnectionCvsSettings
extends CvsConnectionSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.connections.ext.ExtConnectionCvsSettings");
    @NonNls
    private static final String UNHANDLED_RESPONSE_PREFIX = "Unhandled response: ";
    private final SshSettings mySshSettings;

    public ExtConnectionCvsSettings(CvsRootConfiguration cvsRootConfiguration) {
        super(cvsRootConfiguration);
        this.mySshSettings = cvsRootConfiguration.SSH_FOR_EXT_CONFIGURATION;
    }

    @Override
    protected IConnection createOriginalConnection(ErrorRegistry errorRegistry, CvsRootConfiguration cvsRootConfiguration) {
        return CvsConnectionUtil.createExtConnection((CvsRootData)this, (ExtConfiguration)this.getExtConfiguration(), (SshSettings)this.mySshSettings, (SSHPasswordProvider)SSHPasswordProviderImpl.getInstance(), (ProxySettings)cvsRootConfiguration.PROXY_SETTINGS, (ErrorRegistry)errorRegistry, (int)(CvsApplicationLevelConfiguration.getInstance().TIMEOUT * 1000));
    }

    @Override
    public int getDefaultPort() {
        return 22;
    }

    public CvsLoginWorker getLoginWorker(Project project) {
        return new ExtLoginWorker(project, this);
    }

    public CommandException processException(CommandException t) {
        Exception sourceException = t.getUnderlyingException();
        if (!(sourceException instanceof IOException)) {
            return t;
        }
        String localizedMessage = t.getLocalizedMessage();
        if (localizedMessage == null || !localizedMessage.startsWith(UNHANDLED_RESPONSE_PREFIX)) {
            return t;
        }
        String response = localizedMessage.substring(UNHANDLED_RESPONSE_PREFIX.length(), localizedMessage.length() - 1);
        if (StringUtil.startsWithConcatenation((String)response, (String[])new String[]{this.USER, "@", this.HOST})) {
            return new IOCommandException(new IOException(CvsBundle.message((String)"exception.text.ext.server.rejected.access", (Object[])new Object[0])));
        }
        return new IOCommandException(new IOException(CvsBundle.message((String)"exception.text.cannot.establish.external.connection", (Object[])new Object[]{response})));
    }

    private class ExtLoginWorker
    extends CvsLoginWorkerImpl<ExtConnectionCvsSettings> {
        public ExtLoginWorker(Project project, ExtConnectionCvsSettings settings) {
            super(project, settings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void silentLoginImpl(boolean forceCheck) throws AuthenticationException {
            IConnection connection = ((ExtConnectionCvsSettings)this.mySettings).createConnection(new ReadWriteStatistics());
            try {
                connection.open((IStreamLogger)new StreamLogger());
                ((ExtConnectionCvsSettings)this.mySettings).setOffline(false);
            }
            finally {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }

        public boolean promptForPassword() {
            return SshConnectionUtil.promptForPassword(ExtConnectionCvsSettings.this.mySshSettings, ExtConnectionCvsSettings.this.getCvsRootAsString());
        }

        @Override
        protected void clearOldCredentials() {
            if (!((ExtConnectionCvsSettings)ExtConnectionCvsSettings.this).getExtConfiguration().USE_INTERNAL_SSH_IMPLEMENTATION) {
                return;
            }
            if (((ExtConnectionCvsSettings)ExtConnectionCvsSettings.this).mySshSettings.USE_PPK) {
                SSHPasswordProviderImpl.getInstance().removePPKPasswordFor(ExtConnectionCvsSettings.this.getCvsRootAsString());
            } else {
                SSHPasswordProviderImpl.getInstance().removePasswordFor(ExtConnectionCvsSettings.this.getCvsRootAsString());
            }
        }
    }
}

