/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffProvider
extends DiffProviderEx
implements DiffProvider,
DiffMixin {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnDiffProvider");
    public static final String COMMIT_MESSAGE = "svn:log";
    private static final int BATCH_INFO_SIZE = 20;
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffProvider(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnDiffProvider.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(@NotNull VirtualFile file) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(1);
        }
        Info svnInfo = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        return SvnDiffProvider.getRevision(svnInfo);
    }

    @Nullable
    private static VcsRevisionNumber getRevision(@Nullable Info info) {
        SvnRevisionNumber result = null;
        if (info != null) {
            SVNRevision revision = SVNRevision.UNDEFINED.equals((Object)info.getCommittedRevision()) && info.getCopyFromRevision() != null ? info.getCopyFromRevision() : info.getRevision();
            result = new SvnRevisionNumber(revision);
        }
        return result;
    }

    @NotNull
    public Map<VirtualFile, VcsRevisionNumber> getCurrentRevisions(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            SvnDiffProvider.$$$reportNull$$$0(2);
        }
        HashMap result = ContainerUtil.newHashMap();
        HashMap items = ContainerUtil.newHashMap();
        ArrayList ioFiles = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            ioFiles.add(ioFile);
            items.put(ioFile.getAbsolutePath(), file);
            if (items.size() != 20) continue;
            this.collectRevisionsInBatch(result, items, ioFiles);
            items.clear();
            ioFiles.clear();
        }
        this.collectRevisionsInBatch(result, items, ioFiles);
        HashMap hashMap = result;
        if (hashMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private void collectRevisionsInBatch(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap, @NotNull List<File> ioFiles) {
        if (revisionMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(4);
        }
        if (fileMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(5);
        }
        if (ioFiles == null) {
            SvnDiffProvider.$$$reportNull$$$0(6);
        }
        this.myVcs.collectInfo(ioFiles, SvnDiffProvider.createInfoHandler(revisionMap, fileMap));
    }

    @NotNull
    private static InfoConsumer createInfoHandler(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap) {
        if (revisionMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(7);
        }
        if (fileMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(8);
        }
        InfoConsumer infoConsumer = info -> {
            if (fileMap == null) {
                SvnDiffProvider.$$$reportNull$$$0(36);
            }
            if (revisionMap == null) {
                SvnDiffProvider.$$$reportNull$$$0(37);
            }
            if (info != null) {
                VirtualFile file = (VirtualFile)fileMap.get(info.getFile().getAbsolutePath());
                if (file != null) {
                    revisionMap.put(file, SvnDiffProvider.getRevision(info));
                } else {
                    LOG.info("Could not find virtual file for path " + info.getFile().getAbsolutePath());
                }
            }
        };
        if (infoConsumer == null) {
            SvnDiffProvider.$$$reportNull$$$0(9);
        }
        return infoConsumer;
    }

    @Nullable
    public VcsRevisionDescription getCurrentRevisionDescription(@NotNull VirtualFile file) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(10);
        }
        return this.getCurrentRevisionDescription(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    private VcsRevisionDescription getCurrentRevisionDescription(@NotNull File path) {
        File localPath;
        Info svnInfo;
        if (path == null) {
            SvnDiffProvider.$$$reportNull$$$0(11);
        }
        if ((svnInfo = this.myVcs.getInfo(path)) == null) {
            return null;
        }
        if (svnInfo.getCommittedRevision().equals((Object)SVNRevision.UNDEFINED) && !svnInfo.getCopyFromRevision().equals((Object)SVNRevision.UNDEFINED) && svnInfo.getCopyFromURL() != null && (localPath = this.myVcs.getSvnFileUrlMapping().getLocalPath(svnInfo.getCopyFromURL())) != null) {
            return this.getCurrentRevisionDescription(localPath);
        }
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new SvnRevisionNumber(svnInfo.getCommittedRevision()), svnInfo.getCommittedDate(), svnInfo.getAuthor(), this.getCommitMessage(path, svnInfo));
    }

    @Nullable
    private String getCommitMessage(@NotNull File path, @NotNull Info info) {
        String result;
        if (path == null) {
            SvnDiffProvider.$$$reportNull$$$0(12);
        }
        if (info == null) {
            SvnDiffProvider.$$$reportNull$$$0(13);
        }
        try {
            PropertyValue property = this.myVcs.getFactory(path).createPropertyClient().getProperty(SvnTarget.fromFile((File)path), COMMIT_MESSAGE, true, info.getCommittedRevision());
            result = PropertyValue.toString(property);
        }
        catch (VcsException e) {
            LOG.info("Failed to get commit message for file " + path + ", " + info.getCommittedRevision() + ", " + info.getRevision(), (Throwable)e);
            result = "";
        }
        return result;
    }

    @NotNull
    private static ItemLatestState defaultResult() {
        ItemLatestState itemLatestState = SvnDiffProvider.createResult(SVNRevision.HEAD, true, true);
        if (itemLatestState == null) {
            SvnDiffProvider.$$$reportNull$$$0(14);
        }
        return itemLatestState;
    }

    @NotNull
    private static ItemLatestState createResult(@NotNull SVNRevision revision, boolean exists, boolean defaultHead) {
        if (revision == null) {
            SvnDiffProvider.$$$reportNull$$$0(15);
        }
        ItemLatestState itemLatestState = new ItemLatestState((VcsRevisionNumber)new SvnRevisionNumber(revision), exists, defaultHead);
        if (itemLatestState == null) {
            SvnDiffProvider.$$$reportNull$$$0(16);
        }
        return itemLatestState;
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull VirtualFile file) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(17);
        }
        ItemLatestState itemLatestState = this.getLastRevision(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (itemLatestState == null) {
            SvnDiffProvider.$$$reportNull$$$0(18);
        }
        return itemLatestState;
    }

    @NotNull
    public ContentRevision createFileContent(@NotNull VcsRevisionNumber revisionNumber, @NotNull VirtualFile selectedFile) {
        if (revisionNumber == null) {
            SvnDiffProvider.$$$reportNull$$$0(19);
        }
        if (selectedFile == null) {
            SvnDiffProvider.$$$reportNull$$$0(20);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
        SVNRevision svnRevision = ((SvnRevisionNumber)revisionNumber).getRevision();
        if (!SVNRevision.HEAD.equals((Object)svnRevision) && revisionNumber.equals(this.getCurrentRevision(selectedFile))) {
            SvnContentRevision svnContentRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnRevision);
            if (svnContentRevision == null) {
                SvnDiffProvider.$$$reportNull$$$0(21);
            }
            return svnContentRevision;
        }
        Status svnStatus = this.getFileStatus(VfsUtilCore.virtualToIoFile((VirtualFile)selectedFile), false);
        SvnContentRevision svnContentRevision = svnStatus != null && svnRevision.equals((Object)svnStatus.getRevision()) ? SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnRevision) : SvnContentRevision.createRemote(this.myVcs, filePath, svnRevision);
        if (svnContentRevision == null) {
            SvnDiffProvider.$$$reportNull$$$0(22);
        }
        return svnContentRevision;
    }

    @Nullable
    private Status getFileStatus(@NotNull File file, boolean remote) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(23);
        }
        Status result = null;
        try {
            result = this.myVcs.getFactory(file).createStatusClient().doStatus(file, remote);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull FilePath filePath) {
        if (filePath == null) {
            SvnDiffProvider.$$$reportNull$$$0(24);
        }
        ItemLatestState itemLatestState = this.getLastRevision(filePath.getIOFile());
        if (itemLatestState == null) {
            SvnDiffProvider.$$$reportNull$$$0(25);
        }
        return itemLatestState;
    }

    @Nullable
    public VcsRevisionNumber getLatestCommittedRevision(@NotNull VirtualFile vcsRoot) {
        Info info;
        if (vcsRoot == null) {
            SvnDiffProvider.$$$reportNull$$$0(26);
        }
        return (info = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), SVNRevision.HEAD)) != null ? new SvnRevisionNumber(info.getCommittedRevision()) : null;
    }

    @NotNull
    private ItemLatestState getLastRevision(@NotNull File file) {
        Status svnStatus;
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(27);
        }
        if ((svnStatus = this.getFileStatus(file, true)) == null || SvnDiffProvider.itemExists(svnStatus) && SVNRevision.UNDEFINED.equals((Object)svnStatus.getRemoteRevision())) {
            Info info = this.myVcs.getInfo(file, SVNRevision.HEAD);
            if (info == null || info.getURL() == null) {
                LOG.info("No SVN status returned for " + file.getPath());
                ItemLatestState itemLatestState = SvnDiffProvider.defaultResult();
                if (itemLatestState == null) {
                    SvnDiffProvider.$$$reportNull$$$0(28);
                }
                return itemLatestState;
            }
            ItemLatestState itemLatestState = SvnDiffProvider.createResult(info.getCommittedRevision(), true, false);
            if (itemLatestState == null) {
                SvnDiffProvider.$$$reportNull$$$0(29);
            }
            return itemLatestState;
        }
        if (!SvnDiffProvider.itemExists(svnStatus)) {
            ItemLatestState itemLatestState = SvnDiffProvider.createResult(this.getLastExistingRevision(file, svnStatus), false, false);
            if (itemLatestState == null) {
                SvnDiffProvider.$$$reportNull$$$0(30);
            }
            return itemLatestState;
        }
        ItemLatestState itemLatestState = SvnDiffProvider.createResult((SVNRevision)ObjectUtils.notNull((Object)svnStatus.getRemoteRevision(), (Object)svnStatus.getRevision()), true, false);
        if (itemLatestState == null) {
            SvnDiffProvider.$$$reportNull$$$0(31);
        }
        return itemLatestState;
    }

    @NotNull
    private SVNRevision getLastExistingRevision(@NotNull File file, @NotNull Status svnStatus) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(32);
        }
        if (svnStatus == null) {
            SvnDiffProvider.$$$reportNull$$$0(33);
        }
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(file);
        long revision = -1L;
        if (format.less(WorkingCopyFormat.ONE_DOT_EIGHT)) {
            if (svnStatus.getRepositoryRootURL() != null) {
                revision = new LatestExistentSearcher(this.myVcs, svnStatus.getURL(), svnStatus.getRepositoryRootURL()).getDeletionRevision();
            } else {
                LOG.info("Could not find repository url for file " + file);
            }
        }
        SVNRevision sVNRevision = SVNRevision.create((long)revision);
        if (sVNRevision == null) {
            SvnDiffProvider.$$$reportNull$$$0(34);
        }
        return sVNRevision;
    }

    private static boolean itemExists(@NotNull Status svnStatus) {
        if (svnStatus == null) {
            SvnDiffProvider.$$$reportNull$$$0(35);
        }
        return !StatusType.STATUS_DELETED.equals((Object)svnStatus.getRemoteContentsStatus()) && !StatusType.STATUS_DELETED.equals((Object)svnStatus.getRemoteNodeStatus());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 10: 
            case 17: 
            case 23: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnDiffProvider";
                break;
            }
            case 4: 
            case 7: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionMap";
                break;
            }
            case 5: 
            case 8: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnDiffProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentRevisions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultResult";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createResult";
                break;
            }
            case 18: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastRevision";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileContent";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastExistingRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevisions";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectRevisionsInBatch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevisionDescription";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommitMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createResult";
                break;
            }
            case 17: 
            case 24: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLastRevision";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFileContent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLatestCommittedRevision";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLastExistingRevision";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "itemExists";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createInfoHandler$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

