/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitCheckoutClient
extends BaseSvnClient
implements CheckoutClient {
    public static final List<WorkingCopyFormat> SUPPORTED_FORMATS;

    @Override
    public void checkout(@NotNull SvnTarget source, @NotNull File destination, @Nullable SVNRevision revision, @Nullable Depth depth, boolean ignoreExternals, boolean force, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(1);
        }
        if (format == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(2);
        }
        this.assertUrl(source);
        this.validateFormat(format, this.getSupportedFormats());
        SVNUpdateClient client = this.myVcs.getSvnKitManager().createUpdateClient();
        client.setIgnoreExternals(ignoreExternals);
        client.setEventHandler(SvnKitCheckoutClient.toEventHandler(handler));
        try {
            SvnKitCheckoutClient.runCheckout(client, format, source, destination, revision, depth, force);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private static void runCheckout(@NotNull SVNUpdateClient client, @NotNull WorkingCopyFormat format, @NotNull SvnTarget source, @NotNull File destination, @Nullable SVNRevision revision, @Nullable Depth depth, boolean force) throws SVNException {
        if (client == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(3);
        }
        if (format == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(4);
        }
        if (source == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(6);
        }
        SvnCheckout checkoutOperation = SvnKitCheckoutClient.createCheckoutOperation(client, format);
        checkoutOperation.setUpdateLocksOnDemand(client.isUpdateLocksOnDemand());
        checkoutOperation.setSource(SvnTarget.fromURL((SVNURL)source.getURL(), (SVNRevision)source.getPegRevision()));
        checkoutOperation.setSingleTarget(SvnTarget.fromFile((File)destination));
        checkoutOperation.setRevision(revision);
        checkoutOperation.setDepth(SvnKitCheckoutClient.toDepth(depth));
        checkoutOperation.setAllowUnversionedObstructions(force);
        checkoutOperation.setIgnoreExternals(client.isIgnoreExternals());
        checkoutOperation.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)client.getExternalsHandler()));
        checkoutOperation.run();
    }

    @NotNull
    private static SvnCheckout createCheckoutOperation(@NotNull SVNUpdateClient client, @NotNull WorkingCopyFormat format) {
        if (client == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(7);
        }
        if (format == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(8);
        }
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            client.getOperationsFactory().setPrimaryWcGeneration(SvnWcGeneration.V16);
        }
        SvnCheckout checkoutOperation = client.getOperationsFactory().createCheckout();
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            checkoutOperation.setTargetWorkingCopyFormat(29);
        }
        SvnCheckout svnCheckout = checkoutOperation;
        if (svnCheckout == null) {
            SvnKitCheckoutClient.$$$reportNull$$$0(9);
        }
        return svnCheckout;
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    static {
        ArrayList<WorkingCopyFormat> supportedFormats = new ArrayList<WorkingCopyFormat>();
        supportedFormats.add(WorkingCopyFormat.ONE_DOT_SEVEN);
        supportedFormats.add(WorkingCopyFormat.ONE_DOT_SIX);
        SUPPORTED_FORMATS = Collections.unmodifiableList(supportedFormats);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/checkout/SvnKitCheckoutClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/checkout/SvnKitCheckoutClient";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckoutOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runCheckout";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCheckoutOperation";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

